/*
 * qt3_compat.h - stuff for compatibility with several Qt 3 versions
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _QT3_COMPAT_H
#define _QT3_COMPAT_H

#include <qglobal.h>


#if QT_VERSION < 0x030100

// Qt 3.0.x doesn't have QMutexLocker, so we implement it on our own...
class QMutexLocker
{
public:
	QMutexLocker( QMutex * _m ) :
		m_mutex( _m )
	{
		if( m_mutex != NULL )
		{
			m_mutex->lock();
		}
	}
	~QMutexLocker()
	{
		if( m_mutex != NULL )
		{
			m_mutex->unlock();
		}
	}

private:
    QMutex * m_mutex;

} ;

#endif

#if QT_VERSION < 0x030200

// in Qt 3.0.x QMessageBox has no member question(), so let's simply use information()
#define question	information

// in Qt 3.0.x QWidget has no member isShown(), so use isVisible() instead
#define isShown		isVisible

#endif

#endif
