#ifndef _INCLINATION_H
#define _INCLINATION_H

#include "entity.h"

class Builder;
class Player;
class Strings;

class Inclination : public Entity {
 public:

   Inclination();
   virtual ~Inclination();
   Inclination(char *quest_name);

   void set_description(char *the_string);
   char *get_description();
   void set_special(char *the_string);
   char *get_special();

   void set_str_offset(int the_num);
   int get_str_offset();
   void set_dex_offset(int the_num);
   int get_dex_offset();
   void set_intel_offset(int the_num);
   int get_intel_offset();
   void set_con_offset(int the_num);
   int get_con_offset();
   void set_wis_offset(int the_num);
   int get_wis_offset();
   void set_cha_offset(int the_num);
   int get_cha_offset();

   int set_values(Player *the_player);

   int load_inclination(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   void write_object(FILE *the_file, int is_builder);


   int is_modified();
   void set_modified(int the_num);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:

   int       modified;

   Strings   description;
   int       str_offset;
   int       dex_offset;
   int       con_offset;
   int       intel_offset;   
   int       wis_offset;
   int       cha_offset;

   int       magic_offset;
   int       endur_offset;

   Strings   the_special;
};

#endif
