#ifndef _KEY_H
#define _KEY_H

#include "moveable.h"
#include "builder.h"

class Key : public Moveable
{
public:

   Key(char *the_name, char *the_area);
   virtual ~Key();

   void    write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int     copy_key(Key *copy_from);
   Key     *operator = (Key *copy_from); 
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

private:

   Key();

};

#endif
