
#ifndef ProdElemFUNCTIONTYPES_H
#define ProdElemFUNCTIONTYPES_H

#include "eliproto.h"

/* include header file defining ProdElem if Syntax is set: */
#define EMPTYSyntaxHDR
#ifndef EMPTYHDR
#include "Syntax.h"
#endif
#undef EMPTYSyntaxHDR

typedef int (*ProdElemCmpFctType) ELI_ARG((ProdElem, ProdElem));
/* Functions that compare two ProdElem values
 *   If the left argument is less than the right then on exit-
 *     ProdElemCmpFctType = -1
 *   Else if the arguments are equal then on exit-
 *     ProdElemCmpFctType = 0
 *   Else on exit-
 *     ProdElemCmpFctType = 1
 ***/

typedef ProdElem (*ProdElemMapFct) ELI_ARG((ProdElem));
/* Functions that map one ProdElem value into another
 *   On exit-
 *     ProdElemMapFct = image of the argument under the map
 ***/

typedef ProdElem (*ProdElemSumFct) ELI_ARG((ProdElem, ProdElem));
/* Functions that combine two ProdElem values
 *   On exit-
 *     ProdElemSumFct = combination of the two arguments
 ***/

#endif
