/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <gtk/gtk.h>
#include <string.h>

#include "config.h"
#include "dproperties.h"
#include "properties.h"
#include "rcfile.h"
#include "help.h"
#include "notebook.h"

void dialog_properties_create(d_properties_t*);

void dialog_properties_close(d_properties_t *p) {
    gm_properties_free(p->p);
    g_free(p->belongs_name);
    g_free(p);
}

void gm_dialog_properties_close(d_properties_t *p) {
    pc_destroy(p->pc);
    dialog_properties_close(p);
}

d_properties_t *gm_dialog_properties_open(world *w) {
    d_properties_t *p = g_malloc(sizeof(d_properties_t));
    p->belongs_to = w;
    p->belongs_name = NULL;
    p->open_world = TRUE;
    p->p = gm_properties_copy(w->p);
    dialog_properties_create(p);
    return p;
}

d_properties_t *gm_dialog_properties_open_by_name(const char *name) {
    d_properties_t *p = g_malloc(sizeof(d_properties_t));
    p->belongs_to = NULL;
    p->belongs_name = g_strdup(name);
    p->open_world = TRUE;
    p->p = gm_world_get_settings_by_name(name);
    dialog_properties_create(p);
    return p;
}

d_properties_t *gm_dialog_properties_open_new() {
    d_properties_t *p = g_malloc(sizeof(d_properties_t));
    p->belongs_to = NULL;
    p->belongs_name = NULL;
    p->open_world = TRUE;
    p->p = gm_world_get_settings_by_name(TEMPLATE);
    g_free(p->p->name);
    p->p->name = g_strdup(_("New World"));
    dialog_properties_create(p);
    return p;
}

d_properties_t *gm_dialog_properties_open_current_world() {
    world *w = gm_notebook_current_world();
    if(w) {
	return gm_dialog_properties_open(w);
    }
    return NULL;
}

int dialog_properties_apply(d_properties_t *p) {
    if(debug) printf("Apply properties now...\n");
    if(p->belongs_to) {
        return gm_world_apply_properties(p->belongs_to, p->p);
    } else {
        if(p->belongs_name) {
            if(gm_world_apply_properties_by_name(p->belongs_name, p->p)) {
                pc_hide(p->pc);
                return TRUE;
            }
            return FALSE;
        } else if(gm_world_create_config(p->p)) {
            pc_hide(p->pc);
            if(p->open_world) {
                gm_notebook_try_add_world(p->p->name);
            }
            return TRUE;
        }
        return FALSE;
    }
}

void dialog_properties_help(int page, char *page_name, d_properties_t *p) {
    char *chapter;
    int i;
    if(debug) printf("Help pressed for %d (\"%s\")\n", page, page_name);
    chapter = g_strconcat(HELP_DPROPERTIES, "_", page_name, NULL);
    for(i = 0; chapter[i] != '\0'; i++) {
        if(chapter[i] == ' ') chapter[i] = '_';
    }
    gm_help_show(p->pc->window, chapter);
    g_free(chapter);
}

#if 0
void dialog_properties_create(d_properties_t *p) {
#define MAX_SLAVES 3
    pc_sec *s, *sec;
    pc_var *master;
    pc_var *s0, *s1, *s2, *s3;
    GtkWidget *w;
    
    p->pc = pc_new(p->belongs_to ? _("World properties"):_("Create new world"),
		   (pc_apply_func)dialog_properties_apply,
		   (pc_func)      dialog_properties_close,
		   (pc_help_func) dialog_properties_help,
		   p->belongs_to ? TRUE : FALSE,
		   p);

    if(p->p->username == NULL) p->p->username = g_strdup("");
    if(p->p->password == NULL) p->p->password = g_strdup("");

    sec = s = pc_section_new(p->pc, _("World info"));
    w = pc_entry_new(s, _("Name"), &p->p->name);
    pc_entry_new(s, _("Hostname"), &p->p->hostname);
    pc_spin_new (s, _("Port"), 0, G_MAXINT, &p->p->port);
    if(strcmp(TEMPLATE, p->p->name) == 0)
	gtk_widget_set_sensitive(w, FALSE);
    gtk_entry_set_max_length(GTK_ENTRY(w), 100);

    s = pc_subsection_new(sec, _("Logging in"));
    master    = pc_check_new(s, _("Autologin"), &p->p->autologin);
    s0 = pc_entry_new(s, _("Username"), &p->p->username);
    s1 = pc_entry_new(s, _("Password"), &p->p->password);
    gtk_entry_set_visibility(GTK_ENTRY(s1), FALSE);
    pc_check_lock(master, s0, s1, NULL);

    sec = s = pc_section_new(p->pc, _("History"));
    master = pc_check_new(s, _("Enable input history"), &p->p->history);
    s0     = pc_spin_new(s, _("History size"), 10, G_MAXINT,
			 &p->p->history_size);
    s1     = pc_check_new(s, _("Selective history"), &p->p->history_selective);
    s2     = pc_check_new(s, _("Case sensitive"), &p->p->history_sensitive);
    s3     = pc_check_new(s, _("Store history"), &p->p->history_store);
    pc_check_lock(master, s0, s1, s3, NULL);
    pc_check_lock2(master, s1, s2, NULL);

    sec = s = pc_section_new(p->pc, _("Output"));
    pc_check_new(s, _("Terminal beeps to the speaker"), &p->p->beep);
    pc_check_new(s, _("Scroll down when you press <enter>\n"
		      "in blocked mode"), &p->p->scroll_on_enter);
#ifdef ZVT
    pc_spin_new (s, _("Scrollback length"), 10, G_MAXINT,
		 &p->p->scrollback_length);
    master = pc_check_new(s, _("Background transparent"),
			  &p->p->background.transparent);
    s0 = pc_check_new(s, _("Background shaded"),
		      &p->p->background.shaded);
    pc_check_lock(master, s0, NULL);
    pc_entry_new(s, _("Wordclass"), &p->p->wordclass);
#endif
 
    s = pc_subsection_new(sec, _("User Input"));
    master = pc_check_new(s, _("Show your own input"),
			  &p->p->show_own_input);
    s0 = pc_option_new(s, _("Foreground color"), &p->p->show_own_input_fgcolor,
		       gm_settings_get_color_name(0),
		       gm_settings_get_color_name(1),
		       gm_settings_get_color_name(2),
		       gm_settings_get_color_name(3),
		       gm_settings_get_color_name(4),
		       gm_settings_get_color_name(5),
		       gm_settings_get_color_name(6),
		       gm_settings_get_color_name(7),
		       _("None"), NULL);
    s1 = pc_option_new(s, _("Background color"), &p->p->show_own_input_bgcolor,
		       gm_settings_get_color_name(0),
		       gm_settings_get_color_name(1),
		       gm_settings_get_color_name(2),
		       gm_settings_get_color_name(3),
		       gm_settings_get_color_name(4),
		       gm_settings_get_color_name(5),
		       gm_settings_get_color_name(6),
		       gm_settings_get_color_name(7),
		       _("None"), NULL);
    s2 = pc_check_new(s, _("Show in bold"), &p->p->show_own_input_bold);
    s3 = pc_check_new(s, _("Show underlined"),&p->p->show_own_input_underline);
    pc_check_lock(master, s0, s1, s2, s3, NULL);

    s = pc_subsection_new(sec, _("Logs"));
    master = pc_check_new(s, _("Keep logs"), &p->p->log_use);
    s0 = pc_check_new(s, _("Log user input"), &p->p->log_input);
    s1 = pc_check_new(s, _("Log output with ansi color"), &p->p->log_color);
#ifndef ZLIB
    s2 = pc_check_new(s, _("Use compressed logs"), &p->p->compressed_logs);
    pc_check_lock(master, s0, s1, s2, NULL);
#else
    s3 = pc_option_new(s, _("Log type"), &p->p->log_type,
		       _("Append to a single file"),
		       _("One log file per day"),
		       _("One log file per connection"), NULL);
    pc_check_lock(master, s0, s1, s2, s3, NULL);
#endif

    s = pc_subsection_new(sec, _("Misc"));
    pc_check_new(s, _("Reconnect on disconnect"), &p->p->reconnect);

    pc_show(p->pc);
}
#endif

void dialog_properties_create(d_properties_t *p) {
#define MAX_SLAVES 3
    pc_sec *s, *sec;
    pc_var *master;
#ifndef ZLIB
    pc_var *s0, *s1, *s3;
#else
    pc_var *s0, *s1, *s2, *s3;
#endif
    GtkWidget *w;
    
    p->pc = pc_new(p->belongs_to ? _("World properties"):_("Create new world"),
		   (pc_apply_func)dialog_properties_apply,
		   (pc_func)      dialog_properties_close,
		   (pc_help_func) dialog_properties_help,
		   p->belongs_to ? TRUE : FALSE,
		   p);

    if(p->p->username == NULL) p->p->username = g_strdup("");
    if(p->p->password == NULL) p->p->password = g_strdup("");

    sec = s = pc_section_new(p->pc, _("World info"));
    w = pc_entry_new(s, _("Name"), &p->p->name);
    pc_entry_new(s, _("Hostname"), &p->p->hostname);
    pc_spin_new (s, _("Port"), 0, G_MAXINT, &p->p->port);
    if(strcmp(TEMPLATE, p->p->name) == 0)
	gtk_widget_set_sensitive(w, FALSE);
    gtk_entry_set_max_length(GTK_ENTRY(w), 100);

    s = pc_subsection_new(sec, _("Logging in"));
    master    = pc_check_new(s, _("Autologin"), &p->p->autologin);
    s0 = pc_entry_new(s, _("Username"), &p->p->username);
    s1 = pc_entry_new(s, _("Password"), &p->p->password);
    gtk_entry_set_visibility(GTK_ENTRY(s1), FALSE);
    pc_check_lock(master, s0, s1, NULL);

    sec = s = pc_section_new(p->pc, _("Logs"));
    master = pc_check_new(s, _("Keep logs"), &p->p->log_use);
    s0 = pc_check_new(s, _("Log user input"), &p->p->log_input);
    s1 = pc_check_new(s, _("Log output with ansi color"), &p->p->log_color);
#ifdef ZLIB
    s2 = pc_check_new(s, _("Use compressed logs"), &p->p->compressed_logs);
#endif
    s3 = pc_option_new(s, _("Log type"), &p->p->log_type,
		       _("Append to a single file"),
		       _("One log file per day"),
		       _("One log file per connection"), NULL);
#ifndef ZLIB
    pc_check_lock(master, s0, s1, s3, NULL);
#else
    pc_check_lock(master, s0, s1, s2, s3, NULL);
#endif

    pc_show(p->pc);
}
