/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_SETTINGS_H
#define GM_SETTINGS_H

#include <gtk/gtk.h>

typedef struct _settings_t   settings_t;

#define LEFT  0
#define RIGHT 1

#define BLACK   0     /* The color indexes */
#define RED     1
#define GREEN   2
#define YELLOW  3
#define BLUE    4
#define MAGENTA 5
#define CYAN    6
#define WHITE   7
#define BRIGHT    8   /* Bright modifyer (BLACK + BRIGHT == gray) */
#define FG_COLOR 16 /* Default foreground &&                    */
#define BG_COLOR 17 /* background colors                        */
#define FG_SELECT 18
#define BG_SELECT 19
#define N_COLORS 20   /* The # of colors */

#define LOG_APPEND	0
#define LOG_DAY		1
#define LOG_CONNECTION	2

#define HOTKEY_CTRL   0 /* not actually used ... */
#define HOTKEY_ALT    1
#define HOTKEY_EITHER 2

#define WORLD_PROPERTIES_FILE "properties"
#define WORLD_ORDER_FILE      ".world_order"
#define WORLD_HISTORY_FILE    "history"
#define RUN_MENU_FILE         "run_menu"
#define NOTEBOOK_STATUS_FILE  "active_tabs"

#define COLOR_CUSTOM 0
#define COLOR_LINUX  1
#define COLOR_XTERM  2
#define COLOR_RXVT   3

#define FGBG_CUSTOM 0
#define FGBG_WB     1
#define FGBG_BW     2
#define FGBG_GB     3

GdkColor colors[N_COLORS];

GtkStyle *redtab_style;
GtkStyle *bluetab_style;
GtkStyle *input_style;

struct _settings_t {
    int color_palette;
    int fgbg_palette;

    gushort reds[N_COLORS];
    gushort greens[N_COLORS];
    gushort blues[N_COLORS];

    char *fontname;
    
    /* Window */
    int save_window_size;
    int window_width;
    int window_height;

    /* notebook */
    int tab_position;
    int homo_tabs;
    int tabs_show_lines_waiting;
    int tab_limit_length;
    int tab_max_length;
    int tab_pos_on_tab;
    int hotkey;
    int hotkey_mask;
    int hotkey_arrow;

    int toolbar;

    int save_input_height;

    int   editor_external;
    int   editor_use_env;
    int   editor_needs_term;
    char *editor_command;
    int   editor_delete_file;

    int userlist_pos;
    int userlist_resizeable;
    int userlist_totals;
    int userlist_headers;
    int userlist_objects;
    int userlist_friends_color;
    int userlist_auto_open;
    
    int restore_open_worlds;
    int enable_run_menu;

    int history;
    int history_size;
    int history_selective;
    int history_sensitive;
    int history_store;

    int beep;
    int scroll_on_enter;
    int scroll_on_text;
    
    int show_own_input;
    int show_own_input_fgcolor;
    int show_own_input_bgcolor;
    int show_own_input_bold;
    int show_own_input_underline;
    
    int reconnect;

    int buffer_size;
    char *timestamp;

    /* Backgrounds */
    int bg_col;
    int bg_trans;
    int bg_file;
    char *bg_filename;
    int bg_tinted;
    int bg_tint_r;
    int bg_tint_g;
    int bg_tint_b;
    int bg_tile;
};

settings_t *settings;

void  gm_settings_init           (int argc, char *argv[]);
char *gm_settings_get_config_dir ();
char *gm_settings_get_editor_dir ();
char *gm_settings_get_scripts_dir();
char *gm_settings_get_worlds_dir ();
char *gm_settings_get_log_dir    ();
char *gm_settings_get_pixmap_dir ();
char *gm_settings_get_trigger_file();
void  gm_settings_load           (settings_t *s);
void  gm_settings_store          (settings_t *s);
void  gm_settings_update         ();

settings_t *gm_settings_alloc();
settings_t *gm_settings_copy (settings_t *s);
void        gm_settings_free (settings_t *s);

settings_t *gm_settings_replace(settings_t *s);

char *gm_settings_get_color_name(int color);

#endif /* GM_SETTINGS_H */
