/* ======================================================================
 * vector3d.hh
 * 
 * This file is part of 3Dwm: The CUBE Window Manager.
 * Copyright (c) 1999, 2000 Niklas Elmqvist. All rights reserved.
 *
 * File created 1999-06-02 by Niklas Elmqvist <d97elm@dtek.chalmers.se>.
 * 
 * The 3Dwm Project
 *      <http://www.medialab.chalmers.se/projects/3dwm>
 * Chalmers Medialab
 *      <http://www.medialab.chalmers.se>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 * ======================================================================
 */

#ifndef _VECTOR3D_HH_
#define _VECTOR3D_HH_

// Need to export functions on Win32
#if !defined(APIEXPORT)
#if !defined(WIN32)
#define APIEXPORT
#else
#define APIEXPORT __declspec(dllexport)
#endif 
#endif

// -- Namespace Definitions

namespace MeshIO {

    // -- Class Declarations
    
    // Vector3D class declaration
    class APIEXPORT Vector3D {
    public:
	
	union {
	    struct {
		float x, y, z, w;      // Vector component (named form)
	    } coord;
	    float fCoord[4];           // Vector components (array form)
	};
	
	// Constructors
	Vector3D(void);
	Vector3D(float x, float y, float z, float w = 1.0f);
	Vector3D(float _fCoord[3]);
	
	// Access operator (indexing)
	float &operator [] (int nIndex) { return fCoord[nIndex]; }
	
	// Arithmetric operators (vectorial)
	Vector3D &operator += (const Vector3D vVec);
	Vector3D &operator -= (const Vector3D vVec);
	
	Vector3D operator + (const Vector3D vVec) const;
	Vector3D operator - (const Vector3D vVec) const;
	Vector3D operator / (const Vector3D vVec) const;
	Vector3D operator * (const Vector3D vVec) const;
	
	// Arithmetric operators (scalar)
	Vector3D &operator += (const float fVal);
	Vector3D &operator -= (const float fVal);
	Vector3D &operator /= (const float fVal);
	Vector3D &operator *= (const float fVal);
	
	Vector3D operator + (const float fVal) const;
	Vector3D operator - (const float fVal) const;
	Vector3D operator / (const float fVal) const;
	Vector3D operator * (const float fVal) const;
	
	// Unary arithmetric operators
	Vector3D operator - (void) const;
	
	// Assignment
	Vector3D &operator = (const Vector3D vVec);
	
	// Mathematical operations
	float Magnitude(void);
	void Normalize(void);
	void Clear(void);
    };
    
    // --+ Auxiliary function prototypes
    float Dot(Vector3D vVec1, Vector3D vVec2);
    Vector3D operator * (float fVal, Vector3D vVec);

};

#endif /* vector3d.hh */

