#include "spaceobj.h"
#include "allegro.h"
#include "hull_weapon.h"
#include "hull_weapon_rocket_heavy.h"

HeavyRocket_WHull::HeavyRocket_WHull():
HullWeapon( 0, 1, 40 ){}

void HeavyRocket_WHull::Draw( BITMAP * who, int x, int y ) {
	#define HXFactor 6
	#define HYFactor 30
	rectfill(who,x,y+3,x+HXFactor,y+HYFactor,makecol(120,120,120) );
	triangle(who,x-2,y+3,x+HXFactor/2,y,x+HXFactor+2,y+3, makecol(190,190,190) );
}


bool HeavyRocket_WHull::Collide( int mx, int my, SpaceObject * check ) {

	if ( check->HitMe( mx, my ) )
		return true;
	if ( check->HitMe( mx+HXFactor/2, my+HYFactor*2/3 ) )
		return true;
	return false;

}
