//
//  Structs.h
//  CamelBones
//
//  Copyright (c) 2004 Sherm Pendley. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PerlImports.h"

// Creating NSPoint structs
NSPoint CBPointFromAV(AV* av);
NSPoint CBPointFromHV(HV* hv);
NSPoint CBPointFromSV(SV* sv);

// Converting NSPoint structs to blessed scalar references
SV* CBPointToSV(NSPoint point);

// Creating NSRect structs
NSRect CBRectFromAV(AV* av);
NSRect CBRectFromHV(HV* hv);
NSRect CBRectFromSV(SV* sv);

// Converting NSRect structs to blessed scalar references
SV* CBRectToSV(NSRect rect);

// Creating NSRange structs
NSRange CBRangeFromAV(AV* av);
NSRange CBRangeFromHV(HV* hv);
NSRange CBRangeFromSV(SV* sv);

// Converting NSRange structs to blessed scalar references
SV* CBRangeToSV(NSRange range);

// Creating NSSize structs
NSSize CBSizeFromAV(AV* av);
NSSize CBSizeFromHV(HV* hv);
NSSize CBSizeFromSV(SV* sv);

// Converting NSSize structs to blessed scalar references
SV* CBSizeToSV(NSSize size);

// The following aren't needed on GNUStep
#ifndef GNUSTEP
// Creating OSType structs
OSType CBOSTypeFromSV(SV* sv);

// Converting OSType structs to blessed scalar references
SV* CBOSTypeToSV(OSType type);
#endif
