<?php
/**
 *  All function which are able to get infos from outside will be here
 * This is mostly a package holding very similar functions
 * All must take 1  parameter: an integer  with a default value, which is the 
 * number of hadlines to get;
 * All shall return a string, formatted with HTML::sidebox
 * The better thing to do if you want to create your own backend is to 
 * cut'n'paste, using Backends::generic()
 *
 * daCode http://www.dacode.org/
 * src/phplib/backends.php3
 * $Id: backends.php3,v 1.59.2.13 2002/08/03 22:46:58 ruffy Exp $
 *
 * Depends: Config Utils Html Cache
 */

Class Backends {
	/**
	 * Html subclass instance
	 *@var object Html
	 */
	var $html;

	/**
	 * Cache instance
	 *@var object Cache
	 */
	var $cache;

	/**
	 * Utils instance
	 *@var object Utils
	 */	
	var $utils;

	/**
	 * Class constructor
	 */
	Function Backends() {
		$this->utils  = LoadClass('Utils');
		$this->html   = LoadClass('Html');
		$this->cache  = LoadClass('Cache');
	}

	/**
	 * Generic function to extract informations from external websites
	 *@param integer $nb number of items
	 *@param integer $ttl duration of cached file
	 *@param string $url_site URL of backend file
	 *@param string $title_site title of website
	 *@param string $template string describing how items must be rendered, with $x being replaced by x-th line of input
	 *@param string $delim separator between items
	 *@param boolean $striphtml Removes html tags
	 *@param boolean $raw if set, text is returned without decoration
	 *@param boolean $show_url if set, the boxtitle will be an url, else no
	 *@param string $url_web if not empty, used in the boxtitle
	 *@return string the HTML
	 *@access private
	 */
	Function generic($nb,$ttl,$url_site,$title_site,$template,$delim="%%",
			$striphtml=false, $raw=false ,$show_url=true , $url_web="") {
		global $config;

		$site = str_replace("http://","",$url_site);
		list ($site,$file) = split("/",$site,2);
		$file = "/" . $file;
		if (empty($url_web)) {
			$url_web = $site;
		}

		$fcontents = $this->cache->check_box($ttl,"backends_".$site, $config->ext);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		if ($show_url) {
			$sidebox_title = "<a href=\"http://".$url_web."/\" class=\"boxheader\">".
				$title_site."</a>";
		} else {
			$sidebox_title = $title_site;
		}
		$nbocc = preg_match_all('/\$([0-9])/', $template, $res, PREG_SET_ORDER);
		$max = 0;
		for ($i=0; $i<$nbocc; $i++) {
			$max = max($max, $res[$i][1]);
		}

		$fpread = fsockopen($site, 80, $errno, $errstr, 5);
		if (!$fpread) {
			$out = '<!-- Connection trouble: '.$errstr.' ('.$errno.") -->\n";
			$out .= lecho("Down...")."\n";
			$out = $this->html->sidebox($sidebox_title,$out);
			$this->cache->write_box("backends_".$site,$config->ext,$out);
			return $out;
		}

		fputs($fpread, "GET ".$file." HTTP/1.1\r\n");
		fputs($fpread, "Host: ".$site."\r\n\r\n");

		$out = "";
		$nbread=0;
		while (!feof($fpread)) {
			if ($nbread >= $nb) {
				break;
			}
			$buffer = trim(fgets($fpread, 256));
			if ($buffer == $delim) {
				$nbread++;
				for ($i=1; $i<=$max; $i++) {
					$line[$i] = trim(fgets($fpread, 256));
					if ($striphtml) {
						$line[$i] = ereg_replace("^<[^>]+>(.*)</[^>]+>$","\\1",$line[$i]);
					}
				}
				$tmp = $template;
				for ($i=1; $i<=$max; $i++) {
					$not_empty = 0;
					if(!empty($line[$i])) {
						$not_empty++;
					}
					$tmp = str_replace('$'.$i, $line[$i], $tmp);
				}
				if ($not_empty > 0) {
					$out .= $tmp."\n";
				}
			}
		}
		fclose($fpread);
		if ($nbread == 0) {
			$out = lecho("Down...")."\n";
		}

		if (!$raw) {
			$out = $this->html->sidebox($sidebox_title,$out);
		}
		$this->cache->write_box("backends_".$site,$config->ext,$out);
		return $out;
	}

	/**
	 *  Get agenda from Lolix
	 * http://agenda.lolix.org/backend/backend-full.php3
	 * FIXME: misbehaviour when agenda.lolix.org is unreachable. 
	 * Shall prompt for a rewrite of this->generic. 
	 *@param integer number of dates ti retrive
	 *@access public
	 *@return string the sidebox with the next nb events.
	 */
	Function agenda($nb=5) {
		$title = lecho("Calendar");
		$tmp = $this->generic($nb, 3600,
			"agenda.lolix.org/backend/backend-full.php3",
			$title, '$1|$2|&nbsp;-&nbsp;$5: <a href="$4">$3</a><br />', '%%', 0, 1);

		if ($tmp) {
			$list = split("\n", $tmp);

			$dateold = $out = '';
			while($row = current($list)) {
				$res = explode("|", $row);
				$date = $this->utils->stamp2date($res[0],"short",1);
				if ($dateold != $res[0]) {
					if (!empty($dateold)) {
						$out .= "<br />";
					}
					$out .= "<b>".$date."</b><br />\n";
				}
				//FIXME DIRTY TEMPORARY FIX!
				$out .= isset($res[2])?$res[2]:"";
				$dateold = $res[0];
				next($list);
			}
		} else {
			$out = lecho("Down...")."\n";
		}
		return $this->html->sidebox("Agenda",$out);
	}

	/**
	 *  Prints information on current Linux kernels
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function kernel() {
		global $config;

		$fcontents = $this->cache->check_box("3600","backends_kernel",
			$config->ext);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = '';

		$fpread = fsockopen('finger.kernel.org', 79, $errno, $errstr, 5);
		if (!$fpread) {
			$out = "<!-- Erreur de connexion:".$errstr." (".$errno.") -->\n";
			$out .= lecho("Down...")."\n";
			$out = $this->html->sidebox(
				'<a href="http://www.kernel.org/pub/linux/kernel/" class="boxheader">'.
				lecho("Linux kernels").'</a>',$out);
			$this->cache->write_box("backends_kernel",$config->ext,$out);
			return $out;
		}
		fputs($fpread, "\n");
		$i = 0;
		while (!feof ($fpread)) {
			$buffer = chop(fgets($fpread, 128));
			if (ereg(': +(([0-9]+\.[0-9]+)\..+)', $buffer, $regs)) {
				$version[$i] = $regs[1];
				$major[$i] = $regs[2];
				$i++;
			}
		}
		fclose($fpread);
		$out = '';
		$out .= 'Stable: <a href="http://www.kernel.org/pub/linux/kernel/v'.
			$major[0].'/linux-'.$version[0].'.tar.bz2">'.
			$version[0].'</a> ('.
			'<a href="http://www.kernel.org/pub/linux/kernel/v'.
			$major[0].'/patch-'.$version[0].'.bz2">patch</a> / '.
			'<a href="http://www.kernel.org/pub/linux/kernel/v'.$major[0].
			'/ChangeLog-'.$version[0].'">Changes</a>)<br />'."\n";
		if (isset($version[1])) {
			$minor = ereg_replace("-p?r[ec][0-9]+", "", $version[1]);
			$out .= 'Pre-stable: <a href="'.
				'http://www.kernel.org/pub/linux/kernel/v'.$major[1].
				'/testing/patch-'.$version[1].'.bz2">'.$version[1].'</a> ('.
				'<a href="http://www.kernel.org/pub/linux/kernel/v'.$major[1].
				'/testing/patch-'.$minor.'.log">Changes</a>)<br />'."\n";
		}
		if (isset($version[2])) {
			$out .= 'Beta: <a href="http://www.kernel.org/pub/linux/kernel/v'.
				$major[2].'/linux-'.$version[2].'.tar.bz2">'.
				$version[2].'</a> ('.
				'<a href="http://www.kernel.org/pub/linux/kernel/v'.
				$major[2].'/patch-'.$version[2].'.bz2">patch</a> / '.
				'<a href="http://www.kernel.org/pub/linux/kernel/v'.$major[2].
				'/ChangeLog-'.$version[2].'">Changes</a>)<br />'."\n";
		}
		if (isset($version[3])) {
			$minor = ereg_replace("-pre[0-9]+", "", $version[3]);
			$out .= 'Pre-beta: <a href="'.
				'http://www.kernel.org/pub/linux/kernel/v'.$major[3].
				'/testing/patch-'.$version[3].'.bz2">'.$version[3].'</a> ('.
				'<a href="http://www.kernel.org/pub/linux/kernel/v'.$major[3].
				'/testing/patch-'.$minor.'.log">Changes</a>)<br />'."\n";
		}
		if (isset($version[4])) {
			//$major[4] = ereg_replace("^[^-]+-", "", $version[4]);
			$minor = ereg_replace("-ac[0-9]+", "", $version[4]);
			$log = ereg_replace('\.', "", $minor);
			$out .= 'Alan Cox: '.
				'<a href="http://www.kernel.org/pub/linux/kernel/people/alan/linux-'.
				$major[4].'/'.$minor.'/patch-'.$version[4].'.gz">'.$version[4].'</a>'.
				' (<a href="http://www.kernel.org/pub/linux/kernel/people/alan/linux-'.
				$major[4].'/'.$minor.'/notes.'.$log.'">Changes</a>)'."\n";
		}

		$out = $this->html->sidebox(
			'<a href="http://www.kernel.org/pub/linux/kernel/" class="boxheader">'.
			lecho("Linux kernels").'</a>',$out);

		$this->cache->write_box("backends_kernel",$config->ext,$out);
		return $out;
	}

	/**
	 * LinuxFR News (fr)
	 *@param integer number of items it retrive
	 *@access public
	 *@return string the sidebox with the next nb events.
	 */
	Function linuxfr($nb=10) {
		return $this->generic($nb, 3600, 'linuxfr.org/backend.rss',
			'LinuxFR', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 * daCode.org (en/fr)
	 *@param integer number of items it retrive
	 *@access public
	 *@return string the sidebox with the next nb events.
	 */
	Function dacodeorg($nb=10) {
		return $this->generic($nb, 3600, 'news.dacode.org/backend.rss',
			'news.daCode.org', '&nbsp;- <a href="$2">$1</a><br />');
	}

	/**
	 *  JeSuisLibre (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function jesuislibre($nb=10) {
		return $this->generic($nb, 3600, 'www.jesuislibre.org/backend.php3',
			'JeSuisLibre', '&nbsp;- <a href="$5">$1</a> ($4)<br />');
	}

	/**
	 *  Lolix France (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function lolixfr($nb=10) {
		return $this->generic($nb, 3600, 'back.fr.lolix.org/long.php3',
			'Lolix France', '&nbsp;- [$1] <a href="$3">$2</a><br />','%%',1,0,1,
			'fr.lolix.org');
	}

	/**
	 *   Slashdot News (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function slashdot($nb=10) {
		return $this->generic($nb, 3600, 'slashdot.org/slashdot.rdf',
			'Slashdot', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  Freshmeat.net (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function freshmeat($nb=10) {
		return $this->generic($nb, 3600, 'www.freshmeat.net/backend/fm.rdf',
			'Freshmeat', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  Latest RFCs (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function rfc($nb=5) {
		return $this->generic($nb, 3600, 'x42.com/rss/rfc.rss',
			'RFCs', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1,0,0);
	}

	/**
	 *  Techmag (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function techmag($nb=10) {
		return $this->generic($nb, 3600, 'www.techmag.net/techmag.rdf.php3',
			'Techmag', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 * NoSpoon.org (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function nospoon($nb=10) {
		return $this->generic($nb, 3600, 'nospoon.org/backend_rdf.xml',
			'NoSpoon', '&nbsp;- <a href="$4">$2</a><br />', '<item>', 1);
	}

	/**
	 *  Segfault (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function segfault($nb=10) {
		return $this->generic($nb, 3600, 'segfault.org/stories.txt',
			'Segfault', '&nbsp;- <a href="$2">$1</a><br />');
	}

	/**
	 *  LinuxToday (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function linuxtoday($nb=10) {
		return $this->generic($nb, 3600, 'linuxtoday.com/backend/lthead.txt',
			'LinuxToday', '&nbsp;- <a href="$2">$1</a><br />', '&&', 1);
	}

	/**
	 *  Debian Planet (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function debianplanet($nb=10) {
		return $this->generic($nb, 3600,
			'www.debianplanet.org/debianplanet/backend.php',
			'Debian Planet', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  Advogato (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function advogato($nb=10) {
		return $this->generic($nb, 3600, 'www.advogato.org/rss/articles.xml',
			'Advogato', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  KDE Dot News (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function dotkde($nb=10) {
		return $this->generic($nb, 3600, 'dot.kde.org/rdf',
			'KDE Dot news', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  Gnome News (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function gnomenews($nb=10) {
		return $this->generic($nb, 3600, 'news.gnome.org/gnome-news/rdf',
			'Gnome News', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  Mozilla NewsBot (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function mozillanewsbot($nb=10) {
		return $this->generic($nb, 3600, 'mozilla.org/newsbot/newsbot.rdf',
			'Mozilla NewsBot', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  MozillaZine (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function mozillazine($nb=10) {
		return $this->generic($nb, 3600, 'www.mozillazine.org/contents.rdf',
			'MozillaZine', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  phpInfo.net (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function phpinfonet($nb=10) {
		return $this->generic($nb, 3600,
			'www.phpinfo.net/news-phpinfo/news-phpinfo.rss',
			'phpInfo.net', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  PHPIndex (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function phpindex($nb=10) {
		return $this->generic($nb, 3600, 'www.phpindex.com/rss/phpindex_news.rss',
			'PHPIndex', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  PHPBuilder (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */
	Function phpbuilder($nb=10) {
		return $this->generic($nb, 3600,
			'www.phpbuilder.com/rss_feed.php?type=articles&limit=10',
			'PHPBuilder', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 *  Use Perl; (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */

	Function useperl($nb=10) {
		return $this->generic($nb, 3600,
			'use.perl.org/useperl.rdf',
			'Use Perl;', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}
	/**
	 *  FSF France (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */

	Function fsffrance($nb=10) {
		return $this->generic($nb, 3600,
			'france.fsfeurope.org/news/fsfe-fr-channel.fr.xml',
			'FSF France', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}

	/**
	 * Cipherwar (en)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */

	Function cipherwar($nb=10) {
		return $this->generic($nb, 3600, "cipherwar.com/backend.xml",
			'Cipherwar', '&nbsp;- <a href="$2">$1</a><br />', '<item>', 1);
	}
	/**
	 * Emacsfr (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */

	Function emacsfr($nb=10) {
		return $this->generic($nb, 3600, "www.emacsfr.org/short.php3",
			'Emacs-Tips', '&nbsp;-&nbsp;[$5] <a href="$2">$1</a><br />');
	}
	/**
	 * GnusFr (fr)
	 *@param integer number of items it retrive
	 *@return string the sidebox with the next nb events.
	 *@access public
	 */

	Function gnusfr($nb=10) {
		return $this->generic($nb, 3600, "www.gnusfr.org/short.php4",
			'GnusFr', '&nbsp;-&nbsp;[$5] <a href="$2">$1</a><br />');
	}

}

?>
