/*!

\if MANPAGES
\page findscu DICOM query (C-FIND) SCU
\else
\page findscu findscu: DICOM query (C-FIND) SCU
\endif

\section synopsis SYNOPSIS

\verbatim
findscu [options] peer port [dcmfile_in...]
\endverbatim

\section description DESCRIPTION

The \b findscu application implements an SCU for the Query/Retrieve Service
Class and the Basic Worklist Management Service Class.  \b findscu only
supports query functionality using the C-FIND message.  It sends query keys
to an SCP and awaits responses.  The application can be used to test SCPs of
the Query/Retrieve and Basic Worklist Management Service Classes.

\section parameters PARAMETERS

\verbatim
peer        hostname of DICOM peer

port        tcp/ip port number of peer

dcmfile_in  DICOM query file(s)
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information
\endverbatim

\subsection network_options network options
\verbatim
override matching keys:

  -k    --key  key: gggg,eeee="string"
          override matching key

query information model:

  -W    --worklist
          use modality worklist information model (default)

  -P    --patient
          use patient root information model

  -S    --study
          use study root information model

  -O    --psonly
          use patient/study only information model

application entity titles:

  -aet  --aetitle  aetitle: string
          set my calling AE title (default: FINDSCU)

  -aec  --call  aetitle: string
          set called AE title of peer (default: ANY-SCP)

post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

other network options:

  -to   --timeout  [s]econds: integer (default: unlimited)
          timeout for connection requests

  -pdu  --max-pdu  [n]umber of bytes: integer [4096..131072]
          set max receive pdu to n bytes (default: 16384)

        --repeat  [n]umber: integer
          repeat n times

        --abort
          abort association instead of releasing it

        --cancel  [n]umber: integer
          cancel after n responses (default: never)

  -X    --extract
          extract responses to file (rsp0001.dcm, ...)
\endverbatim

\subsection tls_options transport layer security (TLS) options
\verbatim
transport protocol stack options:

  -tls  --disable-tls
          use normal TCP/IP connection (default)

  +tls  --enable-tls  [p]rivate key file, [c]ertificate file: string
          use authenticated secure TLS connection

  +tla  --anonymous-tls
          use secure TLS connection without certificate

private key password options (only with --enable-tls):

  +ps   --std-passwd
          prompt user to type password on stdin (default)

  +pw   --use-passwd  [p]assword: string
          use specified password

  -pw   --null-passwd
          use empty string as password

key and certificate file format options:

  -pem  --pem-keys
          read keys and certificates as PEM file (default)

  -der  --der-keys
          read keys and certificates as DER file

certification authority options:

  +cf   --add-cert-file  [c]ertificate filename: string
          add certificate file to list of certificates

  +cd   --add-cert-dir  [c]ertificate directory: string
          add certificates in d to list of certificates

ciphersuite options:

  +cs   --cipher  [c]iphersuite name: string
          add ciphersuite to list of negotiated suites

  +dp   --dhparam  [f]ilename: string
          read DH parameters for DH/DSS ciphersuites

pseudo random generator options:

  +rs   --seed  [f]ilename: string
          seed random generator with contents of f

  +ws   --write-seed
          write back modified seed (only with --seed)

  +wf   --write-seed-file  [f]ilename: string (only with --seed)
          write modified seed to file f

peer authentication options:

  -rc   --require-peer-cert
          verify peer certificate, fail if absent (default)

  -vc   --verify-peer-cert
          verify peer certificate if present

  -ic   --ignore-peer-cert
          don't verify peer certificate
\endverbatim

\section notes NOTES

Each file supplied on the command line will be sent to the SCP as part of a
C-FIND request.  The query file must be a valid DICOM data set containing
the dataset part of a C-FIND-RQ message.  The query file could, for instance,
be created with the \b dump2dcm utility from a script like the following
example:

\verbatim
# query patient names and IDs
(0008,0052) CS [PATIENT]     # QueryRetrieveLevel
(0010,0010) PN []            # PatientsName
(0010,0020) LO []            # PatientID
\endverbatim
\if MANPAGES
.fi
\endif

Individual attributes of each file sent can be modified or supplemented
using the "-k key" option.  For example the command:

\verbatim
findscu -P -k 0010,0010="HEWETT*" caesar 5678 patqry.dcm
\endverbatim
\if MANPAGES
.fi
\endif

will, when sent to the SCP caesar at TCP/IP port 5678, cause any PatientsName
attribute in patqry.dcm to have the value "HEWETT*".  If such an attribute is
present it will be replaced, if absent it will be inserted.  The \e -k option
can be present more than once.  The value part (after the '=') may be absent
causing the attribute to be sent with zero length.  It is not possible to
replace or insert attributes within sequences using the \e -k option.

If no file is specified on the command line, the query must be specified
completely with one or more "-k key" options.

Each set of response identifers received will be printed to stdout.

\subsection dicom_conformance DICOM Conformance

The \b findscu application supports the following SOP Classes as an SCU:

\verbatim
FINDPatientRootQueryRetrieveInformationModel       1.2.840.10008.5.1.4.1.2.1.1
FINDStudyRootQueryRetrieveInformationModel         1.2.840.10008.5.1.4.1.2.2.1
FINDPatientStudyOnlyQueryRetrieveInformationModel  1.2.840.10008.5.1.4.1.2.3.1
FINDModalityWorklistInformationModel               1.2.840.10008.5.1.4.31
\endverbatim
\if MANPAGES
.fi
\endif

The \b findscu application will propose presentation contexts for one of the
abovementioned supported SOP Classes depending on command line options (\e -P,
\e -S, \e -O or \e -W).  Each proposed presentation context will propose the
transfer syntaxes:

\verbatim
LittleEndianImplicitTransferSyntax                 1.2.840.10008.1.2
LittleEndianExplicitTransferSyntax                 1.2.840.10008.1.2.1
BigEndianExplicitTransferSyntax                    1.2.840.10008.1.2.2
\endverbatim
\if MANPAGES
.fi
\endif

The \b findscu application does not support extended negotiation.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b findscu utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section see_also SEE ALSO

<b>movescu</b>(1), <b>dump2dcm</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1994-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/