/*!

\if MANPAGES
\page storescu DICOM storage (C-STORE) SCU
\else
\page storescu storescu: DICOM storage (C-STORE) SCU
\endif

\section synopsis SYNOPSIS

\verbatim
storescu [options] peer port dcmfile_in...
\endverbatim

\section description DESCRIPTION

The \b storescu application implements an SCU for the Storage Service Class.
For each image file command line parameter it sends a C-STORE message to a
Storage SCP and waits for a response.  The application can be used to transmit
DICOM images.

\section parameters PARAMETERS

\verbatim
peer        hostname of DICOM peer

port        tcp/ip port number of peer

dcmfile_in  DICOM file(s) to be transmitted
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  +v    --verbose-pc
          verbose mode and show presentation contexts

  -d    --debug
          debug mode, print debug information
\endverbatim

\subsection network_options network options
\verbatim
application entity titles:

  -aet  --aetitle  aetitle: string
          set my calling AE title (default: STORESCU)

  -aec  --call  aetitle: string
          set called AE title of peer (default: ANY-SCP)

association negotiation profile from configuration file:

  -xf   --config-file  [f]ilename, [p]rofile: string
          use profile p from config file f

proposed transmission transfer syntaxes (not with --config-file):

  -x=   --propose-uncompr
          propose all uncompressed TS, explicit VR
          with local byte ordering first (default)

  -xe   --propose-little
          propose all uncompressed TS, explicit VR
          little endian first

  -xb   --propose-big
          propose all uncompressed TS, explicit VR
          big endian first

  -xi   --propose-implicit
          propose implicit VR little endian TS only

  -xs   --propose-lossless
          propose default JPEG lossless TS
          and all uncompressed transfer syntaxes

  -xy   --propose-jpeg8
          propose default JPEG lossy TS for 8 bit data
          and all uncompressed transfer syntaxes

  -xx   --propose-jpeg12
          propose default JPEG lossy TS for 12 bit data
          and all uncompressed transfer syntaxes

  -xr   --propose-rle
          propose RLE lossless TS
          and all uncompressed transfer syntaxes

  -R    --required
          propose only required presentation contexts
          (default: propose all supported)

  +C    --combine
          combine proposed transfer syntaxes
          (default: separate presentation context for each TS)

post-1993 value representations:

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB


deflate compression level (only with --propose-deflated or --config-file):

  +cl   --compression-level  compression level: 0-9 (default 6)
          0=uncompressed, 1=fastest, 9=best compression

other network options:

  -to   --timeout  [s]econds: integer (default: unlimited)
          timeout for connection requests

  -pdu  --max-pdu  [n]umber of bytes: integer [4096..131072]
          set max receive pdu to n bytes (default: 16384)

        --max-send-pdu  [n]umber of bytes: integer [4096..131072]
          restrict max send pdu to n bytes

        --repeat  [n]umber: integer
          repeat n times

        --abort
          abort association instead of releasing it

        --no-halt
          do not halt if unsuccessful store encountered
          (default: do halt)

  -up   --uid-padding
          silently correct space-padded UIDs

  +II   --invent-instance
          invent a new SOP instance UID for every image sent

  +IR   --invent-series  [n]umber: integer (implies --invent-instance)
          invent a new series UID after n images have been sent
          (default: 100)

  +IS   --invent-study  [n]umber: integer (implies --invent-instance)
          invent a new study UID after n series have been sent
          (default: 50)

  +IP   --invent-patient  [n]umber: integer (implies --invent-instance)
          invent a new patient ID and name after n studies have
          been sent (default: 25)
\endverbatim

\subsection tls_options transport layer security (TLS) options
\verbatim
transport protocol stack options:

  -tls  --disable-tls
          use normal TCP/IP connection (default)

  +tls  --enable-tls  [p]rivate key file, [c]ertificate file: string
          use authenticated secure TLS connection

  +tla  --anonymous-tls
          use secure TLS connection without certificate

private key password options (only with --enable-tls):

  +ps   --std-passwd
          prompt user to type password on stdin (default)

  +pw   --use-passwd  [p]assword: string
          use specified password

  -pw   --null-passwd
          use empty string as password

key and certificate file format options:

  -pem  --pem-keys
          read keys and certificates as PEM file (default)

  -der  --der-keys
          read keys and certificates as DER file

certification authority options:

  +cf   --add-cert-file  [c]ertificate filename: string
          add certificate file to list of certificates

  +cd   --add-cert-dir  [c]ertificate directory: string
          add certificates in d to list of certificates

ciphersuite options:

  +cs   --cipher  [c]iphersuite name: string
          add ciphersuite to list of negotiated suites

  +dp   --dhparam  [f]ilename: string
          read DH parameters for DH/DSS ciphersuites

pseudo random generator options:

  +rs   --seed  [f]ilename: string
          seed random generator with contents of f

  +ws   --write-seed
          write back modified seed (only with --seed)

  +wf   --write-seed-file  [f]ilename: string (only with --seed)
          write modified seed to file f

peer authentication options:

  -rc   --require-peer-cert
          verify peer certificate, fail if absent (default)

  -vc   --verify-peer-cert
          verify peer certificate if present

  -ic   --ignore-peer-cert
          don't verify peer certificate
\endverbatim

\section notes NOTES

\subsection dicom_conformance DICOM Conformance

The \b storescu application supports the following Storage SOP Classes as an
SCU:

\verbatim
StoredPrintStorage                                   1.2.840.10008.5.1.1.27
HardcopyGrayscaleImageStorage                        1.2.840.10008.5.1.1.29
HardcopyColorImageStorage                            1.2.840.10008.5.1.1.30
ComputedRadiographyImageStorage                      1.2.840.10008.5.1.4.1.1.1
DigitalXRayImageStorageForPresentation               1.2.840.10008.5.1.4.1.1.1.1
DigitalXRayImageStorageForProcessing                 1.2.840.10008.5.1.4.1.1.1.1.1
DigitalMammographyXRayImageStorageForPresentation    1.2.840.10008.5.1.4.1.1.1.2
DigitalMammographyXRayImageStorageForProcessing      1.2.840.10008.5.1.4.1.1.1.2.1
DigitalIntraOralXRayImageStorageForPresentation      1.2.840.10008.5.1.4.1.1.1.3
DigitalIntraOralXRayImageStorageForProcessing        1.2.840.10008.5.1.4.1.1.1.3.1
CTImageStorage                                       1.2.840.10008.5.1.4.1.1.2
EnhancedCTImageStorage                               1.2.840.10008.5.1.4.1.1.2.1
RETIRED_UltrasoundMultiframeImageStorage             1.2.840.10008.5.1.4.1.1.3
UltrasoundMultiframeImageStorage                     1.2.840.10008.5.1.4.1.1.3.1
MRImageStorage                                       1.2.840.10008.5.1.4.1.1.4
EnhancedMRImageStorage                               1.2.840.10008.5.1.4.1.1.4.1
MRSpectroscopyStorage                                1.2.840.10008.5.1.4.1.1.4.2
RETIRED_NuclearMedicineImageStorage                  1.2.840.10008.5.1.4.1.1.5
RETIRED_UltrasoundImageStorage                       1.2.840.10008.5.1.4.1.1.6
UltrasoundImageStorage                               1.2.840.10008.5.1.4.1.1.6.1
SecondaryCaptureImageStorage                         1.2.840.10008.5.1.4.1.1.7
MultiframeSingleBitSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.1
MultiframeGrayscaleByteSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.2
MultiframeGrayscaleWordSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.3
MultiframeTrueColorSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.4
StandaloneOverlayStorage                             1.2.840.10008.5.1.4.1.1.8
StandaloneCurveStorage                               1.2.840.10008.5.1.4.1.1.9
TwelveLeadECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.1
GeneralECGWaveformStorage                            1.2.840.10008.5.1.4.1.1.9.1.2
AmbulatoryECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.3
HemodynamicWaveformStorage                           1.2.840.10008.5.1.4.1.1.9.2.1
CardiacElectrophysiologyWaveformStorage              1.2.840.10008.5.1.4.1.1.9.3.1
BasicVoiceAudioWaveformStorage                       1.2.840.10008.5.1.4.1.1.9.4.1
StandaloneModalityLUTStorage                         1.2.840.10008.5.1.4.1.1.10
StandaloneVOILUTStorage                              1.2.840.10008.5.1.4.1.1.11
GrayscaleSoftcopyPresentationStateStorage            1.2.840.10008.5.1.4.1.1.11.1
XRayAngiographicImageStorage                         1.2.840.10008.5.1.4.1.1.12.1
XRayFluoroscopyImageStorage                          1.2.840.10008.5.1.4.1.1.12.2
RETIRED_XRayAngiographicBiPlaneImageStorage          1.2.840.10008.5.1.4.1.1.12.3
NuclearMedicineImageStorage                          1.2.840.10008.5.1.4.1.1.20
RawDataStorage                                       1.2.840.10008.5.1.4.1.1.66
SpatialRegistrationStorage                           1.2.840.10008.5.1.4.1.1.66.1
SpatialFiducialsStorage                              1.2.840.10008.5.1.4.1.1.66.2
VLEndoscopicImageStorage                             1.2.840.10008.5.1.4.1.1.77.1.1
VideoEndoscopicImageStorage                          1.2.840.10008.5.1.4.1.1.77.1.1.1
VLMicroscopicImageStorage                            1.2.840.10008.5.1.4.1.1.77.1.2
MicroscopicImageStorage                              1.2.840.10008.5.1.4.1.1.77.1.2.1
VLSlideCoordinatesMicroscopicImageStorage            1.2.840.10008.5.1.4.1.1.77.1.3
VLPhotographicImageStorage                           1.2.840.10008.5.1.4.1.1.77.1.4
VideoPhotographicImageStorage                        1.2.840.10008.5.1.4.1.1.77.1.4.1
BasicTextSR                                          1.2.840.10008.5.1.4.1.1.88.11
EnhancedSR                                           1.2.840.10008.5.1.4.1.1.88.22
ComprehensiveSR                                      1.2.840.10008.5.1.4.1.1.88.33
ProcedureLogStorage                                  1.2.840.10008.5.1.4.1.1.88.40
MammographyCADSR                                     1.2.840.10008.5.1.4.1.1.88.50
KeyObjectSelectionDocument                           1.2.840.10008.5.1.4.1.1.88.59
ChestCADSR                                           1.2.840.10008.5.1.4.1.1.88.65
PETImageStorage                                      1.2.840.10008.5.1.4.1.1.128
PETCurveStorage                                      1.2.840.10008.5.1.4.1.1.129
RTImageStorage                                       1.2.840.10008.5.1.4.1.1.481.1
RTDoseStorage                                        1.2.840.10008.5.1.4.1.1.481.2
RTStructureSetStorage                                1.2.840.10008.5.1.4.1.1.481.3
RTBeamsTreatmentRecordStorage                        1.2.840.10008.5.1.4.1.1.481.4
RTPlanStorage                                        1.2.840.10008.5.1.4.1.1.481.5
RTBrachyTreatmentRecordStorage                       1.2.840.10008.5.1.4.1.1.481.6
RTTreatmentSummaryRecordStorage                      1.2.840.10008.5.1.4.1.1.481.7
\endverbatim
\if MANPAGES
.fi
\endif

The default behaviour of \b storescu is to propose two presentation contexts
for each supported SOP class (abstract syntax) - one with the preferred
transfer syntax and one with all other uncompressed transfer syntaxes.  The
default preferred transfer syntax is explicit VR with byte ordering
corresponding to the local byte ordering of the machine on which \b storescu
is running.  This behaviour can be changed with the \e --propose, \e --combine
and \e --required options, see above.

The \b storescu application does not support extended negotiation.

\subsection profiles Association Negotiation Profiles and Configuration Files

\b storescu supports a flexible mechanism for specifying the DICOM network
association negotiation behaviour, based on so-called "association
negotiation profiles" which may be read from a configuration file.
The format and semantics of this configuration file are documented in
\e asconfig.txt.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b storescu utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>share/doc/asconfig.txt</em> - configuration file documentation
\n<em>etc/storescu.cfg</em> - example association negotiation profile

\section see_also SEE ALSO

<b>storescp</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1994-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/