/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines tools/types for basic memory card handling
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   04/03/2000
 *
 *****************************************************************************/


#ifndef _MEMORYCARDS_H_
#define _MEMORYCARDS_H_

#include "eco5000.h"
#include "sercom.h"
#include "ctapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "ecotools.h"
#include "defines.h"


/***************************************************/
/* structure for handling all kind of memory cards */
/***************************************************/

struct memorycard_t  {
    int SelectedFile;                     /* currently selected FID/AID          */
    int Path;                             /* start byte of selected data section */
    int CardID;                           /* type of card (4442,4432,I2C)        */
    long Number_of_Data_Units;            /* number of data units on card        */
    int Length_Data_Units;                /* length of data units, 8 = 8 bit     */
    int DIR_data_reference;               /* start byte of dir data section      */
    int ATR_data_reference;               /* start byte of ATR data section      */
    unsigned char Length_of_DIR_section;  /* Length of DIR data section          */
    unsigned char PINVerified;            /* signs whether PIN checked           */
    unsigned char *Memory;                /* complete content of card memory     */
};



/* Defines for supported memory cards / IDs */

#define SLE4432     0x01     /* SLE4432 (no pin)   */
#define SLE4442     0x02     /* SLE4442 (pin)      */
#define SLE4418     0x03     /* SLE4418 (no pin)   */
#define SLE4428     0x04     /* SLE4428 (pin)      */
#define I2C         0x05     /* I2C-Bus card       */

/* Defines response code of basic processing function */

#define COMMAND_UNKNOWN       1

/**************************/
/* Interindustry Commands */
/**************************/

/* Define OMC240SP commands                                                 */
#define READ_MAIN_MEMORY          0x30
#define UPDATE_MAIN_MEMORY        0x38
#define READ_PROTECTION_MEMORY    0x34
#define WRITE_PROTECTION_MEMORY   0x3C
#define READ_SECURITY_MEMORY      0x31
#define UPDATE_SECURITY_MEMORY    0x39
#define COMPARE_VERIFICATION_DATA 0x33

/* Define OMC1024SP commands                                                */
#define READ_MEMORY                 0x0E
#define UPDATE_MEMORY               0x33
#define UPDATE_ERROR_COUNTER        0x32
#define VERIFY_PSC                  0x0D


/*********************************/
/* Here are the selectable Files */
/*********************************/
#define NONE              0x0000
#define MF                0x3F00
#define DIR_DATA_SECTION  0x2F00
#define ATR_DATA_SECTION  0x2F01
#define PROTECTION_MEMORY 0x3F01
#define AID               0x00FF


/****************/
/* various tags */
/****************/
#define MANUFACTURER_DATA_OBJECT   0x46
#define APPLICATION_IDENTIFIER     0x4F
#define APPLICATION_TEMPLATE       0x61
#define APPLICATION_LABEL          0x50
#define DISCRETIONARY_DATA         0x53
#define SEQUENCE                   0x30
#define PATH                       0x51


/******************************/
/* Basic processing functions */
/******************************/

int MemoryCardProcess(struct eco5000_t *ctx,
		      unsigned int lc,
		      unsigned char *cmd,
		      unsigned int *lr,
		      unsigned char *rsp);



int Find_AID (struct eco5000_t *ctx,
	      unsigned char *buffer,
	      unsigned char *aid);


int MemoryCard_Select_File(struct eco5000_t *ctx,
			   unsigned int lc,
			   unsigned char *cmd,
			   unsigned int *lr,
			   unsigned char *rsp);

int MemoryCard_Read_Binary(struct eco5000_t *ctx,
			   unsigned int lc,
			   unsigned char *cmd,
			   unsigned int *lr,
			   unsigned char *rsp);

int MemoryCard_Update_Binary(struct eco5000_t *ctx,
			     unsigned int lc,
			     unsigned char *cmd,
			     unsigned int *lr,
			     unsigned char *rsp);


int DetermineVariables(struct eco5000_t *ctx);


#endif









