/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.2 $
 *
 * $Log: flow_storage.h,v $
 * Revision 1.2  2002/12/13 19:45:20  tim
 * *** empty log message ***
 *
 * Revision 1.1  2002/11/24 23:13:41  tim
 * Initial revision
 *
 *
 */

#ifndef _FLOW_STORAGE_H
#define _FLOW_STORAGE_H

#define	HASH_SLOTS	65536
/* Number of flows to pre-allocate. Increase for high speed interfaces. */
#define	FLOW_ITEMS	2 << 18

#define	FLOW_STATUS_FREE	0
#define	FLOW_STATUS_USED	1
#define FLOW_STATUS_EXPORT	2


typedef struct flow_item_t {
  unsigned int src_ip;
  unsigned int dst_ip;

  unsigned int key;           /* lookup key (based on sport and dport) */
  unsigned char proto;        /* IP protocol */

  unsigned short sport;       /* source port */
  unsigned short dport;       /* destination port */

  unsigned long flow_start;   /* timestamp when flow started */
  unsigned long last_packet;  /* timestamp when last packet was seen */

  unsigned long bytes;        /* number of bytes in all packets */
  unsigned long packets;      /* number of packets in flow */

  unsigned short src_iif, dst_iif;      /* source/destination interface id */
  unsigned int slot;          /* hash bucket number */
  unsigned int particle_id;
  struct flow_item_t *next;
} flow_item_t;


struct hash_slot {
  struct flow_item_t *list;
  unsigned long last_parse;   /* timestamp when the list was parsed */
};

typedef struct hash_slot HASH_TABLE[HASH_SLOTS];

struct flow_item_t *flow_pool;


struct flow_item_t *flow_get_new(void);
struct flow_item_t *flow_particle[FLOW_ITEMS];
char flow_status[FLOW_ITEMS];


#endif
