/***************************************************************************
                          mycanvasitem.h  -  description
                             -------------------
    begin                : Die Apr 23 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYCANVASITEM_H
#define MYCANVASITEM_H

#include <qcanvas.h>
#include <qpoint.h>
#include <qimage.h>
#include <qpicture.h>
#include "mybarcode.h"
#include "tokenprovider.h"

#define BARCODE_RTTI 1001
#define TEXT_RTTI 1002
#define RECT_RTTI 1003
#define PIC_RTTI  1004
#define LINE_RTTI 1005
#define SPOTSIZE 7

class QPixmap;
/** A very small singleton, which creates a pixmap
  * for the accesor points in the label editor.
  *
  * @author Dominik Seichter
  */
class SpotProvider {
    public:
        static SpotProvider* getInstance();

        const QPixmap* spot() const {
            return m_spot;
        }

    private:
        SpotProvider();
        ~SpotProvider();

        static SpotProvider* instance;
        static QPixmap* m_spot;
};

class QColor;
class MyCanvasRectangle : public QCanvasRectangle {
    public:
        MyCanvasRectangle( QCanvas* c, double rotate = 0.0 );
        ~MyCanvasRectangle();

        void setAutoSize( bool b ) {
            m_autosize = b;
        }
        
        void setPixmap( QPixmap* p );
        void setPicture( QPicture* p, int w, int h );
        
        QPixmap getPixmap() const {
            return pix;
        }

        QPixmap getTransformedPixmap();

        void setRot( double r );
        void pMove( QPoint p ) {
            move( (double)p.x(), (double)p.y() );
        }
        
        double getRotation() const {
            return rot;
        }

        virtual void redraw() {
            update();
        };

        void draw ( QPainter & p );

        void setColor( const QColor & c );
        QColor color() const { return m_color; }

    signals:
        void colorChanged();
             
    protected:
        double rot;
        QPixmap pix;
        QPicture picture;
        QColor m_color;
        bool m_autosize;
};

/** A QCanvasItem representing a barcode in the LabelEditor.
  */
class CanvasBarcode : public MyCanvasRectangle, public BarCode {
    public:
        CanvasBarcode( QCanvas* c );
        CanvasBarcode( QCanvas* c, barcodeData* bcode );        
    
        ~CanvasBarcode();

        int rtti() const {
            return BARCODE_RTTI;    
        } 

        void updateBarcode();
};

class QString;
class LabelEditor;
/** A multi line rich text object in the LabelEditor
  */
class CanvasText : public MyCanvasRectangle, public TokenProvider {
    public:
        CanvasText( QCanvas* c, LabelEditor* editor );
        CanvasText( const QString & t, QCanvas* c, LabelEditor* editor );
        ~CanvasText();

        int rtti() const {
            return TEXT_RTTI;
        }
        
        void setText( const QString & t ) {
            stext = t;
            draw();
        }

        const QString text() const { return stext; }

        void redraw() {
            draw();
            MyCanvasRectangle::update();
        }
        
    private:
        void draw();
        void init();
        
    protected:
        QString stext;
        LabelEditor* m_editor;
};

/** A colored rectangle or ellipse in the LabelEditor.
  */
class DrawingRect : public MyCanvasRectangle {
    public:
        DrawingRect( QCanvas* c );
        DrawingRect( const QColor & cl, QCanvas* c );
        ~DrawingRect();

        int rtti() const {
            return RECT_RTTI;
        }

        void redraw() {
            draw();
            update();
        }

        void setCircle( bool b ) {
            m_circle = b;
            redraw();
        }
        
        bool isCircle() const {
            return m_circle;
        }

        void setBorderColor( const QColor & c ) {
            m_bordercolor = c;
            redraw();
        }

        const QColor borderColor() const {
            return m_bordercolor;
        }

        void setBorderWidth( int w ) {
            m_borderwidth = w;
            redraw();
        }

        int borderWidth() const {
            return borderStyle() ? m_borderwidth : 0;
        }

        void setBorderStyle( int s ) {
            m_borderstyle = s;
            redraw();
        }

        int borderStyle() const {
            return m_borderstyle;
        }
        
    private:
        void draw();
        void init();
        
        bool m_circle;
        QColor m_bordercolor;
        int m_borderwidth;
        int m_borderstyle;
};

class QImage;
class PictureRectangle : public MyCanvasRectangle {
    public:
        PictureRectangle( QCanvas* c );
        ~PictureRectangle() { };

        int rtti() const {
            return PIC_RTTI;
        }
        
        void redraw() {
            draw();
            update();
        }
        
        void setImage( QImage* img ); 
        QImage getImage() const {
            return pic;
        }

    private:
        void draw();
        QImage pic;    
};

class QRect;
class QRegion;
class MyCanvasLine : public QCanvasItem {
    public:
        MyCanvasLine( QCanvas* c );
        ~MyCanvasLine();

        void setPoints( int xa, int ya, int xb, int yb );
        void setPen( const QPen & p ) {
            m_pen = p;
        }
                
        QPen pen() const { return m_pen; }
        int rtti() const { return LINE_RTTI; }

        void moveBy( double dx, double dy );
        void move( double x, double y );
        void setStartPoint( int xa, int ya );
        
        QRect boundingRect() const;
        QPoint startPoint() const;
        QPoint endPoint() const;

        bool collidesWith( const QCanvasItem* ) const { return false; }
        bool collidesWith( const QCanvasSprite*, const QCanvasPolygonalItem*, const QCanvasRectangle*, const QCanvasEllipse*, const QCanvasText*) const { return false; } 
    protected:
        void draw( QPainter & p );

    private:
        QPen m_pen;
        int x1, y1;
};

#endif
