/***************************************************************************
                          kfocusdialogcompletetask.cpp  -  description
                             -------------------
    begin                : Sun Aug 26 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qstring.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <kiconloader.h>

#include "kfocusdialogcompletetask.h"

#include "kfocustask.h"
#include "kfocuslogentry.h"

#include "kfocustaskpropsview.h"
#include "kfvlog.h"

KFDCompleteTask::KFDCompleteTask(int tasksRemaining,
																									 QWidget *parent,
																									 const char *name )
 : KDialog(parent,name,true)
{
	task_ = new KFMTask();
	log_ = new KFMLog();
	createWidgets(tasksRemaining);
}


KFDCompleteTask::~KFDCompleteTask(){
	delete task_;
	delete log_;
}


/////////////////////////////////////////////////////////////////
// Private methods


void KFDCompleteTask::createLogWidgets(QLayout* lParent){
	QVBoxLayout* vbl = new QVBoxLayout(lParent);
		cbLog_ = new QCheckBox("Log the completed task", this);
			connect(cbLog_, SIGNAL( toggled(bool) ), this, SLOT( onCbLogToggled(bool) ));
			vbl->addWidget(cbLog_);
		
		vLog_ = new KFVLog(this);
			vbl->addWidget(vLog_);
}

void KFDCompleteTask::createLeftWidgets(QLayout* lParent, int tasksRemaining){
	QVBoxLayout* vbl = new QVBoxLayout(lParent);
		vbl->setSpacing(spacingHint());
	
		// Congratulations panel
		QHBoxLayout* hbl = new QHBoxLayout(vbl);
			hbl->setMargin(2*marginHint());
			hbl->addWidget(new QWidget(this));
		
			QLabel* lMsg = new QLabel(this);
				KIconLoader iconLoader;
					lMsg->setPixmap(iconLoader.loadIcon("run", KIcon::Desktop));
				hbl->addWidget(lMsg);
			
			lMsg = new QLabel("Congratulations!  One down, "
													+ QString::number(tasksRemaining)
													+ " more to go.", this);
			hbl->addWidget(lMsg);
			
			hbl->addWidget(new QWidget(this));
			
		QFrame* frame = new QFrame(this);
			frame->setFrameStyle(QFrame::HLine | QFrame::Raised);
			vbl->addWidget(frame);
			
		createLogWidgets(vbl);
}
	
void KFDCompleteTask::createWidgets(int tasksRemaining){
	setCaption("Complete Task");
	
	// Make widgets
	QVBoxLayout* vbl1;
		vbl1 = new QVBoxLayout(this);
		vbl1->setMargin(marginHint());
		vbl1->setSpacing(spacingHint());

		QHBoxLayout* hbl1 = new QHBoxLayout(vbl1); {
		
			createLeftWidgets(hbl1, tasksRemaining);
		
			// Divide Gratz panel from Followup panel
			QFrame* fVDivide = new QFrame(this); {
				fVDivide->setFrameShape(QFrame::VLine);
				fVDivide->setFrameShadow(QFrame::Sunken);
				hbl1->addWidget(fVDivide);
				}
				
			// Followup task panel
			QVBoxLayout* vblFollowup = new QVBoxLayout(hbl1); {
				// Checkbox to enable the panel
				cbFollowup_ = new QCheckBox("Schedule followup task", this);
					connect(cbFollowup_, SIGNAL( toggled(bool) ), this,
							SLOT( onCbFollowupToggled(bool) ));
					vblFollowup->addWidget(cbFollowup_);
					
				// View of the task
				vTaskProps_ = new KFVTask(this, "FollowupTaskProps");
					vblFollowup->addWidget(vTaskProps_);
					
				vblFollowup->addWidget(new QWidget(this));
				}
			}
				
		
		QFrame* fDivide = new QFrame(this);
			fDivide->setFrameShape(QFrame::HLine);
			fDivide->setFrameShadow(QFrame::Raised);
			vbl1->addWidget(fDivide);
			
		hbl1 = new QHBoxLayout(vbl1); {
			hbl1->setMargin(marginHint());
			hbl1->setSpacing(spacingHint());
			hbl1->addWidget(new QWidget(this));
			
			QPushButton* pb = new QPushButton("&Continue", this);
				pb->setDefault(true);
				connect(pb, SIGNAL( clicked() ), this, SLOT( accept() ));
				hbl1->addWidget(pb);
			
			pb = new QPushButton("C&ancel", this);
				connect(pb, SIGNAL( clicked() ), this, SLOT( reject() ));
				hbl1->addWidget(pb);
			}
}


void KFDCompleteTask::onCbFollowupToggled(bool on){
	if (on) {
		vTaskProps_->task(task_);
		vTaskProps_->titleLineEditSelected(true);
	}
	else {
		vTaskProps_->task(NULL);
	}
}


void KFDCompleteTask::onCbLogToggled(bool on){
	if (on) {
		vLog_->log(log_);
	}
	else {
		vLog_->log(NULL);	
	}
}

//////////////////////////////////////////////////////////
// Protected methods
void KFDCompleteTask::accept(){
	KDialog::accept();
}

//////////////////////////////////////////////////////////
// Public methods

/** Specify the completed task to the dialog so it can initialize the followup task */
void KFDCompleteTask::completedTask(KFMTask* task){
	// Initialize followup task
	task_->title(QString("Followup on: ") + task->title());
	if (!task->comments().isEmpty()) {
		task_->comments(QString("Comments from previous task:\n\n")
			+ task->comments());
	}
		
	// Initialize log
	QString body = QString("Completed a task: ") + task->title();
	if (!task->comments().isEmpty()) {
			body += QString("\n\nTask comments:\n") + task->comments();
	}
	log_->body(body);
}


/** Query the followup task that was defined in the dialog */
KFMTask* KFDCompleteTask::followupTask() const{
	if (cbFollowup_->isChecked()) {
		return task_;
	}
	else
		return NULL;
}


/** Query the log that was defined in the dialog */
KFMLog* KFDCompleteTask::log() const{
	if (cbLog_->isChecked()) {
		return log_;
	}
	else
		return NULL;
}
