/***************************************************************************
                          kfocusdoc.h  -  description
                             -------------------
    begin                : Sun Aug 12 08:36:08 PDT 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSDOC_H
#define KFOCUSDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qxml.h>
#include <qfile.h>

// include files for KDE
#include <kurl.h>

// forward declaration of the KFocus classes
class KFocusView;
class KFMProjectList;

/**	KFocusDoc provides a document object for a document-view model.
  *
  * The KFocusDoc class provides a document object that can be used in conjunction with the classes KFocusApp and KFocusView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KFocusApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KFocusView objects. Also, KFocusDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KFocusDoc : public QObject
{
  Q_OBJECT
public:
  /** Constructor for the fileclass of the application */
  KFocusDoc(QWidget *parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~KFocusDoc();

  /** adds a view to the document which represents the document contents. Usually this is your main view. */
  void addView(KFocusView *view);
  /** removes a view from the list of currently connected views */
  void removeView(KFocusView *view);
  /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
  void setModified(bool _m=true);
  /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
  bool isModified(){ return modified; };
  /** "save modified" - asks the user for saving if the document is modified */
  bool saveModified();	
  /** deletes the document's contents */
  void deleteContents();
  /** initializes the document generally */
  bool newDocument();
  /** closes the acutal document */
  void closeDocument();
  /** loads the document by filename and format and emits the updateViews() signal */
  bool openDocument(const KURL& url, const char *format=0);
  /** saves the document under filename and format.*/	
  bool saveDocument(const KURL& url, const char *format=0);
  /** returns the KURL of the document */
  const KURL& URL() const;
  /** sets the URL of the document */
  void setURL(const KURL& url);
  /** Test if the document is untitled */
  bool isUntitled() const;

  /** Read the doc's projectList */
 	KFMProjectList* projectList() const;
  										 	
public slots:
  /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
   * As this view normally repaints itself, it is excluded from the paintEvent.
   */
  void slotUpdateAllViews(KFocusView *sender);

signals: // Signals
  /** Signal that the document is empty of content */
  void documentEmpty();
  /** Signal when the document finishes loading a file */
  void fileLoaded();
  /** Signal sent when the document is modified */
  void modifiedSet( bool modified );

private: // Private attributes
  /** the list of the views currently connected to the document */
  static QList<KFocusView> *pViewList;	
  /** the modified flag of the current document */
  bool modified;
  KURL doc_url;

  KFMProjectList* projectList_;

private: // Private methods
 	/** Load a KFocus data file */
 	bool loadFile(QString filename);
 	
 	void projectList(KFMProjectList* project);
	
private slots: // Private slots
  /** Slot for when a document component changes */
  void onComponentChanged();
};

#endif // KFOCUSDOC_H
