/* this is the brisby fancy buffer */
#ifndef __bin_h
#define __bin_h

#include "mem.h"
#include "error.h"

#define bin_init(s) do { s[0].buf = 0; s->len = s->used = 0; } while(0)

struct bin_s {
	char *buf;
	int len;
	int used;
};

typedef struct bin_s bin_t[1];

#define caddr(x) ((x)->buf)
#define clen(x) ((x)->used)

#include <stdlib.h>

static void inline bin_need(bin_t p, int tot)
{
	if (tot > p->len) {
		/* Clib */
		p->buf = realloc(p->buf, tot);
		if (!p->buf) {
			cfatal("bin_need:realloc: %s");
		}
		p->len = tot;
	}
}
static void inline bin_needplus(bin_t p, int amu)
{
	bin_need(p, p->used+amu);
}

static void inline bin_cat(bin_t p, char *s, int len) {
	bin_needplus(p, len);
	memcpy(p->buf + p->used, s, len);
	p->used += len;
}

static void inline bin_addch(bin_t p, int ch) {
	char b[2];

	b[0] = ch;
	bin_cat(p, b, 1);
}

static void inline bin_empty(bin_t p) {
	if (p) p->used = 0;
}
static void inline bin_0(bin_t p) {
	bin_addch(p, '\0');
}

static void inline bin_copy(bin_t p, const char *s, int len) {
	bin_need(p, len);
	memcpy(p->buf, s, len);
	p->used = len;
}

static int inline bin_len(bin_t p) {
	return p->len;
}

#endif
