#include <curses.h>
#include <stdio.h>
#include <signal.h>
#include <sys/fcntl.h>

#ifdef ATT
#define	crmode()	cbreak()
#define bzero(s,n)	memset(s,0,n)
#endif

void	die();
extern	FILE 		*popen();
extern	int 		pclose();
extern	long		time();
extern	char		*ctime();

main(argc, argv)
int argc;
char *argv[];
{
	int hor = 0, ver = 0;
	FILE *piper;
	char buf[180];
	char blank[180];		/* Bdale hack */
	char cmd[128];
	int count = 1;
	long timer;
	int nsecs = 2;

	if (argc < 2) {
		fprintf(stderr, "Usage: %s command [args]\n", argv[0]);
		exit(1);
	} /* if */

	/* If -n is specified, convert the next argument to the numver
	 * for the number of seconds
	 */
	if (strcmp(argv[1], "-n") == 0) {
		nsecs = atoi(argv[2]);
		count = 3;
		if (nsecs == 0 || argc < 3) {
			fprintf(stderr, "Usage: %s command [args]\n", argv[0]);
			exit(1);
		} /* if */
	} /* if */

	/* Build command string to give to popen */
	(void)bzero(cmd, sizeof(cmd));
	strcpy(cmd, argv[count]);
	while (++count < argc) {
		strcat(cmd, " ");
		strcat(cmd, argv[count]);
	} /* while */

	/* Catch keyboard interrupts so we can
	 * put tty back in a sane state 
	 */
	(void) signal(SIGINT, die);
	(void) signal(SIGTERM, die);
	(void) signal(SIGHUP, die);

	/* Set up tty for curses use */
	initscr();
	nonl();
	noecho();
	crmode();

	/* create an array of all blanks */
	while (ver < 180) blank[ver++] = ' ';
	blank[COLS-1] = '\0';
	ver = 0;

	while(1) { /* loop forever */

		/* Put up time interval and current time */
		move(hor, ver);
		time(&timer);
		printw("Every %d seconds\t\t%s\t\t%s", nsecs, cmd, ctime(&timer));
		hor = 2;

		/* Open pipe to command */
		if ((piper = popen(cmd, "r")) == (FILE *)NULL) {
			perror("popen");
			exit(2);
		} /* if */


		/* Read in output from the command and make sure 
	 	* that it will fit on 1 screen 
	 	*/
		while ((fgets(buf, sizeof(buf), piper) != NULL) && hor < LINES) {
			buf[COLS-1] = '\0';
			mvaddstr(hor, ver, buf);
			hor++;
		} /* while */

		/* Now, clear off the bottom of the screen past what we got
		*  from the pipe...  Bdale hack 910716
		*/
		while (hor < LINES) {
			mvaddstr(hor, ver, blank);
			hor++;
		}
		refresh();

		sleep(nsecs);
		hor = 0; /* Go back to the top of screen */
		pclose(piper);

	} /* while */
} /* main */


void
die()
{
	/* Ignore interrupts while we clear the screen
	 * and reset the tty 
	 */
	(void) signal(SIGINT, SIG_IGN);
	clear(); 
	refresh(); 
	endwin();
	exit(0);
} /* die */
