#ifndef ___ARENA_FORMS_TYPES_H___
#  define ___ARENA_FORMS_TYPES_H___


#include "editor_types.h"
#include "image_types.h"


typedef enum { GET = 0, POST = 1, ISINDEX = 6, MAILTO = 9 } FormSubmitMethod;

typedef struct option_struct
{
 struct option_struct *next; /* linked list of options */
 unsigned char flags;        /* OPTION_CHECKED, OPTION_DISABLED, etc. */
 char *label;
 char *value;                /* differs from label if there is `value="..."' */
 int j;                      /* option index number */
} Option;


typedef struct field_struct
{
 struct field_struct *next;  /* linked list of fields */
 struct form_struct  *form;  /* the parent form */
 Option* options;            /* linked list of options */
 unsigned char type;         /* RADIOBUTTON, CHECKBOX, ... */
 unsigned char flags;        /* MULTIPLE, CHECKED, DISABLED */
 char *name;                 /* field name attribute */
 int nlen;                   /* name length --Spif */
 char *value;                /* malloc'ed buffer */
 int pos;                    /* current editing position in buffer (`value') */
 Image* image;               /* SUBMIT & RESET can be images --Spif */
 int bufsize;                /* current buffer size */
 int buflen;                 /* length of useful data */
 int maxlength;              /* maxlength parameter for text fields */
 int above;                  /* above baseline */
 int width;                  /* in pixels */
 int height;                 /* in pixels */
 int x;                      /* from left of document */
 int x_indent;               /* for text fields */
 int y_indent;
 long baseline;              /* from start of document */
 int object;                 /* offset in paint stream */
 int frame_indent;           /* this is a kludge !!!! */
 TextField* text_field;      /* howcome 20/1/95 */
} Field;


typedef struct form_struct
{
 struct form_struct *next;   /* linked list of forms */
 FormSubmitMethod  method;   /* Method */
 char *action;               /* URL from ACTION attriubte */
 int  alen;                  /* size of URL --Spif */
 Field* fields;              /* linked list of fields */
} Form;


#endif /* ifndef ___ARENA_FORMS_TYPES_H___ */
