/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import netscape.plugin.composer.io.Comment;

public class SelectedHTMLReader
extends Reader {
    private Reader in;
    private Writer out;
    private int index;
    private int length;
    private String string;

    public SelectedHTMLReader(Reader in) throws IOException {
        this(in, null);
    }

    public SelectedHTMLReader(Reader in, Writer out) throws IOException {
        int len;
        this.in = in;
        this.out = out;
        StringBuffer buffer = new StringBuffer(1024);
        char[] temp = new char[1024];
        while ((len = in.read(temp)) >= 0) {
            buffer.append(temp, 0, len);
        }
        this.string = new String(buffer);
        String startComment = Comment.createSelectionStart().toString();
        String endComment = Comment.createSelectionEnd().toString();
        int start = this.string.indexOf(startComment);
        if (start < 0 && (start = this.string.indexOf(Comment.createSelectionStart(true).toString())) < 0) {
            System.err.println(this.string);
            throw new IOException("No start comment.");
        }
        int end = this.string.indexOf(endComment, start);
        if (end < 0) {
            String stickyEnd = Comment.createSelectionEnd(true).toString();
            end = this.string.indexOf(stickyEnd, start);
            if (end < 0) {
                System.err.println(this.string);
                throw new IOException("No end comment");
            }
            end += stickyEnd.length();
        } else {
            end += endComment.length();
        }
        this.index = start;
        this.length = end;
        if (out != null) {
            out.write(this.string, 0, this.index);
        }
    }

    public void close() throws IOException {
        this.in.close();
        if (this.out != null) {
            int toWrite = this.string.length() - this.index;
            this.out.write(this.string, this.index, toWrite);
            this.index = this.string.length();
        }
    }

    public int read() throws IOException {
        if (this.index >= this.length) {
            return -1;
        }
        return this.string.charAt(this.index++);
    }

    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(char[] buf, int start, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        int trueLength = Math.min(length, this.length - this.index);
        if (trueLength <= 0) {
            return -1;
        }
        this.string.getChars(this.index, this.index + trueLength, buf, start);
        this.index += trueLength;
        return trueLength;
    }

    public long skip(long count) throws IOException {
        long trueSkip = Math.max(0L, Math.min(count, (long)this.length - (long)this.index));
        this.index += (int)trueSkip;
        return trueSkip;
    }
}

