/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;

public class LDAPSSLSocketFactory
implements LDAPSocketFactory {
    private boolean m_isClientAuth = false;
    private String m_packageName = "netscape.net.SSLSocket";

    public LDAPSSLSocketFactory() {
    }

    public LDAPSSLSocketFactory(String className) {
        this.m_packageName = new String(className);
    }

    public void enableClientAuth() {
        this.m_isClientAuth = true;
    }

    public void enableClientAuth(String certdb, String keydb, String keypwd, String certnickname, String keynickname) throws LDAPException {
        throw new LDAPException("Client auth not supported now");
    }

    public boolean isClientAuth() {
        return this.m_isClientAuth;
    }

    public String getSSLSocketImpl() {
        return this.m_packageName;
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        Socket s = null;
        if (this.m_isClientAuth) {
            try {
                Method m = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
                if (m != null) {
                    Object[] args = new Object[]{new String("ClientAuth")};
                    m.invoke(null, args);
                }
            }
            catch (Exception e) {
                throw new LDAPException("Invoking enablePrivilege: " + e.toString(), 89);
            }
        }
        try {
            Class<?> c = Class.forName(this.m_packageName);
            Constructor<?>[] m = c.getConstructors();
            int i = 0;
            while (i < m.length) {
                Class<?>[] params = m[i].getParameterTypes();
                if (params.length == 2 && params[0].getName().equals("java.lang.String") && params[1].getName().equals("int")) {
                    Object[] args = new Object[]{host, new Integer(port)};
                    s = (Socket)m[i].newInstance(args);
                    return s;
                }
                ++i;
            }
            throw new LDAPException("No appropriate constructor in " + this.m_packageName, 89);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class " + this.m_packageName + " not found", 89);
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }
}

