/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.ColorWell;
import netscape.application.ContainerView;
import netscape.application.Font;
import netscape.application.InternalWindow;
import netscape.application.Size;
import netscape.application.Slider;
import netscape.application.Target;
import netscape.application.TextField;
import netscape.application.TextFieldOwner;
import netscape.application.View;
import netscape.application.Window;

public class ColorChooser
implements Target,
TextFieldOwner {
    ColorWell _colorWell;
    Slider _redSlider;
    Slider _greenSlider;
    Slider _blueSlider;
    TextField _redTextField;
    TextField _greenTextField;
    TextField _blueTextField;
    private ContainerView contentView = new ContainerView(0, 0, 157, 113);
    private Window window;
    private static final String COLOR_CHANGED = "colorChanged";

    public ColorChooser() {
        this.contentView.setBackgroundColor(Color.lightGray);
        this.contentView.setBorder(null);
        this.contentView.setHorizResizeInstruction(2);
        this.contentView.setVertResizeInstruction(16);
        this._colorWell = new ColorWell(3, 3, 152, 40);
        this._colorWell.setHorizResizeInstruction(2);
        this._colorWell.setVertResizeInstruction(16);
        this._colorWell.setTarget(this);
        this.contentView.addSubview(this._colorWell);
        this._redSlider = new Slider(3, 50, 120, 13);
        this._redSlider.setBuffered(true);
        this._redSlider.setImageDisplayStyle(1);
        this._redSlider.setImage(Bitmap.bitmapNamed("netscape/application/RedGrad.gif"));
        this._redSlider.setTarget(this);
        this._redSlider.setCommand(COLOR_CHANGED);
        this._redSlider.setValue(255);
        this._redSlider.setHorizResizeInstruction(2);
        this._redSlider.setVertResizeInstruction(8);
        this.contentView.addSubview(this._redSlider);
        this._greenSlider = new Slider(3, 68, 120, 13);
        this._greenSlider.setBuffered(true);
        this._greenSlider.setImageDisplayStyle(1);
        this._greenSlider.setImage(Bitmap.bitmapNamed("netscape/application/GreenGrad.gif"));
        this._greenSlider.setTarget(this);
        this._greenSlider.setCommand(COLOR_CHANGED);
        this._greenSlider.setValue(255);
        this._greenSlider.setHorizResizeInstruction(2);
        this._greenSlider.setVertResizeInstruction(8);
        this.contentView.addSubview(this._greenSlider);
        this._blueSlider = new Slider(3, 86, 120, 13);
        this._blueSlider.setBuffered(true);
        this._blueSlider.setImageDisplayStyle(1);
        this._blueSlider.setImage(Bitmap.bitmapNamed("netscape/application/BlueGrad.gif"));
        this._blueSlider.setTarget(this);
        this._blueSlider.setCommand(COLOR_CHANGED);
        this._blueSlider.setValue(255);
        this._blueSlider.setHorizResizeInstruction(2);
        this._blueSlider.setVertResizeInstruction(8);
        this.contentView.addSubview(this._blueSlider);
        Font fieldFont = Font.fontNamed("Helvetica", 0, 10);
        this._redTextField = new TextField(125, 49, 30, 16);
        this._redTextField.setContentsChangedCommandAndTarget("", this);
        this._redTextField.setFont(fieldFont);
        this._redTextField.setTextColor(Color.darkGray);
        this._redTextField.setBackgroundColor(Color.white);
        this._redTextField.setIntValue(this._redSlider.value());
        this._redTextField.setHorizResizeInstruction(1);
        this._redTextField.setVertResizeInstruction(8);
        this.contentView.addSubview(this._redTextField);
        this._greenTextField = new TextField(125, 67, 30, 16);
        this._greenTextField.setContentsChangedCommandAndTarget("", this);
        this._greenTextField.setFont(fieldFont);
        this._greenTextField.setTextColor(Color.darkGray);
        this._greenTextField.setBackgroundColor(Color.white);
        this._greenTextField.setIntValue(this._greenSlider.value());
        this._greenTextField.setHorizResizeInstruction(1);
        this._greenTextField.setVertResizeInstruction(8);
        this.contentView.addSubview(this._greenTextField);
        this._blueTextField = new TextField(125, 85, 30, 16);
        this._blueTextField.setIntValue(this._blueSlider.value());
        this._blueTextField.setTextColor(Color.darkGray);
        this._blueTextField.setBackgroundColor(Color.white);
        this._blueTextField.setContentsChangedCommandAndTarget("", this);
        this._blueTextField.setFont(fieldFont);
        this._blueTextField.setHorizResizeInstruction(1);
        this._blueTextField.setVertResizeInstruction(8);
        this.contentView.addSubview(this._blueTextField);
        this._redTextField.setOwner(this);
        this._blueTextField.setOwner(this);
        this._updateColorWell();
    }

    public void show() {
        if (this.window != null) {
            this.window.show();
        }
    }

    public void hide() {
        if (this.window != null) {
            this.window.hide();
        }
    }

    private void _updateColorWell() {
        this._colorWell.setColor(new Color(this._redSlider.value(), this._greenSlider.value(), this._blueSlider.value()));
    }

    public void setColor(Color aColor) {
        if (aColor != null) {
            this._redSlider.setValue(aColor.red());
            this._redTextField.setIntValue(aColor.red());
            this._greenSlider.setValue(aColor.green());
            this._greenTextField.setIntValue(aColor.green());
            this._blueSlider.setValue(aColor.blue());
            this._blueTextField.setIntValue(aColor.blue());
            this._updateColorWell();
        }
    }

    public Color color() {
        return this._colorWell.color();
    }

    public void performCommand(String command, Object data) {
        if (data == this._redTextField) {
            this._redSlider.setValue(this._redTextField.intValue());
            this._redTextField.setIntValue(this._redSlider.value());
        } else if (data == this._greenTextField) {
            this._greenSlider.setValue(this._greenTextField.intValue());
            this._greenTextField.setIntValue(this._greenSlider.value());
        } else if (data == this._blueTextField) {
            this._blueSlider.setValue(this._blueTextField.intValue());
            this._blueTextField.setIntValue(this._blueSlider.value());
        } else if (data == this._redSlider) {
            this._redTextField.setIntValue(this._redSlider.value());
        } else if (data == this._greenSlider) {
            this._greenTextField.setIntValue(this._greenSlider.value());
        } else if (data == this._blueSlider) {
            this._blueTextField.setIntValue(this._blueSlider.value());
        } else if (data == this._colorWell) {
            this.setColor(this._colorWell.color());
            return;
        }
        this._updateColorWell();
    }

    public void textEditingDidBegin(TextField textField) {
    }

    public void textWasModified(TextField textField) {
    }

    public boolean textEditingWillEnd(TextField textField, int endCondition, boolean contentsChanged) {
        return true;
    }

    public void textEditingDidEnd(TextField textField, int endCondition, boolean contentsChanged) {
    }

    public void setWindow(Window aWindow) {
        this.window = aWindow;
        Size windowSize = this.window.windowSizeForContentSize(this.contentView.width(), this.contentView.height());
        this.window.sizeTo(windowSize.width, windowSize.height);
        this.window.setTitle("Color Chooser");
        if (this.window instanceof InternalWindow) {
            InternalWindow iWindow = (InternalWindow)this.window;
            iWindow.setCloseable(true);
        }
        this.window.setContainsDocument(false);
        this.window.addSubview(this.contentView);
    }

    public Window window() {
        return this.window;
    }

    public View contentView() {
        return this.contentView;
    }
}

