/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.Graphics;
import netscape.application.Rect;
import netscape.application.ScrollBar;
import netscape.application.ScrollBarOwner;
import netscape.application.ScrollView;
import netscape.application.ScrollViewLineBorder;
import netscape.application.Size;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ScrollGroup
extends View
implements ScrollBarOwner {
    ScrollView scrollView;
    ScrollBar vertScrollBar;
    ScrollBar horizScrollBar;
    Border border = EmptyBorder.emptyBorder();
    Border interiorBorder = new ScrollViewLineBorder();
    Color cornerColor;
    int horizScrollDisplay;
    int vertScrollDisplay;
    private boolean ignoreScrollBars;
    private static final boolean debugScrollers = false;
    public static final int NEVER_DISPLAY = 0;
    public static final int ALWAYS_DISPLAY = 1;
    public static final int AS_NEEDED_DISPLAY = 2;
    static final String SCROLLVIEW_KEY = "scrollView";
    static final String VERTSCROLLBAR_KEY = "vertScrollBar";
    static final String HORIZSCROLLBAR_KEY = "horizScrollBar";
    static final String BORDER_KEY = "border";
    static final String HORIZDISPLAY_KEY = "horizScrollDisplay";
    static final String VERTDISPLAY_KEY = "vertScrollDisplay";
    static final String CORNER_COLOR_KEY = "cornerColor";

    public ScrollGroup() {
        this(0, 0, 0, 0);
    }

    public ScrollGroup(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ScrollGroup(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.scrollView = this.createScrollView();
        this.addSubview(this.scrollView);
        this.horizScrollBar = this.createScrollBar(true);
        this.horizScrollBar.setScrollableObject(this.scrollView);
        this.horizScrollBar.setScrollBarOwner(this);
        this.scrollView.addScrollBar(this.horizScrollBar);
        this.addSubview(this.horizScrollBar);
        this.vertScrollBar = this.createScrollBar(false);
        this.vertScrollBar.setScrollableObject(this.scrollView);
        this.vertScrollBar.setScrollBarOwner(this);
        this.scrollView.addScrollBar(this.vertScrollBar);
        this.addSubview(this.vertScrollBar);
        this.ignoreScrollBars = false;
        this.setCornerColor(Color.lightGray);
        this.layoutView(0, 0);
    }

    public Size minSize() {
        Size minSize = super.minSize();
        if (minSize != null && (minSize.width != 0 || minSize.height != 0)) {
            return minSize;
        }
        if (this.vertScrollDisplay == 0 && this.horizScrollDisplay == 0) {
            return new Size(this.border.widthMargin(), this.border.heightMargin());
        }
        if (this.vertScrollDisplay != 0 && this.horizScrollDisplay != 0) {
            return new Size(this.border.widthMargin() + this.horizScrollBar().minSize().width + this.vertScrollBar().minSize().width, this.border.heightMargin() + this.horizScrollBar().minSize().height + this.vertScrollBar().minSize().height);
        }
        if (this.horizScrollDisplay == 1 || this.horizScrollDisplay == 2) {
            return new Size(this.border.widthMargin() + this.horizScrollBar().minSize().width, this.border.heightMargin() + this.horizScrollBar().minSize().height * 2);
        }
        if (this.vertScrollDisplay == 1 || this.vertScrollDisplay == 2) {
            return new Size(this.border.widthMargin() + this.vertScrollBar().minSize().width * 2, this.border.heightMargin() + this.vertScrollBar().minSize().height);
        }
        return super.minSize();
    }

    public boolean isTransparent() {
        Vector sViews = this.subviews();
        int count = sViews.count();
        int i = 0;
        while (i < count) {
            if (((View)this.subviews().elementAt(i)).isTransparent()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setBorder(Border newBorder) {
        if (newBorder == null) {
            newBorder = EmptyBorder.emptyBorder();
        }
        this.interiorBorder = newBorder;
        this.layoutView(0, 0);
    }

    public Border border() {
        return this.interiorBorder;
    }

    protected ScrollView createScrollView() {
        return new ScrollView(0, 0, this.bounds.width, this.bounds.height);
    }

    public ScrollView scrollView() {
        return this.scrollView;
    }

    protected ScrollBar createScrollBar(boolean horizontal) {
        ScrollBar aBar = horizontal ? new ScrollBar(0, 0, this.bounds.width, 1, 0) : new ScrollBar(0, 0, 1, this.bounds.height, 1);
        return aBar;
    }

    public void setHasVertScrollBar(boolean flag) {
        if (flag) {
            this.setVertScrollBarDisplay(1);
            return;
        }
        this.setVertScrollBarDisplay(0);
    }

    public boolean hasVertScrollBar() {
        return this.vertScrollDisplay == 1;
    }

    public void setVertScrollBarDisplay(int flag) {
        this.vertScrollDisplay = flag;
        if (this.vertScrollBar == null) {
            this.vertScrollBar = this.createScrollBar(false);
            this.vertScrollBar.setScrollableObject(this.scrollView);
            this.vertScrollBar.setScrollBarOwner(this);
            this.scrollView.addScrollBar(this.vertScrollBar);
            this.addSubview(this.vertScrollBar);
        }
        this.layoutView(0, 0);
    }

    public int vertScrollBarDisplay() {
        return this.vertScrollDisplay;
    }

    public ScrollBar vertScrollBar() {
        return this.vertScrollBar;
    }

    public void setHasHorizScrollBar(boolean flag) {
        if (flag) {
            this.setHorizScrollBarDisplay(1);
            return;
        }
        this.setHorizScrollBarDisplay(0);
    }

    public boolean hasHorizScrollBar() {
        return this.horizScrollDisplay == 1;
    }

    public void setHorizScrollBarDisplay(int flag) {
        this.horizScrollDisplay = flag;
        if (this.horizScrollBar == null) {
            this.horizScrollBar = this.createScrollBar(true);
            this.horizScrollBar.setScrollableObject(this.scrollView);
            this.horizScrollBar.setScrollBarOwner(this);
            this.scrollView.addScrollBar(this.horizScrollBar);
            this.addSubview(this.horizScrollBar);
        }
        this.layoutView(0, 0);
    }

    public int horizScrollBarDisplay() {
        return this.horizScrollDisplay;
    }

    public ScrollBar horizScrollBar() {
        return this.horizScrollBar;
    }

    private void putParts() {
        this.horizScrollBar.removeFromSuperview();
        this.vertScrollBar.removeFromSuperview();
        if (this.scrollView == null) {
            return;
        }
        Rect contentBounds = new Rect(0, 0, 0, 0);
        if (this.horizScrollBar != null && this.horizScrollBar.scrollableObject() != null) {
            contentBounds.width = this.horizScrollBar.scrollableObject().lengthOfContentViewForAxis(0);
        } else if (this.scrollView.contentView != null) {
            contentBounds.width = this.scrollView.contentView.bounds.width;
        }
        if (this.vertScrollBar != null && this.vertScrollBar.scrollableObject() != null) {
            contentBounds.height = this.vertScrollBar.scrollableObject().lengthOfContentViewForAxis(1);
        } else if (this.scrollView.contentView != null) {
            contentBounds.height = this.scrollView.contentView.bounds.height;
        }
        int sViewX = this.border.leftMargin() + this.interiorBorder.leftMargin();
        int sViewY = this.border.topMargin() + this.interiorBorder.topMargin();
        int sViewWidth = this.bounds.width - this.border.widthMargin() - this.interiorBorder.widthMargin();
        int sViewHeight = this.bounds.height - this.border.heightMargin() - this.interiorBorder.heightMargin();
        this.ignoreScrollBars = true;
        this.scrollView.moveTo(sViewX, sViewY);
        this.scrollView.sizeTo(sViewWidth, sViewHeight);
        this.vertScrollBar.moveTo(sViewX + sViewWidth - this.vertScrollBar.bounds.width, sViewY);
        this.vertScrollBar.sizeTo(this.vertScrollBar.bounds.width, sViewHeight);
        this.horizScrollBar.moveTo(sViewX, sViewY + sViewHeight - this.horizScrollBar.bounds.height);
        this.horizScrollBar.sizeTo(sViewWidth, this.horizScrollBar.bounds.height);
        this.ignoreScrollBars = false;
        if (this.vertScrollDisplay == 1 && this.horizScrollDisplay == 1 || this.vertScrollDisplay == 2 && this.horizScrollDisplay == 2 && this.scrollView.bounds.width < contentBounds.width && this.scrollView.bounds.height < contentBounds.height) {
            this.setBothScrollersOn();
            return;
        }
        if (this.vertScrollDisplay == 1 || this.vertScrollDisplay == 2 && this.scrollView.bounds.height < contentBounds.height) {
            if (this.horizScrollDisplay == 1 || this.horizScrollDisplay == 2 && this.scrollView.bounds.width - contentBounds.width < this.vertScrollBar.bounds.width) {
                this.setBothScrollersOn();
                return;
            }
            this.horizScrollBar.removeFromSuperview();
            this.ignoreScrollBars = true;
            this.scrollView.moveTo(sViewX, sViewY);
            this.scrollView.sizeTo(sViewWidth - this.vertScrollBar.bounds.width, sViewHeight);
            this.vertScrollBar.moveTo(this.bounds.width - this.border.rightMargin() - this.vertScrollBar.bounds.width, this.border.topMargin());
            this.vertScrollBar.sizeTo(this.vertScrollBar.bounds.width, this.bounds.height - this.border.heightMargin());
            this.addSubview(this.vertScrollBar);
            this.ignoreScrollBars = false;
            return;
        }
        if (this.vertScrollDisplay == 2 && this.horizScrollDisplay == 2 && this.scrollView.bounds.height == contentBounds.height) {
            this.ignoreScrollBars = true;
            this.vertScrollBar.removeFromSuperview();
            this.horizScrollBar.removeFromSuperview();
            this.scrollView.moveTo(sViewX, sViewY);
            this.scrollView.sizeTo(sViewWidth, sViewHeight);
            this.ignoreScrollBars = false;
            return;
        }
        if (this.horizScrollDisplay == 1 || this.horizScrollDisplay == 2 && this.scrollView.bounds.width < contentBounds.width) {
            if (this.vertScrollDisplay == 1 || this.vertScrollDisplay == 2 && this.scrollView.bounds.height - contentBounds.height < this.horizScrollBar.bounds.height) {
                this.setBothScrollersOn();
                return;
            }
            this.vertScrollBar.removeFromSuperview();
            this.ignoreScrollBars = true;
            this.scrollView.moveTo(sViewX, sViewY);
            this.scrollView.sizeTo(sViewWidth, sViewHeight - this.horizScrollBar.bounds.height);
            this.horizScrollBar.moveTo(this.border.leftMargin(), this.bounds.height - this.border.bottomMargin() - this.horizScrollBar.bounds.height);
            this.horizScrollBar.sizeTo(this.bounds.width - this.border.widthMargin(), this.horizScrollBar.bounds.height);
            this.addSubview(this.horizScrollBar);
            this.ignoreScrollBars = false;
            return;
        }
        if (this.horizScrollDisplay == 2 && this.vertScrollDisplay == 2 && this.scrollView.bounds.width == contentBounds.width) {
            this.ignoreScrollBars = true;
            this.horizScrollBar.removeFromSuperview();
            this.vertScrollBar.removeFromSuperview();
            this.scrollView.moveTo(sViewX, sViewY);
            this.scrollView.sizeTo(sViewWidth, sViewHeight);
            this.ignoreScrollBars = false;
            return;
        }
    }

    void setBothScrollersOn() {
        int sViewX = this.border.leftMargin() + this.interiorBorder.leftMargin();
        int sViewY = this.border.topMargin() + this.interiorBorder.topMargin();
        int sViewWidth = this.bounds.width - this.border.widthMargin() - this.interiorBorder.widthMargin();
        int sViewHeight = this.bounds.height - this.border.heightMargin() - this.interiorBorder.heightMargin();
        this.ignoreScrollBars = true;
        this.scrollView.moveTo(sViewX, sViewY);
        this.scrollView.sizeTo(sViewWidth - this.vertScrollBar.bounds.width, sViewHeight - this.horizScrollBar.bounds.height);
        this.horizScrollBar.moveTo(this.border.leftMargin(), this.bounds.height - this.border.bottomMargin() - this.horizScrollBar.bounds.height);
        this.horizScrollBar.sizeTo(this.bounds.width - this.border.widthMargin() - this.vertScrollBar.bounds.width + 2, this.horizScrollBar.bounds.height);
        this.addSubview(this.horizScrollBar);
        this.vertScrollBar.moveTo(this.bounds.width - this.border.rightMargin() - this.vertScrollBar.bounds.width, this.border.topMargin());
        this.vertScrollBar.sizeTo(this.vertScrollBar.bounds.width, this.bounds.height - this.border.heightMargin() - this.horizScrollBar.bounds.height + 2);
        this.addSubview(this.vertScrollBar);
        this.ignoreScrollBars = false;
    }

    public void drawView(Graphics g) {
        this.border.drawInRect(g, 0, 0, this.bounds.width, this.bounds.height);
        this.interiorBorder.drawInRect(g, this.border.leftMargin(), this.border.topMargin(), this.scrollView.bounds.width + this.interiorBorder.widthMargin(), this.scrollView.bounds.height + this.interiorBorder.heightMargin());
        if (this.cornerColor != null && this.horizScrollBarIsVisible() && this.vertScrollBarIsVisible()) {
            g.setColor(this.cornerColor);
            g.fillRect(this.horizScrollBar.bounds.maxX(), this.vertScrollBar.bounds.maxY(), this.vertScrollBar.bounds.width - 2, this.horizScrollBar.bounds.height - 2);
        }
    }

    public void drawContents() {
        this.scrollView.setDirty(true);
    }

    public void drawSubviews(Graphics g) {
        super.drawSubviews(g);
        this.drawView(g);
    }

    public void setContentView(View aView) {
        this.scrollView.setContentView(aView);
        this.layoutView(0, 0);
    }

    public View contentView() {
        return this.scrollView.contentView();
    }

    public void setBackgroundColor(Color aColor) {
        this.scrollView.setBackgroundColor(aColor);
    }

    public void setCornerColor(Color aColor) {
        this.cornerColor = aColor;
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ScrollGroup", 2);
        info.addField(SCROLLVIEW_KEY, (byte)18);
        info.addField(VERTSCROLLBAR_KEY, (byte)18);
        info.addField(HORIZSCROLLBAR_KEY, (byte)18);
        info.addField(BORDER_KEY, (byte)18);
        info.addField(HORIZDISPLAY_KEY, (byte)8);
        info.addField(VERTDISPLAY_KEY, (byte)8);
        info.addField(CORNER_COLOR_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(SCROLLVIEW_KEY, this.scrollView);
        encoder.encodeObject(VERTSCROLLBAR_KEY, this.vertScrollBar);
        encoder.encodeObject(HORIZSCROLLBAR_KEY, this.horizScrollBar);
        encoder.encodeObject(BORDER_KEY, this.interiorBorder);
        encoder.encodeInt(HORIZDISPLAY_KEY, this.horizScrollDisplay);
        encoder.encodeInt(VERTDISPLAY_KEY, this.vertScrollDisplay);
        encoder.encodeObject(CORNER_COLOR_KEY, this.cornerColor);
    }

    public void decode(Decoder decoder) throws CodingException {
        int version = decoder.versionForClassName("netscape.application.ScrollGroup");
        super.decode(decoder);
        this.scrollView = (ScrollView)decoder.decodeObject(SCROLLVIEW_KEY);
        this.vertScrollBar = (ScrollBar)decoder.decodeObject(VERTSCROLLBAR_KEY);
        this.horizScrollBar = (ScrollBar)decoder.decodeObject(HORIZSCROLLBAR_KEY);
        this.interiorBorder = (Border)decoder.decodeObject(BORDER_KEY);
        this.horizScrollDisplay = decoder.decodeInt(HORIZDISPLAY_KEY);
        this.vertScrollDisplay = decoder.decodeInt(VERTDISPLAY_KEY);
        if (version >= 2) {
            this.cornerColor = (Color)decoder.decodeObject(CORNER_COLOR_KEY);
            return;
        }
        this.cornerColor = Color.lightGray;
    }

    public void scrollBarDidBecomeActive(ScrollBar aScrollBar) {
        if (this.ignoreScrollBars) {
            return;
        }
        if (aScrollBar == this.horizScrollBar && this.horizScrollDisplay == 0) {
            return;
        }
        if (aScrollBar == this.vertScrollBar && this.vertScrollDisplay == 0) {
            return;
        }
        this.layoutView(0, 0);
    }

    public void scrollBarDidBecomeInactive(ScrollBar aScrollBar) {
        if (this.ignoreScrollBars) {
            return;
        }
        if (aScrollBar == this.horizScrollBar && this.horizScrollDisplay == 0) {
            return;
        }
        if (aScrollBar == this.vertScrollBar && this.vertScrollDisplay == 0) {
            return;
        }
        this.layoutView(0, 0);
    }

    public void scrollBarWasEnabled(ScrollBar aScrollBar) {
        if (this.ignoreScrollBars) {
            return;
        }
        if (aScrollBar == this.horizScrollBar && this.horizScrollDisplay == 0) {
            return;
        }
        if (aScrollBar == this.vertScrollBar && this.vertScrollDisplay == 0) {
            return;
        }
        this.layoutView(0, 0);
    }

    public void scrollBarWasDisabled(ScrollBar aScrollBar) {
        if (this.ignoreScrollBars) {
            return;
        }
        if (aScrollBar == this.horizScrollBar && this.horizScrollDisplay == 0) {
            return;
        }
        if (aScrollBar == this.vertScrollBar && this.vertScrollDisplay == 0) {
            return;
        }
        this.layoutView(0, 0);
    }

    public boolean vertScrollBarIsVisible() {
        return this.vertScrollBar.isInViewHierarchy();
    }

    public boolean horizScrollBarIsVisible() {
        return this.horizScrollBar.isInViewHierarchy();
    }

    public void layoutView(int x, int y) {
        this.putParts();
        this.ignoreScrollBars = false;
        this.setDirty(true);
    }
}

