/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.Graphics;
import netscape.application.InternalWindow;
import netscape.application.KeyEvent;
import netscape.application.KeyStroke;
import netscape.application.LayoutManager;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.VectorCache;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class View
implements Codable {
    View _superview;
    Size _minSize;
    Bitmap drawingBuffer;
    private Vector subviews;
    private Vector kbdOrder;
    LayoutManager layoutManager;
    Hashtable _keyboardBindings;
    public Rect bounds = new Rect();
    Rect dirtyRect;
    byte resizeInstr = (byte)4;
    int drawingDisabled;
    boolean autoResizeSubviews = true;
    boolean buffered;
    boolean drawingBufferValid;
    boolean drawingBufferIsBitCache;
    boolean isDirty;
    boolean needFocus;
    boolean focusPaused;
    boolean wantsKeyboardArrow;
    public static final int RIGHT_MARGIN_CAN_CHANGE = 0;
    public static final int LEFT_MARGIN_CAN_CHANGE = 1;
    public static final int WIDTH_CAN_CHANGE = 2;
    public static final int CENTER_HORIZ = 32;
    public static final int BOTTOM_MARGIN_CAN_CHANGE = 4;
    public static final int TOP_MARGIN_CAN_CHANGE = 8;
    public static final int HEIGHT_CAN_CHANGE = 16;
    public static final int CENTER_VERT = 64;
    private static final int DEFAULT_RESIZE_INSTR = 4;
    private static final int VERT_MASK = 92;
    private static final int HORZ_MASK = 35;
    static final String MINSIZE_KEY = "minSize";
    static final String BOUNDS_KEY = "bounds";
    static final String SUBVIEWS_KEY = "subviews";
    static final String RESIZE_KEY = "resizeInstr";
    static final String DRAWINGDISABLED_KEY = "drawingDisabled";
    static final String AUTORESIZE_KEY = "autoResizeSubviews";
    static final String BUFFERED_KEY = "buffered";
    static final String LAYOUTMANAGER_KEY = "layoutManager";
    static final String KEYBOARD_BINDINGS_KEY = "keyboardBindings";
    private static final String KBD_COMMAND_KEY = "kbdCmd";
    private static final String KBD_WHEN = "when";
    private static final String KBD_DATA_KEY = "kbdData";
    static final int DEFAULT_CURSOR = -1;
    public static final int ARROW_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    public static final int WHEN_SELECTED = 0;
    public static final int WHEN_IN_MAIN_WINDOW = 1;
    public static final int ALWAYS = 2;

    public View() {
        this(0, 0, 0, 0);
    }

    public View(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public View(int x, int y, int width, int height) {
        this._setBounds(x, y, width, height);
    }

    void _setBounds(int x, int y, int width, int height) {
        this.bounds.setBounds(x, y, width, height);
    }

    int subviewCount() {
        if (this.subviews == null) {
            return 0;
        }
        return this.subviews.count();
    }

    public Vector subviews() {
        if (this.subviews == null) {
            this.subviews = new Vector();
        }
        return this.subviews;
    }

    public Vector peersForSubview(View subview) {
        if (this.subviewCount() == 0 || !this.subviews().contains(subview)) {
            return new Vector();
        }
        Vector newVector = new Vector();
        newVector.addElementsIfAbsent(this.subviews);
        return newVector;
    }

    public boolean descendsFrom(View aView) {
        if (aView == this) {
            return true;
        }
        if (this._superview == null || aView == null) {
            return false;
        }
        if (this._superview == aView) {
            return true;
        }
        return this._superview.descendsFrom(aView);
    }

    public InternalWindow window() {
        if (this._superview == null) {
            return null;
        }
        return this._superview.window();
    }

    public Rect bounds() {
        return new Rect(this.bounds);
    }

    public int x() {
        return this.bounds.x;
    }

    public int y() {
        return this.bounds.y;
    }

    public int width() {
        return this.bounds.width;
    }

    public int height() {
        return this.bounds.height;
    }

    public View superview() {
        return this._superview;
    }

    public void setHorizResizeInstruction(int instruction) {
        if (instruction != 0 && instruction != 1 && instruction != 2 && instruction != 32) {
            throw new IllegalArgumentException("invalid horz resize instruction " + instruction);
        }
        this.resizeInstr = (byte)(this.resizeInstr & 0x5C);
        this.resizeInstr = (byte)(this.resizeInstr | instruction);
    }

    public int horizResizeInstruction() {
        return this.resizeInstr & 0x23;
    }

    public void setVertResizeInstruction(int instruction) {
        if (instruction != 4 && instruction != 8 && instruction != 16 && instruction != 64) {
            throw new IllegalArgumentException("invalid vert resize instruction " + instruction);
        }
        this.resizeInstr = (byte)(this.resizeInstr & 0x23);
        this.resizeInstr = (byte)(this.resizeInstr | instruction);
    }

    public int vertResizeInstruction() {
        return this.resizeInstr & 0x5C;
    }

    public boolean wantsAutoscrollEvents() {
        return false;
    }

    public DragDestination acceptsDrag(DragSession session, int x, int y) {
        return null;
    }

    public void setAutoResizeSubviews(boolean flag) {
        this.autoResizeSubviews = flag;
    }

    public boolean doesAutoResizeSubviews() {
        return this.autoResizeSubviews;
    }

    public void didMoveBy(int deltaX, int deltaY) {
    }

    public void didSizeBy(int deltaWidth, int deltaHeight) {
        if (!this.autoResizeSubviews) {
            return;
        }
        this.layoutView(deltaWidth, deltaHeight);
    }

    public void setBounds(Rect rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean didResize;
        int dx = x - this.bounds.x;
        int dy = y - this.bounds.y;
        int dw = width - this.bounds.width;
        int dh = height - this.bounds.height;
        boolean didMove = dx != 0 || dy != 0;
        boolean bl = didResize = dw != 0 || dh != 0;
        if (!didMove && !didResize) {
            return;
        }
        this._setBounds(x, y, width, height);
        if (this.buffered && didResize) {
            if (this.drawingBuffer != null) {
                this.drawingBuffer.flush();
            }
            this.drawingBuffer = width > 0 && height > 0 ? this.createBuffer() : null;
            this.drawingBufferValid = false;
        }
        if (didMove) {
            if (this._superview != null) {
                this._superview.subviewDidMove(this);
            }
            this.didMoveBy(dx, dy);
        }
        if (didResize) {
            if (this._superview != null) {
                this._superview.subviewDidResize(this);
            }
            this.didSizeBy(dw, dh);
        }
    }

    public void moveBy(int deltaX, int deltaY) {
        this.setBounds(this.bounds.x + deltaX, this.bounds.y + deltaY, this.bounds.width, this.bounds.height);
    }

    public void moveTo(int x, int y) {
        this.setBounds(x, y, this.bounds.width, this.bounds.height);
    }

    public void sizeBy(int deltaWidth, int deltaHeight) {
        this.setBounds(this.bounds.x, this.bounds.y, this.bounds.width + deltaWidth, this.bounds.height + deltaHeight);
    }

    public void sizeTo(int width, int height) {
        this.setBounds(this.bounds.x, this.bounds.y, width, height);
    }

    public void setMinSize(int width, int height) {
        if (width == -1 || height == -1) {
            this._minSize = null;
            return;
        }
        this._minSize = new Size(width, height);
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        return new Size();
    }

    public void sizeToMinSize() {
        Size minSize = this.minSize();
        this.sizeTo(minSize.width, minSize.height);
    }

    public void subviewDidResize(View aSubview) {
        if (this._superview != null) {
            this._superview.subviewDidResize(aSubview);
        }
    }

    public void subviewDidMove(View aSubview) {
        if (this._superview != null) {
            this._superview.subviewDidMove(aSubview);
        }
    }

    private void setSuperview(View aView) {
        this._superview = aView;
        this.ancestorWasAddedToViewHierarchy(aView);
        RootView rView = this.rootView();
        if (rView != null) {
            rView.updateCursorLater();
            rView.viewHierarchyChanged();
        }
    }

    public void addSubview(View aView) {
        if (aView == null) {
            return;
        }
        this.invalidateKeyboardSelectionOrder();
        if (this.subviews == null) {
            this.subviews = new Vector();
        } else if (this.subviews.contains(aView)) {
            return;
        }
        this.subviews.addElement(aView);
        aView.setSuperview(this);
        if (this.layoutManager != null) {
            this.layoutManager.addSubview(aView);
        }
    }

    protected void ancestorWasAddedToViewHierarchy(View addedView) {
        if (this.buffered) {
            this.setBuffered(true);
        }
        if (this.needFocus) {
            this.setFocusedView();
        }
        int i = this.subviewCount();
        while (i-- > 0) {
            View nextView = (View)this.subviews.elementAt(i);
            nextView.ancestorWasAddedToViewHierarchy(addedView);
        }
    }

    protected void removeSubview(View aView) {
        this.invalidateKeyboardSelectionOrder();
        if (this.subviews != null) {
            this.subviews.removeElement(aView);
        }
        if (this.layoutManager != null) {
            this.layoutManager.removeSubview(aView);
        }
    }

    public void removeFromSuperview() {
        if (this._superview != null) {
            RootView rView = this.rootView();
            if (rView != null) {
                rView.updateCursorLater();
            }
            this.ancestorWillRemoveFromViewHierarchy(this);
            this._superview.removeSubview(this);
            this._superview = null;
            if (rView != null) {
                rView.viewHierarchyChanged();
            }
        }
    }

    protected void ancestorWillRemoveFromViewHierarchy(View removedView) {
        RootView rView;
        if (this.drawingBuffer != null) {
            this.drawingBuffer.flush();
            this.drawingBuffer = null;
        }
        if ((rView = this.rootView()) != null) {
            if (rView.mouseView() == this) {
                rView.setMouseView(null);
            }
            if (rView._moveView == this) {
                rView._moveView = null;
            }
        }
        if (this.isDirty) {
            this.setDirty(false);
        }
        int i = this.subviewCount();
        while (i-- > 0) {
            View nextView = (View)this.subviews.elementAt(i);
            nextView.ancestorWillRemoveFromViewHierarchy(removedView);
        }
    }

    public boolean containsPoint(int x, int y) {
        return Rect.contains(0, 0, this.width(), this.height(), x, y);
    }

    public boolean containsPointInVisibleRect(int x, int y) {
        Rect visibleRect = Rect.newRect();
        this.computeVisibleRect(visibleRect);
        boolean containsPoint = visibleRect.contains(x, y);
        Rect.returnRect(visibleRect);
        return containsPoint;
    }

    View _viewForRect(Rect aRect, View fromView) {
        Rect tmpRect;
        View viewForRect = null;
        if (aRect == null) {
            return null;
        }
        if (fromView != null) {
            if (!this.bounds.contains(aRect)) {
                return null;
            }
            tmpRect = Rect.newRect();
            fromView.convertRectToView(this, aRect, tmpRect);
        } else {
            tmpRect = Rect.newRect(aRect);
        }
        int i = this.subviewCount();
        while (i-- > 0) {
            View nextView = (View)this.subviews.elementAt(i);
            viewForRect = nextView._viewForRect(tmpRect, this);
            if (viewForRect != null) break;
        }
        Rect.returnRect(tmpRect);
        if (viewForRect != null) {
            return viewForRect;
        }
        if (this.isTransparent() && fromView != null) {
            return null;
        }
        return this;
    }

    public View viewForMouse(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        int i = this.subviewCount();
        while (i-- > 0) {
            View hitView;
            View subView = (View)this.subviews.elementAt(i);
            if (subView instanceof InternalWindow || (hitView = subView.viewForMouse(x - subView.bounds.x, y - subView.bounds.y)) == null) continue;
            return hitView;
        }
        return this;
    }

    public int cursorForPoint(int x, int y) {
        return 0;
    }

    public boolean mouseDown(MouseEvent event) {
        return false;
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void keyDown(KeyEvent event) {
        if (this._superview != null) {
            this._superview.keyDown(event);
        }
    }

    public void keyUp(KeyEvent event) {
        if (this._superview != null) {
            this._superview.keyUp(event);
        }
    }

    View scrollingView() {
        if (this._superview != null) {
            return this._superview.scrollingView();
        }
        return null;
    }

    public void scrollRectToVisible(Rect aRect) {
        if (this._superview != null) {
            this._superview.scrollRectToVisible(this.convertRectToView(this._superview, aRect));
        }
    }

    public void disableDrawing() {
        ++this.drawingDisabled;
    }

    public void reenableDrawing() {
        --this.drawingDisabled;
        if (this.drawingDisabled < 0) {
            this.drawingDisabled = 0;
        }
    }

    public boolean isDrawingEnabled() {
        return this.drawingDisabled == 0;
    }

    public boolean isInViewHierarchy() {
        RootView rootView = this.rootView();
        return rootView != null && rootView.isVisible();
    }

    public RootView rootView() {
        if (this._superview == null) {
            return null;
        }
        return this._superview.rootView();
    }

    public boolean canDraw() {
        if (this.drawingDisabled > 0 || this._superview == null) {
            return false;
        }
        return this._superview.canDraw();
    }

    public void computeVisibleRect(Rect visibleRect) {
        if (this._superview == null) {
            visibleRect.setBounds(0, 0, this.width(), this.height());
            return;
        }
        this._superview.computeVisibleRect(visibleRect);
        this._superview.convertRectToView(this, visibleRect, visibleRect);
        visibleRect.intersectWith(0, 0, this.width(), this.height());
    }

    public boolean isTransparent() {
        return true;
    }

    public boolean wantsMouseEventCoalescing() {
        return true;
    }

    View opaqueAncestor() {
        if (this.isTransparent() && this._superview != null) {
            return this._superview.opaqueAncestor();
        }
        return this;
    }

    public void addDirtyRect(Rect rect) {
        if (rect == null) {
            this.setDirty(true);
            return;
        }
        if (this.isDirty) {
            if (this.dirtyRect != null) {
                this.dirtyRect.unionWith(rect);
                return;
            }
        } else {
            RootView rootView = this.rootView();
            if (rootView != null) {
                this.dirtyRect = new Rect(rect);
                rootView.markDirty(this);
                this.isDirty = true;
            }
        }
    }

    public void setDirty(boolean flag) {
        RootView rootView;
        if (flag) {
            RootView rootView2;
            if (!this.isDirty && (rootView2 = this.rootView()) != null) {
                rootView2.markDirty(this);
                this.isDirty = true;
            }
        } else if (this.isDirty && (rootView = this.rootView()) != null) {
            rootView.markClean(this);
            this.isDirty = false;
        }
        this.dirtyRect = null;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void drawView(Graphics g) {
    }

    public void drawSubviews(Graphics g) {
        Rect subClipRect = null;
        if (this.drawingDisabled > 0) {
            return;
        }
        Rect clipRect = g.clipRect();
        int count = this.subviewCount();
        int i = 0;
        while (i < count) {
            View nextView = (View)this.subviews.elementAt(i);
            boolean canDraw = nextView.isDrawingEnabled();
            if (subClipRect == null) {
                subClipRect = Rect.newRect();
            }
            this.convertRectToView(nextView, clipRect, subClipRect);
            subClipRect.intersectWith(0, 0, nextView.bounds.width, nextView.bounds.height);
            if (canDraw && !subClipRect.isEmpty()) {
                nextView._drawView(g, subClipRect, false);
            }
            ++i;
        }
        if (subClipRect != null) {
            Rect.returnRect(subClipRect);
        }
    }

    void _drawView(Graphics g, Rect drawRect, boolean isTopLevelView) {
        if (this.drawingDisabled > 0) {
            return;
        }
        g.pushState();
        g.setDebug(this);
        if (!isTopLevelView) {
            g.translate(this.bounds.x, this.bounds.y);
        }
        if (drawRect == null) {
            Rect clipRect = Rect.newRect(0, 0, this.width(), this.height());
            g.setClipRect(clipRect);
            Rect.returnRect(clipRect);
        } else {
            g.setClipRect(drawRect);
        }
        if (this.drawingBuffer != null && isTopLevelView && !g.isDrawingBuffer()) {
            this.drawingBuffer.drawAt(g, 0, 0);
        } else {
            this.drawView(g);
            this.drawSubviews(g);
        }
        g.popState();
    }

    void clipAndDrawView(Graphics g, Rect clipRect) {
        Rect ancestorVisibleRect;
        if (g.isDrawingBuffer()) {
            ancestorVisibleRect = Rect.newRect(0, 0, this.width(), this.height());
        } else {
            ancestorVisibleRect = Rect.newRect();
            this.computeVisibleRect(ancestorVisibleRect);
        }
        ancestorVisibleRect.intersectWith(clipRect);
        clipRect = ancestorVisibleRect;
        Vector windowClipRectVector = this == this.rootView() && clipRect.x == 0 && clipRect.y == 0 && clipRect.width == this.width() && clipRect.height == this.height() || g.isDrawingBuffer() ? null : this.rootView().windowRects(this.convertRectToView(null, clipRect), this.window());
        if (windowClipRectVector == null || windowClipRectVector.isEmpty()) {
            this._drawView(g, clipRect, true);
            Rect.returnRect(clipRect);
        } else {
            int j;
            Vector disunionRectVector = VectorCache.newVector();
            Vector clipVector = VectorCache.newVector();
            clipRect.x += this.absoluteX();
            clipRect.y += this.absoluteY();
            clipVector.addElement(clipRect);
            Vector newClipVector = VectorCache.newVector();
            int i = windowClipRectVector.count();
            while (i-- > 0) {
                Rect windowClipRect = (Rect)windowClipRectVector.elementAt(i);
                j = clipVector.count();
                while (j-- > 0) {
                    Rect nextClipRect = (Rect)clipVector.elementAt(j);
                    nextClipRect.computeDisunionRects(windowClipRect, disunionRectVector);
                    if (!disunionRectVector.isEmpty()) {
                        newClipVector.addElementsIfAbsent(disunionRectVector);
                        disunionRectVector.removeAllElements();
                        continue;
                    }
                    if (windowClipRect.contains(nextClipRect)) continue;
                    newClipVector.addElement(nextClipRect);
                    clipVector.removeElement(nextClipRect);
                }
                Vector tmpVector = clipVector;
                clipVector = newClipVector;
                newClipVector = tmpVector;
                Rect.returnRects(newClipVector);
            }
            VectorCache.returnVector(disunionRectVector);
            VectorCache.returnVector(newClipVector);
            int count = clipVector.count();
            i = 0;
            while (i < count) {
                Rect nextRect = (Rect)clipVector.elementAt(i);
                j = count;
                while (j-- > 0) {
                    Rect otherRect = (Rect)clipVector.elementAt(j);
                    if (otherRect == nextRect || !nextRect.contains(otherRect)) continue;
                    Rect.returnRect((Rect)clipVector.removeElementAt(j));
                    --count;
                    i = -1;
                    break;
                }
                ++i;
            }
            i = clipVector.count();
            while (i-- > 0) {
                clipRect = (Rect)clipVector.elementAt(i);
                if (clipRect.isEmpty()) continue;
                clipRect.x -= this.absoluteX();
                clipRect.y -= this.absoluteY();
                this._drawView(g, clipRect, true);
            }
            Rect.returnRects(clipVector);
            VectorCache.returnVector(clipVector);
        }
        Rect.returnRects(windowClipRectVector);
        VectorCache.returnVector(windowClipRectVector);
    }

    void _draw(Graphics g, Rect clipRect) {
        boolean transparent;
        boolean bl = transparent = this.drawingBuffer != null && !g.isDrawingBuffer() ? false : this.isTransparent();
        if (transparent && !(this instanceof InternalWindow)) {
            Rect ancestorClipRect = Rect.newRect();
            View opaqueAncestor = this.opaqueAncestor();
            this.convertRectToView(opaqueAncestor, clipRect, ancestorClipRect);
            g.pushState();
            g.translate(clipRect.x - ancestorClipRect.x, clipRect.y - ancestorClipRect.y);
            opaqueAncestor.draw(g, ancestorClipRect);
            Rect.returnRect(ancestorClipRect);
            g.popState();
            return;
        }
        this.updateInvalidDrawingBuffers(clipRect);
        this.clipAndDrawView(g, clipRect);
    }

    public void draw(Graphics g, Rect clipRect) {
        if (clipRect != null) {
            clipRect = Rect.newRect(clipRect);
            clipRect.intersectWith(0, 0, this.width(), this.height());
            if (clipRect.isEmpty()) {
                Rect.returnRect(clipRect);
                return;
            }
        } else {
            clipRect = Rect.newRect(0, 0, this.width(), this.height());
        }
        boolean canDraw = this.canDraw();
        if (g == null || !g.isDrawingBuffer()) {
            if (this.drawingBuffer == null) {
                if (!canDraw) {
                    Rect.returnRect(clipRect);
                    return;
                }
                View bufferView = this.ancestorWithDrawingBuffer();
                if (bufferView != null && bufferView != this) {
                    Rect tmpRect = Rect.newRect();
                    this.computeVisibleRect(tmpRect);
                    tmpRect.intersectWith(clipRect);
                    this.convertRectToView(bufferView, tmpRect, tmpRect);
                    bufferView.drawingBufferValid = false;
                    if (g == null) {
                        g = bufferView.createGraphics();
                        bufferView.draw(g, tmpRect);
                        g.dispose();
                        g = null;
                    } else {
                        Point point = new Point(0, 0);
                        this.convertPointToView(bufferView, point, point);
                        g.pushState();
                        try {
                            g.translate(-point.x, -point.y);
                            bufferView.draw(g, tmpRect);
                        }
                        finally {
                            Object var9_7 = null;
                            g.popState();
                        }
                    }
                    Rect.returnRect(tmpRect);
                    Rect.returnRect(clipRect);
                    return;
                }
            } else if (!this.drawingBufferIsBitCache) {
                this.updateDrawingBuffer(clipRect);
            }
            Rect absoluteClip = this.convertRectToView(this.rootView(), clipRect);
            this.rootView().redrawTransparentWindows(absoluteClip, this.window());
        }
        if (g != null && g.isDrawingBuffer() || canDraw) {
            if (g == null) {
                g = this.createGraphics();
                this._draw(g, clipRect);
                g.dispose();
                g = null;
            } else {
                this._draw(g, clipRect);
            }
        }
        Rect.returnRect(clipRect);
    }

    public void draw(Rect clipRect) {
        if (this.isInViewHierarchy()) {
            this.draw(null, clipRect);
        }
    }

    public void draw() {
        if (this.isInViewHierarchy()) {
            this.draw(null, null);
        }
    }

    public void setBuffered(boolean flag) {
        this.buffered = flag;
        if (flag && this.drawingBuffer == null) {
            if (this.bounds.width != 0 && this.bounds.height != 0) {
                this.drawingBuffer = this.createBuffer();
            }
            this.drawingBufferValid = false;
            return;
        }
        if (!flag && this.drawingBuffer != null) {
            this.drawingBuffer.flush();
            this.drawingBuffer = null;
        }
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public Bitmap drawingBuffer() {
        return this.drawingBuffer;
    }

    void updateDrawingBuffer(Rect updateRect) {
        if (!updateRect.intersects(0, 0, this.width(), this.height())) {
            return;
        }
        if (this.drawingBuffer != null) {
            Bitmap bitmap = this.drawingBuffer;
            synchronized (bitmap) {
                Graphics bufferedGraphics = Graphics.newGraphics(this.drawingBuffer);
                this.drawingBufferValid = true;
                bufferedGraphics.setDebugOptions(this.shouldDebugGraphics());
                this.draw(bufferedGraphics, updateRect);
                if (!this.canDraw()) {
                    this.drawingBufferValid = false;
                }
                bufferedGraphics.dispose();
                bufferedGraphics = null;
                return;
            }
        }
    }

    void updateInvalidDrawingBuffers(Rect clipRect) {
        Rect subClipRect = null;
        int i = this.subviewCount();
        while (i-- > 0) {
            View nextView = (View)this.subviews.elementAt(i);
            if (subClipRect == null) {
                subClipRect = Rect.newRect();
            }
            this.convertRectToView(nextView, clipRect, subClipRect);
            if (!subClipRect.intersects(0, 0, nextView.width(), nextView.height())) continue;
            if (nextView.drawingBuffer != null && !nextView.drawingBufferValid) {
                nextView.updateDrawingBuffer(subClipRect);
            }
            nextView.updateInvalidDrawingBuffers(subClipRect);
        }
        if (subClipRect != null) {
            Rect.returnRect(subClipRect);
        }
    }

    View ancestorWithDrawingBuffer() {
        if (this.drawingBuffer != null) {
            return this;
        }
        if (this._superview == null) {
            return null;
        }
        return this._superview.ancestorWithDrawingBuffer();
    }

    void _startFocus() {
        if (this.focusPaused) {
            this.focusPaused = false;
            this.resumeFocus();
            return;
        }
        this.startFocus();
    }

    void _stopFocus() {
        this.focusPaused = false;
        this.stopFocus();
    }

    void _pauseFocus() {
        this.focusPaused = true;
        this.pauseFocus();
    }

    public void startFocus() {
    }

    public void stopFocus() {
    }

    public void pauseFocus() {
    }

    public void resumeFocus() {
    }

    void setFocusedView(View view) {
        if (this._superview != null) {
            this._superview.setFocusedView(view);
        }
    }

    public void setFocusedView() {
        if (this._superview != null && (this.isInViewHierarchy() || this.window() != null)) {
            this._superview.setFocusedView(this);
            this.needFocus = false;
            return;
        }
        this.needFocus = true;
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.View", 2);
        info.addField(BOUNDS_KEY, (byte)18);
        info.addField(MINSIZE_KEY, (byte)18);
        info.addField(SUBVIEWS_KEY, (byte)18);
        info.addField(RESIZE_KEY, (byte)4);
        info.addField(DRAWINGDISABLED_KEY, (byte)8);
        info.addField(AUTORESIZE_KEY, (byte)0);
        info.addField(BUFFERED_KEY, (byte)0);
        info.addField(LAYOUTMANAGER_KEY, (byte)18);
        info.addField(KEYBOARD_BINDINGS_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(BOUNDS_KEY, this.bounds);
        encoder.encodeObject(MINSIZE_KEY, this._minSize);
        if (this.subviewCount() == 0) {
            encoder.encodeObject(SUBVIEWS_KEY, null);
        } else {
            encoder.encodeObject(SUBVIEWS_KEY, this.subviews);
        }
        encoder.encodeByte(RESIZE_KEY, this.resizeInstr);
        encoder.encodeInt(DRAWINGDISABLED_KEY, this.drawingDisabled);
        encoder.encodeBoolean(AUTORESIZE_KEY, this.autoResizeSubviews);
        encoder.encodeBoolean(BUFFERED_KEY, this.buffered);
        encoder.encodeObject(LAYOUTMANAGER_KEY, this.layoutManager);
        encoder.encodeObject(KEYBOARD_BINDINGS_KEY, this._keyboardBindings);
    }

    public void decode(Decoder decoder) throws CodingException {
        int version = decoder.versionForClassName("netscape.application.View");
        this.bounds = (Rect)decoder.decodeObject(BOUNDS_KEY);
        this._minSize = (Size)decoder.decodeObject(MINSIZE_KEY);
        Object nextObject = decoder.decodeObject(SUBVIEWS_KEY);
        if (nextObject != null) {
            this.subviews = (Vector)nextObject;
        }
        this.resizeInstr = decoder.decodeByte(RESIZE_KEY);
        this.drawingDisabled = decoder.decodeInt(DRAWINGDISABLED_KEY);
        boolean flag = decoder.decodeBoolean(AUTORESIZE_KEY);
        if (flag) {
            this.setAutoResizeSubviews(flag);
        }
        if (flag = decoder.decodeBoolean(BUFFERED_KEY)) {
            this.setBuffered(flag);
        }
        this.layoutManager = (LayoutManager)decoder.decodeObject(LAYOUTMANAGER_KEY);
        if (version >= 2) {
            this._keyboardBindings = (Hashtable)decoder.decodeObject(KEYBOARD_BINDINGS_KEY);
        }
    }

    public void finishDecoding() throws CodingException {
        int i = this.subviewCount();
        while (i-- > 0) {
            View nextView = (View)this.subviews.elementAt(i);
            nextView.setSuperview(this);
            nextView._setBounds(nextView.bounds.x, nextView.bounds.y, nextView.bounds.width, nextView.bounds.height);
        }
        this._setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    Application application() {
        return Application.application();
    }

    public void convertToView(View otherView, int x, int y, Point destPoint) {
        int destX = x;
        int destY = y;
        if (this._superview == otherView) {
            destX += this.bounds.x;
            destY += this.bounds.y;
        } else if (otherView != null && otherView._superview == this) {
            destX -= otherView.bounds.x;
            destY -= otherView.bounds.y;
        } else {
            View sView = this;
            while (sView._superview != null) {
                destX += sView.bounds.x;
                destY += sView.bounds.y;
                sView = sView._superview;
            }
            if (otherView != null) {
                View otherSView = otherView;
                while (otherSView._superview != null) {
                    destX -= otherSView.bounds.x;
                    destY -= otherSView.bounds.y;
                    otherSView = otherSView._superview;
                }
                if (sView != otherSView) {
                    throw new InconsistencyException("Can't convert between " + this + " and " + otherView + ", no common ancestor");
                }
            }
        }
        destPoint.x = destX;
        destPoint.y = destY;
    }

    public Point convertToView(View otherView, int x, int y) {
        Point point = new Point();
        this.convertToView(otherView, x, y, point);
        return point;
    }

    public void convertRectToView(View otherView, Rect sourceRect, Rect destRect) {
        Point destPoint = Point.newPoint();
        this.convertToView(otherView, sourceRect.x, sourceRect.y, destPoint);
        destRect.setBounds(destPoint.x, destPoint.y, sourceRect.width, sourceRect.height);
        Point.returnPoint(destPoint);
    }

    public void convertPointToView(View otherView, Point sourcePoint, Point destPoint) {
        this.convertToView(otherView, sourcePoint.x, sourcePoint.y, destPoint);
    }

    public Rect convertRectToView(View otherView, Rect sourceRect) {
        Rect destRect = new Rect();
        this.convertRectToView(otherView, sourceRect, destRect);
        return destRect;
    }

    public Point convertPointToView(View otherView, Point sourcePoint) {
        Point destPoint = new Point();
        this.convertPointToView(otherView, sourcePoint, destPoint);
        return destPoint;
    }

    public MouseEvent convertEventToView(View otherView, MouseEvent sourceEvent) {
        Point destPoint = Point.newPoint();
        MouseEvent dstEvent = (MouseEvent)sourceEvent.clone();
        this.convertToView(otherView, sourceEvent.x, sourceEvent.y, destPoint);
        dstEvent.x = destPoint.x;
        dstEvent.y = destPoint.y;
        Point.returnPoint(destPoint);
        return dstEvent;
    }

    public void setGraphicsDebugOptions(int debugOptions) {
        Graphics.setViewDebug(this, debugOptions);
    }

    public int graphicsDebugOptions() {
        return Graphics.viewDebug(this);
    }

    int shouldDebugGraphics() {
        return Graphics.shouldViewDebug(this);
    }

    int absoluteX() {
        int x = 0;
        View sView = this;
        while (sView != null) {
            x += sView.bounds.x;
            sView = sView._superview;
        }
        return x;
    }

    int absoluteY() {
        int y = 0;
        View sView = this;
        while (sView != null) {
            y += sView.bounds.y;
            sView = sView._superview;
        }
        return y;
    }

    public void setLayoutManager(LayoutManager value) {
        this.layoutManager = value;
    }

    public LayoutManager layoutManager() {
        return this.layoutManager;
    }

    public void layoutView(int deltaWidth, int deltaHeight) {
        if (this.layoutManager == null) {
            this.relativeLayoutView(deltaWidth, deltaHeight);
            return;
        }
        this.layoutManager.layoutView(this, deltaWidth, deltaHeight);
    }

    private void relativeLayoutView(int deltaWidth, int deltaHeight) {
        int i = this.subviewCount();
        while (i-- > 0) {
            View subview = (View)this.subviews.elementAt(i);
            int x = subview.bounds.x;
            int y = subview.bounds.y;
            int w = subview.bounds.width;
            int h = subview.bounds.height;
            switch (subview.horizResizeInstruction()) {
                case 1: {
                    x += deltaWidth;
                    break;
                }
                case 2: {
                    w += deltaWidth;
                    break;
                }
                case 32: {
                    x = (this.bounds.width - subview.bounds.width) / 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid horz resize instruction: " + subview.horizResizeInstruction());
                }
                case 0: 
            }
            switch (subview.vertResizeInstruction()) {
                case 8: {
                    y += deltaHeight;
                    break;
                }
                case 16: {
                    h += deltaHeight;
                    break;
                }
                case 64: {
                    y = (this.bounds.height - subview.bounds.height) / 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid vert resize instruction: " + subview.vertResizeInstruction());
                }
                case 4: 
            }
            subview.setBounds(x, y, w, h);
        }
    }

    public Rect localBounds() {
        return new Rect(0, 0, this.bounds.width, this.bounds.height);
    }

    public Graphics createGraphics() {
        return Graphics.newGraphics(this);
    }

    protected Bitmap createBuffer() {
        return new Bitmap(this.width(), this.height());
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.bounds.toString();
    }

    public boolean canBecomeSelectedView() {
        return false;
    }

    public boolean hidesSubviewsFromKeyboard() {
        return false;
    }

    public View nextSelectableView() {
        return null;
    }

    public View previousSelectableView() {
        return null;
    }

    public void invalidateKeyboardSelectionOrder() {
        this.kbdOrder = null;
    }

    public void willBecomeSelected() {
        this.wantsKeyboardArrow = true;
    }

    public void willBecomeUnselected() {
        this.wantsKeyboardArrow = false;
    }

    public void setCommandForKey(String aCommand, Object cmdData, int key, int modifiers, int when) {
        KeyStroke keyStroke = new KeyStroke(key, modifiers);
        if (this._keyboardBindings == null) {
            this._keyboardBindings = new Hashtable();
        }
        if (aCommand == null) {
            this._keyboardBindings.remove(keyStroke);
            return;
        }
        Hashtable data = new Hashtable();
        data.put(KBD_COMMAND_KEY, aCommand);
        data.put(KBD_WHEN, String.valueOf(when));
        if (cmdData != null) {
            data.put(KBD_DATA_KEY, cmdData);
        }
        this._keyboardBindings.put(keyStroke, data);
    }

    public void setCommandForKey(String aCommand, int aKey, int when) {
        this.setCommandForKey(aCommand, this, aKey, 0, when);
    }

    public void removeCommandForKey(int aKey) {
        this.setCommandForKey(null, null, aKey, 0, 0);
    }

    public void removeAllCommandsForKeys() {
        this._keyboardBindings = null;
    }

    boolean hasKeyboardBindings() {
        return this._keyboardBindings != null && this._keyboardBindings.count() > 0;
    }

    boolean performCommandForKeyStroke(KeyStroke aKeyStroke, int condition) {
        if (!(this instanceof Target)) {
            return false;
        }
        if (this._keyboardBindings != null) {
            Enumeration keys = this._keyboardBindings.keys();
            while (keys.hasMoreElements()) {
                KeyStroke ks = (KeyStroke)keys.nextElement();
                if (!ks.equals(aKeyStroke)) continue;
                boolean sendCommand = false;
                Hashtable data = (Hashtable)this._keyboardBindings.get(ks);
                String s = (String)data.get(KBD_WHEN);
                int when = Integer.parseInt(s);
                switch (when) {
                    case 0: {
                        if (condition != 0) break;
                        sendCommand = true;
                        break;
                    }
                    case 1: {
                        if (condition != 0 && condition != 1) break;
                        sendCommand = true;
                        break;
                    }
                    case 2: {
                        sendCommand = true;
                        break;
                    }
                    default: {
                        throw new InconsistencyException("Wrong condition:" + when);
                    }
                }
                if (!sendCommand) continue;
                String command = (String)data.get(KBD_COMMAND_KEY);
                ((Target)((Object)this)).performCommand(command, data.get(KBD_DATA_KEY));
                return true;
            }
        }
        return false;
    }

    public Rect keyboardRect() {
        return this.localBounds();
    }

    View _firstSubview(Vector subViews) {
        View view;
        if (subViews.count() == 0) {
            return null;
        }
        View minYView = (View)subViews.elementAt(0);
        int minY = minYView.y();
        int i = 1;
        int c = subViews.count();
        while (i < c) {
            view = (View)subViews.elementAt(i);
            if (view.y() < minY) {
                minYView = view;
                minY = view.y();
            }
            ++i;
        }
        View minXView = minYView;
        int minX = minYView.x();
        i = 0;
        c = subViews.count();
        while (i < c) {
            view = (View)subViews.elementAt(i);
            if (view != minXView && (int)Math.sqrt((view.y() - minXView.y()) * (view.y() - minXView.y())) <= 10 && view.x() < minX) {
                minXView = view;
                minX = view.x();
            }
            ++i;
        }
        return minXView;
    }

    private void validateKeyboardOrder() {
        if (this.kbdOrder == null) {
            Vector sv = new Vector();
            int i = 0;
            int c = this.subviews.count();
            while (i < c) {
                sv.addElement(this.subviews.elementAt(i));
                ++i;
            }
            this.kbdOrder = new Vector();
            block1: while (sv.count() > 0) {
                View nv;
                View v = this._firstSubview(sv);
                this.kbdOrder.addElement(v);
                sv.removeElement(v);
                while ((nv = v.nextSelectableView()) != null) {
                    if (sv.indexOfIdentical(nv) == -1) continue block1;
                    this.kbdOrder.addElement(nv);
                    sv.removeElement(nv);
                    v = nv;
                }
            }
        }
    }

    View firstSubview() {
        this.validateKeyboardOrder();
        if (this.kbdOrder.count() > 0) {
            return (View)this.kbdOrder.elementAt(0);
        }
        return null;
    }

    View lastSubview() {
        this.validateKeyboardOrder();
        if (this.kbdOrder.count() > 0) {
            return (View)this.kbdOrder.elementAt(this.kbdOrder.count() - 1);
        }
        return null;
    }

    View viewAfter(View anotherView) {
        this.validateKeyboardOrder();
        int index = this.kbdOrder.indexOfIdentical(anotherView);
        if (index != -1 && index < this.kbdOrder.count() - 1) {
            return (View)this.kbdOrder.elementAt(index + 1);
        }
        return null;
    }

    View viewBefore(View anotherView) {
        this.validateKeyboardOrder();
        int index = this.kbdOrder.indexOfIdentical(anotherView);
        if (index > 0) {
            return (View)this.kbdOrder.elementAt(index - 1);
        }
        return null;
    }

    boolean wantsKeyboardArrow() {
        return this.wantsKeyboardArrow;
    }

    void getDirtyRect(Rect rect) {
        int count;
        if (this.isDirty() && this.dirtyRect == null) {
            if (rect.isEmpty()) {
                rect.setBounds(this.bounds);
                return;
            }
            rect.unionWith(this.bounds);
            return;
        }
        if (this.dirtyRect != null) {
            if (rect.isEmpty()) {
                rect.setBounds(this.dirtyRect.x + this.bounds.x, this.dirtyRect.y + this.bounds.y, this.dirtyRect.width, this.dirtyRect.height);
            } else {
                rect.unionWith(this.dirtyRect.x + this.bounds.x, this.dirtyRect.y + this.bounds.y, this.dirtyRect.width, this.dirtyRect.height);
            }
        }
        if ((count = this.subviewCount()) != 0) {
            rect.moveBy(-this.bounds.x, -this.bounds.y);
            while (count-- > 0) {
                ((View)this.subviews.elementAt(count)).getDirtyRect(rect);
            }
            rect.moveBy(this.bounds.x, this.bounds.y);
        }
    }
}

