/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.util.Archive;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.CodingException;
import netscape.util.DeserializationException;
import netscape.util.Deserializer;
import netscape.util.Enumeration;
import netscape.util.FormattingSerializer;
import netscape.util.Hashtable;
import netscape.util.IdHashtable;
import netscape.util.InconsistencyException;
import netscape.util.Serializer;

class ASCIIArchiveLoader {
    static final String classTablesKey = "classTables";
    static final String fieldNamesKey = "fieldNames";
    static final String fieldTypesKey = "fieldTypes";
    static final String classNamesKey = "classNames";
    static final String classVersionsKey = "classVersions";
    static final String instancesKey = "instances";
    static final String rootInstancesKey = "rootInstances";
    static final String archiveVersionKey = "archiveVersion";
    Archive archive;
    Hashtable archiveDict;
    IdHashtable idForName;
    String[] nameForId;
    Hashtable baseNameForTable;
    static byte[] hexChar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    ASCIIArchiveLoader(Archive archive) {
        this.archive = archive;
    }

    void readASCII(InputStream in) throws CodingException, DeserializationException, IOException {
        Deserializer deserializer = null;
        if (in instanceof Deserializer) {
            deserializer = (Deserializer)in;
        }
        this.idForName = new IdHashtable(true);
        if (deserializer == null) {
            deserializer = new Deserializer(in);
        }
        this.archiveDict = (Hashtable)deserializer.readObject();
        String versionString = (String)this.archiveDict.get(archiveVersionKey);
        if (versionString == null) {
            throw new IOException("Missing archiveVersion");
        }
        this.archive.version = Integer.parseInt(versionString);
        if (this.archive.version != 1) {
            throw new IOException("Unknown archiveVersion " + this.archive.version);
        }
        this.loadClassInfo();
        this.loadInstanceData();
        this.loadRoots();
    }

    void loadClassInfo() throws CodingException {
        Hashtable allTablesDict = (Hashtable)this.archiveDict.get(classTablesKey);
        if (allTablesDict == null) {
            return;
        }
        Enumeration classNameEnum = allTablesDict.keys();
        while (classNameEnum.hasMoreElements()) {
            String className = (String)classNameEnum.nextElement();
            Hashtable tableDict = (Hashtable)allTablesDict.get(className);
            ClassInfo info = new ClassInfo(className);
            Object[] classNames = (Object[])tableDict.get(classNamesKey);
            Object[] classVersions = (Object[])tableDict.get(classVersionsKey);
            int i = 0;
            while (i < classNames.length) {
                int version = Integer.parseInt((String)classVersions[i]);
                info.addClass((String)classNames[i], version);
                ++i;
            }
            Object[] fieldNames = (Object[])tableDict.get(fieldNamesKey);
            Object[] fieldTypes = (Object[])tableDict.get(fieldTypesKey);
            i = 0;
            while (i < fieldNames.length) {
                info.addField((String)fieldNames[i], ASCIIArchiveLoader.typeForName((String)fieldTypes[i]));
                ++i;
            }
            ClassTable table = new ClassTable(this.archive, info);
            this.archive.addClassTable(table);
        }
    }

    static byte typeForName(String typeName) throws CodingException {
        int length = typeName.length();
        if (length <= 0) {
            throw new CodingException("unknown type name: " + typeName);
        }
        switch (typeName.charAt(0)) {
            case 'b': {
                if (typeName.equals("boolean")) {
                    return 0;
                }
                if (typeName.equals("boolean[]")) {
                    return 1;
                }
                if (typeName.equals("byte")) {
                    return 4;
                }
                if (!typeName.equals("byte[]")) break;
                return 5;
            }
            case 'c': {
                if (typeName.equals("char")) {
                    return 2;
                }
                if (!typeName.equals("char[]")) break;
                return 3;
            }
            case 's': {
                if (typeName.equals("short")) {
                    return 6;
                }
                if (!typeName.equals("short[]")) break;
                return 7;
            }
            case 'i': {
                if (typeName.equals("int")) {
                    return 8;
                }
                if (!typeName.equals("int[]")) break;
                return 9;
            }
            case 'l': {
                if (typeName.equals("long")) {
                    return 10;
                }
                if (!typeName.equals("long[]")) break;
                return 11;
            }
            case 'f': {
                if (typeName.equals("float")) {
                    return 12;
                }
                if (!typeName.equals("float[]")) break;
                return 13;
            }
            case 'd': {
                if (typeName.equals("double")) {
                    return 14;
                }
                if (!typeName.equals("double[]")) break;
                return 15;
            }
            case 'j': {
                if (length == 16) {
                    if (typeName.equals("java.lang.String")) {
                        return 16;
                    }
                    if (!typeName.equals("java.lang.Object")) break;
                    return 18;
                }
                if (length != 18) break;
                if (typeName.equals("java.lang.String[]")) {
                    return 17;
                }
                if (!typeName.equals("java.lang.Object[]")) break;
                return 19;
            }
        }
        throw new CodingException("unknown type name: " + typeName);
    }

    void loadInstanceData() throws CodingException {
        Hashtable tableDict;
        String className;
        Hashtable allTablesDict = (Hashtable)this.archiveDict.get(classTablesKey);
        if (allTablesDict == null) {
            return;
        }
        Enumeration classNameEnum = allTablesDict.keys();
        while (classNameEnum.hasMoreElements()) {
            className = (String)classNameEnum.nextElement();
            tableDict = (Hashtable)allTablesDict.get(className);
            this.loadRowMapping(className, tableDict);
        }
        classNameEnum = allTablesDict.keys();
        while (classNameEnum.hasMoreElements()) {
            className = (String)classNameEnum.nextElement();
            tableDict = (Hashtable)allTablesDict.get(className);
            this.loadRowData(className, tableDict);
        }
    }

    void loadRowMapping(String className, Hashtable tableDict) throws CodingException {
        Hashtable allInstancesDict = (Hashtable)tableDict.get(instancesKey);
        if (allInstancesDict == null) {
            return;
        }
        Enumeration nameEnum = allInstancesDict.keys();
        while (nameEnum.hasMoreElements()) {
            String name = (String)nameEnum.nextElement();
            Hashtable instanceDict = (Hashtable)allInstancesDict.get(name);
            if (this.idForName.get(name) != 0) {
                throw new CodingException("duplicate instance name: " + name);
            }
            ClassTable table = this.archive.classTableForName(className);
            if (table == null) {
                throw new CodingException("bad class name for instance: " + name);
            }
            int id = table.newIdentifier();
            this.idForName.putKnownAbsent(name, id);
        }
    }

    void loadRowData(String className, Hashtable tableDict) throws CodingException {
        Hashtable allInstancesDict = (Hashtable)tableDict.get(instancesKey);
        if (allInstancesDict == null) {
            return;
        }
        Enumeration nameEnum = allInstancesDict.keys();
        while (nameEnum.hasMoreElements()) {
            String name = (String)nameEnum.nextElement();
            int id = this.idForName.get(name);
            ClassTable table = this.archive.tableForId[id];
            int row = this.archive.rowForId[id];
            Hashtable instanceDict = (Hashtable)allInstancesDict.get(name);
            this.loadRow(table, row, instanceDict);
        }
    }

    void loadRow(ClassTable table, int row, Hashtable instanceDict) throws CodingException {
        int i = 0;
        while (i < table.fieldCount) {
            Object value = instanceDict.get(table.fieldNames[i]);
            if (value != null) {
                this.setColumnFromValue(table, row, i, value);
            }
            ++i;
        }
    }

    void setColumnFromValue(ClassTable table, int row, int column, Object v) throws CodingException {
        String value = null;
        Object[] array = null;
        if (v instanceof String) {
            value = (String)v;
            switch (table.fieldTypes[column]) {
                case 0: {
                    if (value.equalsIgnoreCase("true")) {
                        table.setBooleanAt(row, column, true);
                        return;
                    }
                    if (value.equalsIgnoreCase("false")) {
                        table.setBooleanAt(row, column, false);
                        return;
                    }
                    throw new CodingException("Invalid boolean value");
                }
                case 2: {
                    table.setCharAt(row, column, value.charAt(0));
                    return;
                }
                case 4: {
                    table.setByteAt(row, column, (byte)Integer.parseInt(value));
                    return;
                }
                case 5: {
                    table.setByteArrayAt(row, column, this.bytesFromString(value));
                    return;
                }
                case 6: {
                    table.setShortAt(row, column, (short)Integer.parseInt(value));
                    return;
                }
                case 8: {
                    table.setIntAt(row, column, Integer.parseInt(value));
                    return;
                }
                case 10: {
                    table.setLongAt(row, column, Long.parseLong(value));
                    return;
                }
                case 12: {
                    table.setFloatAt(row, column, Float.valueOf(value).floatValue());
                    return;
                }
                case 14: {
                    table.setDoubleAt(row, column, Double.valueOf(value));
                    return;
                }
                case 16: {
                    table.setStringAt(row, column, value);
                    return;
                }
                case 18: {
                    table.setIdentifierAt(row, column, this.idForName.get(value));
                    return;
                }
            }
            throw new CodingException("Invalid value " + value);
        }
        if (v instanceof Object[]) {
            array = (Object[])v;
            switch (table.fieldTypes[column]) {
                case 1: {
                    int count = array.length;
                    boolean[] booleanArray = new boolean[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        if (value.equalsIgnoreCase("true")) {
                            booleanArray[i] = true;
                        } else if (value.equalsIgnoreCase("false")) {
                            booleanArray[i] = false;
                        } else {
                            throw new CodingException("Invalid boolean value");
                        }
                        ++i;
                    }
                    table.setBooleanArrayAt(row, column, booleanArray);
                    return;
                }
                case 3: {
                    int count = array.length;
                    char[] charArray = new char[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        charArray[i] = value.charAt(0);
                        ++i;
                    }
                    table.setCharArrayAt(row, column, charArray);
                    return;
                }
                case 7: {
                    int count = array.length;
                    short[] shortArray = new short[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        shortArray[i] = (short)Integer.parseInt(value);
                        ++i;
                    }
                    table.setShortArrayAt(row, column, shortArray);
                    return;
                }
                case 9: {
                    int count = array.length;
                    int[] intArray = new int[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        intArray[i] = Integer.parseInt(value);
                        ++i;
                    }
                    table.setIntArrayAt(row, column, intArray);
                    return;
                }
                case 11: {
                    int count = array.length;
                    long[] longArray = new long[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        longArray[i] = Long.parseLong(value);
                        ++i;
                    }
                    table.setLongArrayAt(row, column, longArray);
                    return;
                }
                case 13: {
                    int count = array.length;
                    float[] floatArray = new float[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        floatArray[i] = Float.valueOf(value).floatValue();
                        ++i;
                    }
                    table.setFloatArrayAt(row, column, floatArray);
                    return;
                }
                case 15: {
                    int count = array.length;
                    double[] doubleArray = new double[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        doubleArray[i] = Double.valueOf(value);
                        ++i;
                    }
                    table.setDoubleArrayAt(row, column, doubleArray);
                    return;
                }
                case 17: {
                    int count = array.length;
                    String[] stringArray = new String[count];
                    int i = 0;
                    while (i < count) {
                        stringArray[i] = (String)array[i];
                        ++i;
                    }
                    table.setStringArrayAt(row, column, stringArray);
                    return;
                }
                case 19: {
                    int count = array.length;
                    int[] intArray = new int[count];
                    int i = 0;
                    while (i < count) {
                        value = (String)array[i];
                        if (value != null) {
                            intArray[i] = this.idForName.get(value);
                        }
                        ++i;
                    }
                    table.setIdentifierArrayAt(row, column, intArray);
                    return;
                }
            }
            throw new CodingException("Invalid value" + value);
        }
    }

    /*
     * Unable to fully structure code
     */
    byte[] bytesFromString(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("")) {
            return new byte[0];
        }
        count = value.length();
        buf = new byte[count / 2 + 1];
        i = 0;
        outCount = 0;
        ** GOTO lbl18
        {
            if (!Character.isSpace(ch = value.charAt(i++))) {
                if (i >= count) {
                    throw new NumberFormatException("bad byte string");
                }
                nibble = this.nibbleForHexChar(ch);
                ch = value.charAt(i++);
                buf[outCount++] = (byte)((nibble << 4) + this.nibbleForHexChar(ch));
            }
            do {
                if (i < count) continue block0;
lbl18:
                // 2 sources

            } while (i < count);
        }
        tmp = new byte[outCount];
        System.arraycopy(buf, 0, tmp, 0, outCount);
        return tmp;
    }

    int nibbleForHexChar(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new NumberFormatException("bad byte string");
    }

    void loadRoots() throws CodingException {
        Object[] rootsArray = (Object[])this.archiveDict.get(rootInstancesKey);
        if (rootsArray == null || rootsArray.length == 0) {
            return;
        }
        int i = 0;
        while (i < rootsArray.length) {
            String name = (String)rootsArray[i];
            int id = name == null || name.equals("") ? 0 : this.idForName.get(name);
            if (id == 0) {
                throw new CodingException("unknown root instance " + name);
            }
            this.archive.addRootIdentifier(id);
            ++i;
        }
    }

    void writeASCII(OutputStream out, boolean formatted) throws IOException {
        this.nameForId = new String[this.archive.idCount];
        this.baseNameForTable = new Hashtable();
        this.archiveDict = new Hashtable();
        String versionString = String.valueOf(1);
        this.archiveDict.put(archiveVersionKey, versionString);
        this.saveClassInfo();
        this.saveInstanceData();
        this.saveRoots();
        Serializer serializer = formatted ? new FormattingSerializer(out) : new Serializer(out);
        serializer.writeObject(this.archiveDict);
        serializer.flush();
    }

    String nameForId(int id) {
        int digits;
        String name = this.nameForId[id];
        if (name != null) {
            return name;
        }
        ClassTable table = this.archive.tableForId[id];
        if (table == null) {
            return null;
        }
        String base = (String)this.baseNameForTable.get(table);
        if (base == null) {
            base = table.className();
            int lastDotIndex = base.lastIndexOf(46);
            if (lastDotIndex > 0 && lastDotIndex < base.length() - 1 && base.charAt(0) != '[') {
                base = base.substring(lastDotIndex + 1, base.length());
            }
            if (this.baseNameForTable.get(base = String.valueOf(base) + "-") != null) {
                base = String.valueOf(table.className()) + "-";
                digits = 0;
                while (this.baseNameForTable.get(base) != null) {
                    base = String.valueOf(table.className()) + "-" + digits + "-";
                    ++digits;
                }
            }
            this.baseNameForTable.put(table, base);
        }
        digits = this.decimalDigitCount(table.rowCount());
        String seqString = this.decimalString(this.archive.rowForId[id], digits);
        this.nameForId[id] = name = String.valueOf(base) + seqString;
        return name;
    }

    int decimalDigitCount(int number) {
        int i = 0;
        while (number > 0) {
            ++i;
            number /= 10;
        }
        return i;
    }

    String decimalString(int number, int digits) {
        char[] buf = new char[digits];
        int i = 0;
        while (i < digits) {
            buf[i] = 48;
            ++i;
        }
        i = digits;
        while (number > 0 && i > 0) {
            buf[--i] = (char)(number % 10 + 48);
            number /= 10;
        }
        return new String(buf);
    }

    void saveClassInfo() {
        Hashtable allTablesDict = new Hashtable();
        Enumeration tableEnum = this.archive.classTables.elements();
        while (tableEnum.hasMoreElements()) {
            ClassTable table = (ClassTable)tableEnum.nextElement();
            Hashtable tableDict = this.dictionaryForTable(table);
            allTablesDict.put(table.className(), tableDict);
        }
        this.archiveDict.put(classTablesKey, allTablesDict);
    }

    Hashtable dictionaryForTable(ClassTable table) {
        Hashtable tableDict = new Hashtable(5);
        String[] typeArray = new String[table.fieldCount];
        int i = 0;
        while (i < table.fieldCount) {
            typeArray[i] = this.nameForType(table.fieldTypes[i]);
            ++i;
        }
        tableDict.put(fieldNamesKey, table.fieldNames);
        tableDict.put(fieldTypesKey, typeArray);
        String[] classVersions = new String[table.classCount];
        i = 0;
        while (i < table.classCount) {
            classVersions[i] = String.valueOf(table.classVersions[i]);
            ++i;
        }
        tableDict.put(classNamesKey, table.classNames);
        tableDict.put(classVersionsKey, classVersions);
        return tableDict;
    }

    String nameForType(int fieldType) {
        switch (fieldType) {
            case 0: {
                return "boolean";
            }
            case 1: {
                return "boolean[]";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "char[]";
            }
            case 4: {
                return "byte";
            }
            case 5: {
                return "byte[]";
            }
            case 6: {
                return "short";
            }
            case 7: {
                return "short[]";
            }
            case 8: {
                return "int";
            }
            case 9: {
                return "int[]";
            }
            case 10: {
                return "long";
            }
            case 11: {
                return "long[]";
            }
            case 12: {
                return "float";
            }
            case 13: {
                return "float[]";
            }
            case 14: {
                return "double";
            }
            case 15: {
                return "double[]";
            }
            case 16: {
                return "java.lang.String";
            }
            case 17: {
                return "java.lang.String[]";
            }
            case 18: {
                return "java.lang.Object";
            }
            case 19: {
                return "java.lang.Object[]";
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + fieldType);
    }

    void saveInstanceData() {
        Hashtable allTablesDict = (Hashtable)this.archiveDict.get(classTablesKey);
        int i = 1;
        while (i < this.archive.idCount) {
            ClassTable table = this.archive.tableForId[i];
            int row = this.archive.rowForId[i];
            Hashtable instanceDict = this.dictionaryForInstance(table, row);
            Hashtable tableDict = (Hashtable)allTablesDict.get(table.className);
            Hashtable allInstancesDict = (Hashtable)tableDict.get(instancesKey);
            if (allInstancesDict == null) {
                allInstancesDict = new Hashtable();
                tableDict.put(instancesKey, allInstancesDict);
            }
            allInstancesDict.put(this.nameForId(i), instanceDict);
            ++i;
        }
    }

    Hashtable dictionaryForInstance(ClassTable table, int row) {
        Hashtable dict = new Hashtable(2 * table.fieldCount);
        int i = 0;
        while (i < table.fieldCount) {
            Object fieldValue = this.valueForField(table, row, i);
            if (fieldValue != null) {
                dict.put(table.fieldNames[i], fieldValue);
            }
            ++i;
        }
        return dict;
    }

    Object valueForField(ClassTable table, int row, int column) {
        switch (table.fieldTypes[column]) {
            case 0: {
                return String.valueOf(table.booleanAt(row, column));
            }
            case 1: {
                boolean[] booleanArray = table.booleanArrayAt(row, column);
                if (booleanArray == null) {
                    return null;
                }
                int count = booleanArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = String.valueOf(booleanArray[i]);
                    ++i;
                }
                return stringArray;
            }
            case 2: {
                return String.valueOf(table.charAt(row, column));
            }
            case 3: {
                char[] charArray = table.charArrayAt(row, column);
                if (charArray == null) {
                    return null;
                }
                int count = charArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = String.valueOf(charArray[i]);
                    ++i;
                }
                return stringArray;
            }
            case 4: {
                return String.valueOf(table.byteAt(row, column) & 0xFF);
            }
            case 5: {
                return ASCIIArchiveLoader.bytesString(table.byteArrayAt(row, column));
            }
            case 6: {
                return String.valueOf(table.shortAt(row, column));
            }
            case 7: {
                short[] shortArray = table.shortArrayAt(row, column);
                if (shortArray == null) {
                    return null;
                }
                int count = shortArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = String.valueOf(shortArray[i]);
                    ++i;
                }
                return stringArray;
            }
            case 8: {
                return String.valueOf(table.intAt(row, column));
            }
            case 9: {
                int[] intArray = table.intArrayAt(row, column);
                if (intArray == null) {
                    return null;
                }
                int count = intArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = String.valueOf(intArray[i]);
                    ++i;
                }
                return stringArray;
            }
            case 10: {
                return String.valueOf(table.longAt(row, column));
            }
            case 11: {
                long[] longArray = table.longArrayAt(row, column);
                if (longArray == null) {
                    return null;
                }
                int count = longArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = String.valueOf(longArray[i]);
                    ++i;
                }
                return stringArray;
            }
            case 12: {
                return String.valueOf(table.floatAt(row, column));
            }
            case 13: {
                float[] floatArray = table.floatArrayAt(row, column);
                if (floatArray == null) {
                    return null;
                }
                int count = floatArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = String.valueOf(floatArray[i]);
                    ++i;
                }
                return stringArray;
            }
            case 14: {
                return String.valueOf(table.doubleAt(row, column));
            }
            case 15: {
                double[] doubleArray = table.doubleArrayAt(row, column);
                if (doubleArray == null) {
                    return null;
                }
                int count = doubleArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = String.valueOf(doubleArray[i]);
                    ++i;
                }
                return stringArray;
            }
            case 16: {
                return table.stringAt(row, column);
            }
            case 17: {
                return table.stringArrayAt(row, column);
            }
            case 18: {
                return this.nameForId(table.identifierAt(row, column));
            }
            case 19: {
                int[] intArray = table.identifierArrayAt(row, column);
                if (intArray == null) {
                    return null;
                }
                int count = intArray.length;
                String[] stringArray = new String[count];
                int i = 0;
                while (i < count) {
                    stringArray[i] = this.nameForId(intArray[i]);
                    ++i;
                }
                return stringArray;
            }
        }
        throw new InconsistencyException("Unknown field type: " + table.fieldTypes[column]);
    }

    static String bytesString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        int count = bytes.length;
        byte[] buf = new byte[2 * count + count / 4 + 1];
        int outCount = 0;
        int i = 0;
        while (i < count) {
            byte b = bytes[i];
            buf[outCount++] = hexChar[b >>> 4 & 0xF];
            buf[outCount++] = hexChar[b & 0xF];
            if ((i + 1) % 4 == 0) {
                buf[outCount++] = 32;
            }
            ++i;
        }
        if (buf[outCount - 1] == 32) {
            --outCount;
        }
        return new String(buf, 0, 0, outCount);
    }

    void saveRoots() {
        String[] rootsArray = new String[this.archive.rootCount];
        int i = 0;
        while (i < this.archive.rootCount) {
            rootsArray[i] = this.nameForId(this.archive.roots[i]);
            ++i;
        }
        this.archiveDict.put(rootInstancesKey, rootsArray);
    }
}

