/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.util.ASCIIArchiveLoader;
import netscape.util.ClassTable;
import netscape.util.CodingException;
import netscape.util.CompactInputStream;
import netscape.util.CompactOutputStream;
import netscape.util.DeserializationException;
import netscape.util.ExternalCoder;
import netscape.util.Hashtable;
import netscape.util.PrimitiveCoder;

public class Archive {
    public static final int ARCHIVE_MAGIC = 1852138529;
    static final int ARCHIVE_VERSION = 1;
    static Hashtable externalCoders;
    int version;
    int rootCount = 0;
    int[] roots = new int[4];
    int idCount = 1;
    int[] rowForId = new int[4];
    ClassTable[] tableForId = new ClassTable[4];
    Hashtable classTables = new Hashtable();
    public boolean performanceDebug = false;

    private static int[] growIntArray(int[] array) {
        int[] newArray = new int[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private static ClassTable[] growTableArray(ClassTable[] array) {
        ClassTable[] newArray = new ClassTable[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public void addRootIdentifier(int id) {
        if (this.rootCount >= this.roots.length) {
            this.roots = Archive.growIntArray(this.roots);
        }
        this.roots[this.rootCount] = id;
        ++this.rootCount;
    }

    public boolean removeRootIdentifier(int id) {
        boolean removed = false;
        int i = 0;
        while (i < this.rootCount) {
            if (this.roots[i] == id) {
                removed = true;
                --this.rootCount;
                break;
            }
            ++i;
        }
        while (i < this.rootCount) {
            this.roots[i] = this.roots[i + 1];
            ++i;
        }
        return removed;
    }

    public int[] rootIdentifiers() {
        int[] rootsCopy = new int[this.rootCount];
        System.arraycopy(this.roots, 0, rootsCopy, 0, this.rootCount);
        return rootsCopy;
    }

    public ClassTable classTableForName(String className) {
        return (ClassTable)this.classTables.get(className);
    }

    public void addClassTable(ClassTable table) {
        this.classTables.put(table.className(), table);
    }

    public ClassTable classTableForIdentifier(int id) {
        if (id >= this.idCount) {
            throw new ArrayIndexOutOfBoundsException(id);
        }
        return this.tableForId[id];
    }

    public int rowForIdentifier(int id) {
        if (id >= this.idCount) {
            throw new ArrayIndexOutOfBoundsException(id);
        }
        return this.rowForId[id];
    }

    public int mapIdentifier(ClassTable table, int row) {
        if (this.idCount >= this.rowForId.length) {
            this.rowForId = Archive.growIntArray(this.rowForId);
            this.tableForId = Archive.growTableArray(this.tableForId);
        }
        int id = this.idCount++;
        this.rowForId[id] = row;
        this.tableForId[id] = table;
        return id;
    }

    public int identifierCount() {
        return this.idCount;
    }

    static synchronized void setupExternalCoders() {
        if (externalCoders != null) {
            return;
        }
        externalCoders = new Hashtable(24);
        PrimitiveCoder coder = new PrimitiveCoder(0);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(1);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(2);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(3);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(4);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(5);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(6);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(7);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(8);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(9);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(10);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(11);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(12);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(13);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(14);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(15);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(16);
        externalCoders.put(coder.className(), coder);
        coder = new PrimitiveCoder(17);
        externalCoders.put(coder.className(), coder);
    }

    ExternalCoder externalCoderForName(String className) {
        if (externalCoders == null) {
            Archive.setupExternalCoders();
        }
        return (ExternalCoder)externalCoders.get(className);
    }

    public void read(InputStream inputStream) throws IOException {
        ClassTable table;
        CompactInputStream in = inputStream instanceof CompactInputStream ? (CompactInputStream)inputStream : new CompactInputStream(inputStream);
        int magic = in.readInt();
        if (magic != 1852138529) {
            throw new IOException("Bad magic number " + magic);
        }
        this.version = in.readInt();
        if (this.version != 1) {
            throw new IOException("Unknown archiveVersion " + this.version);
        }
        int count = in.readCompactInt();
        ClassTable[] tables = new ClassTable[count];
        int i = 0;
        while (i < count) {
            tables[i] = table = new ClassTable(this);
            table.readInfo(in);
            this.addClassTable(table);
            ++i;
        }
        i = 0;
        while (i < count) {
            table = tables[i];
            table.readData(in);
            ++i;
        }
        count = in.readCompactInt();
        this.roots = new int[count];
        this.rootCount = count;
        i = 0;
        while (i < count) {
            this.roots[i] = in.readCompactInt();
            ++i;
        }
        count = in.readCompactInt();
        this.rowForId = new int[count];
        this.tableForId = new ClassTable[count];
        this.idCount = count;
        i = 1;
        while (i < count) {
            this.rowForId[i] = in.readCompactInt();
            this.tableForId[i] = tables[in.readCompactInt()];
            ++i;
        }
        count = in.readCompactInt();
        if (count > 0) {
            in.skipBytes(count);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        ClassTable table;
        CompactOutputStream out = outputStream instanceof CompactOutputStream ? (CompactOutputStream)outputStream : new CompactOutputStream(outputStream);
        out.writeInt(1852138529);
        out.writeInt(1);
        Object[] tables = this.classTables.elementsArray();
        int count = tables == null ? 0 : tables.length;
        out.writeCompactInt(count);
        int i = 0;
        while (i < count) {
            table = (ClassTable)tables[i];
            table.tableId = i++;
            table.writeInfo(out);
        }
        i = 0;
        while (i < count) {
            table = (ClassTable)tables[i];
            table.writeData(out);
            ++i;
        }
        count = this.rootCount;
        out.writeCompactInt(count);
        i = 0;
        while (i < count) {
            out.writeCompactInt(this.roots[i]);
            ++i;
        }
        count = this.idCount;
        out.writeCompactInt(count);
        i = 1;
        while (i < count) {
            out.writeCompactInt(this.rowForId[i]);
            table = this.tableForId[i];
            if (table == null) {
                out.writeCompactInt(0);
            } else {
                out.writeCompactInt(table.tableId);
            }
            ++i;
        }
        out.writeCompactInt(0);
        out.flush();
    }

    public void readASCII(InputStream inputStream) throws CodingException, DeserializationException, IOException {
        ASCIIArchiveLoader loader = new ASCIIArchiveLoader(this);
        loader.readASCII(inputStream);
    }

    public void writeASCII(OutputStream outputStream, boolean formatted) throws CodingException, IOException {
        ASCIIArchiveLoader loader = new ASCIIArchiveLoader(this);
        loader.writeASCII(outputStream, formatted);
    }
}

