/*
 * Copyright (c) 1991-1993 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: controller.h,v 1.22 96/04/25 06:13:10 van Exp $ (LBL)
 */

#ifndef vat_controller_h
#define vat_controller_h

class Audio;
class Site;
class SiteBox;
class SampleStream;
class VUMeter;
class PCM_Encoder;

#include "observe.h"
#include "audio.h"
#include "timer.h"
#include "inet.h"
#include "Tcl.h"
#include "media-timer.h"

#define TALK_LEAD (4)		// number of audio frames sent before a
				// silence-to-talk transition 
#define TALK_TAIL (32)		// number of audio frames sent after a
				// talk-to-silence transition

class Controller : public TclObject, public Observer, public MediaTimer,
			public AudioHandler, public Timer {
    public:
	Controller();
	virtual void update(Observable*);
	int active() const;
	void mix_from_net(int del, const u_int8_t* frame, int len);
	virtual int command(int argc, const char*const* argv);
	inline int maxdel() const { return (as_->MaxSamp()); }
	u_int32_t media_ts();
	u_int32_t ref_ts();
    protected:
	virtual void timeout();
	virtual void audio_handle();
	void Activate();
	void DoAudio();
	void DoTimer();
	void mixaudio(SampleStream& ss);
	int sending() const;
	int Output();
	void send_block(u_int32_t ts, u_int8_t* blk, int len);

	Audio* audio_;

	SampleStream* as_;	/* audio stream to/from local device */
	SampleStream* ns_;	/* audio stream to/from network */

	int lastnetout_;
	int lastaudout_;
	u_int timer_interval_;
	u_long tsec_, tusec_;

	int ostate_;

	VUMeter* pmeter_;
	VUMeter* rmeter_;

	int talk_thresh_;
	int echo_thresh_;
	u_int echo_suppress_time_;
	int idle_drop_time_;
	int meter_update_;
	int active_;		/* set to 1 whenever audio or net written */

	u_int32_t last_mts_;	/* media timestamp of last block sent */
	timeval last_uts_;	/* unix timestamp associated with last_mts */

	/* XXX eventually want to handle other types of encoders */
	PCM_Encoder* encoder_;

	/*
	 * Output buffering state needed to coalesce several sample
	 * blocks from the audio hardware into a single chunk to
	 * be handed to the encoder.
	 */
	int outmax_;		/* size of chunk handed to encoder */
	int outlen_;		/* current size of chunk being built */
	u_int32_t out_ts_;	/* timestamp of head of current chunk */
	u_int8_t* out_;		/* pointer to chunk is sample-stream */
	u_int8_t overflow_[1024]; /* bounce buffer in case chunk wraps */
};

inline int Controller::sending() const
{
	return (ostate_ < TALK_TAIL+TALK_LEAD || out_);
}

inline int Controller::active() const
{
	return (audio_->HaveAudio());
}

#endif
