/*
  Utility
*/

#ifndef __UTILS_H__
#define __UTILS_H__

#include <syslog.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>

#define  LOG_ENABLED 1

#define  MAX_FILENAME PATH_MAX

#ifndef  FALSE
#define  FALSE (1!=1)
#endif

#ifndef  TRUE
#define  TRUE  (1==1)
#endif

#ifndef  ERROR
#define  ERROR (-1)
#endif

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif

// -------------------------------------------------------
// file interfaces
// -------------------------------------------------------
#define NO_DIR (NULL)

typedef class fhandle {
	
public:

	FILE *f;

public:

  fhandle(void) : f(NULL) {};

  void operator=(void *f_)
  {
    f = (FILE *)f_;
  }

  void operator=(class fhandle *f_)
  {
    f = f_->f;
  }

  bool operator==(void *f_)
  {
    return(f == f_);
  }

  operator FILE*(void)
  {
    return(f);
  }

  operator bool(void)
  {
    return(f != NULL);
  }

} FHANDLE;

typedef unsigned int t_off;

char *    return_path(char *p_dir, char *p_file, char *p_buffer, int max_lenght);

FHANDLE   file_open(char *p_dir, char *p_file, char *p_mode, bool safe = TRUE);
void      file_close(FHANDLE f);

int    		file_load(char *p_dir, char *p_file, char *p_mem, t_off max_lenght, t_off start_address = 0, bool safe = TRUE);
int    		file_load_text(char * p_dir, char * p_file, char * p_mem, t_off max_lenght, t_off start_address = 0, bool safe = TRUE);

int    	  file_load(FHANDLE f, char * p_mem, t_off max_lenght, t_off start_address = 0);
int       file_load_text(FHANDLE f, char * p_mem, t_off max_lenght, t_off start_address = 0);

void *    file_load(char *p_dir, char *p_file, t_off *p_lenght, t_off start_address = 0, bool safe = TRUE);

bool      file_save(char *p_dir, char *p_file, void *p_buffer, t_off lenght);

bool      file_exists(char *p_dir, char *p_file);

int       file_size_get(char * p_dir, char * p_file);
int       file_size_get(FHANDLE f);

bool      file_copy(char *p_src, char *p_src_dir, char *p_dest, char *p_dest_dir, bool safe = TRUE);

void      print_errno(bool new_line = FALSE);

bool      dir_create(char *p_dir);
char   *  dir_home_get(char *p_dir, int max);

// Don't use standart I/O
#define fopen(a,b)
#define fclose(a)
#define FILE

#define DEFAULT_DIR_MASK   0755
#define DEFAULT_FILE_MASK  0644

// -------------------------------------------------------
// log file management
// -------------------------------------------------------

extern FHANDLE log_file;

void log_open(char *p_file);
void log_open_ini(char *p_ini_file);
void log_close(void);
void log_flush(void);

// -------------------------------------------------------
// memory allocation
// -------------------------------------------------------

inline void * mmalloc(int size)
{
   void *p_tmp = malloc(size);

   if(!p_tmp) {
     syslog(3,"Out of memory! file: %s line: %d",__FILE__,__LINE__);
     assert(0);
     exit(0);
   } else {
     memset(p_tmp,0,size);
     return(p_tmp);
   }
}

inline void * mmemcpy(void *p_src, int size)
{
  void *p_tmp = mmalloc(size);
  memcpy(p_tmp, p_src, size);
  return(p_tmp);
}

inline void * rrealloc(void *p_mem, int size)
{
   void *p_tmp = realloc(p_mem,size);

   if(!p_tmp) {
     syslog(3,"Out of memory! file: %s line: %d",__FILE__,__LINE__);
     assert(0);
     exit(0);
   } else {
     return(p_tmp);
   }
}

inline void xfree(void **p_mem)
{
   if(p_mem && *p_mem) {
     free(*p_mem);
     *p_mem = NULL;     
   }
}

#define ffree(ptr) { if(ptr) { free(ptr); ptr = NULL; }}

// -------------------------------------------------------
// logging - helper function
// -------------------------------------------------------
#ifdef  LOG_ENABLED

inline void berror(char *p_text,...)
{
  char      text[2000];
  va_list   arguments;  

  va_start(arguments,p_text);
  vsnprintf(text,2000,p_text,arguments);
  va_end(arguments);

  fprintf(stderr,"Error at line %d file %s: %s\n",__LINE__,__FILE__,text);

  assert(0);
  exit(255);
}

inline void bprintf(char *p_text,...)
{
  char      text[2000];
  va_list   arguments;  

  va_start(arguments,p_text);
  vsnprintf(text,2000,p_text,arguments);
  va_end(arguments);

  fprintf(stderr,"%s\n",text);

  if(log_file) {
    fprintf(log_file,"%s\n",text);
  }
}

inline void bprintfnl(char *p_text,...)
{
  char      text[2000];
  va_list   arguments;  

  va_start(arguments,p_text);
  vsnprintf(text,2000,p_text,arguments);
  va_end(arguments);

  fprintf(stderr,"%s",text);

  if(log_file) {
    fprintf(log_file,"%s",text);
  }
}

inline int fgets_correction(char * p_kor)
{
  int delka = strlen(p_kor);
  if (p_kor[delka - 1] == '\n') {
    p_kor[delka - 1] = 0;
    return (delka - 1);
  }
  else {
    return (delka);
  }
}

#else

#define berror(p_text,...)
#define bprintf(p_text,...)
#define fgets_correction(p_kor)

#endif

// -------------------------------------------------------
// configuration management
// -------------------------------------------------------

typedef class dir_list {

  char levels[MAX_FILENAME];
  char levels_user[MAX_FILENAME];
  char gamedata[MAX_FILENAME];
  char graphics[MAX_FILENAME];
  char tmp[MAX_FILENAME];
  char game_binary[MAX_FILENAME];
  char cwd[MAX_FILENAME];

public:
  
  dir_list(void)
  {
    levels[0] = '\0';
    levels_user[0] = '\0';
    gamedata[0] = '\0';
    graphics[0] = '\0';
    tmp[0] = '\0';
    game_binary[0] = '\0';    
    cwd[0] = '\0';
  }

  ~dir_list(void) {};

private:
  
  void update_path(char *p_dir);

public:
  
  void load(char *p_ini);

  char * levels_get(void)
  {
    return(levels);
  }

  char * levels_user_get(void)
  {
    return(levels_user);
  }

  char * gamedata_get(void)
  {
    return(gamedata);
  }

  char * graphics_get(void)
  {
    return(graphics);
  }

  char * tmp_get(void)
  {
    return(tmp);
  }

  char * game_binary_get(void)
  {
    return(game_binary);
  }

  char * cwd_get(void)
  {
    return(cwd);
  }

} DIR_LIST;

bool get_fullscreen(char *p_ini_file);
int  get_colors(char *p_ini_file, int default_color_depth);

// -------------------------------------------------------
// the rest
// -------------------------------------------------------

inline char * change_tail(char * p_str, char * p_end)
{
  char *p_act = p_str, *p_last = NULL;
  while((p_act = strchr(p_act, '.'))) {
    p_last = p_act;
    p_act++;
  }  
  if (p_last)
    *p_last = 0;
  return (p_end ? (char *) strcat(p_str, p_end) : p_str);
}

#endif // __UTILS_H__
