# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Tests for the testing infrastructure in bzr-explorer."""

from PyQt4 import QtCore, QtGui

from bzrlib.plugins.explorer import tests


class _Emitter(QtCore.QObject):

    def trigger_foo(self):
        self.emit(QtCore.SIGNAL('foo()'))

    def trigger_bar(self, arg1, arg2):
        self.emit(QtCore.SIGNAL('bar(int, int)'), arg1, arg2)


class TestTestCaseWithQt(tests.TestCaseWithQt):

    def test_create_qpixmap(self):
        pixmap = QtGui.QPixmap()

    def test_logger_named_slot(self):
        slot = self.logger.createNamedSlot('trapping_foo')
        emitter = _Emitter()
        QtCore.QObject.connect(emitter, QtCore.SIGNAL('foo()'), slot)
        self.assertEqual([], self.logger.log)
        emitter.trigger_foo()
        self.assertEqual([('trapping_foo',)], self.logger.log)
        emitter.trigger_bar(1, 2) # not connected
        self.assertEqual([('trapping_foo',)], self.logger.log)
        emitter.trigger_foo()
        self.assertEqual([('trapping_foo',), ('trapping_foo',)],
                         self.logger.log)
        slot = self.logger.createNamedSlot('trapping_bar')
        QtCore.QObject.connect(emitter, QtCore.SIGNAL('bar(int, int)'), slot)
        emitter.trigger_bar(1, 2)
        self.assertEqual([('trapping_foo',), ('trapping_foo',),
                          ('trapping_bar', 1, 2),
                         ], self.logger.log)

    def test_connectToNamedSlot(self):
        emitter = _Emitter()
        self.logger.connectToNamedSlot('foo()', emitter)
        self.logger.connectToNamedSlot('bar(int, int)', emitter)
        emitter.trigger_foo()
        self.assertEqual([('foo()',)], self.logger.log)
        emitter.trigger_bar(3, 4)
        self.assertEqual([('foo()',), ('bar(int, int)', 3, 4)],
                         self.logger.log)

