(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open Color

class map cmap = object
  val obj = cmap
  method colormap = obj

  method max = obj.max
  method map = obj.map

  method query_rgb x = if x < size cmap then cmap.map.(x) else raise Not_found

  method set_max max = obj.max <- max
  method set_map map = obj.map <- map

  method size = size obj
  method find_exact = find_exact obj
  method find_nearest = find_exact obj
  method add_color = add_color obj
  method add_colors = add_colors obj
end
