(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open OImage

(* split a string according to char_sep predicate *)
let split_str char_sep str =
  let len = String.length str in
  if len = 0 then [] else
    let rec skip_sep cur =
      if cur >= len then cur
      else if char_sep str.[cur] then skip_sep (succ cur)
      else cur  in
    let rec split beg cur =
      if cur >= len then 
	if beg = cur then []
	else [String.sub str beg (len - beg)]
      else if char_sep str.[cur] 
	   then 
	     let nextw = skip_sep cur in
	      (String.sub str beg (cur - beg))
		::(split nextw nextw)
	   else split beg (succ cur) in
    let wstart = skip_sep 0 in
    split wstart wstart

let get_extension s =
  let dotpos = String.rindex s '.' in
  String.sub s (dotpos + 1) (String.length s - dotpos - 1)
;;

let _ =
  let files = ref [] in
  let force_write = ref false in
  let conf = ref None in
  Arg.parse [ "-force", Arg.Unit (fun () -> force_write := true),
	      ": force to create a cropped file everytime";
	      "-crop", Arg.String (fun s ->
		match List.map int_of_string 
		    (split_str (function '+' | 'x' -> true | _ -> false) s) 
		with
 		| [w;h;x;y] -> conf := Some (w,h,x,y)
		| _ -> assert false), "?x?+?+? : explicit cropping";
    ] (fun s -> files := s :: !files) "crop files";
  let files = List.rev !files in
  List.iter (fun file -> 
    try
      let format,_ = Image.file_format file in
      try
	let img = index8 (OImage.load file []) in
    	let ext = get_extension file in
	let body = String.sub file 0 (String.length file - String.length ext - 1) in 
    	let outfile = body ^ ".crop." ^ ext in

	let w, h, x1, y1 = 
	  match !conf with
	  | None ->
	      let hline_check y col =
	      	try
	    	  for x = 0 to img#width - 1 do
(* prerr_endline (Printf.sprintf "%d,%d" x y); *)
		    if img#get x y <> col then raise Exit
	    	  done;
	    	  true
	      	with
	    	  Exit -> false
	      	| _ -> false 
	      in
	      let vline_check x col =
	      	try
	    	  for y = 0 to img#height - 1 do
(* prerr_endline (Printf.sprintf "%d,%d" x y); *)
		    if img#get x y <> col then raise Exit
	    	  done;
	    	  true
	      	with
	    	  Exit -> false
	      	| _ -> false
	      in
	      let x1 =
	      	let x = ref 0 in
	      	let col = img#get 0 0 in
	      	while vline_check !x col do
	    	  incr x
	      	done;
	      	!x
	      in
	      let x2 =
	      	let x = ref (img#width - 1) in
	      	let col = img#get !x 0 in
	      	while vline_check !x col do
	    	  decr x
	      	done;
	      	!x
	      in
	      let y1 =
	      	let y = ref 0 in
	      	let col = img#get 0 0 in
	      	while hline_check !y col do
	    	  incr y
	      	done;
	      	!y
	      in
	      let y2 =
	      	let y = ref (img#height - 1) in
	      	let col = img#get 0 !y in
	      	while hline_check !y col do
	    	  decr y
	      	done;
	      	!y
	      in
	      let w = x2 - x1 + 1
	      and h = y2 - y1 + 1
	      in
	      w, h, x1, y1
	  | Some (w,h,x1,y1) ->
	      w, h, x1, y1
	in
	prerr_string (Printf.sprintf "%s:\t%dx%d+%d+%d " file w h x1 y1); 
	if w <> img#width || h <> img#height then begin
	  let img' = new index8_with w h img#colormap img#transparent 
	      (String.create (w * h))
	  in
	  for x = x1 to x1 + w - 1 do
	    for y = y1 to y1 + h - 1 do
	      img'#set (x - x1) (y - y1) (img#get x y)
	    done
	  done;
	  prerr_endline "\tsaving...";
    	  img'#save outfile None []
	end else begin
	  (* no need to create the file *)
	  if !force_write then begin
	    prerr_endline "\tsaving...";
    	    img#save outfile None []
	  end else begin
	    prerr_endline "\tno need to save";
	  end
	end
      with
      | Wrong_image_class -> 
	  prerr_endline (Printf.sprintf "%s not supported" file)
    with _ -> ()) files


  
