// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// WARNING! This file is copied from third_party/skia/tools/skpdiff and slightly
// modified to be compilable outside Skia and suit chromium style. Some comments
// can make no sense.

// To regenerate SkPMetricUtil_generated.h, simply run
// ./generate_pmetric_tables.py
// TODO(elizavetai): remove this file and reuse the original one in Skia
#ifndef CHROME_BROWSER_CHROMEOS_LOGIN_SCREENSHOT_TESTING_SKPMETRICUTIL_GEN_H_
#define CHROME_BROWSER_CHROMEOS_LOGIN_SCREENSHOT_TESTING_SKPMETRICUTIL_GEN_H_
namespace SkPMetricUtil {
static float gCubeRootTable[] = {
    0.0000000000f, 0.0992125657f, 0.1250000000f, 0.1430892803f, 0.1574901312f,
    0.1696511010f, 0.1802811963f, 0.1897868107f, 0.1984251315f, 0.2063704531f,
    0.2137469933f, 0.2206467710f, 0.2271400741f, 0.2332819473f, 0.2391163978f,
    0.2446792276f, 0.2500000000f, 0.2551034439f, 0.2600104779f, 0.2647389740f,
    0.2693043363f, 0.2737199462f, 0.2779975113f, 0.2821473397f, 0.2861785606f,
    0.2900993021f, 0.2939168360f, 0.2976376972f, 0.3012677830f, 0.3048124351f,
    0.3082765093f, 0.3116644345f, 0.3149802625f, 0.3182277106f, 0.3214101988f,
    0.3245308814f, 0.3275926743f, 0.3305982795f, 0.3335502061f, 0.3364507883f,
    0.3393022021f, 0.3421064797f, 0.3448655220f, 0.3475811104f, 0.3502549163f,
    0.3528885108f, 0.3554833725f, 0.3580408947f, 0.3605623926f, 0.3630491083f,
    0.3655022173f, 0.3679228323f, 0.3703120086f, 0.3726707474f, 0.3750000000f,
    0.3773006710f, 0.3795736215f, 0.3818196715f, 0.3840396032f, 0.3862341629f,
    0.3884040632f, 0.3905499856f, 0.3926725815f, 0.3947724749f, 0.3968502630f,
    0.3989065187f, 0.4009417912f, 0.4029566080f, 0.4049514752f, 0.4069268795f,
    0.4088832888f, 0.4108211532f, 0.4127409061f, 0.4146429648f, 0.4165277315f,
    0.4183955938f, 0.4202469258f, 0.4220820885f, 0.4239014304f, 0.4257052880f,
    0.4274939867f, 0.4292678410f, 0.4310271550f, 0.4327722233f, 0.4345033306f,
    0.4362207529f, 0.4379247575f, 0.4396156035f, 0.4412935419f, 0.4429588163f,
    0.4446116631f, 0.4462523114f, 0.4478809839f, 0.4494978968f, 0.4511032600f,
    0.4526972777f, 0.4542801482f, 0.4558520644f, 0.4574132138f, 0.4589637789f,
    0.4605039373f, 0.4620338620f, 0.4635537212f, 0.4650636788f, 0.4665638946f,
    0.4680545242f, 0.4695357193f, 0.4710076277f, 0.4724703937f, 0.4739241579f,
    0.4753690576f, 0.4768052266f, 0.4782327957f, 0.4796518924f, 0.4810626414f,
    0.4824651643f, 0.4838595801f, 0.4852460048f, 0.4866245520f, 0.4879953326f,
    0.4893584551f, 0.4907140257f, 0.4920621479f, 0.4934029233f, 0.4947364512f,
    0.4960628287f, 0.4973821510f, 0.4986945110f, 0.5000000000f, 0.5012987071f,
    0.5025907198f, 0.5038761237f, 0.5051550026f, 0.5064274387f, 0.5076935126f,
    0.5089533031f, 0.5102068877f, 0.5114543423f, 0.5126957412f, 0.5139311574f,
    0.5151606625f, 0.5163843266f, 0.5176022187f, 0.5188144063f, 0.5200209558f,
    0.5212219322f, 0.5224173995f, 0.5236074205f, 0.5247920567f, 0.5259713687f,
    0.5271454158f, 0.5283142565f, 0.5294779480f, 0.5306365468f, 0.5317901081f,
    0.5329386865f, 0.5340823352f, 0.5352211070f, 0.5363550534f, 0.5374842252f,
    0.5386086725f, 0.5397284443f, 0.5408435889f, 0.5419541538f, 0.5430601857f,
    0.5441617307f, 0.5452588339f, 0.5463515399f, 0.5474398925f, 0.5485239347f,
    0.5496037090f, 0.5506792572f, 0.5517506203f, 0.5528178389f, 0.5538809527f,
    0.5549400011f, 0.5559950226f, 0.5570460554f, 0.5580931369f, 0.5591363041f,
    0.5601755933f, 0.5612110404f, 0.5622426807f, 0.5632705489f, 0.5642946794f,
    0.5653151060f, 0.5663318620f, 0.5673449802f, 0.5683544930f, 0.5693604322f,
    0.5703628294f, 0.5713617156f, 0.5723571213f, 0.5733490767f, 0.5743376115f,
    0.5753227552f, 0.5763045365f, 0.5772829841f, 0.5782581261f, 0.5792299904f,
    0.5801986042f, 0.5811639947f, 0.5821261885f, 0.5830852119f, 0.5840410910f,
    0.5849938514f, 0.5859435185f, 0.5868901171f, 0.5878336719f, 0.5887742074f,
    0.5897117475f, 0.5906463161f, 0.5915779364f, 0.5925066317f, 0.5934324248f,
    0.5943553383f, 0.5952753945f, 0.5961926153f, 0.5971070226f, 0.5980186378f,
    0.5989274821f, 0.5998335765f, 0.6007369417f, 0.6016375981f, 0.6025355660f,
    0.6034308654f, 0.6043235159f, 0.6052135371f, 0.6061009482f, 0.6069857684f,
    0.6078680164f, 0.6087477108f, 0.6096248701f, 0.6104995125f, 0.6113716558f,
    0.6122413179f, 0.6131085164f, 0.6139732687f, 0.6148355918f, 0.6156955028f,
    0.6165530186f, 0.6174081556f, 0.6182609304f, 0.6191113592f, 0.6199594580f,
    0.6208052427f, 0.6216487292f, 0.6224899328f, 0.6233288690f, 0.6241655531f,
    0.6250000000f, 0.6258322247f, 0.6266622419f, 0.6274900661f, 0.6283157119f,
    0.6291391935f, 0.6299605249f, 0.6307797203f, 0.6315967934f, 0.6324117579f,
    0.6332246274f, 0.6340354152f, 0.6348441348f, 0.6356507991f, 0.6364554212f,
    0.6372580140f, 0.6380585903f, 0.6388571625f, 0.6396537434f, 0.6404483451f,
    0.6412409800f, 0.6420316602f, 0.6428203977f, 0.6436072043f, 0.6443920919f,
    0.6451750722f, 0.6459561565f, 0.6467353565f, 0.6475126834f, 0.6482881485f,
    0.6490617627f, 0.6498335373f, 0.6506034829f, 0.6513716105f, 0.6521379308f,
    0.6529024543f, 0.6536651915f, 0.6544261528f, 0.6551853486f, 0.6559427889f,
    0.6566984841f, 0.6574524439f, 0.6582046785f, 0.6589551976f, 0.6597040110f,
    0.6604511283f, 0.6611965591f, 0.6619403129f, 0.6626823990f, 0.6634228269f,
    0.6641616057f, 0.6648987446f, 0.6656342527f, 0.6663681389f, 0.6671004122f,
    0.6678310813f, 0.6685601552f, 0.6692876423f, 0.6700135514f, 0.6707378909f,
    0.6714606694f, 0.6721818951f, 0.6729015765f, 0.6736197217f, 0.6743363390f,
    0.6750514364f, 0.6757650220f, 0.6764771037f, 0.6771876894f, 0.6778967869f,
    0.6786044041f, 0.6793105487f, 0.6800152282f, 0.6807184502f, 0.6814202223f,
    0.6821205519f, 0.6828194464f, 0.6835169131f, 0.6842129593f, 0.6849075923f,
    0.6856008191f, 0.6862926468f, 0.6869830825f, 0.6876721332f, 0.6883598058f,
    0.6890461072f, 0.6897310441f, 0.6904146234f, 0.6910968517f, 0.6917777357f,
    0.6924572821f, 0.6931354973f, 0.6938123879f, 0.6944879602f, 0.6951622208f,
    0.6958351760f, 0.6965068319f, 0.6971771950f, 0.6978462715f, 0.6985140673f,
    0.6991805888f, 0.6998458419f, 0.7005098327f, 0.7011725671f, 0.7018340510f,
    0.7024942904f, 0.7031532910f, 0.7038110588f, 0.7044675993f, 0.7051229184f,
    0.7057770217f, 0.7064299147f, 0.7070816032f, 0.7077320927f, 0.7083813885f,
    0.7090294963f, 0.7096764214f, 0.7103221691f, 0.7109667450f, 0.7116101541f,
    0.7122524019f, 0.7128934935f, 0.7135334342f, 0.7141722290f, 0.7148098831f,
    0.7154464016f, 0.7160817895f, 0.7167160518f, 0.7173491935f, 0.7179812196f,
    0.7186121349f, 0.7192419442f, 0.7198706526f, 0.7204982646f, 0.7211247852f,
    0.7217502189f, 0.7223745706f, 0.7229978450f, 0.7236200465f, 0.7242411799f,
    0.7248612497f, 0.7254802605f, 0.7260982167f, 0.7267151229f, 0.7273309834f,
    0.7279458028f, 0.7285595854f, 0.7291723356f, 0.7297840576f, 0.7303947558f,
    0.7310044346f, 0.7316130980f, 0.7322207503f, 0.7328273958f, 0.7334330386f,
    0.7340376827f, 0.7346413324f, 0.7352439917f, 0.7358456646f, 0.7364463552f,
    0.7370460675f, 0.7376448054f, 0.7382425730f, 0.7388393740f, 0.7394352125f,
    0.7400300922f, 0.7406240171f, 0.7412169909f, 0.7418090175f, 0.7424001007f,
    0.7429902441f, 0.7435794515f, 0.7441677266f, 0.7447550732f, 0.7453414947f,
    0.7459269950f, 0.7465115775f, 0.7470952459f, 0.7476780037f, 0.7482598545f,
    0.7488408019f, 0.7494208492f, 0.7500000000f, 0.7505782577f, 0.7511556259f,
    0.7517321078f, 0.7523077069f, 0.7528824265f, 0.7534562700f, 0.7540292408f,
    0.7546013421f, 0.7551725772f, 0.7557429495f, 0.7563124621f, 0.7568811183f,
    0.7574489213f, 0.7580158743f, 0.7585819805f, 0.7591472430f, 0.7597116649f,
    0.7602752494f, 0.7608379997f, 0.7613999186f, 0.7619610094f, 0.7625212750f,
    0.7630807186f, 0.7636393430f, 0.7641971514f, 0.7647541466f, 0.7653103316f,
    0.7658657094f, 0.7664202829f, 0.7669740550f, 0.7675270285f, 0.7680792064f,
    0.7686305915f, 0.7691811867f, 0.7697309947f, 0.7702800185f, 0.7708282607f,
    0.7713757241f, 0.7719224115f, 0.7724683257f, 0.7730134694f, 0.7735578453f,
    0.7741014560f, 0.7746443043f, 0.7751863929f, 0.7757277244f, 0.7762683013f,
    0.7768081265f, 0.7773472024f, 0.7778855317f, 0.7784231168f, 0.7789599605f,
    0.7794960653f, 0.7800314336f, 0.7805660681f, 0.7810999712f, 0.7816331454f,
    0.7821655932f, 0.7826973171f, 0.7832283195f, 0.7837586029f, 0.7842881697f,
    0.7848170223f, 0.7853451631f, 0.7858725945f, 0.7863993189f, 0.7869253387f,
    0.7874506562f, 0.7879752737f, 0.7884991936f, 0.7890224182f, 0.7895449497f,
    0.7900667905f, 0.7905879429f, 0.7911084091f, 0.7916281914f, 0.7921472920f,
    0.7926657132f, 0.7931834571f, 0.7937005260f, 0.7942169220f, 0.7947326475f,
    0.7952477044f, 0.7957620951f, 0.7962758215f, 0.7967888860f, 0.7973012906f,
    0.7978130374f, 0.7983241285f, 0.7988345660f, 0.7993443521f, 0.7998534888f,
    0.8003619781f, 0.8008698221f, 0.8013770229f, 0.8018835825f, 0.8023895029f,
    0.8028947861f, 0.8033994341f, 0.8039034489f, 0.8044068326f, 0.8049095870f,
    0.8054117141f, 0.8059132159f, 0.8064140944f, 0.8069143514f, 0.8074139889f,
    0.8079130088f, 0.8084114130f, 0.8089092034f, 0.8094063819f, 0.8099029503f,
    0.8103989106f, 0.8108942646f, 0.8113890141f, 0.8118831610f, 0.8123767071f,
    0.8128696543f, 0.8133620043f, 0.8138537589f, 0.8143449200f, 0.8148354894f,
    0.8153254688f, 0.8158148599f, 0.8163036646f, 0.8167918846f, 0.8172795217f,
    0.8177665775f, 0.8182530539f, 0.8187389525f, 0.8192242751f, 0.8197090233f,
    0.8201931988f, 0.8206768034f, 0.8211598387f, 0.8216423064f, 0.8221242082f,
    0.8226055457f, 0.8230863205f, 0.8235665343f, 0.8240461888f, 0.8245252855f,
    0.8250038261f, 0.8254818122f, 0.8259592454f, 0.8264361273f, 0.8269124595f,
    0.8273882435f, 0.8278634810f, 0.8283381734f, 0.8288123225f, 0.8292859296f,
    0.8297589964f, 0.8302315244f, 0.8307035152f, 0.8311749701f, 0.8316458909f,
    0.8321162790f, 0.8325861358f, 0.8330554629f, 0.8335242618f, 0.8339925340f,
    0.8344602809f, 0.8349275040f, 0.8353942047f, 0.8358603846f, 0.8363260451f,
    0.8367911876f, 0.8372558136f, 0.8377199244f, 0.8381835216f, 0.8386466065f,
    0.8391091806f, 0.8395712452f, 0.8400328018f, 0.8404938517f, 0.8409543964f,
    0.8414144372f, 0.8418739754f, 0.8423330126f, 0.8427915500f, 0.8432495890f,
    0.8437071309f, 0.8441641771f, 0.8446207289f, 0.8450767877f, 0.8455323548f,
    0.8459874315f, 0.8464420192f, 0.8468961190f, 0.8473497325f, 0.8478028608f,
    0.8482555052f, 0.8487076671f, 0.8491593476f, 0.8496105482f, 0.8500612701f,
    0.8505115145f, 0.8509612827f, 0.8514105760f, 0.8518593955f, 0.8523077427f,
    0.8527556186f, 0.8532030246f, 0.8536499618f, 0.8540964315f, 0.8545424350f,
    0.8549879733f, 0.8554330478f, 0.8558776597f, 0.8563218101f, 0.8567655002f,
    0.8572087313f, 0.8576515045f, 0.8580938210f, 0.8585356819f, 0.8589770885f,
    0.8594180419f, 0.8598585433f, 0.8602985938f, 0.8607381946f, 0.8611773468f,
    0.8616160516f, 0.8620543101f, 0.8624921234f, 0.8629294927f, 0.8633664191f,
    0.8638029038f, 0.8642389477f, 0.8646745521f, 0.8651097180f, 0.8655444466f,
    0.8659787389f, 0.8664125961f, 0.8668460191f, 0.8672790092f, 0.8677115674f,
    0.8681436948f, 0.8685753923f, 0.8690066612f, 0.8694375025f, 0.8698679171f,
    0.8702979063f, 0.8707274710f, 0.8711566122f, 0.8715853311f, 0.8720136286f,
    0.8724415059f, 0.8728689638f, 0.8732960035f, 0.8737226259f, 0.8741488321f,
    0.8745746232f, 0.8750000000f, 0.8754249636f, 0.8758495151f, 0.8762736554f,
    0.8766973854f, 0.8771207063f, 0.8775436190f, 0.8779661244f, 0.8783882235f,
    0.8788099174f, 0.8792312070f, 0.8796520932f, 0.8800725771f, 0.8804926595f,
    0.8809123415f, 0.8813316240f, 0.8817505079f, 0.8821689942f, 0.8825870838f,
    0.8830047777f, 0.8834220768f, 0.8838389821f, 0.8842554944f, 0.8846716147f,
    0.8850873439f, 0.8855026829f, 0.8859176327f, 0.8863321941f, 0.8867463681f,
    0.8871601555f, 0.8875735573f, 0.8879865744f, 0.8883992076f, 0.8888114579f,
    0.8892233261f, 0.8896348131f, 0.8900459199f, 0.8904566472f, 0.8908669959f,
    0.8912769670f, 0.8916865612f, 0.8920957795f, 0.8925046227f, 0.8929130917f,
    0.8933211874f, 0.8937289105f, 0.8941362619f, 0.8945432425f, 0.8949498531f,
    0.8953560946f, 0.8957619678f, 0.8961674735f, 0.8965726125f, 0.8969773858f,
    0.8973817940f, 0.8977858381f, 0.8981895188f, 0.8985928370f, 0.8989957935f,
    0.8993983891f, 0.8998006246f, 0.9002025007f, 0.9006040184f, 0.9010051784f,
    0.9014059814f, 0.9018064284f, 0.9022065200f, 0.9026062571f, 0.9030056405f,
    0.9034046709f, 0.9038033491f, 0.9042016758f, 0.9045996520f, 0.9049972783f,
    0.9053945554f, 0.9057914843f, 0.9061880655f, 0.9065843000f, 0.9069801884f,
    0.9073757315f, 0.9077709300f, 0.9081657847f, 0.9085602964f, 0.9089544658f,
    0.9093482936f, 0.9097417806f, 0.9101349275f, 0.9105277350f, 0.9109202039f,
    0.9113123349f, 0.9117041287f, 0.9120955861f, 0.9124867078f, 0.9128774944f,
    0.9132679468f, 0.9136580655f, 0.9140478514f, 0.9144373052f, 0.9148264275f,
    0.9152152191f, 0.9156036806f, 0.9159918127f, 0.9163796163f, 0.9167670918f,
    0.9171542402f, 0.9175410619f, 0.9179275578f, 0.9183137284f, 0.9186995746f,
    0.9190850969f, 0.9194702961f, 0.9198551727f, 0.9202397276f, 0.9206239614f,
    0.9210078747f, 0.9213914682f, 0.9217747425f, 0.9221576984f, 0.9225403365f,
    0.9229226575f, 0.9233046619f, 0.9236863505f, 0.9240677240f, 0.9244487829f,
    0.9248295279f, 0.9252099596f, 0.9255900788f, 0.9259698860f, 0.9263493819f,
    0.9267285671f, 0.9271074423f, 0.9274860081f, 0.9278642651f, 0.9282422139f,
    0.9286198552f, 0.9289971896f, 0.9293742177f, 0.9297509402f, 0.9301273576f,
    0.9305034706f, 0.9308792798f, 0.9312547858f, 0.9316299892f, 0.9320048907f,
    0.9323794907f, 0.9327537901f, 0.9331277892f, 0.9335014888f, 0.9338748894f,
    0.9342479917f, 0.9346207962f, 0.9349933035f, 0.9353655143f, 0.9357374291f,
    0.9361090484f, 0.9364803729f, 0.9368514032f, 0.9372221399f, 0.9375925834f,
    0.9379627345f, 0.9383325937f, 0.9387021615f, 0.9390714386f, 0.9394404254f,
    0.9398091226f, 0.9401775308f, 0.9405456505f, 0.9409134822f, 0.9412810266f,
    0.9416482841f, 0.9420152554f, 0.9423819410f, 0.9427483415f, 0.9431144574f,
    0.9434802893f, 0.9438458377f, 0.9442111031f, 0.9445760862f, 0.9449407874f,
    0.9453052074f, 0.9456693465f, 0.9460332055f, 0.9463967848f, 0.9467600849f,
    0.9471231065f, 0.9474858499f, 0.9478483159f, 0.9482105048f, 0.9485724172f,
    0.9489340537f, 0.9492954148f, 0.9496565009f, 0.9500173127f, 0.9503778506f,
    0.9507381152f, 0.9510981069f, 0.9514578264f, 0.9518172740f, 0.9521764504f,
    0.9525353560f, 0.9528939913f, 0.9532523569f, 0.9536104532f, 0.9539682808f,
    0.9543258402f, 0.9546831318f, 0.9550401562f, 0.9553969139f, 0.9557534053f,
    0.9561096310f, 0.9564655914f, 0.9568212871f, 0.9571767185f, 0.9575318861f,
    0.9578867905f, 0.9582414321f, 0.9585958113f, 0.9589499288f, 0.9593037849f,
    0.9596573801f, 0.9600107149f, 0.9603637899f, 0.9607166054f, 0.9610691620f,
    0.9614214601f, 0.9617735002f, 0.9621252828f, 0.9624768083f, 0.9628280773f,
    0.9631790901f, 0.9635298473f, 0.9638803492f, 0.9642305965f, 0.9645805895f,
    0.9649303287f, 0.9652798145f, 0.9656290475f, 0.9659780280f, 0.9663267566f,
    0.9666752336f, 0.9670234596f, 0.9673714350f, 0.9677191602f, 0.9680666356f,
    0.9684138619f, 0.9687608393f, 0.9691075683f, 0.9694540494f, 0.9698002830f,
    0.9701462696f, 0.9704920096f, 0.9708375034f, 0.9711827515f, 0.9715277542f,
    0.9718725122f, 0.9722170257f, 0.9725612952f, 0.9729053211f, 0.9732491040f,
    0.9735926441f, 0.9739359420f, 0.9742789980f, 0.9746218126f, 0.9749643862f,
    0.9753067192f, 0.9756488121f, 0.9759906652f, 0.9763322791f, 0.9766736540f,
    0.9770147905f, 0.9773556889f, 0.9776963497f, 0.9780367732f, 0.9783769600f,
    0.9787169103f, 0.9790566246f, 0.9793961034f, 0.9797353469f, 0.9800743557f,
    0.9804131302f, 0.9807516706f, 0.9810899776f, 0.9814280513f, 0.9817658923f,
    0.9821035010f, 0.9824408777f, 0.9827780228f, 0.9831149368f, 0.9834516200f,
    0.9837880729f, 0.9841242958f, 0.9844602891f, 0.9847960532f, 0.9851315885f,
    0.9854668954f, 0.9858019743f, 0.9861368255f, 0.9864714495f, 0.9868058466f,
    0.9871400173f, 0.9874739618f, 0.9878076807f, 0.9881411742f, 0.9884744427f,
    0.9888074867f, 0.9891403065f, 0.9894729024f, 0.9898052749f, 0.9901374244f,
    0.9904693511f, 0.9908010556f, 0.9911325380f, 0.9914637989f, 0.9917948386f,
    0.9921256575f, 0.9924562559f, 0.9927866341f, 0.9931167927f, 0.9934467318f,
    0.9937764520f, 0.9941059535f, 0.9944352367f, 0.9947643020f, 0.9950931497f,
    0.9954217802f, 0.9957501939f, 0.9960783911f, 0.9964063721f, 0.9967341374f,
    0.9970616873f, 0.9973890221f, 0.9977161421f, 0.9980430478f, 0.9983697395f,
    0.9986962176f, 0.9990224823f, 0.9993485340f, 0.9996743731f,
};
static float get_cube_root(float value) {
  DCHECK(value >= 0.0f);
  DCHECK(value * 1023.0f < 1024.0f);
  return gCubeRootTable[(int)(value * 1023.0f)];
}

static float gGammaTable[] = {
    0.0000000000f, 0.0000050771f, 0.0000233280f, 0.0000569218f, 0.0001071874f,
    0.0001751240f, 0.0002615438f, 0.0003671363f, 0.0004925038f, 0.0006381828f,
    0.0008046585f, 0.0009923743f, 0.0012017395f, 0.0014331346f, 0.0016869153f,
    0.0019634162f, 0.0022629532f, 0.0025858256f, 0.0029323183f, 0.0033027030f,
    0.0036972396f, 0.0041161771f, 0.0045597549f, 0.0050282035f, 0.0055217449f,
    0.0060405937f, 0.0065849574f, 0.0071550370f, 0.0077510274f, 0.0083731177f,
    0.0090214919f, 0.0096963287f, 0.0103978023f, 0.0111260824f, 0.0118813344f,
    0.0126637200f, 0.0134733969f, 0.0143105194f, 0.0151752382f, 0.0160677009f,
    0.0169880521f, 0.0179364333f, 0.0189129834f, 0.0199178384f, 0.0209511319f,
    0.0220129949f, 0.0231035562f, 0.0242229421f, 0.0253712769f, 0.0265486828f,
    0.0277552800f, 0.0289911865f, 0.0302565189f, 0.0315513914f, 0.0328759169f,
    0.0342302066f, 0.0356143697f, 0.0370285142f, 0.0384727463f, 0.0399471710f,
    0.0414518916f, 0.0429870102f, 0.0445526273f, 0.0461488424f, 0.0477757536f,
    0.0494334576f, 0.0511220501f, 0.0528416255f, 0.0545922773f, 0.0563740976f,
    0.0581871775f, 0.0600316071f, 0.0619074756f, 0.0638148709f, 0.0657538803f,
    0.0677245897f, 0.0697270844f, 0.0717614488f, 0.0738277663f, 0.0759261195f,
    0.0780565900f, 0.0802192587f, 0.0824142059f, 0.0846415107f, 0.0869012518f,
    0.0891935069f, 0.0915183530f, 0.0938758665f, 0.0962661231f, 0.0986891975f,
    0.1011451642f, 0.1036340967f, 0.1061560678f, 0.1087111500f, 0.1112994148f,
    0.1139209334f, 0.1165757762f, 0.1192640130f, 0.1219857132f, 0.1247409454f,
    0.1275297778f, 0.1303522781f, 0.1332085132f, 0.1360985497f, 0.1390224537f,
    0.1419802907f, 0.1449721256f, 0.1479980230f, 0.1510580469f, 0.1541522608f,
    0.1572807279f, 0.1604435107f, 0.1636406715f, 0.1668722719f, 0.1701383732f,
    0.1734390363f, 0.1767743216f, 0.1801442892f, 0.1835489985f, 0.1869885088f,
    0.1904628788f, 0.1939721670f, 0.1975164314f, 0.2010957296f, 0.2047101188f,
    0.2083596560f, 0.2120443975f, 0.2157643996f, 0.2195197181f, 0.2233104083f,
    0.2271365255f, 0.2309981243f, 0.2348952592f, 0.2388279843f, 0.2427963533f,
    0.2468004196f, 0.2508402364f, 0.2549158566f, 0.2590273325f, 0.2631747164f,
    0.2673580602f, 0.2715774154f, 0.2758328335f, 0.2801243653f, 0.2844520616f,
    0.2888159728f, 0.2932161491f, 0.2976526404f, 0.3021254964f, 0.3066347662f,
    0.3111804991f, 0.3157627437f, 0.3203815488f, 0.3250369625f, 0.3297290330f,
    0.3344578079f, 0.3392233349f, 0.3440256613f, 0.3488648341f, 0.3537409001f,
    0.3586539059f, 0.3636038979f, 0.3685909222f, 0.3736150246f, 0.3786762509f,
    0.3837746465f, 0.3889102565f, 0.3940831261f, 0.3992932999f, 0.4045408226f,
    0.4098257384f, 0.4151480917f, 0.4205079262f, 0.4259052857f, 0.4313402138f,
    0.4368127538f, 0.4423229488f, 0.4478708418f, 0.4534564755f, 0.4590798924f,
    0.4647411350f, 0.4704402453f, 0.4761772654f, 0.4819522371f, 0.4877652019f,
    0.4936162013f, 0.4995052766f, 0.5054324688f, 0.5113978189f, 0.5174013675f,
    0.5234431552f, 0.5295232224f, 0.5356416093f, 0.5417983560f, 0.5479935022f,
    0.5542270878f, 0.5604991522f, 0.5668097349f, 0.5731588751f, 0.5795466118f,
    0.5859729839f, 0.5924380303f, 0.5989417895f, 0.6054842999f, 0.6120655999f,
    0.6186857275f, 0.6253447208f, 0.6320426176f, 0.6387794557f, 0.6455552724f,
    0.6523701054f, 0.6592239918f, 0.6661169688f, 0.6730490733f, 0.6800203422f,
    0.6870308122f, 0.6940805198f, 0.7011695015f, 0.7082977937f, 0.7154654323f,
    0.7226724536f, 0.7299188934f, 0.7372047874f, 0.7445301713f, 0.7518950806f,
    0.7592995507f, 0.7667436169f, 0.7742273142f, 0.7817506778f, 0.7893137424f,
    0.7969165429f, 0.8045591139f, 0.8122414899f, 0.8199637053f, 0.8277257945f,
    0.8355277915f, 0.8433697304f, 0.8512516452f, 0.8591735697f, 0.8671355375f,
    0.8751375824f, 0.8831797377f, 0.8912620368f, 0.8993845130f, 0.9075471995f,
    0.9157501293f, 0.9239933353f, 0.9322768503f, 0.9406007070f, 0.9489649382f,
    0.9573695762f, 0.9658146535f, 0.9743002024f, 0.9828262551f, 0.9913928436f,
    1.0000000000f,
};
static float get_gamma(unsigned char value) {
  return gGammaTable[value];
}

static float gTVITable[] = {
    0.0013803843f, 0.0054723435f, 0.0090762146f, 0.0127002285f, 0.0161086814f,
    0.0201358517f, 0.0241630221f, 0.0281901924f, 0.0322173627f, 0.0362445331f,
    0.0402717034f, 0.0442988738f, 0.0483260441f, 0.0523532145f, 0.0563803848f,
    0.0604075551f, 0.0644347255f, 0.0684618958f, 0.0724890662f, 0.0765162365f,
    0.0805434069f, 0.0845705772f, 0.0885977476f, 0.0926249179f, 0.0966520882f,
    0.1006792586f, 0.1047064289f, 0.1087335993f, 0.1127607696f, 0.1167879400f,
    0.1208151103f, 0.1248422806f, 0.1288694510f, 0.1328966213f, 0.1369237917f,
    0.1409509620f, 0.1449781324f, 0.1490053027f, 0.1530324730f, 0.1570596434f,
    0.1610868137f, 0.1651139841f, 0.1691411544f, 0.1731683248f, 0.1771954951f,
    0.1812226654f, 0.1852498358f, 0.1892770061f, 0.1933041765f, 0.1973313468f,
    0.2013585172f, 0.2053856875f, 0.2094128578f, 0.2134400282f, 0.2174671985f,
    0.2214943689f, 0.2255215392f, 0.2295487096f, 0.2335758799f, 0.2376030503f,
    0.2416302206f, 0.2456573909f, 0.2496845613f, 0.2537117316f, 0.2577389020f,
    0.2617660723f, 0.2657932427f, 0.2698204130f, 0.2738475833f, 0.2778747537f,
    0.2819019240f, 0.2859290944f, 0.2899562647f, 0.2939834351f, 0.2980106054f,
    0.3020377757f, 0.3060649461f, 0.3100921164f, 0.3141192868f, 0.3181464571f,
    0.3221736275f, 0.3262007978f, 0.3302279681f, 0.3342551385f, 0.3382823088f,
    0.3423094792f, 0.3463366495f, 0.3503638199f, 0.3543909902f, 0.3584181605f,
    0.3624453309f, 0.3664725012f, 0.3704996716f, 0.3745268419f, 0.3785540123f,
    0.3825811826f, 0.3862015808f, 0.3874843130f, 0.3887618285f, 0.3900342072f,
    0.3913015271f, 0.3925638643f, 0.3938212928f, 0.3950738850f, 0.3963217116f,
    0.3975648414f, 0.3988033417f, 0.4000372783f, 0.4012667154f, 0.4024917157f,
    0.4037123404f, 0.4049286496f, 0.4061407017f, 0.4073485541f, 0.4085522627f,
    0.4097518824f, 0.4109474667f, 0.4121390682f, 0.4133267382f, 0.4145105269f,
    0.4156904836f, 0.4168666565f, 0.4180390927f, 0.4192078385f, 0.4203729393f,
    0.4215344394f, 0.4226923823f, 0.4238468107f, 0.4249977665f, 0.4261452906f,
    0.4272894232f, 0.4284302038f, 0.4295676711f, 0.4307018630f, 0.4318328169f,
    0.4329605692f, 0.4340851559f, 0.4352066122f, 0.4363249726f, 0.4374402712f,
    0.4385525412f, 0.4396618156f, 0.4407681264f, 0.4418715052f, 0.4429719831f,
    0.4440695907f, 0.4451643580f, 0.4462563143f, 0.4473454889f, 0.4484319100f,
    0.4495156058f, 0.4505966038f, 0.4516749311f, 0.4527506143f, 0.4538236798f,
    0.4548941532f, 0.4559620600f, 0.4570274252f, 0.4580902732f, 0.4591506283f,
    0.4602085144f, 0.4612639548f, 0.4623169726f, 0.4633675905f, 0.4644158309f,
    0.4654617159f, 0.4665052671f, 0.4675465059f, 0.4685854533f, 0.4696221301f,
    0.4706565566f, 0.4716887532f, 0.4727187394f, 0.4737465350f, 0.4747721591f,
    0.4757956308f, 0.4768169688f, 0.4778361914f, 0.4788533170f, 0.4798683633f,
    0.4808813482f, 0.4818922891f, 0.4829012030f, 0.4839081071f, 0.4849130180f,
    0.4859159522f, 0.4869169260f, 0.4879159554f, 0.4889130563f, 0.4899082444f,
    0.4909015350f, 0.4918929433f, 0.4928824844f, 0.4938701732f, 0.4948560241f,
    0.4958400518f, 0.4968222703f, 0.4978026939f, 0.4987813364f, 0.4997582115f,
    0.5007333328f, 0.5017067136f, 0.5026783672f, 0.5036483066f, 0.5046165447f,
    0.5055830942f, 0.5065479677f, 0.5075111777f, 0.5084727363f, 0.5094326557f,
    0.5103909478f, 0.5113476246f, 0.5123026977f, 0.5132561786f, 0.5142080788f,
    0.5151584096f, 0.5161071821f, 0.5170544073f, 0.5180000961f, 0.5189442593f,
    0.5198869076f, 0.5208280514f, 0.5217677012f, 0.5227058673f, 0.5236425598f,
    0.5245777888f, 0.5255115642f, 0.5264438959f, 0.5273747936f, 0.5283042669f,
    0.5292323254f, 0.5301589784f, 0.5310842352f, 0.5320081051f, 0.5329305972f,
    0.5338517205f, 0.5347714839f, 0.5356898962f, 0.5366069661f, 0.5375227023f,
    0.5384371133f, 0.5393502076f, 0.5402619936f, 0.5411724795f, 0.5420816735f,
    0.5429895837f, 0.5438962181f, 0.5448015848f, 0.5457056915f, 0.5466085461f,
    0.5475101562f, 0.5484105295f, 0.5493096736f, 0.5502075958f, 0.5511043036f,
    0.5519998044f, 0.5528941054f, 0.5537872138f, 0.5546791367f, 0.5555698811f,
    0.5564594540f, 0.5573478624f, 0.5582351130f, 0.5591212127f, 0.5600061681f,
    0.5608899860f, 0.5617726729f, 0.5626542353f, 0.5635346797f, 0.5644140125f,
    0.5652922401f, 0.5661693686f, 0.5670454044f, 0.5679203536f, 0.5687942223f,
    0.5696670167f, 0.5705387425f, 0.5714094060f, 0.5722790128f, 0.5731475689f,
    0.5740150800f, 0.5748815519f, 0.5757469902f, 0.5766114006f, 0.5774747887f,
    0.5783371600f, 0.5791985199f, 0.5800588740f, 0.5809182275f, 0.5817765859f,
    0.5826339544f, 0.5834903383f, 0.5843457428f, 0.5852001731f, 0.5860536342f,
    0.5869061312f, 0.5877576691f, 0.5886082530f, 0.5894578877f, 0.5903065783f,
    0.5911543294f, 0.5920011460f, 0.5928470329f, 0.5936919946f, 0.5945360361f,
    0.5953791619f, 0.5962213766f, 0.5970626848f, 0.5979030911f, 0.5987426000f,
    0.5995812159f, 0.6004189433f, 0.6012557866f, 0.6020917502f, 0.6029268383f,
    0.6037610553f, 0.6045944054f, 0.6054268928f, 0.6062585218f, 0.6070892966f,
    0.6079192211f, 0.6087482996f, 0.6095765360f, 0.6104039345f, 0.6112304990f,
    0.6120562334f, 0.6128811418f, 0.6137052280f, 0.6145284960f, 0.6153509494f,
    0.6161725922f, 0.6169934282f, 0.6178134611f, 0.6186326946f, 0.6194511325f,
    0.6202687784f, 0.6210856359f, 0.6219017088f, 0.6227170005f, 0.6235315147f,
    0.6243452548f, 0.6251582244f, 0.6259704271f, 0.6267818661f, 0.6275925450f,
    0.6284024673f, 0.6292116362f, 0.6300200551f, 0.6308277274f, 0.6316346564f,
    0.6324408454f, 0.6332462976f, 0.6340510163f, 0.6348550047f, 0.6356582660f,
    0.6364608033f, 0.6372626199f, 0.6380637188f, 0.6388641032f, 0.6396637761f,
    0.6404627406f, 0.6412609997f, 0.6420585565f, 0.6428554140f, 0.6436515750f,
    0.6444470427f, 0.6452418199f, 0.6460359096f, 0.6468293146f, 0.6476220378f,
    0.6484140821f, 0.6492054503f, 0.6499961452f, 0.6507861697f, 0.6515755264f,
    0.6523642183f, 0.6531522479f, 0.6539396181f, 0.6547263316f, 0.6555123910f,
    0.6562977990f, 0.6570825582f, 0.6578666713f, 0.6586501410f, 0.6594329698f,
    0.6602151602f, 0.6609967149f, 0.6617776365f, 0.6625579273f, 0.6633375901f,
    0.6641166272f, 0.6648950411f, 0.6656728344f, 0.6664500094f, 0.6672265686f,
    0.6680025145f, 0.6687778494f, 0.6695525757f, 0.6703266958f, 0.6711002120f,
    0.6718731268f, 0.6726454424f, 0.6734171611f, 0.6741882853f, 0.6749588172f,
    0.6757287592f, 0.6764981134f, 0.6772668821f, 0.6780350675f, 0.6788026719f,
    0.6795696975f, 0.6803361464f, 0.6811020209f, 0.6818673230f, 0.6826320549f,
    0.6833962189f, 0.6841598169f, 0.6849228512f, 0.6856853237f, 0.6864472367f,
    0.6872085921f, 0.6879693920f, 0.6887296385f, 0.6894893336f, 0.6902484794f,
    0.6910070778f, 0.6917651308f, 0.6925226404f, 0.6932796087f, 0.6940360375f,
    0.6947919289f, 0.6955472847f, 0.6963021069f, 0.6970563974f, 0.6978101581f,
    0.6985633910f, 0.6993160978f, 0.7000682805f, 0.7008199410f, 0.7015710810f,
    0.7023217025f, 0.7030718072f, 0.7038213970f, 0.7045704738f, 0.7053190392f,
    0.7060670951f, 0.7068146432f, 0.7075616854f, 0.7083082234f, 0.7090542590f,
    0.7097997938f, 0.7105448296f, 0.7112893682f, 0.7120334112f, 0.7127769604f,
    0.7135200174f, 0.7142625840f, 0.7150046617f, 0.7157462523f, 0.7164873574f,
    0.7172279787f, 0.7179681178f, 0.7187077763f, 0.7194469559f, 0.7201856581f,
    0.7209238845f, 0.7216616368f, 0.7223989166f, 0.7231357254f, 0.7238720647f,
    0.7246079362f, 0.7253433413f, 0.7260782817f, 0.7268127589f, 0.7275467743f,
    0.7282803296f, 0.7290134261f, 0.7297460655f, 0.7304782492f, 0.7312099786f,
    0.7319412554f, 0.7326720809f, 0.7334024566f, 0.7341323839f, 0.7348618644f,
    0.7355908994f, 0.7363194903f, 0.7370476387f, 0.7377753459f, 0.7385026133f,
    0.7392294424f, 0.7399558344f, 0.7406817909f, 0.7414073132f, 0.7421324026f,
    0.7428570606f, 0.7435812885f, 0.7443050876f, 0.7450284593f, 0.7457514049f,
    0.7464739258f, 0.7471960233f, 0.7479176987f, 0.7486389533f, 0.7493597885f,
    0.7500802055f, 0.7508002056f, 0.7515197900f, 0.7522389602f, 0.7529577174f,
    0.7536760627f, 0.7543939976f, 0.7551115232f, 0.7558286407f, 0.7565453515f,
    0.7572616568f, 0.7579775578f, 0.7586930557f, 0.7594081517f, 0.7601228471f,
    0.7608371430f, 0.7615510407f, 0.7622645414f, 0.7629776462f, 0.7636903563f,
    0.7644026729f, 0.7651145972f, 0.7658261304f, 0.7665372735f, 0.7672480278f,
    0.7679583944f, 0.7686683744f, 0.7693779691f, 0.7700871794f, 0.7707960066f,
    0.7715044518f, 0.7722125160f, 0.7729202005f, 0.7736275063f, 0.7743344344f,
    0.7750409861f, 0.7757471624f, 0.7764529643f, 0.7771583930f, 0.7778634496f,
    0.7785681350f, 0.7792724504f, 0.7799763969f, 0.7806799755f, 0.7813831871f,
    0.7820860330f, 0.7827885141f, 0.7834906315f, 0.7841923862f, 0.7848937792f,
    0.7855948115f, 0.7862954843f, 0.7869957984f, 0.7876957549f, 0.7883953547f,
    0.7890945990f, 0.7897934887f, 0.7904920247f, 0.7911902081f, 0.7918880398f,
    0.7925855209f, 0.7932826523f, 0.7939794349f, 0.7946758698f, 0.7953719578f,
    0.7960677000f, 0.7967630973f, 0.7974581506f, 0.7981528610f, 0.7988472292f,
    0.7995412563f, 0.8002349432f, 0.8009282908f, 0.8016213001f, 0.8023139719f,
    0.8030063072f, 0.8036983069f, 0.8043899718f, 0.8050813030f, 0.8057723013f,
    0.8064629675f, 0.8071533026f, 0.8078433075f, 0.8085329830f, 0.8092223301f,
    0.8099113495f, 0.8106000423f, 0.8112884091f, 0.8119764510f, 0.8126641688f,
    0.8133515632f, 0.8140386353f, 0.8147253858f, 0.8154118155f, 0.8160979254f,
    0.8167837163f, 0.8174691889f, 0.8181543441f, 0.8188391829f, 0.8195237058f,
    0.8202079139f, 0.8208918079f, 0.8215753887f, 0.8222586569f, 0.8229416136f,
    0.8236242594f, 0.8243065951f, 0.8249886216f, 0.8256703397f, 0.8263517501f,
    0.8270328536f, 0.8277136511f, 0.8283941432f, 0.8290743309f, 0.8297542147f,
    0.8304337956f, 0.8311130743f, 0.8317920516f, 0.8324707281f, 0.8331491048f,
    0.8338271823f, 0.8345049614f, 0.8351824428f, 0.8358596273f, 0.8365365157f,
    0.8372131086f, 0.8378894068f, 0.8385654111f, 0.8392411222f, 0.8399165407f,
    0.8405916676f, 0.8412665033f, 0.8419410488f, 0.8426153047f, 0.8432892716f,
    0.8439629504f, 0.8446363418f, 0.8453094464f, 0.8459822649f, 0.8466547981f,
    0.8473270466f, 0.8479990112f, 0.8486706925f, 0.8493420912f, 0.8500132081f,
    0.8506840438f, 0.8513545989f, 0.8520248742f, 0.8526948703f, 0.8533645880f,
    0.8540340278f, 0.8547031905f, 0.8553720767f, 0.8560406871f, 0.8567090223f,
    0.8573770831f, 0.8580448700f, 0.8587123837f, 0.8593796249f, 0.8600465942f,
    0.8607132923f, 0.8613797197f, 0.8620458772f, 0.8627117654f, 0.8633773850f,
    0.8640427364f, 0.8647078205f, 0.8653726378f, 0.8660371889f, 0.8667014745f,
    0.8673654952f, 0.8680292516f, 0.8686927443f, 0.8693559740f, 0.8700189412f,
    0.8706816466f, 0.8713440908f, 0.8720062744f, 0.8726681979f, 0.8733298621f,
    0.8739912674f, 0.8746524145f, 0.8753133040f, 0.8759739365f, 0.8766343125f,
    0.8772944327f, 0.8779542976f, 0.8786139079f, 0.8792732640f, 0.8799323667f,
    0.8805912164f, 0.8812498137f, 0.8819081593f, 0.8825662536f, 0.8832240973f,
    0.8838816909f, 0.8845390350f, 0.8851961302f, 0.8858529770f, 0.8865095759f,
    0.8871659276f, 0.8878220326f, 0.8884778913f, 0.8891335045f, 0.8897888727f,
    0.8904439963f, 0.8910988759f, 0.8917535121f, 0.8924079054f, 0.8930620564f,
    0.8937159656f, 0.8943696335f, 0.8950230607f, 0.8956762476f, 0.8963291949f,
    0.8969819031f, 0.8976343726f, 0.8982866040f, 0.8989385979f, 0.8995903547f,
    0.9002418749f, 0.9008931592f, 0.9015442079f, 0.9021950217f, 0.9028456010f,
    0.9034959463f, 0.9041460582f, 0.9047959371f, 0.9054455836f, 0.9060949981f,
    0.9067441812f, 0.9073931334f, 0.9080418551f, 0.9086903468f, 0.9093386091f,
    0.9099866425f, 0.9106344474f, 0.9112820243f, 0.9119293737f, 0.9125764961f,
    0.9132233920f, 0.9138700618f, 0.9145165061f, 0.9151627253f, 0.9158087199f,
    0.9164544904f, 0.9171000373f, 0.9177453609f, 0.9183904619f, 0.9190353406f,
    0.9196799976f, 0.9203244333f, 0.9209686481f, 0.9216126425f, 0.9222564171f,
    0.9228999722f, 0.9235433083f, 0.9241864259f, 0.9248293254f, 0.9254720073f,
    0.9261144720f, 0.9267567200f, 0.9273987517f, 0.9280405676f, 0.9286821682f,
    0.9293235538f, 0.9299647249f, 0.9306056820f, 0.9312464255f, 0.9318869558f,
    0.9325272734f, 0.9331673788f, 0.9338072722f, 0.9344469543f, 0.9350864254f,
    0.9357256859f, 0.9363647363f, 0.9370035770f, 0.9376422085f, 0.9382806311f,
    0.9389188453f, 0.9395568515f, 0.9401946501f, 0.9408322416f, 0.9414696263f,
    0.9421068047f, 0.9427437773f, 0.9433805443f, 0.9440171063f, 0.9446534636f,
    0.9452896166f, 0.9459255658f, 0.9465613116f, 0.9471968544f, 0.9478321945f,
    0.9484673324f, 0.9491022685f, 0.9497370032f, 0.9503715369f, 0.9510058700f,
    0.9516400028f, 0.9522739359f, 0.9529076695f, 0.9535412041f, 0.9541745400f,
    0.9548076778f, 0.9554406176f, 0.9560733600f, 0.9567059053f, 0.9573382540f,
    0.9579704063f, 0.9586023627f, 0.9592341236f, 0.9598656893f, 0.9604970603f,
    0.9611282369f, 0.9617592194f, 0.9623900083f, 0.9630206040f, 0.9636510067f,
    0.9642812170f, 0.9649112351f, 0.9655410614f, 0.9661706964f, 0.9668001403f,
    0.9674293936f, 0.9680584565f, 0.9686873296f, 0.9693160130f, 0.9699445073f,
    0.9705728128f, 0.9712009297f, 0.9718288586f, 0.9724565997f, 0.9730841534f,
    0.9737115200f, 0.9743387000f, 0.9749656936f, 0.9755925013f, 0.9762191234f,
    0.9768455601f, 0.9774718120f, 0.9780978793f, 0.9787237623f, 0.9793494615f,
    0.9799749772f, 0.9806003097f, 0.9812254593f, 0.9818504265f, 0.9824752115f,
    0.9830998147f, 0.9837242364f, 0.9843484770f, 0.9849725368f, 0.9855964161f,
    0.9862201153f, 0.9868436347f, 0.9874669747f, 0.9880901356f, 0.9887131177f,
    0.9893359213f, 0.9899585468f, 0.9905809946f, 0.9912032648f, 0.9918253579f,
    0.9924472742f, 0.9930690141f, 0.9936905777f, 0.9943119656f, 0.9949331779f,
    0.9955542150f, 0.9961750773f, 0.9967957650f, 0.9974162785f, 0.9980366181f,
    0.9986567840f, 0.9992767767f, 0.9998965965f, 1.0005162436f, 1.0011357183f,
    1.0017550210f, 1.0023741520f, 1.0029931117f, 1.0036119002f, 1.0042305179f,
    1.0048489652f, 1.0054672423f, 1.0060853496f, 1.0067032873f, 1.0073210557f,
    1.0079386552f, 1.0085560861f, 1.0091733486f, 1.0097904431f, 1.0104073699f,
    1.0110241292f, 1.0116407213f, 1.0122571467f, 1.0128734055f, 1.0134894980f,
    1.0141054246f, 1.0147211855f, 1.0153367811f, 1.0159522116f, 1.0165674773f,
    1.0171825786f, 1.0177975156f, 1.0184122888f, 1.0190268983f, 1.0196413445f,
    1.0202556276f, 1.0208697480f, 1.0214837059f, 1.0220975016f, 1.0227111355f,
    1.0233246077f, 1.0239379185f, 1.0245510684f, 1.0251640574f, 1.0257768860f,
    1.0263895543f, 1.0270020627f, 1.0276144115f, 1.0282266008f, 1.0288386311f,
    1.0294505026f, 1.0300622154f, 1.0306737701f, 1.0312851667f, 1.0318964055f,
    1.0325074870f, 1.0331184112f, 1.0337291785f, 1.0343397891f, 1.0349502434f,
    1.0355605416f, 1.0361706839f, 1.0367806707f, 1.0373905021f, 1.0380001785f,
    1.0386097001f, 1.0392190672f, 1.0398282800f, 1.0404373389f, 1.0410462440f,
    1.0416549956f, 1.0422635941f, 1.0428720396f, 1.0434803324f, 1.0440884727f,
    1.0446964609f, 1.0453042972f, 1.0459119818f, 1.0465195150f, 1.0471268971f,
    1.0477341283f, 1.0483412088f, 1.0489481389f, 1.0495549189f, 1.0501615490f,
    1.0507680295f, 1.0513743606f, 1.0519805426f, 1.0525865757f, 1.0531924601f,
    1.0537981962f, 1.0544037841f, 1.0550092241f, 1.0556145164f, 1.0562196614f,
    1.0568246592f, 1.0574295101f, 1.0580342143f, 1.0586387721f, 1.0592431836f,
    1.0598474493f, 1.0604515692f, 1.0610555437f, 1.0616593729f, 1.0622630571f,
    1.0628665966f, 1.0634699916f, 1.0640732423f, 1.0646763490f, 1.0652793118f,
    1.0658821311f, 1.0664848070f, 1.0670873399f, 1.0676897299f, 1.0682919772f,
    1.0688940822f, 1.0694960449f, 1.0700978658f, 1.0706995449f, 1.0713010825f,
    1.0719024789f, 1.0725037343f, 1.0731048488f, 1.0737058228f, 1.0743066565f,
    1.0749073500f, 1.0755079037f, 1.0761083177f, 1.0767085922f, 1.0773087275f,
    1.0779087239f, 1.0785085815f, 1.0791083005f, 1.0797078812f, 1.0803073238f,
    1.0809066285f, 1.0815057956f, 1.0821048252f, 1.0827037176f, 1.0833024729f,
    1.0839010915f, 1.0844995735f, 1.0850979192f, 1.0856961287f, 1.0862942023f,
    1.0868921402f, 1.0874899426f, 1.0880876098f, 1.0886851418f, 1.0892825391f,
    1.0898798016f, 1.0904769298f, 1.0910739237f, 1.0916707836f, 1.0922675098f,
    1.0928641023f, 1.0934605615f, 1.0940568875f, 1.0946530806f, 1.0952491409f,
    1.0958450686f, 1.0964408640f, 1.0970365273f, 1.0976320587f, 1.0982274584f,
    1.0988227265f, 1.0994178634f, 1.1000128691f, 1.1006077439f, 1.1012024881f,
    1.1017971017f, 1.1023915850f, 1.1029859383f, 1.1035801616f, 1.1041742553f,
    1.1047682195f, 1.1053620544f, 1.1059557602f, 1.1065493371f, 1.1071427853f,
    1.1077361050f, 1.1083292964f, 1.1089223597f, 1.1095152951f, 1.1101081027f,
    1.1107007829f, 1.1112933357f, 1.1118857614f, 1.1124780602f, 1.1130702322f,
    1.1136622777f, 1.1142541968f, 1.1148459898f, 1.1154376568f, 1.1160291980f,
    1.1166206136f, 1.1172119038f, 1.1178030688f, 1.1183941088f, 1.1189850239f,
    1.1195758144f, 1.1201664805f, 1.1207570223f, 1.1213474399f, 1.1219377337f,
    1.1225279038f, 1.1231179504f, 1.1237078736f, 1.1242976737f, 1.1248873508f,
    1.1254769051f, 1.1260663368f, 1.1266556461f, 1.1272448332f, 1.1278338982f,
    1.1284228413f, 1.1290116627f, 1.1296003627f, 1.1301889413f, 1.1307773987f,
    1.1313657352f, 1.1319539509f, 1.1325420460f, 1.1331300207f, 1.1337178751f,
    1.1343056094f, 1.1348932238f, 1.1354807185f, 1.1360680937f, 1.1366553495f,
    1.1372424860f, 1.1378295036f, 1.1384164024f, 1.1390031824f, 1.1395898440f,
    1.1401763872f, 1.1407628123f, 1.1413491194f, 1.1419353088f, 1.1425213805f,
    1.1431073347f, 1.1436931716f, 1.1442788914f, 1.1448644943f, 1.1454499804f,
    1.1460353499f, 1.1466206030f, 1.1472057398f, 1.1477907605f, 1.1483756652f,
    1.1489604542f, 1.1495451276f, 1.1501296856f, 1.1507141283f, 1.1512984559f,
    1.1518826686f, 1.1524667665f, 1.1530507498f, 1.1536346187f, 1.1542183733f,
    1.1548020138f, 1.1553855404f, 1.1559689532f, 1.1565522524f, 1.1571354381f,
    1.1577185105f, 1.1583014698f, 1.1588843162f, 1.1594670497f, 1.1600496706f,
    1.1606321790f, 1.1612145751f, 1.1617968590f, 1.1623790309f, 1.1629610909f,
    1.1635430393f, 1.1641248762f, 1.1647066016f, 1.1652882159f, 1.1658697191f,
    1.1664511114f, 1.1670323930f, 1.1676135639f, 1.1681946245f, 1.1687755748f,
    1.1693564149f, 1.1699371451f, 1.1705177655f, 1.1710982762f, 1.1716786775f,
    1.1722589693f, 1.1728391520f, 1.1734192257f, 1.1739991904f, 1.1745790465f,
    1.1751587939f, 1.1757384329f, 1.1763179636f, 1.1768973862f, 1.1774767008f,
    1.1780559076f, 1.1786350067f, 1.1792139983f, 1.1797928825f, 1.1803716594f,
    1.1809503293f, 1.1815288922f, 1.1821073484f, 1.1826856979f, 1.1832639409f,
    1.1838420776f, 1.1844201081f, 1.1849980325f, 1.1855758511f, 1.1861535638f,
    1.1867311710f, 1.1873086727f, 1.1878860690f, 1.1884633602f, 1.1890405464f,
    1.1896176276f, 1.1901946041f, 1.1907714761f, 1.1913482435f, 1.1919249066f,
    1.1925014656f, 1.1930779205f, 1.1936542715f, 1.1942305188f, 1.1948066625f,
    1.1953827027f, 1.1959586396f, 1.1965344733f, 1.1971102039f, 1.1976858317f,
    1.1982613567f, 1.1988367790f, 1.1994120989f, 1.1999873164f, 1.2005624317f,
    1.2011374449f, 1.2017123562f, 1.2022871657f, 1.2028618735f, 1.2034364798f,
    1.2040109847f, 1.2045853884f, 1.2051596910f, 1.2057338925f, 1.2063079933f,
    1.2068819933f, 1.2074558927f, 1.2080296917f, 1.2086033904f, 1.2091769890f,
    1.2097504875f, 1.2103238861f, 1.2108971849f, 1.2114703841f, 1.2120434838f,
    1.2126164841f, 1.2131893851f, 1.2137621871f, 1.2143348901f, 1.2149074942f,
    1.2154799996f, 1.2160524065f, 1.2166247149f, 1.2171969249f, 1.2177690368f,
    1.2183410506f, 1.2189129665f, 1.2194847846f, 1.2200565050f, 1.2206281278f,
    1.2211996533f, 1.2217710814f, 1.2223424124f, 1.2229136464f, 1.2234847834f,
    1.2240558237f, 1.2246267673f, 1.2251976144f, 1.2257683651f, 1.2263390195f,
    1.2269095777f, 1.2274800400f, 1.2280504063f, 1.2286206769f, 1.2291908518f,
    1.2297609312f, 1.2303309153f, 1.2309008040f, 1.2314705976f, 1.2320402961f,
    1.2326098998f, 1.2331794087f, 1.2337488229f, 1.2343181426f, 1.2348873679f,
    1.2354564989f, 1.2360255357f, 1.2365944784f, 1.2371633273f, 1.2377320823f,
    1.2383007437f, 1.2388693115f, 1.2394377859f, 1.2400061669f, 1.2405744547f,
    1.2411426495f, 1.2417107513f, 1.2422787602f, 1.2428466764f, 1.2434145001f,
    1.2439822312f, 1.2445498700f, 1.2451174165f, 1.2456848709f, 1.2462522332f,
    1.2468195037f, 1.2473866824f, 1.2479537694f, 1.2485207649f, 1.2490876689f,
    1.2496544817f, 1.2502212032f, 1.2507878337f, 1.2513543732f, 1.2519208218f,
    1.2524871797f, 1.2530534470f, 1.2536196238f, 1.2541857101f, 1.2547517062f,
    1.2553176122f, 1.2558834281f, 1.2564491540f, 1.2570147902f, 1.2575803366f,
    1.2581457934f, 1.2587111607f, 1.2592764387f, 1.2598416274f, 1.2604067270f,
    1.2609717375f, 1.2615366591f, 1.2621014919f, 1.2626662360f, 1.2632308915f,
    1.2637954585f, 1.2643599371f, 1.2649243275f, 1.2654886297f, 1.2660528439f,
    1.2666169702f, 1.2671810087f, 1.2677449594f, 1.2683088225f, 1.2688725982f,
    1.2694362864f, 1.2699998874f, 1.2705634012f, 1.2711268280f, 1.2716901678f,
    1.2722534207f, 1.2728165870f, 1.2733796666f, 1.2739426596f, 1.2745055663f,
    1.2750683866f, 1.2756311208f, 1.2761937688f, 1.2767563309f, 1.2773188070f,
    1.2778811974f, 1.2784435022f, 1.2790057213f, 1.2795678550f, 1.2801299033f,
    1.2806918664f, 1.2812537443f, 1.2818155372f, 1.2823772451f, 1.2829388682f,
    1.2835004066f, 1.2840618603f, 1.2846232295f, 1.2851845143f, 1.2857457148f,
    1.2863068310f, 1.2868678631f, 1.2874288113f, 1.2879896755f, 1.2885504559f,
    1.2891111525f, 1.2896717656f, 1.2902322952f, 1.2907927413f, 1.2913531042f,
    1.2919133839f, 1.2924735804f, 1.2930336940f, 1.2935937246f, 1.2941536725f,
    1.2947135376f, 1.2952733202f, 1.2958330202f, 1.2963926379f, 1.2969521732f,
    1.2975116264f, 1.2980709974f, 1.2986302864f, 1.2991894935f, 1.2997486188f,
    1.3003076624f, 1.3008666244f, 1.3014255049f, 1.3019843039f, 1.3025430216f,
    1.3031016581f, 1.3036602135f, 1.3042186878f, 1.3047770812f, 1.3053353937f,
    1.3058936255f, 1.3064517767f, 1.3070098473f, 1.3075678375f, 1.3081257473f,
    1.3086835768f, 1.3092413262f, 1.3097989955f, 1.3103565848f, 1.3109140942f,
    1.3114715239f, 1.3120288738f, 1.3125861442f, 1.3131433350f, 1.3137004464f,
    1.3142574786f, 1.3148144314f, 1.3153713052f, 1.3159280999f, 1.3164848157f,
    1.3170414526f, 1.3175980107f, 1.3181544902f, 1.3187108911f, 1.3192672135f,
    1.3198234576f, 1.3203796233f, 1.3209357108f, 1.3214917202f, 1.3220476516f,
    1.3226035050f, 1.3231592806f, 1.3237149785f, 1.3242705987f, 1.3248261413f,
    1.3253816064f, 1.3259369942f, 1.3264923046f, 1.3270475378f, 1.3276026939f,
    1.3281577730f, 1.3287127752f, 1.3292677005f, 1.3298225490f, 1.3303773208f,
    1.3309320161f, 1.3314866349f, 1.3320411772f, 1.3325956433f, 1.3331500331f,
    1.3337043467f, 1.3342585843f, 1.3348127460f, 1.3353668317f, 1.3359208417f,
    1.3364747760f, 1.3370286346f, 1.3375824177f, 1.3381361254f, 1.3386897577f,
    1.3392433147f, 1.3397967965f, 1.3403502033f, 1.3409035350f, 1.3414567918f,
    1.3420099738f, 1.3425630810f, 1.3431161135f, 1.3436690715f, 1.3442219549f,
    1.3447747640f, 1.3453274987f, 1.3458801591f, 1.3464327454f, 1.3469852576f,
    1.3475376959f, 1.3480900602f, 1.3486423507f, 1.3491945674f, 1.3497467105f,
    1.3502987800f, 1.3508507761f, 1.3514026987f, 1.3519545480f, 1.3525063240f,
    1.3530580269f, 1.3536096568f, 1.3541612136f, 1.3547126975f, 1.3552641086f,
    1.3558154470f, 1.3563667127f, 1.3569179058f, 1.3574690264f, 1.3580200745f,
    1.3585710504f, 1.3591219540f, 1.3596727854f, 1.3602235447f, 1.3607742320f,
    1.3613248474f, 1.3618753909f, 1.3624258627f, 1.3629762627f, 1.3635265912f,
    1.3640768481f, 1.3646270336f, 1.3651771477f, 1.3657271905f, 1.3662771621f,
    1.3668270625f, 1.3673768919f, 1.3679266504f, 1.3684763379f, 1.3690259546f,
    1.3695755006f, 1.3701249759f, 1.3706743807f, 1.3712237149f, 1.3717729787f,
    1.3723221722f, 1.3728712954f, 1.3734203484f, 1.3739693313f, 1.3745182442f,
    1.3750670871f, 1.3756158601f, 1.3761645634f, 1.3767131969f, 1.3772617607f,
    1.3778102550f, 1.3783586797f, 1.3789070351f, 1.3794553211f, 1.3800035379f,
    1.3805516854f, 1.3810997639f, 1.3816477733f, 1.3821957137f, 1.3827435853f,
    1.3832913880f, 1.3838391220f, 1.3843867873f, 1.3849343841f, 1.3854819123f,
    1.3860293721f, 1.3865767636f, 1.3871240867f, 1.3876713417f, 1.3882185285f,
    1.3887656472f, 1.3893126980f, 1.3898596808f, 1.3904065958f, 1.3909534430f,
    1.3915002225f, 1.3920469345f, 1.3925935788f, 1.3931401557f, 1.3936866652f,
    1.3942331073f, 1.3947794822f, 1.3953257900f, 1.3958720306f, 1.3964182041f,
    1.3969643107f, 1.3975103504f, 1.3980563233f, 1.3986022295f, 1.3991480689f,
    1.3996938418f, 1.4002395481f, 1.4007851880f, 1.4013307615f, 1.4018762686f,
    1.4024217095f, 1.4029670843f, 1.4035123929f, 1.4040576355f, 1.4046028121f,
    1.4051479229f, 1.4056929678f, 1.4062379470f, 1.4067828605f, 1.4073277083f,
    1.4078724907f, 1.4084172075f, 1.4089618590f, 1.4095064452f, 1.4100509660f,
    1.4105954217f, 1.4111398123f, 1.4116841378f, 1.4122283983f, 1.4127725939f,
    1.4133167247f, 1.4138607907f, 1.4144047919f, 1.4149487286f, 1.4154926007f,
    1.4160364082f, 1.4165801514f, 1.4171238301f, 1.4176674446f, 1.4182109949f,
    1.4187544809f, 1.4192979029f, 1.4198412609f, 1.4203845549f, 1.4209277850f,
    1.4214709513f, 1.4220140539f, 1.4225570927f, 1.4231000679f, 1.4236429796f,
    1.4241858278f, 1.4247286125f, 1.4252713340f, 1.4258139921f, 1.4263565870f,
    1.4268991187f, 1.4274415874f, 1.4279839930f, 1.4285263357f, 1.4290686155f,
    1.4296108324f, 1.4301529866f, 1.4306950781f, 1.4312371070f, 1.4317790733f,
    1.4323209771f, 1.4328628185f, 1.4334045976f, 1.4339463143f, 1.4344879687f,
    1.4350295611f, 1.4355710913f, 1.4361125594f, 1.4366539656f, 1.4371953098f,
    1.4377365923f, 1.4382778129f, 1.4388189718f, 1.4393600690f, 1.4399011047f,
    1.4404420788f, 1.4409829915f, 1.4415238427f, 1.4420646326f, 1.4426053613f,
    1.4431460287f, 1.4436866350f, 1.4442271801f, 1.4447676643f, 1.4453080875f,
    1.4458484498f, 1.4463887513f, 1.4469289920f, 1.4474691720f, 1.4480092913f,
    1.4485493501f, 1.4490893483f, 1.4496292861f, 1.4501691634f, 1.4507089805f,
    1.4512487372f, 1.4517884338f, 1.4523280702f, 1.4528676465f, 1.4534071627f,
    1.4539466191f, 1.4544860155f, 1.4550253520f, 1.4555646288f, 1.4561038458f,
    1.4566430032f, 1.4571821010f, 1.4577211393f, 1.4582601180f, 1.4587990374f,
    1.4593378974f, 1.4598766981f, 1.4604154395f, 1.4609541218f, 1.4614927449f,
    1.4620313090f, 1.4625698141f, 1.4631082603f, 1.4636466476f, 1.4641849761f,
    1.4647232458f, 1.4652614568f, 1.4657996091f, 1.4663377029f, 1.4668757382f,
    1.4674137150f, 1.4679516334f, 1.4684894934f, 1.4690272952f, 1.4695650387f,
    1.4701027241f, 1.4706403514f, 1.4711779206f, 1.4717154318f, 1.4722528850f,
    1.4727902804f, 1.4733276180f, 1.4738648978f, 1.4744021200f, 1.4749392844f,
    1.4754763913f, 1.4760134407f, 1.4765504325f, 1.4770873670f, 1.4776242441f,
    1.4781610639f, 1.4786978265f, 1.4792345319f, 1.4797711801f, 1.4803077713f,
    1.4808443055f, 1.4813807827f, 1.4819172030f, 1.4824535665f, 1.4829898731f,
    1.4835261231f, 1.4840623164f, 1.4845984530f, 1.4851345331f, 1.4856705567f,
    1.4862065238f, 1.4867424346f, 1.4872782890f, 1.4878140871f, 1.4883498290f,
    1.4888855147f, 1.4894211443f, 1.4899567179f, 1.4904922354f, 1.4910276970f,
    1.4915631027f, 1.4920984526f, 1.4926337467f, 1.4931689850f, 1.4937041677f,
    1.4942392947f, 1.4947743662f, 1.4953093822f, 1.4958443427f, 1.4963792479f,
    1.4969140977f, 1.4974488922f, 1.4979836314f, 1.4985183155f, 1.4990529444f,
    1.4995875183f, 1.5001220371f, 1.5006565010f, 1.5011909100f, 1.5017252641f,
    1.5022595634f, 1.5027938080f, 1.5033279978f, 1.5038621330f, 1.5043962137f,
    1.5049302397f, 1.5054642113f, 1.5059981285f, 1.5065319913f, 1.5070657997f,
    1.5075995539f, 1.5081332539f, 1.5086668997f, 1.5092004913f, 1.5097340290f,
    1.5102675126f, 1.5108009422f, 1.5113343180f, 1.5118676399f, 1.5124009080f,
    1.5129341223f, 1.5134672829f, 1.5140003899f, 1.5145334434f, 1.5150664432f,
    1.5155993896f, 1.5161322825f, 1.5166651221f, 1.5171979083f, 1.5177306413f,
    1.5182633210f, 1.5187959475f, 1.5193285209f, 1.5198610412f, 1.5203935085f,
    1.5209259228f, 1.5214582842f, 1.5219905927f, 1.5225228484f, 1.5230550514f,
    1.5235872016f, 1.5241192991f, 1.5246513440f, 1.5251833364f, 1.5257152762f,
    1.5262471635f, 1.5267789985f, 1.5273107810f, 1.5278425113f, 1.5283741893f,
    1.5289058150f, 1.5294373886f, 1.5299689101f, 1.5305003795f, 1.5310317969f,
    1.5315631623f, 1.5320944758f, 1.5326257374f, 1.5331569472f, 1.5336881052f,
    1.5342192115f, 1.5347502662f, 1.5352812692f, 1.5358122206f, 1.5363431205f,
    1.5368739689f, 1.5374047659f, 1.5379355115f, 1.5384662058f, 1.5389968488f,
    1.5395274406f, 1.5400579811f, 1.5405884706f, 1.5411189089f, 1.5416492962f,
    1.5421796326f, 1.5427099179f, 1.5432401524f, 1.5437703360f, 1.5443004689f,
    1.5448305509f, 1.5453605823f, 1.5458905630f, 1.5464204931f, 1.5469503726f,
    1.5474802017f, 1.5480099802f, 1.5485397084f, 1.5490693861f, 1.5495990136f,
    1.5501285907f, 1.5506581177f, 1.5511875944f, 1.5517170210f, 1.5522463976f,
    1.5527757240f, 1.5533050005f, 1.5538342271f, 1.5543634037f, 1.5548925305f,
    1.5554216075f, 1.5559506347f, 1.5564796122f, 1.5570085400f, 1.5575374182f,
    1.5580662468f, 1.5585950259f, 1.5591237555f, 1.5596524357f, 1.5601810664f,
    1.5607096479f, 1.5612381800f, 1.5617666629f, 1.5622950965f, 1.5628234810f,
    1.5633518164f, 1.5638801027f, 1.5644083400f, 1.5649365283f, 1.5654646677f,
    1.5659927582f, 1.5665207998f, 1.5670487926f, 1.5675767367f, 1.5681046321f,
    1.5686324788f, 1.5691602769f, 1.5696880264f, 1.5702157273f, 1.5707433798f,
    1.5712709839f, 1.5717985395f, 1.5723260468f, 1.5728535058f, 1.5733809166f,
    1.5739082791f, 1.5744355934f, 1.5749628596f, 1.5754900777f, 1.5760172478f,
    1.5765443699f, 1.5770714440f, 1.5775984703f, 1.5781254486f, 1.5786523791f,
    1.5791792619f, 1.5797060969f, 1.5802328843f, 1.5807596240f, 1.5812863160f,
    1.5818129606f, 1.5823395576f, 1.5828661071f, 1.5833926092f, 1.5839190639f,
    1.5844454713f, 1.5849718314f, 1.5854981442f, 1.5860244098f, 1.5865506283f,
    1.5870767996f, 1.5876029238f, 1.5881290010f, 1.5886550312f, 1.5891810144f,
    1.5897069507f, 1.5902328402f, 1.5907586828f, 1.5912844786f, 1.5918102277f,
    1.5923359301f, 1.5928615858f, 1.5933871949f, 1.5939127575f, 1.5944382735f,
    1.5949637430f, 1.5954891661f, 1.5960145427f, 1.5965398730f, 1.5970651570f,
    1.5975903947f, 1.5981155861f, 1.5986407314f, 1.5991658305f, 1.5996908835f,
    1.6002158904f, 1.6007408513f, 1.6012657662f, 1.6017906351f, 1.6023154581f,
    1.6028402353f, 1.6033649667f, 1.6038896522f, 1.6044142920f, 1.6049388862f,
    1.6054634346f, 1.6059879375f, 1.6065123947f, 1.6070368065f, 1.6075611727f,
    1.6080854935f, 1.6086097688f, 1.6091339988f, 1.6096581834f, 1.6101823228f,
    1.6107064169f, 1.6112304658f, 1.6117544695f, 1.6122784281f, 1.6128023416f,
    1.6133262100f, 1.6138500335f, 1.6143738119f, 1.6148975454f, 1.6154212341f,
    1.6159448779f, 1.6164684768f, 1.6169920310f, 1.6175155405f, 1.6180390053f,
    1.6185624254f, 1.6190858009f, 1.6196091319f, 1.6201324183f, 1.6206556602f,
    1.6211788576f, 1.6217020107f, 1.6222251193f, 1.6227481836f, 1.6232712037f,
    1.6237941794f, 1.6243171110f, 1.6248399984f, 1.6253628416f, 1.6258856407f,
    1.6264083958f, 1.6269311068f, 1.6274537738f, 1.6279763969f, 1.6284989761f,
    1.6290215115f, 1.6295440030f, 1.6300664507f, 1.6305888546f, 1.6311112148f,
    1.6316335314f, 1.6321558043f, 1.6326780336f, 1.6332002194f, 1.6337223616f,
    1.6342444603f, 1.6347665156f, 1.6352885275f, 1.6358104960f, 1.6363324212f,
    1.6368543031f, 1.6373761417f, 1.6378979371f, 1.6384196893f, 1.6389413984f,
    1.6394630644f, 1.6399846873f, 1.6405062672f, 1.6410278040f, 1.6415492980f,
    1.6420707490f, 1.6425921571f, 1.6431135223f, 1.6436348448f, 1.6441561245f,
    1.6446773615f, 1.6451985557f, 1.6457197074f, 1.6462408163f, 1.6467618827f,
    1.6472829066f, 1.6478038880f, 1.6483248268f, 1.6488457233f, 1.6493665773f,
    1.6498873890f, 1.6504081583f, 1.6509288854f, 1.6514495702f, 1.6519702128f,
    1.6524908132f, 1.6530113715f, 1.6535318876f, 1.6540523617f, 1.6545727938f,
    1.6550931838f, 1.6556135319f, 1.6561338381f, 1.6566541023f, 1.6571743248f,
    1.6576945054f, 1.6582146442f, 1.6587347413f, 1.6592547967f, 1.6597748104f,
    1.6602947824f, 1.6608147129f, 1.6613346018f, 1.6618544491f, 1.6623742550f,
    1.6628940194f, 1.6634137424f, 1.6639334240f, 1.6644530642f, 1.6649726631f,
    1.6654922208f, 1.6660117372f, 1.6665312124f, 1.6670506464f, 1.6675700392f,
    1.6680893910f, 1.6686087017f, 1.6691279714f, 1.6696472000f, 1.6701663877f,
    1.6706855345f, 1.6712046403f, 1.6717237053f, 1.6722427295f, 1.6727617129f,
    1.6732806555f, 1.6737995575f, 1.6743184187f, 1.6748372393f, 1.6753560192f,
    1.6758747586f, 1.6763934574f, 1.6769121157f, 1.6774307335f, 1.6779493109f,
    1.6784678479f, 1.6789863445f, 1.6795048007f, 1.6800232167f, 1.6805415924f,
    1.6810599278f, 1.6815782230f, 1.6820964781f, 1.6826146930f, 1.6831328678f,
    1.6836510025f, 1.6841690972f, 1.6846871519f, 1.6852051667f, 1.6857231415f,
    1.6862410764f, 1.6867589714f, 1.6872768266f, 1.6877946420f, 1.6883124176f,
    1.6888301535f, 1.6893478497f, 1.6898655062f, 1.6903831231f, 1.6909007004f,
    1.6914182381f, 1.6919357363f, 1.6924531950f, 1.6929706142f, 1.6934879940f,
    1.6940053344f, 1.6945226354f, 1.6950398971f, 1.6955571195f, 1.6960743026f,
    1.6965914465f, 1.6971085512f, 1.6976256167f, 1.6981426430f, 1.6986596303f,
    1.6991765785f, 1.6996934877f, 1.7002103578f, 1.7007271890f, 1.7012439812f,
    1.7017607345f, 1.7022774490f, 1.7027941246f, 1.7033107613f, 1.7038273594f,
    1.7043439186f, 1.7048604392f, 1.7053769210f, 1.7058933642f, 1.7064097688f,
    1.7069261348f, 1.7074424623f, 1.7079587512f, 1.7084750016f, 1.7089912136f,
    1.7095073872f, 1.7100235223f, 1.7105396191f, 1.7110556776f, 1.7115716977f,
    1.7120876796f, 1.7126036233f, 1.7131195288f, 1.7136353960f, 1.7141512252f,
    1.7146670162f, 1.7151827692f, 1.7156984841f, 1.7162141610f, 1.7167297999f,
    1.7172454008f, 1.7177609639f, 1.7182764890f, 1.7187919763f, 1.7193074258f,
    1.7198228374f, 1.7203382113f, 1.7208535475f, 1.7213688459f, 1.7218841067f,
    1.7223993299f, 1.7229145154f, 1.7234296634f, 1.7239447738f, 1.7244598467f,
    1.7249748821f, 1.7254898800f, 1.7260048405f, 1.7265197637f, 1.7270346494f,
    1.7275494979f, 1.7280643090f, 1.7285790828f, 1.7290938195f, 1.7296085189f,
    1.7301231811f, 1.7306378062f, 1.7311523941f, 1.7316669450f, 1.7321814588f,
    1.7326959356f, 1.7332103753f, 1.7337247781f, 1.7342391440f, 1.7347534730f,
    1.7352677650f, 1.7357820203f, 1.7362962387f, 1.7368104203f, 1.7373245652f,
    1.7378386733f, 1.7383527448f, 1.7388667795f, 1.7393807777f, 1.7398947392f,
    1.7404086641f, 1.7409225525f, 1.7414364044f, 1.7419502198f, 1.7424639987f,
    1.7429777412f, 1.7434914473f, 1.7440051170f, 1.7445187504f, 1.7450323475f,
    1.7455459083f, 1.7460594328f, 1.7465729211f, 1.7470863732f, 1.7475997891f,
    1.7481131689f, 1.7486265126f, 1.7491398202f, 1.7496530918f, 1.7501663273f,
    1.7506795269f, 1.7511926904f, 1.7517058181f, 1.7522189098f, 1.7527319657f,
    1.7532449857f, 1.7537579699f, 1.7542709184f, 1.7547838310f, 1.7552967079f,
    1.7558095492f, 1.7563223547f, 1.7568351246f, 1.7573478589f, 1.7578605576f,
    1.7583732207f, 1.7588858483f, 1.7593984404f, 1.7599109970f, 1.7604235182f,
    1.7609360040f, 1.7614484543f, 1.7619608693f, 1.7624732490f, 1.7629855934f,
    1.7634979025f, 1.7640101763f, 1.7645224150f, 1.7650346184f, 1.7655467867f,
    1.7660589198f, 1.7665710178f, 1.7670830808f, 1.7675951087f, 1.7681071015f,
    1.7686190594f, 1.7691309823f, 1.7696428703f, 1.7701547234f, 1.7706665415f,
    1.7711783248f, 1.7716900733f, 1.7722017870f, 1.7727134659f, 1.7732251101f,
    1.7737367195f, 1.7742482943f, 1.7747598344f, 1.7752713399f, 1.7757828107f,
    1.7762942470f, 1.7768056487f, 1.7773170159f, 1.7778283486f, 1.7783396468f,
    1.7788509106f, 1.7793621399f, 1.7798733349f, 1.7803844955f, 1.7808956218f,
    1.7814067137f, 1.7819177714f, 1.7824287948f, 1.7829397840f, 1.7834507390f,
    1.7839616599f, 1.7844725465f, 1.7849833991f, 1.7854942176f, 1.7860050020f,
    1.7865157524f, 1.7870264687f, 1.7875371511f, 1.7880477995f, 1.7885584140f,
    1.7890689946f, 1.7895795412f, 1.7900900541f, 1.7906005331f, 1.7911109783f,
    1.7916213898f, 1.7921317675f, 1.7926421115f, 1.7931524218f, 1.7936626984f,
    1.7941729414f, 1.7946831508f, 1.7951933266f, 1.7957034688f, 1.7962135775f,
    1.7967236527f, 1.7972336944f, 1.7977437026f, 1.7982536775f, 1.7987636189f,
    1.7992735269f, 1.7997834016f, 1.8002932430f, 1.8008030510f, 1.8013128258f,
    1.8018225674f, 1.8023322757f, 1.8028419508f, 1.8033515928f, 1.8038612016f,
    1.8043707773f, 1.8048803199f, 1.8053898294f, 1.8058993059f, 1.8064087494f,
    1.8069181599f, 1.8074275374f, 1.8079368820f, 1.8084461937f, 1.8089554725f,
    1.8094647184f, 1.8099739315f, 1.8104831118f, 1.8109922593f, 1.8115013740f,
    1.8120104561f, 1.8125195054f, 1.8130285220f, 1.8135375059f, 1.8140464572f,
    1.8145553760f, 1.8150642621f, 1.8155731157f, 1.8160819367f, 1.8165907253f,
    1.8170994813f, 1.8176082049f, 1.8181168961f, 1.8186255548f, 1.8191341812f,
    1.8196427752f, 1.8201513369f, 1.8206598663f, 1.8211683634f, 1.8216768283f,
    1.8221852609f, 1.8226936613f, 1.8232020295f, 1.8237103656f, 1.8242186695f,
    1.8247269413f, 1.8252351811f, 1.8257433888f, 1.8262515644f, 1.8267597080f,
    1.8272678197f, 1.8277758994f, 1.8282839471f, 1.8287919630f, 1.8292999469f,
    1.8298078990f, 1.8303158193f, 1.8308237077f, 1.8313315644f, 1.8318393893f,
    1.8323471824f, 1.8328549439f, 1.8333626736f, 1.8338703717f, 1.8343780381f,
    1.8348856729f, 1.8353932761f, 1.8359008477f, 1.8364083878f, 1.8369158964f,
    1.8374233735f, 1.8379308191f, 1.8384382332f, 1.8389456159f, 1.8394529672f,
    1.8399602872f, 1.8404675757f, 1.8409748330f, 1.8414820589f, 1.8419892536f,
    1.8424964170f, 1.8430035491f, 1.8435106501f, 1.8440177198f, 1.8445247584f,
    1.8450317658f, 1.8455387422f, 1.8460456874f, 1.8465526016f, 1.8470594847f,
    1.8475663368f, 1.8480731579f, 1.8485799480f, 1.8490867072f, 1.8495934354f,
    1.8501001327f, 1.8506067992f, 1.8511134347f, 1.8516200395f, 1.8521266134f,
    1.8526331566f, 1.8531396690f, 1.8536461506f, 1.8541526015f, 1.8546590217f,
    1.8551654113f, 1.8556717702f, 1.8561780984f, 1.8566843961f, 1.8571906632f,
    1.8576968997f, 1.8582031057f, 1.8587092812f, 1.8592154262f, 1.8597215407f,
    1.8602276248f, 1.8607336784f, 1.8612397017f, 1.8617456946f, 1.8622516571f,
    1.8627575893f, 1.8632634912f, 1.8637693628f, 1.8642752042f, 1.8647810153f,
    1.8652867962f, 1.8657925469f, 1.8662982674f, 1.8668039578f, 1.8673096181f,
    1.8678152482f, 1.8683208483f, 1.8688264184f, 1.8693319583f, 1.8698374683f,
    1.8703429483f, 1.8708483983f, 1.8713538184f, 1.8718592086f, 1.8723645688f,
    1.8728698992f, 1.8733751997f, 1.8738804704f, 1.8743857113f, 1.8748909224f,
    1.8753961037f, 1.8759012553f, 1.8764063771f, 1.8769114693f, 1.8774165318f,
    1.8779215646f, 1.8784265678f, 1.8789315413f, 1.8794364853f, 1.8799413997f,
    1.8804462846f, 1.8809511399f, 1.8814559658f, 1.8819607622f, 1.8824655291f,
    1.8829702665f, 1.8834749746f, 1.8839796533f, 1.8844843025f, 1.8849889225f,
    1.8854935131f, 1.8859980744f, 1.8865026064f, 1.8870071092f, 1.8875115827f,
    1.8880160270f, 1.8885204422f, 1.8890248281f, 1.8895291849f, 1.8900335125f,
    1.8905378111f, 1.8910420805f, 1.8915463209f, 1.8920505322f, 1.8925547145f,
    1.8930588678f, 1.8935629921f, 1.8940670875f, 1.8945711539f, 1.8950751914f,
    1.8955792000f, 1.8960831798f, 1.8965871306f, 1.8970910527f, 1.8975949459f,
    1.8980988104f, 1.8986026460f, 1.8991064530f, 1.8996102312f, 1.9001139807f,
    1.9006177015f, 1.9011213936f, 1.9016250571f, 1.9021286920f, 1.9026322983f,
    1.9031358760f, 1.9036394251f, 1.9041429457f, 1.9046464378f, 1.9051499014f,
    1.9056533365f, 1.9061567432f, 1.9066601214f, 1.9071634712f, 1.9076667926f,
    1.9081700857f, 1.9086733504f, 1.9091765867f, 1.9096797948f, 1.9101829746f,
    1.9106861261f, 1.9111892494f, 1.9116923444f, 1.9121954112f, 1.9126984499f,
    1.9132014603f, 1.9137044427f, 1.9142073969f, 1.9147103230f, 1.9152132210f,
    1.9157160910f, 1.9162189329f, 1.9167217468f, 1.9172245327f, 1.9177272907f,
    1.9182300206f, 1.9187327226f, 1.9192353968f, 1.9197380430f, 1.9202406613f,
    1.9207432518f, 1.9212458144f, 1.9217483492f, 1.9222508562f, 1.9227533355f,
    1.9232557869f, 1.9237582107f, 1.9242606067f, 1.9247629750f, 1.9252653157f,
    1.9257676287f, 1.9262699140f, 1.9267721718f, 1.9272744019f, 1.9277766045f,
    1.9282787795f, 1.9287809270f, 1.9292830469f, 1.9297851394f, 1.9302872044f,
    1.9307892419f, 1.9312912520f, 1.9317932347f, 1.9322951899f, 1.9327971178f,
    1.9332990184f, 1.9338008916f, 1.9343027374f, 1.9348045560f, 1.9353063473f,
    1.9358081114f, 1.9363098482f, 1.9368115577f, 1.9373132401f, 1.9378148953f,
    1.9383165233f, 1.9388181242f, 1.9393196980f, 1.9398212447f, 1.9403227642f,
    1.9408242568f, 1.9413257222f, 1.9418271607f, 1.9423285721f, 1.9428299566f,
    1.9433313141f, 1.9438326446f, 1.9443339482f, 1.9448352249f, 1.9453364747f,
    1.9458376976f, 1.9463388937f, 1.9468400630f, 1.9473412054f, 1.9478423211f,
    1.9483434099f, 1.9488444720f, 1.9493455074f, 1.9498465161f, 1.9503474981f,
    1.9508484533f, 1.9513493820f, 1.9518502839f, 1.9523511593f, 1.9528520081f,
    1.9533528302f, 1.9538536258f, 1.9543543949f, 1.9548551374f, 1.9553558535f,
    1.9558565430f, 1.9563572061f, 1.9568578427f, 1.9573584529f, 1.9578590366f,
    1.9583595940f, 1.9588601250f, 1.9593606296f, 1.9598611079f, 1.9603615599f,
    1.9608619856f, 1.9613623850f, 1.9618627581f, 1.9623631050f, 1.9628634257f,
    1.9633637201f, 1.9638639884f, 1.9643642305f, 1.9648644464f, 1.9653646362f,
    1.9658647999f, 1.9663649375f, 1.9668650490f, 1.9673651344f, 1.9678651939f,
    1.9683652272f, 1.9688652346f, 1.9693652160f, 1.9698651715f, 1.9703651009f,
    1.9708650045f, 1.9713648821f, 1.9718647339f, 1.9723645597f, 1.9728643597f,
    1.9733641339f, 1.9738638822f, 1.9743636048f, 1.9748633015f, 1.9753629725f,
    1.9758626178f, 1.9763622373f, 1.9768618311f, 1.9773613992f, 1.9778609416f,
    1.9783604584f, 1.9788599495f, 1.9793594150f, 1.9798588549f, 1.9803582693f,
    1.9808576580f, 1.9813570212f, 1.9818563589f, 1.9823556711f, 1.9828549577f,
    1.9833542189f, 1.9838534546f, 1.9843526649f, 1.9848518498f, 1.9853510092f,
    1.9858501433f, 1.9863492520f, 1.9868483353f, 1.9873473933f, 1.9878464260f,
    1.9883454334f, 1.9888444155f, 1.9893433723f, 1.9898423039f, 1.9903412102f,
    1.9908400914f, 1.9913389474f, 1.9918377781f, 1.9923365838f, 1.9928353642f,
    1.9933341196f, 1.9938328498f, 1.9943315550f, 1.9948302351f, 1.9953288901f,
    1.9958275201f, 1.9963261251f, 1.9968247051f, 1.9973232601f, 1.9978217901f,
    1.9983202952f, 1.9988187754f, 1.9993172306f, 1.9998156610f, 2.0003140664f,
    2.0008124470f, 2.0013108028f, 2.0018091337f, 2.0023074398f, 2.0028057212f,
    2.0033039777f, 2.0038022095f, 2.0043004166f, 2.0047985989f, 2.0052967565f,
    2.0057948894f, 2.0062929977f, 2.0067910813f, 2.0072891403f, 2.0077871746f,
    2.0082851844f, 2.0087831695f, 2.0092811301f, 2.0097790661f, 2.0102769776f,
    2.0107748646f, 2.0112727271f, 2.0117705651f, 2.0122683786f, 2.0127661677f,
    2.0132639323f, 2.0137616725f, 2.0142593884f, 2.0147570798f, 2.0152547469f,
    2.0157523896f, 2.0162500080f, 2.0167476020f, 2.0172451718f, 2.0177427173f,
    2.0182402385f, 2.0187377355f, 2.0192352082f, 2.0197326568f, 2.0202300811f,
    2.0207274812f, 2.0212248572f, 2.0217222091f, 2.0222195368f, 2.0227168403f,
    2.0232141198f, 2.0237113752f, 2.0242086066f, 2.0247058138f, 2.0252029971f,
    2.0257001563f, 2.0261972916f, 2.0266944028f, 2.0271914901f, 2.0276885535f,
    2.0281855929f, 2.0286826083f, 2.0291795999f, 2.0296765676f, 2.0301735115f,
    2.0306704314f, 2.0311673276f, 2.0316641999f, 2.0321610484f, 2.0326578732f,
    2.0331546741f, 2.0336514514f, 2.0341482048f, 2.0346449346f, 2.0351416406f,
    2.0356383230f, 2.0361349817f, 2.0366316167f, 2.0371282281f, 2.0376248159f,
    2.0381213800f, 2.0386179206f, 2.0391144376f, 2.0396109310f, 2.0401074009f,
    2.0406038472f, 2.0411002701f, 2.0415966694f, 2.0420930453f, 2.0425893977f,
    2.0430857267f, 2.0435820322f, 2.0440783143f, 2.0445745730f, 2.0450708084f,
    2.0455670203f, 2.0460632089f, 2.0465593742f, 2.0470555162f, 2.0475516348f,
    2.0480477302f, 2.0485438023f, 2.0490398511f, 2.0495358767f, 2.0500318791f,
    2.0505278582f, 2.0510238142f, 2.0515197470f, 2.0520156566f, 2.0525115431f,
    2.0530074064f, 2.0535032467f, 2.0539990638f, 2.0544948579f, 2.0549906288f,
    2.0554863768f, 2.0559821017f, 2.0564778035f, 2.0569734824f, 2.0574691383f,
    2.0579647712f, 2.0584603811f, 2.0589559681f, 2.0594515322f, 2.0599470734f,
    2.0604425916f, 2.0609380870f, 2.0614335595f, 2.0619290092f, 2.0624244360f,
    2.0629198400f, 2.0634152213f, 2.0639105797f, 2.0644059153f, 2.0649012282f,
    2.0653965184f, 2.0658917858f, 2.0663870305f, 2.0668822525f, 2.0673774518f,
    2.0678726285f, 2.0683677825f, 2.0688629139f, 2.0693580226f, 2.0698531088f,
    2.0703481723f, 2.0708432133f, 2.0713382318f, 2.0718332276f, 2.0723282010f,
    2.0728231518f, 2.0733180802f, 2.0738129860f, 2.0743078694f, 2.0748027304f,
    2.0752975689f, 2.0757923849f, 2.0762871786f, 2.0767819499f, 2.0772766988f,
    2.0777714253f, 2.0782661295f, 2.0787608113f, 2.0792554709f, 2.0797501081f,
    2.0802447230f, 2.0807393157f, 2.0812338861f, 2.0817284343f, 2.0822229602f,
    2.0827174639f, 2.0832119454f, 2.0837064048f, 2.0842008419f, 2.0846952570f,
    2.0851896498f, 2.0856840206f, 2.0861783692f, 2.0866726958f, 2.0871670002f,
    2.0876612826f, 2.0881555430f, 2.0886497813f, 2.0891439976f, 2.0896381918f,
    2.0901323641f, 2.0906265144f, 2.0911206428f, 2.0916147492f, 2.0921088337f,
    2.0926028962f, 2.0930969368f, 2.0935909556f, 2.0940849525f, 2.0945789275f,
    2.0950728807f, 2.0955668120f, 2.0960607215f, 2.0965546092f, 2.0970484751f,
    2.0975423193f, 2.0980361417f, 2.0985299423f, 2.0990237213f, 2.0995174785f,
    2.1000112140f, 2.1005049278f, 2.1009986199f, 2.1014922904f, 2.1019859392f,
    2.1024795665f, 2.1029731720f, 2.1034667560f, 2.1039603184f, 2.1044538593f,
    2.1049473786f, 2.1054408763f, 2.1059343525f, 2.1064278072f, 2.1069212404f,
    2.1074146521f, 2.1079080423f, 2.1084014110f, 2.1088947584f, 2.1093880843f,
    2.1098813887f, 2.1103746718f, 2.1108679335f, 2.1113611738f, 2.1118543928f,
    2.1123475904f, 2.1128407666f, 2.1133339216f, 2.1138270553f, 2.1143201676f,
    2.1148132587f, 2.1153063286f, 2.1157993771f, 2.1162924045f, 2.1167854106f,
    2.1172783956f, 2.1177713593f, 2.1182643018f, 2.1187572232f, 2.1192501235f,
    2.1197430026f, 2.1202358606f, 2.1207286975f, 2.1212215133f, 2.1217143080f,
    2.1222070816f, 2.1226998342f, 2.1231925658f, 2.1236852763f, 2.1241779658f,
    2.1246706343f, 2.1251632819f, 2.1256559084f, 2.1261485141f, 2.1266410987f,
    2.1271336625f, 2.1276262053f, 2.1281187272f, 2.1286112283f, 2.1291037084f,
    2.1295961677f, 2.1300886062f, 2.1305810238f, 2.1310734206f, 2.1315657967f,
    2.1320581519f, 2.1325504863f, 2.1330428000f, 2.1335350929f, 2.1340273651f,
    2.1345196166f, 2.1350118473f, 2.1355040574f, 2.1359962467f, 2.1364884154f,
    2.1369805635f, 2.1374726909f, 2.1379647977f, 2.1384568838f, 2.1389489494f,
    2.1394409944f, 2.1399330188f, 2.1404250226f, 2.1409170059f, 2.1414089686f,
    2.1419009109f, 2.1423928326f, 2.1428847338f, 2.1433766146f, 2.1438684748f,
    2.1443603147f, 2.1448521341f, 2.1453439330f, 2.1458357115f, 2.1463274697f,
    2.1468192074f, 2.1473109248f, 2.1478026218f, 2.1482942985f, 2.1487859548f,
    2.1492775908f, 2.1497692065f, 2.1502608019f, 2.1507523770f, 2.1512439319f,
    2.1517354665f, 2.1522269808f, 2.1527184749f, 2.1532099488f, 2.1537014025f,
    2.1541928361f, 2.1546842494f, 2.1551756426f, 2.1556670156f, 2.1561583684f,
    2.1566497012f, 2.1571410138f, 2.1576323064f, 2.1581235788f, 2.1586148312f,
    2.1591060635f, 2.1595972758f, 2.1600884680f, 2.1605796403f, 2.1610707925f,
    2.1615619247f, 2.1620530369f, 2.1625441292f, 2.1630352015f, 2.1635262538f,
    2.1640172863f, 2.1645082988f, 2.1649992914f, 2.1654902641f, 2.1659812169f,
    2.1664721499f, 2.1669630630f, 2.1674539563f, 2.1679448297f, 2.1684356833f,
    2.1689265172f, 2.1694173312f, 2.1699081255f, 2.1703989000f, 2.1708896547f,
    2.1713803897f, 2.1718711050f, 2.1723618005f, 2.1728524764f, 2.1733431326f,
    2.1738337691f, 2.1743243859f, 2.1748149831f, 2.1753055606f, 2.1757961185f,
    2.1762866568f, 2.1767771755f, 2.1772676747f, 2.1777581542f, 2.1782486142f,
    2.1787390546f, 2.1792294755f, 2.1797198769f, 2.1802102587f, 2.1807006211f,
    2.1811909639f, 2.1816812873f, 2.1821715913f, 2.1826618758f, 2.1831521408f,
    2.1836423864f, 2.1841326126f, 2.1846228194f, 2.1851130069f, 2.1856031749f,
    2.1860933236f, 2.1865834529f, 2.1870735629f, 2.1875636536f, 2.1880537249f,
    2.1885437770f, 2.1890338097f, 2.1895238232f, 2.1900138175f, 2.1905037924f,
    2.1909937482f, 2.1914836847f, 2.1919736020f, 2.1924635001f, 2.1929533790f,
    2.1934432387f, 2.1939330792f, 2.1944229006f, 2.1949127029f, 2.1954024860f,
    2.1958922500f, 2.1963819949f, 2.1968717207f, 2.1973614275f, 2.1978511151f,
    2.1983407838f, 2.1988304333f, 2.1993200639f, 2.1998096754f, 2.2002992679f,
    2.2007888414f, 2.2012783959f, 2.2017679315f, 2.2022574481f, 2.2027469457f,
    2.2032364244f, 2.2037258842f, 2.2042153251f, 2.2047047471f, 2.2051941501f,
    2.2056835344f, 2.2061728997f, 2.2066622462f, 2.2071515739f, 2.2076408827f,
    2.2081301727f, 2.2086194439f, 2.2091086964f, 2.2095979300f, 2.2100871449f,
    2.2105763410f, 2.2110655184f, 2.2115546770f, 2.2120438169f, 2.2125329381f,
    2.2130220406f, 2.2135111245f, 2.2140001896f, 2.2144892361f, 2.2149782640f,
    2.2154672732f, 2.2159562638f, 2.2164452357f, 2.2169341891f, 2.2174231239f,
    2.2179120401f, 2.2184009377f, 2.2188898168f, 2.2193786773f, 2.2198675193f,
    2.2203563428f, 2.2208451477f, 2.2213339342f, 2.2218227022f, 2.2223114517f,
    2.2228001827f, 2.2232888953f, 2.2237775895f, 2.2242662652f, 2.2247549226f,
    2.2252435615f, 2.2257321820f, 2.2262207841f, 2.2267093679f, 2.2271979333f,
    2.2276864804f, 2.2281750091f, 2.2286635195f, 2.2291520116f, 2.2296404854f,
    2.2301289409f, 2.2306173782f, 2.2311057971f, 2.2315941978f, 2.2320825803f,
    2.2325709446f, 2.2330592906f, 2.2335476184f, 2.2340359280f, 2.2345242194f,
    2.2350124927f, 2.2355007478f, 2.2359889847f, 2.2364772035f, 2.2369654042f,
    2.2374535867f, 2.2379417512f, 2.2384298975f, 2.2389180258f, 2.2394061360f,
    2.2398942282f, 2.2403823023f, 2.2408703583f, 2.2413583963f, 2.2418464163f,
    2.2423344184f, 2.2428224024f, 2.2433103684f, 2.2437983165f, 2.2442862466f,
    2.2447741587f, 2.2452620529f, 2.2457499292f, 2.2462377876f, 2.2467256281f,
    2.2472134507f, 2.2477012554f, 2.2481890422f, 2.2486768112f, 2.2491645623f,
    2.2496522956f, 2.2501400111f, 2.2506277088f, 2.2511153886f, 2.2516030507f,
    2.2520906950f, 2.2525783215f, 2.2530659302f, 2.2535535212f, 2.2540410945f,
    2.2545286500f, 2.2550161879f, 2.2555037080f, 2.2559912104f, 2.2564786952f,
    2.2569661623f, 2.2574536117f, 2.2579410435f, 2.2584284576f, 2.2589158542f,
    2.2594032331f, 2.2598905943f, 2.2603779381f, 2.2608652642f, 2.2613525727f,
    2.2618398637f, 2.2623271372f, 2.2628143931f, 2.2633016314f, 2.2637888523f,
    2.2642760556f, 2.2647632415f, 2.2652504099f, 2.2657375608f, 2.2662246942f,
    2.2667118102f, 2.2671989087f, 2.2676859898f, 2.2681730535f, 2.2686600998f,
    2.2691471287f, 2.2696341402f, 2.2701211343f, 2.2706081111f, 2.2710950705f,
    2.2715820125f, 2.2720689373f, 2.2725558447f, 2.2730427347f, 2.2735296075f,
    2.2740164630f, 2.2745033013f, 2.2749901222f, 2.2754769259f, 2.2759637123f,
    2.2764504816f, 2.2769372335f, 2.2774239683f, 2.2779106859f, 2.2783973862f,
    2.2788840694f, 2.2793707354f, 2.2798573843f, 2.2803440160f, 2.2808306305f,
    2.2813172279f, 2.2818038082f, 2.2822903714f, 2.2827769175f, 2.2832634465f,
    2.2837499584f, 2.2842364533f, 2.2847229311f, 2.2852093919f, 2.2856958356f,
    2.2861822623f, 2.2866686719f, 2.2871550646f, 2.2876414403f, 2.2881277990f,
    2.2886141407f, 2.2891004655f, 2.2895867733f, 2.2900730641f, 2.2905593381f,
    2.2910455951f, 2.2915318352f, 2.2920180584f, 2.2925042647f, 2.2929904541f,
    2.2934766267f, 2.2939627824f, 2.2944489212f, 2.2949350432f, 2.2954211484f,
    2.2959072368f, 2.2963933083f, 2.2968793631f, 2.2973654011f, 2.2978514223f,
    2.2983374267f, 2.2988234144f, 2.2993093853f, 2.2997953395f, 2.3002812770f,
    2.3007671977f, 2.3012531018f, 2.3017389891f, 2.3022248598f, 2.3027107138f,
    2.3031965512f, 2.3036823718f, 2.3041681759f, 2.3046539633f, 2.3051397341f,
    2.3056254882f, 2.3061112258f, 2.3065969468f, 2.3070826512f, 2.3075683390f,
    2.3080540102f, 2.3085396650f, 2.3090253031f, 2.3095109247f, 2.3099965299f,
    2.3104821185f, 2.3109676906f, 2.3114532462f, 2.3119387853f, 2.3124243079f,
    2.3129098141f, 2.3133953039f, 2.3138807772f, 2.3143662340f, 2.3148516745f,
    2.3153370985f, 2.3158225062f, 2.3163078974f, 2.3167932723f, 2.3172786307f,
    2.3177639729f, 2.3182492987f, 2.3187346081f, 2.3192199012f, 2.3197051780f,
    2.3201904384f, 2.3206756826f, 2.3211609105f, 2.3216461221f, 2.3221313174f,
    2.3226164965f, 2.3231016593f, 2.3235868059f, 2.3240719362f, 2.3245570503f,
    2.3250421482f, 2.3255272299f, 2.3260122954f, 2.3264973447f, 2.3269823779f,
    2.3274673949f, 2.3279523957f, 2.3284373804f, 2.3289223489f, 2.3294073013f,
    2.3298922377f, 2.3303771579f, 2.3308620620f, 2.3313469500f, 2.3318318220f,
    2.3323166778f, 2.3328015177f, 2.3332863415f, 2.3337711492f, 2.3342559409f,
    2.3347407166f, 2.3352254763f, 2.3357102200f, 2.3361949477f, 2.3366796595f,
    2.3371643552f, 2.3376490350f, 2.3381336989f, 2.3386183468f, 2.3391029788f,
    2.3395875948f, 2.3400721950f, 2.3405567792f, 2.3410413476f, 2.3415259001f,
    2.3420104367f, 2.3424949574f, 2.3429794623f, 2.3434639514f, 2.3439484246f,
    2.3444328819f, 2.3449173235f, 2.3454017493f, 2.3458861592f, 2.3463705534f,
    2.3468549318f, 2.3473392945f, 2.3478236413f, 2.3483079725f, 2.3487922879f,
    2.3492765875f, 2.3497608715f, 2.3502451397f, 2.3507293922f, 2.3512136291f,
    2.3516978502f, 2.3521820557f, 2.3526662455f, 2.3531504197f, 2.3536345782f,
    2.3541187211f, 2.3546028483f, 2.3550869600f, 2.3555710560f, 2.3560551364f,
    2.3565392013f, 2.3570232506f, 2.3575072843f, 2.3579913024f, 2.3584753050f,
    2.3589592920f, 2.3594432636f, 2.3599272196f, 2.3604111600f, 2.3608950850f,
    2.3613789945f, 2.3618628885f, 2.3623467670f, 2.3628306301f, 2.3633144777f,
    2.3637983098f, 2.3642821265f, 2.3647659278f, 2.3652497136f, 2.3657334841f,
    2.3662172391f, 2.3667009788f, 2.3671847030f, 2.3676684119f, 2.3681521055f,
    2.3686357836f, 2.3691194465f, 2.3696030939f, 2.3700867261f, 2.3705703429f,
    2.3710539445f, 2.3715375307f, 2.3720211016f, 2.3725046573f, 2.3729881976f,
    2.3734717228f, 2.3739552326f, 2.3744387272f, 2.3749222066f, 2.3754056707f,
    2.3758891197f, 2.3763725534f, 2.3768559719f, 2.3773393752f, 2.3778227634f,
    2.3783061363f, 2.3787894941f, 2.3792728368f, 2.3797561643f, 2.3802394766f,
    2.3807227739f, 2.3812060560f, 2.3816893230f, 2.3821725749f, 2.3826558117f,
    2.3831390334f, 2.3836222401f, 2.3841054317f, 2.3845886082f, 2.3850717697f,
    2.3855549162f, 2.3860380476f, 2.3865211640f, 2.3870042653f, 2.3874873517f,
    2.3879704231f, 2.3884534795f, 2.3889365209f, 2.3894195474f, 2.3899025589f,
    2.3903855555f, 2.3908685371f, 2.3913515038f, 2.3918344555f, 2.3923173924f,
    2.3928003143f, 2.3932832213f, 2.3937661135f, 2.3942489908f, 2.3947318532f,
    2.3952147007f, 2.3956975334f, 2.3961803513f, 2.3966631543f, 2.3971459425f,
    2.3976287159f, 2.3981114744f, 2.3985942182f, 2.3990769472f, 2.3995596614f,
    2.4000423608f, 2.4005250455f, 2.4010077154f, 2.4014903705f, 2.4019730109f,
    2.4024556366f, 2.4029382476f, 2.4034208439f, 2.4039034254f, 2.4043859923f,
    2.4048685445f, 2.4053510820f, 2.4058336048f, 2.4063161130f, 2.4067986065f,
    2.4072810854f, 2.4077635496f, 2.4082459992f, 2.4087284343f, 2.4092108547f,
    2.4096932605f, 2.4101756517f, 2.4106580283f, 2.4111403903f, 2.4116227378f,
    2.4121050708f, 2.4125873892f, 2.4130696930f, 2.4135519823f, 2.4140342571f,
    2.4145165174f, 2.4149987632f, 2.4154809945f, 2.4159632113f, 2.4164454136f,
    2.4169276014f, 2.4174097748f, 2.4178919338f, 2.4183740783f, 2.4188562083f,
    2.4193383239f, 2.4198204251f, 2.4203025119f, 2.4207845843f, 2.4212666423f,
    2.4217486860f, 2.4222307152f, 2.4227127301f, 2.4231947306f, 2.4236767167f,
    2.4241586886f, 2.4246406460f, 2.4251225892f, 2.4256045180f, 2.4260864326f,
    2.4265683328f, 2.4270502187f, 2.4275320904f, 2.4280139478f, 2.4284957909f,
    2.4289776197f, 2.4294594344f, 2.4299412347f, 2.4304230208f, 2.4309047927f,
    2.4313865504f, 2.4318682939f, 2.4323500232f, 2.4328317383f, 2.4333134392f,
    2.4337951259f, 2.4342767985f, 2.4347584569f, 2.4352401011f, 2.4357217312f,
    2.4362033472f, 2.4366849491f, 2.4371665368f, 2.4376481104f, 2.4381296700f,
    2.4386112154f, 2.4390927467f, 2.4395742640f, 2.4400557672f, 2.4405372564f,
    2.4410187315f, 2.4415001925f, 2.4419816395f, 2.4424630725f, 2.4429444915f,
    2.4434258965f, 2.4439072874f, 2.4443886644f, 2.4448700274f, 2.4453513764f,
    2.4458327114f, 2.4463140325f, 2.4467953396f, 2.4472766328f, 2.4477579121f,
    2.4482391774f, 2.4487204288f, 2.4492016663f, 2.4496828899f, 2.4501640995f,
    2.4506452953f, 2.4511264773f, 2.4516076453f, 2.4520887995f, 2.4525699398f,
    2.4530510663f, 2.4535321789f, 2.4540132778f, 2.4544943627f, 2.4549754339f,
    2.4554564913f, 2.4559375349f, 2.4564185646f, 2.4568995806f, 2.4573805829f,
    2.4578615713f, 2.4583425460f, 2.4588235070f, 2.4593044542f, 2.4597853876f,
    2.4602663074f, 2.4607472134f, 2.4612281057f, 2.4617089843f, 2.4621898493f,
    2.4626707005f, 2.4631515380f, 2.4636323619f, 2.4641131721f, 2.4645939687f,
    2.4650747516f, 2.4655555209f, 2.4660362766f, 2.4665170186f, 2.4669977470f,
    2.4674784618f, 2.4679591630f, 2.4684398506f, 2.4689205247f, 2.4694011851f,
    2.4698818320f, 2.4703624653f, 2.4708430851f, 2.4713236913f, 2.4718042840f,
    2.4722848632f, 2.4727654288f, 2.4732459810f, 2.4737265196f, 2.4742070447f,
    2.4746875564f, 2.4751680546f, 2.4756485392f, 2.4761290105f, 2.4766094682f,
    2.4770899126f, 2.4775703434f, 2.4780507609f, 2.4785311649f, 2.4790115555f,
    2.4794919327f, 2.4799722964f, 2.4804526468f, 2.4809329838f, 2.4814133075f,
    2.4818936177f, 2.4823739146f, 2.4828541981f, 2.4833344683f, 2.4838147251f,
    2.4842949686f, 2.4847751988f, 2.4852554156f, 2.4857356192f, 2.4862158094f,
    2.4866959864f, 2.4871761501f, 2.4876563004f, 2.4881364375f, 2.4886165614f,
    2.4890966720f, 2.4895767693f, 2.4900568534f, 2.4905369243f, 2.4910169819f,
    2.4914970263f, 2.4919770576f, 2.4924570756f, 2.4929370804f, 2.4934170720f,
    2.4938970504f, 2.4943770157f, 2.4948569678f, 2.4953369068f, 2.4958168326f,
    2.4962967452f, 2.4967766447f, 2.4972565311f, 2.4977364044f, 2.4982162646f,
    2.4986961116f, 2.4991759456f, 2.4996557665f, 2.5001355743f, 2.5006153690f,
    2.5010951506f, 2.5015749192f, 2.5020546748f, 2.5025344172f, 2.5030141467f,
    2.5034938631f, 2.5039735665f, 2.5044532569f, 2.5049329343f, 2.5054125987f,
    2.5058922501f, 2.5063718885f, 2.5068515140f, 2.5073311264f, 2.5078107259f,
    2.5082903125f, 2.5087698861f, 2.5092494467f, 2.5097289945f, 2.5102085293f,
    2.5106880512f, 2.5111675601f, 2.5116470562f, 2.5121265394f, 2.5126060097f,
    2.5130854671f, 2.5135649117f, 2.5140443433f, 2.5145237622f, 2.5150031681f,
    2.5154825613f, 2.5159619415f, 2.5164413090f, 2.5169206636f, 2.5174000055f,
    2.5178793345f, 2.5183586507f, 2.5188379541f, 2.5193172448f, 2.5197965227f,
    2.5202757878f, 2.5207550401f, 2.5212342797f, 2.5217135065f, 2.5221927206f,
    2.5226719220f, 2.5231511106f, 2.5236302865f, 2.5241094497f, 2.5245886002f,
    2.5250677380f, 2.5255468631f, 2.5260259756f, 2.5265050753f, 2.5269841624f,
    2.5274632368f, 2.5279422986f, 2.5284213477f, 2.5289003842f, 2.5293794081f,
    2.5298584193f, 2.5303374180f, 2.5308164040f, 2.5312953774f, 2.5317743382f,
    2.5322532864f, 2.5327322220f, 2.5332111451f, 2.5336900556f, 2.5341689536f,
    2.5346478389f, 2.5351267118f, 2.5356055721f, 2.5360844199f, 2.5365632551f,
    2.5370420779f, 2.5375208881f, 2.5379996858f, 2.5384784711f, 2.5389572438f,
    2.5394360041f, 2.5399147518f, 2.5403934872f, 2.5408722100f, 2.5413509204f,
    2.5418296184f, 2.5423083039f, 2.5427869770f, 2.5432656377f, 2.5437442859f,
    2.5442229218f, 2.5447015452f, 2.5451801563f, 2.5456587549f, 2.5461373412f,
    2.5466159151f, 2.5470944767f, 2.5475730258f, 2.5480515626f, 2.5485300871f,
    2.5490085993f, 2.5494870991f, 2.5499655865f, 2.5504440617f, 2.5509225245f,
    2.5514009751f, 2.5518794133f, 2.5523578393f, 2.5528362530f, 2.5533146544f,
    2.5537930435f, 2.5542714204f, 2.5547497850f, 2.5552281373f, 2.5557064775f,
    2.5561848053f, 2.5566631210f, 2.5571414244f, 2.5576197157f, 2.5580979947f,
    2.5585762615f, 2.5590545161f, 2.5595327586f, 2.5600109888f, 2.5604892069f,
    2.5609674129f, 2.5614456066f, 2.5619237882f, 2.5624019577f, 2.5628801150f,
    2.5633582602f, 2.5638363933f, 2.5643145143f, 2.5647926231f, 2.5652707199f,
    2.5657488045f, 2.5662268771f, 2.5667049376f, 2.5671829860f, 2.5676610223f,
    2.5681390466f, 2.5686170588f, 2.5690950590f, 2.5695730471f, 2.5700510232f,
    2.5705289873f, 2.5710069393f, 2.5714848794f, 2.5719628074f, 2.5724407234f,
    2.5729186274f, 2.5733965195f, 2.5738743995f, 2.5743522676f, 2.5748301238f,
    2.5753079679f, 2.5757858001f, 2.5762636204f, 2.5767414287f, 2.5772192251f,
    2.5776970096f, 2.5781747821f, 2.5786525427f, 2.5791302915f, 2.5796080283f,
    2.5800857532f, 2.5805634663f, 2.5810411674f, 2.5815188567f, 2.5819965342f,
    2.5824741997f, 2.5829518535f, 2.5834294953f, 2.5839071254f, 2.5843847436f,
    2.5848623500f, 2.5853399445f, 2.5858175273f, 2.5862950982f, 2.5867726574f,
    2.5872502047f, 2.5877277403f, 2.5882052641f, 2.5886827761f, 2.5891602763f,
    2.5896377648f, 2.5901152415f, 2.5905927065f, 2.5910701598f, 2.5915476013f,
    2.5920250311f, 2.5925024492f, 2.5929798555f, 2.5934572502f, 2.5939346332f,
    2.5944120044f, 2.5948893640f, 2.5953667119f, 2.5958440481f, 2.5963213727f,
    2.5967986856f, 2.5972759868f, 2.5977532764f, 2.5982305544f, 2.5987078207f,
    2.5991850754f, 2.5996623185f, 2.6001395500f, 2.6006167698f, 2.6010939781f,
    2.6015711747f, 2.6020483598f, 2.6025255333f, 2.6030026952f, 2.6034798456f,
    2.6039569844f, 2.6044341116f, 2.6049112273f, 2.6053883314f, 2.6058654240f,
    2.6063425051f, 2.6068195746f, 2.6072966327f, 2.6077736792f, 2.6082507142f,
    2.6087277377f, 2.6092047498f, 2.6096817503f, 2.6101587394f, 2.6106357170f,
    2.6111126831f, 2.6115896378f, 2.6120665810f, 2.6125435128f, 2.6130204332f,
    2.6134973421f, 2.6139742396f, 2.6144511256f, 2.6149280003f, 2.6154048635f,
    2.6158817154f, 2.6163585558f, 2.6168353849f, 2.6173122025f, 2.6177890088f,
    2.6182658038f, 2.6187425873f, 2.6192193596f, 2.6196961204f, 2.6201728699f,
    2.6206496081f, 2.6211263350f, 2.6216030505f, 2.6220797547f, 2.6225564476f,
    2.6230331292f, 2.6235097995f, 2.6239864585f, 2.6244631062f, 2.6249397427f,
    2.6254163678f, 2.6258929817f, 2.6263695844f, 2.6268461758f, 2.6273227559f,
    2.6277993248f, 2.6282758824f, 2.6287524289f, 2.6292289641f, 2.6297054881f,
    2.6301820008f, 2.6306585024f, 2.6311349928f, 2.6316114720f, 2.6320879399f,
    2.6325643968f, 2.6330408424f, 2.6335172769f, 2.6339937002f, 2.6344701124f,
    2.6349465134f, 2.6354229032f, 2.6358992820f, 2.6363756496f, 2.6368520061f,
    2.6373283514f, 2.6378046857f, 2.6382810088f, 2.6387573209f, 2.6392336218f,
    2.6397099117f, 2.6401861905f, 2.6406624582f, 2.6411387149f, 2.6416149604f,
    2.6420911950f, 2.6425674185f, 2.6430436309f, 2.6435198323f, 2.6439960227f,
    2.6444722020f, 2.6449483704f, 2.6454245277f, 2.6459006740f, 2.6463768093f,
    2.6468529336f, 2.6473290470f, 2.6478051493f, 2.6482812407f, 2.6487573211f,
    2.6492333905f, 2.6497094490f, 2.6501854966f, 2.6506615332f, 2.6511375588f,
    2.6516135735f, 2.6520895773f, 2.6525655702f, 2.6530415521f, 2.6535175232f,
    2.6539934833f, 2.6544694326f, 2.6549453710f, 2.6554212984f, 2.6558972150f,
    2.6563731208f, 2.6568490156f, 2.6573248996f, 2.6578007728f, 2.6582766351f,
    2.6587524865f, 2.6592283271f, 2.6597041569f, 2.6601799759f, 2.6606557840f,
    2.6611315814f, 2.6616073679f, 2.6620831437f, 2.6625589086f, 2.6630346627f,
    2.6635104061f, 2.6639861387f, 2.6644618605f, 2.6649375716f, 2.6654132719f,
    2.6658889614f, 2.6663646403f, 2.6668403083f, 2.6673159657f, 2.6677916123f,
    2.6682672481f, 2.6687428733f, 2.6692184878f, 2.6696940915f, 2.6701696846f,
    2.6706452669f, 2.6711208386f, 2.6715963996f, 2.6720719499f, 2.6725474896f,
    2.6730230186f, 2.6734985369f, 2.6739740446f, 2.6744495416f, 2.6749250280f,
    2.6754005038f, 2.6758759689f, 2.6763514234f, 2.6768268673f, 2.6773023006f,
    2.6777777233f, 2.6782531354f, 2.6787285369f, 2.6792039278f, 2.6796793081f,
    2.6801546779f, 2.6806300371f, 2.6811053857f, 2.6815807238f, 2.6820560513f,
    2.6825313683f, 2.6830066747f, 2.6834819706f, 2.6839572560f, 2.6844325308f,
    2.6849077951f, 2.6853830490f, 2.6858582923f, 2.6863335251f, 2.6868087474f,
    2.6872839593f, 2.6877591606f, 2.6882343515f, 2.6887095319f, 2.6891847019f,
    2.6896598614f, 2.6901350104f, 2.6906101490f, 2.6910852772f, 2.6915603949f,
    2.6920355022f, 2.6925105991f, 2.6929856855f, 2.6934607615f, 2.6939358272f,
    2.6944108824f, 2.6948859272f, 2.6953609617f, 2.6958359858f, 2.6963109995f,
    2.6967860028f, 2.6972609957f, 2.6977359783f, 2.6982109505f, 2.6986859124f,
    2.6991608640f, 2.6996358052f, 2.7001107361f, 2.7005856566f, 2.7010605668f,
    2.7015354667f, 2.7020103564f, 2.7024852357f, 2.7029601047f, 2.7034349634f,
    2.7039098118f, 2.7043846499f, 2.7048594778f, 2.7053342954f, 2.7058091028f,
    2.7062838998f, 2.7067586867f, 2.7072334632f, 2.7077082296f, 2.7081829857f,
    2.7086577316f, 2.7091324672f, 2.7096071927f, 2.7100819079f, 2.7105566129f,
    2.7110313077f, 2.7115059923f, 2.7119806668f, 2.7124553310f, 2.7129299851f,
    2.7134046290f, 2.7138792627f, 2.7143538862f, 2.7148284996f, 2.7153031029f,
    2.7157776960f, 2.7162522790f, 2.7167268518f, 2.7172014145f, 2.7176759671f,
    2.7181505095f, 2.7186250419f, 2.7190995641f, 2.7195740763f, 2.7200485783f,
    2.7205230703f, 2.7209975522f, 2.7214720240f, 2.7219464857f, 2.7224209374f,
    2.7228953789f, 2.7233698105f, 2.7238442320f, 2.7243186434f, 2.7247930448f,
    2.7252674362f, 2.7257418175f, 2.7262161888f, 2.7266905501f, 2.7271649014f,
    2.7276392427f, 2.7281135740f, 2.7285878952f, 2.7290622065f, 2.7295365078f,
    2.7300107992f, 2.7304850805f, 2.7309593519f, 2.7314336133f, 2.7319078648f,
    2.7323821063f, 2.7328563379f, 2.7333305595f, 2.7338047712f, 2.7342789729f,
    2.7347531648f, 2.7352273467f, 2.7357015187f, 2.7361756808f, 2.7366498329f,
    2.7371239752f, 2.7375981076f, 2.7380722301f, 2.7385463428f, 2.7390204455f,
    2.7394945384f, 2.7399686214f, 2.7404426946f, 2.7409167579f, 2.7413908113f,
    2.7418648549f, 2.7423388887f, 2.7428129127f, 2.7432869268f, 2.7437609311f,
    2.7442349255f, 2.7447089102f, 2.7451828850f, 2.7456568501f, 2.7461308054f,
    2.7466047508f, 2.7470786865f, 2.7475526124f, 2.7480265286f, 2.7485004349f,
    2.7489743315f, 2.7494482184f, 2.7499220955f, 2.7503959628f, 2.7508698204f,
    2.7513436683f, 2.7518175064f, 2.7522913348f, 2.7527651535f, 2.7532389625f,
    2.7537127618f, 2.7541865513f, 2.7546603312f, 2.7551341014f, 2.7556078619f,
    2.7560816127f, 2.7565553538f, 2.7570290852f, 2.7575028070f, 2.7579765191f,
    2.7584502216f, 2.7589239144f, 2.7593975976f, 2.7598712711f, 2.7603449350f,
    2.7608185892f, 2.7612922339f, 2.7617658689f, 2.7622394943f, 2.7627131101f,
    2.7631867162f, 2.7636603128f, 2.7641338998f, 2.7646074772f, 2.7650810450f,
    2.7655546033f, 2.7660281520f, 2.7665016911f, 2.7669752206f, 2.7674487406f,
    2.7679222510f, 2.7683957519f, 2.7688692432f, 2.7693427251f, 2.7698161973f,
    2.7702896601f, 2.7707631133f, 2.7712365570f, 2.7717099912f, 2.7721834159f,
    2.7726568311f, 2.7731302368f, 2.7736036330f, 2.7740770198f, 2.7745503970f,
    2.7750237648f, 2.7754971231f, 2.7759704720f, 2.7764438114f, 2.7769171413f,
    2.7773904618f, 2.7778637728f, 2.7783370744f, 2.7788103666f, 2.7792836493f,
    2.7797569227f, 2.7802301866f, 2.7807034411f, 2.7811766862f, 2.7816499218f,
    2.7821231481f, 2.7825963650f, 2.7830695725f, 2.7835427707f, 2.7840159594f,
    2.7844891388f, 2.7849623088f, 2.7854354695f, 2.7859086208f, 2.7863817627f,
    2.7868548953f, 2.7873280186f, 2.7878011325f, 2.7882742371f, 2.7887473324f,
    2.7892204183f, 2.7896934949f, 2.7901665623f, 2.7906396203f, 2.7911126690f,
    2.7915857084f, 2.7920587386f, 2.7925317594f, 2.7930047710f, 2.7934777733f,
    2.7939507663f, 2.7944237501f, 2.7948967246f, 2.7953696898f, 2.7958426458f,
    2.7963155925f, 2.7967885301f, 2.7972614583f, 2.7977343774f, 2.7982072872f,
    2.7986801878f, 2.7991530792f, 2.7996259614f, 2.8000988344f, 2.8005716981f,
    2.8010445527f, 2.8015173981f, 2.8019902343f, 2.8024630613f, 2.8029358792f,
    2.8034086879f, 2.8038814874f, 2.8043542778f, 2.8048270590f, 2.8052998310f,
    2.8057725939f, 2.8062453477f, 2.8067180923f, 2.8071908278f, 2.8076635542f,
    2.8081362715f, 2.8086089796f, 2.8090816787f, 2.8095543686f, 2.8100270494f,
    2.8104997212f, 2.8109723838f, 2.8114450374f, 2.8119176819f, 2.8123903173f,
    2.8128629436f, 2.8133355609f, 2.8138081691f, 2.8142807682f, 2.8147533583f,
    2.8152259394f, 2.8156985114f, 2.8161710744f, 2.8166436283f, 2.8171161732f,
    2.8175887091f, 2.8180612360f, 2.8185337539f, 2.8190062628f, 2.8194787626f,
    2.8199512535f, 2.8204237354f, 2.8208962083f, 2.8213686722f, 2.8218411271f,
    2.8223135731f, 2.8227860100f, 2.8232584381f, 2.8237308571f, 2.8242032672f,
    2.8246756684f, 2.8251480606f, 2.8256204439f, 2.8260928183f, 2.8265651837f,
    2.8270375402f, 2.8275098877f, 2.8279822264f, 2.8284545562f, 2.8289268770f,
    2.8293991890f, 2.8298714920f, 2.8303437862f, 2.8308160714f, 2.8312883478f,
    2.8317606154f, 2.8322328740f, 2.8327051238f, 2.8331773647f, 2.8336495968f,
    2.8341218200f, 2.8345940343f, 2.8350662399f, 2.8355384365f, 2.8360106244f,
    2.8364828034f, 2.8369549736f, 2.8374271350f, 2.8378992876f, 2.8383714313f,
    2.8388435663f, 2.8393156924f, 2.8397878098f, 2.8402599184f, 2.8407320181f,
    2.8412041092f, 2.8416761914f, 2.8421482648f, 2.8426203295f, 2.8430923855f,
    2.8435644326f, 2.8440364711f, 2.8445085007f, 2.8449805217f, 2.8454525338f,
    2.8459245373f, 2.8463965320f, 2.8468685181f, 2.8473404953f, 2.8478124639f,
    2.8482844238f, 2.8487563749f, 2.8492283174f, 2.8497002512f, 2.8501721762f,
    2.8506440926f, 2.8511160003f, 2.8515878994f, 2.8520597897f, 2.8525316714f,
    2.8530035444f, 2.8534754088f, 2.8539472645f, 2.8544191116f, 2.8548909500f,
    2.8553627798f, 2.8558346010f, 2.8563064135f, 2.8567782174f, 2.8572500126f,
    2.8577217993f, 2.8581935774f, 2.8586653468f, 2.8591371076f, 2.8596088599f,
    2.8600806035f, 2.8605523386f, 2.8610240651f, 2.8614957830f, 2.8619674923f,
    2.8624391930f, 2.8629108852f, 2.8633825688f, 2.8638542439f, 2.8643259104f,
    2.8647975684f, 2.8652692179f, 2.8657408587f, 2.8662124911f, 2.8666841149f,
    2.8671557303f, 2.8676273370f, 2.8680989353f, 2.8685705251f, 2.8690421064f,
    2.8695136791f, 2.8699852434f, 2.8704567992f, 2.8709283464f, 2.8713998853f,
    2.8718714156f, 2.8723429374f, 2.8728144508f, 2.8732859557f, 2.8737574522f,
    2.8742289402f, 2.8747004198f, 2.8751718909f, 2.8756433536f, 2.8761148078f,
    2.8765862536f, 2.8770576910f, 2.8775291199f, 2.8780005404f, 2.8784719526f,
    2.8789433563f, 2.8794147516f, 2.8798861385f, 2.8803575170f, 2.8808288871f,
    2.8813002488f, 2.8817716022f, 2.8822429472f, 2.8827142837f, 2.8831856120f,
    2.8836569318f, 2.8841282433f, 2.8845995465f, 2.8850708413f, 2.8855421277f,
    2.8860134058f, 2.8864846756f, 2.8869559371f, 2.8874271902f, 2.8878984349f,
    2.8883696714f, 2.8888408996f, 2.8893121194f, 2.8897833309f, 2.8902545342f,
    2.8907257291f, 2.8911969158f, 2.8916680941f, 2.8921392642f, 2.8926104260f,
    2.8930815795f, 2.8935527247f, 2.8940238617f, 2.8944949904f, 2.8949661109f,
    2.8954372231f, 2.8959083271f, 2.8963794228f, 2.8968505103f, 2.8973215895f,
    2.8977926605f, 2.8982637233f, 2.8987347779f, 2.8992058242f, 2.8996768624f,
    2.9001478923f, 2.9006189140f, 2.9010899275f, 2.9015609329f, 2.9020319300f,
    2.9025029190f, 2.9029738997f, 2.9034448723f, 2.9039158367f, 2.9043867930f,
    2.9048577411f, 2.9053286810f, 2.9057996128f, 2.9062705364f, 2.9067414519f,
    2.9072123592f, 2.9076832584f, 2.9081541495f, 2.9086250324f, 2.9090959072f,
    2.9095667739f, 2.9100376324f, 2.9105084829f, 2.9109793252f, 2.9114501595f,
    2.9119209856f, 2.9123918037f, 2.9128626136f, 2.9133334155f, 2.9138042093f,
    2.9142749950f, 2.9147457727f, 2.9152165423f, 2.9156873038f, 2.9161580572f,
    2.9166288026f, 2.9170995400f, 2.9175702693f, 2.9180409905f, 2.9185117037f,
    2.9189824089f, 2.9194531061f, 2.9199237952f, 2.9203944763f, 2.9208651494f,
    2.9213358145f, 2.9218064715f, 2.9222771206f, 2.9227477617f, 2.9232183947f,
    2.9236890198f, 2.9241596369f, 2.9246302460f, 2.9251008472f, 2.9255714403f,
    2.9260420255f, 2.9265126027f, 2.9269831720f, 2.9274537333f, 2.9279242867f,
    2.9283948321f, 2.9288653695f, 2.9293358990f, 2.9298064206f, 2.9302769343f,
    2.9307474400f, 2.9312179378f, 2.9316884277f, 2.9321589097f, 2.9326293838f,
    2.9330998499f, 2.9335703082f, 2.9340407585f, 2.9345112010f, 2.9349816356f,
    2.9354520623f, 2.9359224811f, 2.9363928920f, 2.9368632951f, 2.9373336903f,
    2.9378040776f, 2.9382744571f, 2.9387448287f, 2.9392151925f, 2.9396855484f,
    2.9401558965f, 2.9406262367f, 2.9410965691f, 2.9415668937f, 2.9420372104f,
    2.9425075194f, 2.9429778205f, 2.9434481138f, 2.9439183993f, 2.9443886770f,
    2.9448589469f, 2.9453292089f, 2.9457994632f, 2.9462697097f, 2.9467399485f,
    2.9472101794f, 2.9476804026f, 2.9481506180f, 2.9486208256f, 2.9490910255f,
    2.9495612176f, 2.9500314020f, 2.9505015786f, 2.9509717474f, 2.9514419085f,
    2.9519120619f, 2.9523822075f, 2.9528523455f, 2.9533224757f, 2.9537925981f,
    2.9542627129f, 2.9547328199f, 2.9552029192f, 2.9556730108f, 2.9561430948f,
    2.9566131710f, 2.9570832395f, 2.9575533004f, 2.9580233535f, 2.9584933990f,
    2.9589634368f, 2.9594334669f, 2.9599034894f, 2.9603735042f, 2.9608435113f,
    2.9613135108f, 2.9617835026f, 2.9622534868f, 2.9627234633f, 2.9631934322f,
    2.9636633935f, 2.9641333471f, 2.9646032931f, 2.9650732315f, 2.9655431623f,
    2.9660130854f, 2.9664830010f, 2.9669529089f, 2.9674228092f, 2.9678927020f,
    2.9683625871f, 2.9688324646f, 2.9693023346f, 2.9697721970f, 2.9702420518f,
    2.9707118990f, 2.9711817386f, 2.9716515707f, 2.9721213952f, 2.9725912122f,
    2.9730610216f, 2.9735308235f, 2.9740006178f, 2.9744704046f, 2.9749401838f,
    2.9754099555f, 2.9758797197f, 2.9763494763f, 2.9768192254f, 2.9772889670f,
    2.9777587011f, 2.9782284277f, 2.9786981468f, 2.9791678584f, 2.9796375624f,
    2.9801072590f, 2.9805769481f, 2.9810466297f, 2.9815163038f, 2.9819859705f,
    2.9824556296f, 2.9829252814f, 2.9833949256f, 2.9838645624f, 2.9843341917f,
    2.9848038135f, 2.9852734280f, 2.9857430349f, 2.9862126344f, 2.9866822265f,
    2.9871518112f, 2.9876213884f, 2.9880909582f, 2.9885605206f, 2.9890300755f,
    2.9894996231f, 2.9899691632f, 2.9904386959f, 2.9909082213f, 2.9913777392f,
    2.9918472497f, 2.9923167529f, 2.9927862486f, 2.9932557370f, 2.9937252180f,
    2.9941946916f, 2.9946641578f, 2.9951336167f, 2.9956030682f, 2.9960725124f,
    2.9965419492f, 2.9970113786f, 2.9974808007f, 2.9979502155f, 2.9984196229f,
    2.9988890230f, 2.9993584158f, 2.9998278012f, 3.0002971793f, 3.0007665501f,
    3.0012359136f, 3.0017052697f, 3.0021746186f, 3.0026439601f, 3.0031132943f,
    3.0035826213f, 3.0040519409f, 3.0045212533f, 3.0049905584f, 3.0054598562f,
    3.0059291467f, 3.0063984300f, 3.0068677059f, 3.0073369747f, 3.0078062361f,
    3.0082754903f, 3.0087447372f, 3.0092139769f, 3.0096832094f, 3.0101524346f,
    3.0106216526f, 3.0110908633f, 3.0115600668f, 3.0120292631f, 3.0124984521f,
    3.0129676339f, 3.0134368086f, 3.0139059760f, 3.0143751362f, 3.0148442892f,
    3.0153134350f, 3.0157825736f, 3.0162517050f, 3.0167208292f, 3.0171899462f,
    3.0176590561f, 3.0181281587f, 3.0185972542f, 3.0190663426f, 3.0195354238f,
    3.0200044978f, 3.0204735646f, 3.0209426243f, 3.0214116769f, 3.0218807223f,
    3.0223497605f, 3.0228187916f, 3.0232878156f, 3.0237568325f, 3.0242258422f,
    3.0246948448f, 3.0251638403f, 3.0256328286f, 3.0261018099f, 3.0265707841f,
    3.0270397511f, 3.0275087110f, 3.0279776639f, 3.0284466096f, 3.0289155483f,
    3.0293844799f, 3.0298534044f, 3.0303223218f, 3.0307912321f, 3.0312601354f,
    3.0317290316f, 3.0321979208f, 3.0326668028f, 3.0331356779f, 3.0336045458f,
    3.0340734068f, 3.0345422607f, 3.0350111075f, 3.0354799473f, 3.0359487801f,
    3.0364176058f, 3.0368864246f, 3.0373552363f, 3.0378240409f, 3.0382928386f,
    3.0387616293f, 3.0392304129f, 3.0396991896f, 3.0401679592f, 3.0406367219f,
    3.0411054775f, 3.0415742262f, 3.0420429679f, 3.0425117026f, 3.0429804303f,
    3.0434491511f, 3.0439178649f, 3.0443865717f, 3.0448552716f, 3.0453239645f,
    3.0457926504f, 3.0462613294f, 3.0467300015f, 3.0471986666f, 3.0476673247f,
    3.0481359760f, 3.0486046203f, 3.0490732576f, 3.0495418881f, 3.0500105116f,
    3.0504791282f, 3.0509477379f, 3.0514163407f, 3.0518849366f, 3.0523535255f,
    3.0528221076f, 3.0532906828f, 3.0537592511f, 3.0542278125f, 3.0546963670f,
    3.0551649146f, 3.0556334554f, 3.0561019892f, 3.0565705162f, 3.0570390364f,
    3.0575075497f, 3.0579760561f, 3.0584445557f, 3.0589130484f, 3.0593815342f,
    3.0598500133f, 3.0603184855f, 3.0607869508f, 3.0612554093f, 3.0617238610f,
    3.0621923058f, 3.0626607439f, 3.0631291751f, 3.0635975995f, 3.0640660171f,
    3.0645344279f, 3.0650028318f, 3.0654712290f, 3.0659396194f, 3.0664080030f,
    3.0668763798f, 3.0673447498f, 3.0678131130f, 3.0682814695f, 3.0687498191f,
    3.0692181620f, 3.0696864982f, 3.0701548275f, 3.0706231501f, 3.0710914660f,
    3.0715597751f, 3.0720280774f, 3.0724963730f, 3.0729646619f, 3.0734329440f,
    3.0739012194f, 3.0743694880f, 3.0748377499f, 3.0753060051f, 3.0757742536f,
    3.0762424953f, 3.0767107304f, 3.0771789587f, 3.0776471803f, 3.0781153952f,
    3.0785836035f, 3.0790518050f, 3.0795199998f, 3.0799881879f, 3.0804563694f,
    3.0809245442f, 3.0813927122f, 3.0818608737f, 3.0823290284f, 3.0827971765f,
    3.0832653179f, 3.0837334526f, 3.0842015807f, 3.0846697022f, 3.0851378170f,
    3.0856059251f, 3.0860740266f, 3.0865421215f, 3.0870102097f, 3.0874782913f,
    3.0879463662f, 3.0884144346f, 3.0888824963f, 3.0893505514f, 3.0898185999f,
    3.0902866417f, 3.0907546770f, 3.0912227056f, 3.0916907277f, 3.0921587431f,
    3.0926267520f, 3.0930947543f, 3.0935627500f, 3.0940307391f, 3.0944987216f,
    3.0949666975f, 3.0954346669f, 3.0959026297f, 3.0963705859f, 3.0968385356f,
    3.0973064787f, 3.0977744153f, 3.0982423453f, 3.0987102688f, 3.0991781857f,
    3.0996460960f, 3.1001139999f, 3.1005818972f, 3.1010497879f, 3.1015176722f,
    3.1019855499f, 3.1024534211f, 3.1029212858f, 3.1033891439f, 3.1038569956f,
    3.1043248407f, 3.1047926794f, 3.1052605115f, 3.1057283372f, 3.1061961563f,
    3.1066639690f, 3.1071317752f, 3.1075995749f, 3.1080673681f, 3.1085351548f,
    3.1090029351f, 3.1094707089f, 3.1099384762f, 3.1104062371f, 3.1108739915f,
    3.1113417395f, 3.1118094810f, 3.1122772161f, 3.1127449447f, 3.1132126669f,
    3.1136803826f, 3.1141480919f, 3.1146157948f, 3.1150834912f, 3.1155511812f,
    3.1160188648f, 3.1164865420f, 3.1169542128f, 3.1174218771f, 3.1178895351f,
    3.1183571866f, 3.1188248318f, 3.1192924705f, 3.1197601029f, 3.1202277288f,
    3.1206953484f, 3.1211629616f, 3.1216305684f, 3.1220981689f, 3.1225657629f,
    3.1230333506f, 3.1235009319f, 3.1239685069f, 3.1244360755f, 3.1249036378f,
    3.1253711937f, 3.1258387432f, 3.1263062864f, 3.1267738233f, 3.1272413538f,
    3.1277088780f, 3.1281763958f, 3.1286439073f, 3.1291114125f, 3.1295789114f,
    3.1300464040f, 3.1305138902f, 3.1309813701f, 3.1314488437f, 3.1319163111f,
    3.1323837721f, 3.1328512268f, 3.1333186752f, 3.1337861173f, 3.1342535531f,
    3.1347209827f, 3.1351884060f, 3.1356558229f, 3.1361232337f, 3.1365906381f,
    3.1370580363f, 3.1375254282f, 3.1379928138f, 3.1384601932f, 3.1389275663f,
    3.1393949332f, 3.1398622938f, 3.1403296482f, 3.1407969963f, 3.1412643382f,
    3.1417316739f, 3.1421990033f, 3.1426663265f, 3.1431336435f, 3.1436009543f,
    3.1440682588f, 3.1445355571f, 3.1450028492f, 3.1454701351f, 3.1459374148f,
    3.1464046883f, 3.1468719556f, 3.1473392167f, 3.1478064716f, 3.1482737203f,
    3.1487409628f, 3.1492081992f, 3.1496754294f, 3.1501426533f, 3.1506098712f,
    3.1510770828f, 3.1515442883f, 3.1520114876f, 3.1524786808f, 3.1529458678f,
    3.1534130486f, 3.1538802233f, 3.1543473919f, 3.1548145543f, 3.1552817106f,
    3.1557488607f, 3.1562160047f, 3.1566831425f, 3.1571502743f, 3.1576173999f,
    3.1580845194f, 3.1585516328f, 3.1590187401f, 3.1594858412f, 3.1599529363f,
    3.1604200252f, 3.1608871080f, 3.1613541848f, 3.1618212554f, 3.1622883200f,
    3.1627553785f, 3.1632224309f, 3.1636894772f, 3.1641565174f, 3.1646235515f,
    3.1650905796f, 3.1655576016f, 3.1660246176f, 3.1664916275f, 3.1669586313f,
    3.1674256291f, 3.1678926208f, 3.1683596064f, 3.1688265861f, 3.1692935596f,
    3.1697605272f, 3.1702274887f, 3.1706944442f, 3.1711613936f, 3.1716283370f,
    3.1720952744f, 3.1725622058f, 3.1730291311f, 3.1734960505f, 3.1739629638f,
    3.1744298711f, 3.1748967724f, 3.1753636678f, 3.1758305571f, 3.1762974404f,
    3.1767643177f, 3.1772311891f, 3.1776980544f, 3.1781649138f, 3.1786317672f,
    3.1790986146f, 3.1795654561f, 3.1800322916f, 3.1804991211f, 3.1809659446f,
    3.1814327622f, 3.1818995739f, 3.1823663795f, 3.1828331793f, 3.1832999731f,
    3.1837667609f, 3.1842335428f, 3.1847003188f, 3.1851670888f, 3.1856338529f,
    3.1861006111f, 3.1865673633f, 3.1870341096f, 3.1875008501f, 3.1879675845f,
    3.1884343131f, 3.1889010358f, 3.1893677526f, 3.1898344634f, 3.1903011684f,
    3.1907678674f, 3.1912345606f, 3.1917012479f, 3.1921679293f, 3.1926346048f,
    3.1931012744f, 3.1935679382f, 3.1940345961f, 3.1945012481f, 3.1949678942f,
    3.1954345345f, 3.1959011689f, 3.1963677974f, 3.1968344201f, 3.1973010370f,
    3.1977676480f, 3.1982342531f, 3.1987008524f, 3.1991674459f, 3.1996340335f,
    3.2001006153f, 3.2005671913f, 3.2010337614f, 3.2015003257f, 3.2019668842f,
    3.2024334369f, 3.2028999837f, 3.2033665248f, 3.2038330600f, 3.2042995894f,
    3.2047661131f, 3.2052326309f, 3.2056991429f, 3.2061656492f, 3.2066321496f,
    3.2070986443f, 3.2075651331f, 3.2080316162f, 3.2084980935f, 3.2089645651f,
    3.2094310308f, 3.2098974908f, 3.2103639451f, 3.2108303935f, 3.2112968363f,
    3.2117632732f, 3.2122297044f, 3.2126961299f, 3.2131625496f, 3.2136289635f,
    3.2140953717f, 3.2145617742f, 3.2150281709f, 3.2154945620f, 3.2159609472f,
    3.2164273268f, 3.2168937006f, 3.2173600687f, 3.2178264311f, 3.2182927878f,
    3.2187591388f, 3.2192254840f, 3.2196918236f, 3.2201581575f, 3.2206244856f,
    3.2210908081f, 3.2215571248f, 3.2220234359f, 3.2224897413f, 3.2229560410f,
    3.2234223351f, 3.2238886234f, 3.2243549061f, 3.2248211831f, 3.2252874544f,
    3.2257537201f, 3.2262199801f, 3.2266862345f, 3.2271524832f, 3.2276187262f,
    3.2280849636f, 3.2285511953f, 3.2290174214f, 3.2294836419f, 3.2299498567f,
    3.2304160659f, 3.2308822695f, 3.2313484674f, 3.2318146597f, 3.2322808464f,
    3.2327470274f, 3.2332132029f, 3.2336793727f, 3.2341455369f, 3.2346116955f,
    3.2350778485f, 3.2355439959f, 3.2360101377f, 3.2364762739f, 3.2369424045f,
    3.2374085295f, 3.2378746490f, 3.2383407628f, 3.2388068711f, 3.2392729738f,
    3.2397390709f, 3.2402051624f, 3.2406712484f, 3.2411373288f, 3.2416034037f,
    3.2420694729f, 3.2425355367f, 3.2430015948f, 3.2434676475f, 3.2439336945f,
    3.2443997361f, 3.2448657720f, 3.2453318025f, 3.2457978274f, 3.2462638468f,
    3.2467298606f, 3.2471958689f, 3.2476618717f, 3.2481278690f, 3.2485938607f,
    3.2490598470f, 3.2495258277f, 3.2499918029f, 3.2504577726f, 3.2509237368f,
    3.2513896955f, 3.2518556487f, 3.2523215964f, 3.2527875386f, 3.2532534753f,
    3.2537194066f, 3.2541853323f, 3.2546512526f, 3.2551171674f, 3.2555830767f,
    3.2560489806f, 3.2565148789f, 3.2569807719f, 3.2574466593f, 3.2579125413f,
    3.2583784178f, 3.2588442889f, 3.2593101545f, 3.2597760147f, 3.2602418694f,
    3.2607077187f, 3.2611735626f, 3.2616394010f, 3.2621052340f, 3.2625710615f,
    3.2630368836f, 3.2635027003f, 3.2639685116f, 3.2644343174f, 3.2649001179f,
    3.2653659129f, 3.2658317025f, 3.2662974867f, 3.2667632655f, 3.2672290389f,
    3.2676948069f, 3.2681605695f, 3.2686263267f, 3.2690920785f, 3.2695578250f,
    3.2700235660f, 3.2704893017f, 3.2709550320f, 3.2714207569f, 3.2718864764f,
    3.2723521906f, 3.2728178994f, 3.2732836028f, 3.2737493009f, 3.2742149936f,
    3.2746806809f, 3.2751463629f, 3.2756120396f, 3.2760777109f, 3.2765433768f,
    3.2770090375f, 3.2774746927f, 3.2779403427f, 3.2784059873f, 3.2788716266f,
    3.2793372605f, 3.2798028891f, 3.2802685124f, 3.2807341304f, 3.2811997431f,
    3.2816653505f, 3.2821309525f, 3.2825965492f, 3.2830621407f, 3.2835277268f,
    3.2839933076f, 3.2844588832f, 3.2849244534f, 3.2853900184f, 3.2858555781f,
    3.2863211324f, 3.2867866815f, 3.2872522254f, 3.2877177639f, 3.2881832972f,
    3.2886488252f, 3.2891143479f, 3.2895798654f, 3.2900453776f, 3.2905108845f,
    3.2909763862f, 3.2914418826f, 3.2919073738f, 3.2923728598f, 3.2928383405f,
    3.2933038159f, 3.2937692861f, 3.2942347511f, 3.2947002108f, 3.2951656653f,
    3.2956311146f, 3.2960965587f, 3.2965619975f, 3.2970274311f, 3.2974928595f,
    3.2979582827f, 3.2984237006f, 3.2988891134f, 3.2993545210f, 3.2998199233f,
    3.3002853205f, 3.3007507124f, 3.3012160992f, 3.3016814807f, 3.3021468571f,
    3.3026122283f, 3.3030775943f, 3.3035429551f, 3.3040083108f, 3.3044736612f,
    3.3049390065f, 3.3054043467f, 3.3058696816f, 3.3063350114f, 3.3068003360f,
    3.3072656555f, 3.3077309698f, 3.3081962790f, 3.3086615830f, 3.3091268819f,
    3.3095921756f, 3.3100574642f, 3.3105227476f, 3.3109880259f, 3.3114532991f,
    3.3119185672f, 3.3123838301f, 3.3128490879f, 3.3133143405f, 3.3137795881f,
    3.3142448305f, 3.3147100678f, 3.3151753000f, 3.3156405271f, 3.3161057491f,
    3.3165709660f, 3.3170361777f, 3.3175013844f, 3.3179665860f, 3.3184317825f,
    3.3188969739f, 3.3193621602f, 3.3198273414f, 3.3202925176f, 3.3207576887f,
    3.3212228547f, 3.3216880156f, 3.3221531714f, 3.3226183222f, 3.3230834679f,
    3.3235486086f, 3.3240137442f, 3.3244788747f, 3.3249440002f, 3.3254091206f,
    3.3258742360f, 3.3263393463f, 3.3268044516f, 3.3272695519f, 3.3277346471f,
    3.3281997373f, 3.3286648224f, 3.3291299025f, 3.3295949776f, 3.3300600477f,
    3.3305251127f, 3.3309901727f, 3.3314552277f, 3.3319202777f, 3.3323853227f,
    3.3328503627f, 3.3333153977f, 3.3337804276f, 3.3342454526f, 3.3347104725f,
    3.3351754875f, 3.3356404975f, 3.3361055025f, 3.3365705025f, 3.3370354975f,
    3.3375004875f, 3.3379654726f, 3.3384304526f, 3.3388954278f, 3.3393603979f,
    3.3398253631f, 3.3402903233f, 3.3407552785f, 3.3412202288f, 3.3416851741f,
    3.3421501145f, 3.3426150499f, 3.3430799803f, 3.3435449058f, 3.3440098264f,
    3.3444747421f, 3.3449396527f, 3.3454045585f, 3.3458694593f, 3.3463343552f,
    3.3467992462f, 3.3472641322f, 3.3477290133f, 3.3481938895f, 3.3486587608f,
    3.3491236272f, 3.3495884886f, 3.3500533451f, 3.3505181968f, 3.3509830435f,
    3.3514478853f, 3.3519127223f, 3.3523775543f, 3.3528423814f, 3.3533072037f,
    3.3537720210f, 3.3542368335f, 3.3547016411f, 3.3551664438f, 3.3556312416f,
    3.3560960346f, 3.3565608227f, 3.3570256059f, 3.3574903842f, 3.3579551577f,
    3.3584199263f, 3.3588846901f, 3.3593494490f, 3.3598142030f, 3.3602789522f,
    3.3607436966f, 3.3612084361f, 3.3616731707f, 3.3621379005f, 3.3626026255f,
    3.3630673457f, 3.3635320610f, 3.3639967714f, 3.3644614771f, 3.3649261779f,
    3.3653908739f, 3.3658555651f, 3.3663202514f, 3.3667849330f, 3.3672496097f,
    3.3677142816f, 3.3681789488f, 3.3686436111f, 3.3691082686f, 3.3695729213f,
    3.3700375692f, 3.3705022123f, 3.3709668506f, 3.3714314842f, 3.3718961129f,
    3.3723607369f, 3.3728253561f, 3.3732899705f, 3.3737545801f, 3.3742191850f,
    3.3746837851f, 3.3751483804f, 3.3756129709f, 3.3760775567f, 3.3765421377f,
    3.3770067140f, 3.3774712855f, 3.3779358523f, 3.3784004143f, 3.3788649715f,
    3.3793295240f, 3.3797940718f, 3.3802586148f, 3.3807231531f, 3.3811876867f,
    3.3816522155f, 3.3821167396f, 3.3825812590f, 3.3830457736f, 3.3835102836f,
    3.3839747888f, 3.3844392892f, 3.3849037850f, 3.3853682761f, 3.3858327624f,
    3.3862972441f, 3.3867617210f, 3.3872261932f, 3.3876906608f, 3.3881551236f,
    3.3886195817f, 3.3890840352f, 3.3895484839f, 3.3900129280f, 3.3904773674f,
    3.3909418021f, 3.3914062322f, 3.3918706575f, 3.3923350782f, 3.3927994942f,
    3.3932639055f, 3.3937283122f, 3.3941927142f, 3.3946571116f, 3.3951215043f,
    3.3955858923f, 3.3960502757f, 3.3965146544f, 3.3969790285f, 3.3974433979f,
    3.3979077627f, 3.3983721229f, 3.3988364784f, 3.3993008292f, 3.3997651755f,
    3.4002295171f, 3.4006938541f, 3.4011581864f, 3.4016225142f, 3.4020868373f,
    3.4025511558f, 3.4030154696f, 3.4034797789f, 3.4039440835f, 3.4044083836f,
    3.4048726790f, 3.4053369698f, 3.4058012561f, 3.4062655377f, 3.4067298147f,
    3.4071940872f, 3.4076583550f, 3.4081226183f, 3.4085868770f, 3.4090511311f,
    3.4095153806f, 3.4099796255f, 3.4104438659f, 3.4109081017f, 3.4113723329f,
    3.4118365595f, 3.4123007816f, 3.4127649991f, 3.4132292121f, 3.4136934205f,
    3.4141576243f, 3.4146218236f, 3.4150860183f, 3.4155502085f, 3.4160143941f,
    3.4164785752f, 3.4169427518f, 3.4174069238f, 3.4178710913f, 3.4183352542f,
    3.4187994126f, 3.4192635665f, 3.4197277159f, 3.4201918607f, 3.4206560010f,
    3.4211201368f, 3.4215842681f, 3.4220483948f, 3.4225125171f, 3.4229766348f,
    3.4234407480f, 3.4239048568f, 3.4243689610f, 3.4248330607f, 3.4252971560f,
    3.4257612467f, 3.4262253329f, 3.4266894147f, 3.4271534919f, 3.4276175647f,
    3.4280816330f, 3.4285456968f, 3.4290097562f, 3.4294738110f, 3.4299378614f,
    3.4304019073f, 3.4308659488f, 3.4313299858f, 3.4317940183f, 3.4322580464f,
    3.4327220700f, 3.4331860891f, 3.4336501038f, 3.4341141141f, 3.4345781199f,
    3.4350421212f, 3.4355061181f, 3.4359701106f, 3.4364340986f, 3.4368980822f,
    3.4373620614f, 3.4378260361f, 3.4382900064f, 3.4387539723f, 3.4392179337f,
    3.4396818907f, 3.4401458433f, 3.4406097915f, 3.4410737353f, 3.4415376746f,
    3.4420016096f, 3.4424655401f, 3.4429294663f, 3.4433933880f, 3.4438573054f,
    3.4443212183f, 3.4447851268f, 3.4452490310f, 3.4457129307f, 3.4461768261f,
    3.4466407171f, 3.4471046037f, 3.4475684859f, 3.4480323638f, 3.4484962372f,
    3.4489601063f, 3.4494239710f, 3.4498878314f, 3.4503516874f, 3.4508155390f,
    3.4512793863f, 3.4517432292f, 3.4522070677f, 3.4526709019f, 3.4531347317f,
    3.4535985572f, 3.4540623784f, 3.4545261951f, 3.4549900076f, 3.4554538157f,
    3.4559176195f, 3.4563814189f, 3.4568452140f, 3.4573090048f, 3.4577727912f,
    3.4582365733f, 3.4587003511f, 3.4591641246f, 3.4596278938f, 3.4600916586f,
    3.4605554191f, 3.4610191753f, 3.4614829272f, 3.4619466748f, 3.4624104181f,
    3.4628741571f, 3.4633378918f, 3.4638016222f, 3.4642653483f, 3.4647290701f,
    3.4651927876f, 3.4656565008f, 3.4661202097f, 3.4665839144f, 3.4670476147f,
    3.4675113108f, 3.4679750026f, 3.4684386902f, 3.4689023734f, 3.4693660524f,
    3.4698297272f, 3.4702933976f, 3.4707570638f, 3.4712207258f, 3.4716843834f,
    3.4721480369f, 3.4726116860f, 3.4730753310f, 3.4735389716f, 3.4740026081f,
    3.4744662403f, 3.4749298682f, 3.4753934919f, 3.4758571114f, 3.4763207266f,
    3.4767843376f, 3.4772479444f, 3.4777115469f, 3.4781751452f, 3.4786387393f,
    3.4791023292f, 3.4795659148f, 3.4800294963f, 3.4804930735f, 3.4809566465f,
    3.4814202153f, 3.4818837799f, 3.4823473403f, 3.4828108965f, 3.4832744485f,
    3.4837379963f, 3.4842015399f, 3.4846650793f, 3.4851286145f, 3.4855921455f,
    3.4860556723f, 3.4865191950f, 3.4869827135f, 3.4874462277f, 3.4879097379f,
    3.4883732438f, 3.4888367456f, 3.4893002432f, 3.4897637366f, 3.4902272259f,
    3.4906907110f, 3.4911541919f, 3.4916176687f, 3.4920811413f, 3.4925446098f,
    3.4930080741f, 3.4934715343f, 3.4939349903f, 3.4943984422f, 3.4948618899f,
    3.4953253335f, 3.4957887730f, 3.4962522083f, 3.4967156395f, 3.4971790666f,
    3.4976424895f, 3.4981059083f, 3.4985693230f, 3.4990327335f, 3.4994961400f,
    3.4999595423f, 3.5004229405f, 3.5008863346f, 3.5013497246f, 3.5018131104f,
    3.5022764922f, 3.5027398699f, 3.5032032434f, 3.5036666129f, 3.5041299782f,
    3.5045933395f, 3.5050566967f, 3.5055200498f, 3.5059833988f, 3.5064467437f,
    3.5069100845f, 3.5073734213f, 3.5078367539f, 3.5083000825f, 3.5087634070f,
    3.5092267275f, 3.5096900439f, 3.5101533562f, 3.5106166644f, 3.5110799686f,
    3.5115432687f, 3.5120065648f, 3.5124698568f, 3.5129331447f, 3.5133964286f,
    3.5138597085f, 3.5143229842f, 3.5147862560f, 3.5152495237f, 3.5157127874f,
    3.5161760470f, 3.5166393026f, 3.5171025542f, 3.5175658017f, 3.5180290452f,
    3.5184922846f, 3.5189555201f, 3.5194187515f, 3.5198819789f, 3.5203452023f,
    3.5208084217f, 3.5212716370f, 3.5217348483f, 3.5221980557f, 3.5226612590f,
    3.5231244583f, 3.5235876536f, 3.5240508449f, 3.5245140323f, 3.5249772156f,
    3.5254403949f, 3.5259035702f, 3.5263667416f, 3.5268299089f, 3.5272930723f,
    3.5277562317f, 3.5282193871f, 3.5286825385f, 3.5291456860f, 3.5296088294f,
    3.5300719689f, 3.5305351045f, 3.5309982360f, 3.5314613636f, 3.5319244873f,
    3.5323876069f, 3.5328507227f, 3.5333138344f, 3.5337769422f, 3.5342400461f,
    3.5347031460f, 3.5351662419f, 3.5356293339f, 3.5360924220f, 3.5365555061f,
    3.5370185863f, 3.5374816626f, 3.5379447349f, 3.5384078032f, 3.5388708677f,
    3.5393339282f, 3.5397969848f, 3.5402600375f, 3.5407230862f, 3.5411861311f,
    3.5416491720f, 3.5421122090f, 3.5425752421f, 3.5430382712f, 3.5435012965f,
    3.5439643179f, 3.5444273353f, 3.5448903489f, 3.5453533585f, 3.5458163643f,
    3.5462793661f, 3.5467423641f, 3.5472053582f, 3.5476683484f, 3.5481313347f,
    3.5485943171f, 3.5490572956f, 3.5495202702f, 3.5499832410f, 3.5504462079f,
    3.5509091709f, 3.5513721301f, 3.5518350854f, 3.5522980368f, 3.5527609843f,
    3.5532239280f, 3.5536868678f, 3.5541498038f, 3.5546127359f, 3.5550756642f,
    3.5555385886f, 3.5560015091f, 3.5564644258f, 3.5569273387f, 3.5573902477f,
    3.5578531529f, 3.5583160542f, 3.5587789517f, 3.5592418453f, 3.5597047352f,
    3.5601676212f, 3.5606305033f, 3.5610933817f, 3.5615562562f, 3.5620191269f,
    3.5624819937f, 3.5629448568f, 3.5634077160f, 3.5638705714f, 3.5643334231f,
    3.5647962709f, 3.5652591149f, 3.5657219550f, 3.5661847914f, 3.5666476240f,
    3.5671104528f, 3.5675732778f, 3.5680360990f, 3.5684989164f, 3.5689617300f,
    3.5694245398f, 3.5698873459f, 3.5703501481f, 3.5708129466f, 3.5712757413f,
    3.5717385322f, 3.5722013193f, 3.5726641027f, 3.5731268823f, 3.5735896581f,
    3.5740524301f, 3.5745151984f, 3.5749779630f, 3.5754407237f, 3.5759034807f,
    3.5763662340f, 3.5768289835f, 3.5772917292f, 3.5777544712f, 3.5782172094f,
    3.5786799439f, 3.5791426747f, 3.5796054017f, 3.5800681250f, 3.5805308445f,
    3.5809935603f, 3.5814562724f, 3.5819189807f, 3.5823816853f, 3.5828443862f,
    3.5833070833f, 3.5837697768f, 3.5842324665f, 3.5846951525f, 3.5851578347f,
    3.5856205133f, 3.5860831881f, 3.5865458593f, 3.5870085267f, 3.5874711904f,
    3.5879338504f, 3.5883965067f, 3.5888591593f, 3.5893218083f, 3.5897844535f,
    3.5902470950f, 3.5907097328f, 3.5911723670f, 3.5916349974f, 3.5920976242f,
    3.5925602473f, 3.5930228667f, 3.5934854824f, 3.5939480944f, 3.5944107028f,
    3.5948733075f, 3.5953359085f, 3.5957985059f, 3.5962610996f, 3.5967236896f,
    3.5971862760f, 3.5976488587f, 3.5981114377f, 3.5985740131f, 3.5990365848f,
    3.5994991529f, 3.5999617173f, 3.6004242781f, 3.6008868352f, 3.6013493887f,
    3.6018119386f, 3.6022744848f, 3.6027370273f, 3.6031995663f, 3.6036621016f,
    3.6041246332f, 3.6045871613f, 3.6050496857f, 3.6055122065f, 3.6059747236f,
    3.6064372371f, 3.6068997471f, 3.6073622534f, 3.6078247560f, 3.6082872551f,
    3.6087497506f, 3.6092122424f, 3.6096747307f, 3.6101372153f, 3.6105996963f,
    3.6110621737f, 3.6115246476f, 3.6119871178f, 3.6124495844f, 3.6129120475f,
    3.6133745069f, 3.6138369628f, 3.6142994151f, 3.6147618638f, 3.6152243089f,
    3.6156867504f, 3.6161491883f, 3.6166116227f, 3.6170740535f, 3.6175364807f,
    3.6179989044f, 3.6184613245f, 3.6189237410f, 3.6193861539f, 3.6198485633f,
    3.6203109691f, 3.6207733714f, 3.6212357701f, 3.6216981653f, 3.6221605569f,
    3.6226229449f, 3.6230853294f, 3.6235477104f, 3.6240100878f, 3.6244724617f,
    3.6249348320f, 3.6253971988f, 3.6258595620f, 3.6263219217f, 3.6267842779f,
    3.6272466306f, 3.6277089797f, 3.6281713253f, 3.6286336674f, 3.6290960059f,
    3.6295583410f, 3.6300206725f, 3.6304830005f, 3.6309453249f, 3.6314076459f,
    3.6318699634f, 3.6323322773f, 3.6327945878f, 3.6332568947f, 3.6337191981f,
    3.6341814981f, 3.6346437945f, 3.6351060874f, 3.6355683769f, 3.6360306628f,
    3.6364929453f, 3.6369552243f, 3.6374174997f, 3.6378797717f, 3.6383420402f,
    3.6388043053f, 3.6392665668f, 3.6397288249f, 3.6401910795f, 3.6406533306f,
    3.6411155783f, 3.6415778225f, 3.6420400632f, 3.6425023005f, 3.6429645343f,
    3.6434267646f, 3.6438889915f, 3.6443512149f, 3.6448134349f, 3.6452756514f,
    3.6457378644f, 3.6462000740f, 3.6466622802f, 3.6471244829f, 3.6475866822f,
    3.6480488780f, 3.6485110704f, 3.6489732594f, 3.6494354449f, 3.6498976270f,
    3.6503598056f, 3.6508219808f, 3.6512841526f, 3.6517463210f, 3.6522084859f,
    3.6526706475f, 3.6531328056f, 3.6535949603f, 3.6540571115f, 3.6545192594f,
    3.6549814038f, 3.6554435449f, 3.6559056825f, 3.6563678167f, 3.6568299475f,
    3.6572920749f, 3.6577541989f, 3.6582163196f, 3.6586784368f, 3.6591405506f,
    3.6596026610f, 3.6600647681f, 3.6605268717f, 3.6609889720f, 3.6614510689f,
    3.6619131624f, 3.6623752525f, 3.6628373392f, 3.6632994226f, 3.6637615026f,
    3.6642235792f, 3.6646856524f, 3.6651477223f, 3.6656097888f, 3.6660718519f,
    3.6665339117f, 3.6669959681f, 3.6674580212f, 3.6679200708f, 3.6683821172f,
    3.6688441602f, 3.6693061998f, 3.6697682361f, 3.6702302690f, 3.6706922986f,
    3.6711543249f, 3.6716163478f, 3.6720783673f, 3.6725403835f, 3.6730023964f,
    3.6734644060f, 3.6739264122f, 3.6743884151f, 3.6748504146f, 3.6753124109f,
    3.6757744038f, 3.6762363934f, 3.6766983796f, 3.6771603626f, 3.6776223422f,
    3.6780843185f, 3.6785462915f, 3.6790082612f, 3.6794702276f, 3.6799321906f,
    3.6803941504f, 3.6808561068f, 3.6813180600f, 3.6817800098f, 3.6822419564f,
    3.6827038997f, 3.6831658396f, 3.6836277763f, 3.6840897097f, 3.6845516398f,
    3.6850135666f, 3.6854754901f, 3.6859374103f, 3.6863993273f, 3.6868612410f,
    3.6873231514f, 3.6877850585f, 3.6882469623f, 3.6887088629f, 3.6891707602f,
    3.6896326543f, 3.6900945450f, 3.6905564325f, 3.6910183168f, 3.6914801978f,
    3.6919420755f, 3.6924039500f, 3.6928658212f, 3.6933276891f, 3.6937895539f,
    3.6942514153f, 3.6947132735f, 3.6951751285f, 3.6956369802f, 3.6960988287f,
    3.6965606739f, 3.6970225160f, 3.6974843547f, 3.6979461903f, 3.6984080226f,
    3.6988698516f, 3.6993316775f, 3.6997935001f, 3.7002553195f, 3.7007171357f,
    3.7011789486f, 3.7016407583f, 3.7021025648f, 3.7025643681f, 3.7030261682f,
    3.7034879651f, 3.7039497588f, 3.7044115492f, 3.7048733365f, 3.7053351205f,
    3.7057969013f, 3.7062586790f, 3.7067204534f, 3.7071822247f, 3.7076439927f,
    3.7081057576f, 3.7085675192f, 3.7090292777f, 3.7094910330f, 3.7099527851f,
    3.7104145340f, 3.7108762797f, 3.7113380223f, 3.7117997617f, 3.7122614979f,
    3.7127232309f, 3.7131849607f, 3.7136466874f, 3.7141084109f, 3.7145701313f,
    3.7150318485f, 3.7154935625f, 3.7159552733f, 3.7164169810f, 3.7168786855f,
    3.7173403869f, 3.7178020852f, 3.7182637802f, 3.7187254721f, 3.7191871609f,
    3.7196488465f, 3.7201105290f, 3.7205722084f, 3.7210338846f, 3.7214955576f,
    3.7219572275f, 3.7224188943f, 3.7228805580f, 3.7233422185f, 3.7238038759f,
    3.7242655301f, 3.7247271812f, 3.7251888292f, 3.7256504741f, 3.7261121159f,
    3.7265737545f, 3.7270353900f, 3.7274970225f, 3.7279586517f, 3.7284202779f,
    3.7288819010f, 3.7293435210f, 3.7298051378f, 3.7302667516f, 3.7307283622f,
    3.7311899697f, 3.7316515742f, 3.7321131755f, 3.7325747738f, 3.7330363689f,
    3.7334979610f, 3.7339595500f, 3.7344211359f, 3.7348827187f, 3.7353442984f,
    3.7358058750f, 3.7362674486f, 3.7367290190f, 3.7371905864f, 3.7376521507f,
    3.7381137120f, 3.7385752701f, 3.7390368252f, 3.7394983773f, 3.7399599262f,
    3.7404214721f, 3.7408830149f, 3.7413445547f, 3.7418060914f, 3.7422676251f,
    3.7427291557f, 3.7431906832f, 3.7436522077f, 3.7441137291f, 3.7445752475f,
    3.7450367629f, 3.7454982752f, 3.7459597844f, 3.7464212906f, 3.7468827938f,
    3.7473442939f, 3.7478057910f, 3.7482672851f, 3.7487287761f, 3.7491902641f,
    3.7496517491f, 3.7501132310f, 3.7505747100f, 3.7510361858f, 3.7514976587f,
    3.7519591286f, 3.7524205954f, 3.7528820592f, 3.7533435200f, 3.7538049778f,
    3.7542664326f, 3.7547278843f, 3.7551893331f, 3.7556507788f, 3.7561122216f,
    3.7565736613f, 3.7570350981f, 3.7574965318f, 3.7579579625f, 3.7584193903f,
    3.7588808150f, 3.7593422368f, 3.7598036556f, 3.7602650714f, 3.7607264842f,
    3.7611878940f, 3.7616493008f, 3.7621107046f, 3.7625721055f, 3.7630335034f,
    3.7634948983f, 3.7639562903f, 3.7644176792f, 3.7648790652f, 3.7653404482f,
    3.7658018283f, 3.7662632054f, 3.7667245795f, 3.7671859507f, 3.7676473189f,
    3.7681086842f, 3.7685700465f, 3.7690314058f, 3.7694927622f, 3.7699541156f,
    3.7704154661f, 3.7708768136f, 3.7713381582f, 3.7717994999f, 3.7722608386f,
    3.7727221743f, 3.7731835071f, 3.7736448370f, 3.7741061640f, 3.7745674880f,
    3.7750288091f, 3.7754901272f, 3.7759514424f, 3.7764127547f, 3.7768740641f,
    3.7773353705f, 3.7777966741f, 3.7782579747f, 3.7787192724f, 3.7791805671f,
    3.7796418590f, 3.7801031479f, 3.7805644339f, 3.7810257171f, 3.7814869973f,
    3.7819482746f, 3.7824095490f, 3.7828708205f, 3.7833320891f, 3.7837933548f,
    3.7842546176f, 3.7847158775f, 3.7851771345f, 3.7856383886f, 3.7860996398f,
    3.7865608882f, 3.7870221336f, 3.7874833762f, 3.7879446159f, 3.7884058527f,
    3.7888670866f, 3.7893283176f, 3.7897895458f, 3.7902507711f, 3.7907119935f,
    3.7911732130f, 3.7916344297f, 3.7920956435f, 3.7925568544f, 3.7930180625f,
    3.7934792677f, 3.7939404701f, 3.7944016696f, 3.7948628662f, 3.7953240600f,
    3.7957852509f, 3.7962464390f, 3.7967076242f, 3.7971688065f, 3.7976299861f,
    3.7980911627f, 3.7985523366f, 3.7990135075f, 3.7994746757f, 3.7999358410f,
    3.8003970035f, 3.8008581631f, 3.8013193199f, 3.8017804739f, 3.8022416250f,
    3.8027027733f, 3.8031639188f, 3.8036250614f, 3.8040862013f, 3.8045473383f,
    3.8050084725f, 3.8054696038f, 3.8059307324f, 3.8063918581f, 3.8068529810f,
    3.8073141011f, 3.8077752184f, 3.8082363329f, 3.8086974446f, 3.8091585535f,
    3.8096196596f, 3.8100807628f, 3.8105418633f, 3.8110029610f, 3.8114640559f,
    3.8119251479f, 3.8123862372f, 3.8128473237f, 3.8133084074f, 3.8137694884f,
    3.8142305665f, 3.8146916418f, 3.8151527144f, 3.8156137842f, 3.8160748512f,
    3.8165359154f, 3.8169969768f, 3.8174580355f, 3.8179190914f, 3.8183801445f,
    3.8188411949f, 3.8193022425f, 3.8197632873f, 3.8202243294f, 3.8206853687f,
    3.8211464052f, 3.8216074390f, 3.8220684700f, 3.8225294982f, 3.8229905237f,
    3.8234515465f, 3.8239125665f, 3.8243735837f, 3.8248345982f, 3.8252956100f,
    3.8257566190f, 3.8262176253f, 3.8266786288f, 3.8271396296f, 3.8276006276f,
    3.8280616229f, 3.8285226155f, 3.8289836053f, 3.8294445925f, 3.8299055768f,
    3.8303665585f, 3.8308275374f, 3.8312885136f, 3.8317494871f, 3.8322104578f,
    3.8326714259f, 3.8331323912f, 3.8335933538f, 3.8340543137f, 3.8345152708f,
    3.8349762253f, 3.8354371771f, 3.8358981261f, 3.8363590724f, 3.8368200161f,
    3.8372809570f, 3.8377418952f, 3.8382028307f, 3.8386637636f, 3.8391246937f,
    3.8395856211f, 3.8400465459f, 3.8405074679f, 3.8409683873f, 3.8414293039f,
    3.8418902179f, 3.8423511292f, 3.8428120378f, 3.8432729438f, 3.8437338470f,
    3.8441947476f, 3.8446556455f, 3.8451165407f, 3.8455774332f, 3.8460383231f,
    3.8464992103f, 3.8469600948f, 3.8474209767f, 3.8478818559f, 3.8483427324f,
    3.8488036063f, 3.8492644775f, 3.8497253461f, 3.8501862120f, 3.8506470752f,
    3.8511079358f, 3.8515687937f, 3.8520296490f, 3.8524905016f, 3.8529513516f,
    3.8534121990f, 3.8538730437f, 3.8543338857f, 3.8547947251f, 3.8552555619f,
    3.8557163960f, 3.8561772275f, 3.8566380564f, 3.8570988826f, 3.8575597062f,
    3.8580205272f, 3.8584813455f, 3.8589421612f, 3.8594029743f, 3.8598637847f,
    3.8603245926f, 3.8607853978f, 3.8612462004f, 3.8617070004f, 3.8621677977f,
    3.8626285925f, 3.8630893846f, 3.8635501742f, 3.8640109611f, 3.8644717454f,
    3.8649325271f, 3.8653933062f, 3.8658540827f, 3.8663148566f, 3.8667756279f,
    3.8672363966f, 3.8676971627f, 3.8681579262f, 3.8686186872f, 3.8690794455f,
    3.8695402012f, 3.8700009544f, 3.8704617049f, 3.8709224529f, 3.8713831983f,
    3.8718439411f, 3.8723046814f, 3.8727654190f, 3.8732261541f, 3.8736868866f,
    3.8741476165f, 3.8746083439f, 3.8750690687f, 3.8755297909f, 3.8759905105f,
    3.8764512276f, 3.8769119421f, 3.8773726541f, 3.8778333635f, 3.8782940703f,
    3.8787547746f, 3.8792154763f, 3.8796761755f, 3.8801368721f, 3.8805975661f,
    3.8810582576f, 3.8815189466f, 3.8819796330f, 3.8824403169f, 3.8829009982f,
    3.8833616770f, 3.8838223532f, 3.8842830270f, 3.8847436981f, 3.8852043668f,
    3.8856650329f, 3.8861256964f, 3.8865863575f, 3.8870470160f, 3.8875076719f,
    3.8879683254f, 3.8884289763f, 3.8888896247f, 3.8893502706f, 3.8898109140f,
    3.8902715548f, 3.8907321931f, 3.8911928289f, 3.8916534622f, 3.8921140930f,
    3.8925747213f, 3.8930353471f, 3.8934959703f, 3.8939565911f, 3.8944172093f,
    3.8948778251f, 3.8953384383f, 3.8957990490f, 3.8962596573f, 3.8967202630f,
    3.8971808663f, 3.8976414670f, 3.8981020653f, 3.8985626611f, 3.8990232544f,
    3.8994838452f, 3.8999444335f, 3.9004050193f, 3.9008656027f, 3.9013261836f,
    3.9017867619f, 3.9022473379f, 3.9027079113f, 3.9031684823f, 3.9036290507f,
    3.9040896168f, 3.9045501803f, 3.9050107414f, 3.9054713000f, 3.9059318561f,
    3.9063924098f, 3.9068529610f, 3.9073135098f, 3.9077740561f, 3.9082345999f,
    3.9086951413f, 3.9091556803f, 3.9096162167f, 3.9100767508f, 3.9105372823f,
    3.9109978115f, 3.9114583382f, 3.9119188624f, 3.9123793842f, 3.9128399035f,
    3.9133004204f, 3.9137609349f, 3.9142214469f, 3.9146819565f, 3.9151424637f,
    3.9156029684f, 3.9160634707f, 3.9165239706f, 3.9169844680f, 3.9174449630f,
    3.9179054556f, 3.9183659458f, 3.9188264335f, 3.9192869189f, 3.9197474018f,
    3.9202078822f, 3.9206683603f, 3.9211288360f, 3.9215893092f, 3.9220497800f,
    3.9225102484f, 3.9229707145f, 3.9234311781f, 3.9238916393f, 3.9243520980f,
    3.9248125544f, 3.9252730084f, 3.9257334600f, 3.9261939092f, 3.9266543560f,
    3.9271148004f, 3.9275752424f, 3.9280356820f, 3.9284961193f, 3.9289565541f,
    3.9294169865f, 3.9298774166f, 3.9303378443f, 3.9307982696f, 3.9312586925f,
    3.9317191130f, 3.9321795312f, 3.9326399470f, 3.9331003604f, 3.9335607714f,
    3.9340211801f, 3.9344815864f, 3.9349419903f, 3.9354023918f, 3.9358627910f,
    3.9363231879f, 3.9367835823f, 3.9372439744f, 3.9377043642f, 3.9381647515f,
    3.9386251366f, 3.9390855192f, 3.9395458995f, 3.9400062775f, 3.9404666531f,
    3.9409270264f, 3.9413873973f, 3.9418477659f, 3.9423081321f, 3.9427684960f,
    3.9432288575f, 3.9436892167f, 3.9441495735f, 3.9446099281f, 3.9450702802f,
    3.9455306301f, 3.9459909776f, 3.9464513228f, 3.9469116656f, 3.9473720062f,
    3.9478323444f, 3.9482926802f, 3.9487530138f, 3.9492133450f, 3.9496736739f,
    3.9501340005f, 3.9505943248f, 3.9510546467f, 3.9515149664f, 3.9519752837f,
    3.9524355987f, 3.9528959114f, 3.9533562218f, 3.9538165299f, 3.9542768356f,
    3.9547371391f, 3.9551974403f, 3.9556577392f, 3.9561180357f, 3.9565783300f,
    3.9570386220f, 3.9574989116f, 3.9579591990f, 3.9584194841f, 3.9588797669f,
    3.9593400474f, 3.9598003256f, 3.9602606016f, 3.9607208752f, 3.9611811466f,
    3.9616414157f, 3.9621016825f, 3.9625619470f, 3.9630222092f, 3.9634824692f,
    3.9639427269f, 3.9644029823f, 3.9648632354f, 3.9653234863f, 3.9657837349f,
    3.9662439812f, 3.9667042253f, 3.9671644671f, 3.9676247067f, 3.9680849439f,
    3.9685451790f, 3.9690054117f, 3.9694656422f, 3.9699258705f, 3.9703860965f,
    3.9708463202f, 3.9713065417f, 3.9717667609f, 3.9722269779f, 3.9726871926f,
    3.9731474051f, 3.9736076154f, 3.9740678234f, 3.9745280292f, 3.9749882327f,
    3.9754484340f, 3.9759086330f, 3.9763688298f, 3.9768290244f, 3.9772892168f,
    3.9777494069f, 3.9782095948f, 3.9786697804f, 3.9791299639f, 3.9795901451f,
    3.9800503241f, 3.9805105008f, 3.9809706754f, 3.9814308477f, 3.9818910178f,
    3.9823511857f, 3.9828113513f, 3.9832715148f, 3.9837316760f, 3.9841918351f,
    3.9846519919f, 3.9851121465f, 3.9855722989f, 3.9860324491f, 3.9864925971f,
    3.9869527429f, 3.9874128865f, 3.9878730279f, 3.9883331671f, 3.9887933041f,
    3.9892534389f, 3.9897135715f, 3.9901737020f, 3.9906338302f, 3.9910939562f,
    3.9915540801f, 3.9920142017f, 3.9924743212f, 3.9929344385f, 3.9933945536f,
    3.9938546666f, 3.9943147773f, 3.9947748859f, 3.9952349923f, 3.9956950965f,
    3.9961551986f, 3.9966152985f, 3.9970753962f, 3.9975354917f, 3.9979955851f,
    3.9984556763f, 3.9989157654f, 3.9993758522f, 3.9998359370f, 4.0002960195f,
    4.0007560999f, 4.0012161781f, 4.0016762542f, 4.0021363282f, 4.0025963999f,
    4.0030564696f, 4.0035165370f, 4.0039766024f, 4.0044366655f, 4.0048967266f,
    4.0053567854f, 4.0058168422f, 4.0062768968f, 4.0067369492f, 4.0071969996f,
    4.0076570477f, 4.0081170938f, 4.0085771377f, 4.0090371795f, 4.0094972191f,
    4.0099572566f, 4.0104172920f, 4.0108773252f, 4.0113373564f, 4.0117973854f,
    4.0122574123f, 4.0127174370f, 4.0131774596f, 4.0136374802f, 4.0140974986f,
    4.0145575148f, 4.0150175290f, 4.0154775411f, 4.0159375510f, 4.0163975588f,
    4.0168575645f, 4.0173175681f, 4.0177775696f, 4.0182375690f, 4.0186975663f,
    4.0191575615f, 4.0196175546f, 4.0200775456f, 4.0205375345f, 4.0209975213f,
    4.0214575060f, 4.0219174886f, 4.0223774691f, 4.0228374475f, 4.0232974239f,
    4.0237573981f, 4.0242173703f, 4.0246773403f, 4.0251373083f, 4.0255972742f,
    4.0260572380f, 4.0265171998f, 4.0269771594f, 4.0274371170f, 4.0278970725f,
    4.0283570259f, 4.0288169773f, 4.0292769266f, 4.0297368738f, 4.0301968189f,
    4.0306567620f, 4.0311167030f, 4.0315766420f, 4.0320365789f, 4.0324965137f,
    4.0329564464f, 4.0334163771f, 4.0338763058f, 4.0343362324f, 4.0347961569f,
    4.0352560794f, 4.0357159998f, 4.0361759182f, 4.0366358345f, 4.0370957488f,
    4.0375556610f, 4.0380155712f, 4.0384754793f, 4.0389353854f, 4.0393952895f,
    4.0398551915f, 4.0403150915f, 4.0407749894f, 4.0412348853f, 4.0416947792f,
    4.0421546710f, 4.0426145608f, 4.0430744486f, 4.0435343343f, 4.0439942180f,
    4.0444540997f, 4.0449139794f, 4.0453738570f, 4.0458337327f, 4.0462936062f,
    4.0467534778f, 4.0472133474f, 4.0476732149f, 4.0481330805f, 4.0485929440f,
    4.0490528055f, 4.0495126650f, 4.0499725224f, 4.0504323779f, 4.0508922314f,
    4.0513520828f, 4.0518119323f, 4.0522717797f, 4.0527316252f, 4.0531914686f,
    4.0536513101f, 4.0541111495f, 4.0545709870f, 4.0550308225f, 4.0554906559f,
    4.0559504874f, 4.0564103169f, 4.0568701444f, 4.0573299699f, 4.0577897934f,
    4.0582496149f, 4.0587094345f, 4.0591692521f, 4.0596290676f, 4.0600888812f,
    4.0605486929f, 4.0610085025f, 4.0614683102f, 4.0619281159f, 4.0623879196f,
    4.0628477214f, 4.0633075212f, 4.0637673190f, 4.0642271148f, 4.0646869087f,
    4.0651467006f, 4.0656064906f, 4.0660662786f, 4.0665260646f, 4.0669858487f,
    4.0674456308f, 4.0679054109f, 4.0683651891f, 4.0688249654f, 4.0692847397f,
    4.0697445120f, 4.0702042824f, 4.0706640508f, 4.0711238173f, 4.0715835819f,
    4.0720433445f, 4.0725031051f, 4.0729628639f, 4.0734226206f, 4.0738823755f,
    4.0743421284f, 4.0748018793f, 4.0752616283f, 4.0757213754f, 4.0761811206f,
    4.0766408638f, 4.0771006051f, 4.0775603445f, 4.0780200819f, 4.0784798174f,
    4.0789395510f, 4.0793992827f, 4.0798590124f, 4.0803187402f, 4.0807784661f,
    4.0812381901f, 4.0816979122f, 4.0821576323f, 4.0826173506f, 4.0830770669f,
    4.0835367813f, 4.0839964938f, 4.0844562044f, 4.0849159131f, 4.0853756199f,
    4.0858353248f, 4.0862950277f, 4.0867547288f, 4.0872144280f, 4.0876741252f,
    4.0881338206f, 4.0885935141f, 4.0890532057f, 4.0895128953f, 4.0899725831f,
    4.0904322690f, 4.0908919530f, 4.0913516351f, 4.0918113154f, 4.0922709937f,
    4.0927306702f, 4.0931903448f, 4.0936500175f, 4.0941096883f, 4.0945693572f,
    4.0950290242f, 4.0954886894f, 4.0959483527f, 4.0964080142f, 4.0968676737f,
    4.0973273314f, 4.0977869872f, 4.0982466411f, 4.0987062932f, 4.0991659434f,
    4.0996255918f, 4.1000852382f, 4.1005448828f, 4.1010045256f, 4.1014641665f,
    4.1019238055f, 4.1023834427f, 4.1028430780f, 4.1033027115f, 4.1037623431f,
    4.1042219728f, 4.1046816008f, 4.1051412268f, 4.1056008510f, 4.1060604734f,
    4.1065200939f, 4.1069797126f, 4.1074393294f, 4.1078989444f, 4.1083585575f,
    4.1088181688f, 4.1092777783f, 4.1097373859f, 4.1101969917f, 4.1106565957f,
    4.1111161978f, 4.1115757981f, 4.1120353966f, 4.1124949932f, 4.1129545880f,
    4.1134141810f, 4.1138737722f, 4.1143333615f, 4.1147929490f, 4.1152525347f,
    4.1157121186f, 4.1161717007f, 4.1166312809f, 4.1170908593f, 4.1175504359f,
    4.1180100107f, 4.1184695837f, 4.1189291549f, 4.1193887242f, 4.1198482918f,
    4.1203078575f, 4.1207674215f, 4.1212269836f, 4.1216865439f, 4.1221461025f,
    4.1226056592f, 4.1230652141f, 4.1235247673f, 4.1239843186f, 4.1244438681f,
    4.1249034159f, 4.1253629618f, 4.1258225060f, 4.1262820484f, 4.1267415890f,
    4.1272011277f, 4.1276606648f, 4.1281202000f, 4.1285797334f, 4.1290392651f,
    4.1294987949f, 4.1299583230f, 4.1304178494f, 4.1308773739f, 4.1313368967f,
    4.1317964177f, 4.1322559369f, 4.1327154543f, 4.1331749700f, 4.1336344839f,
    4.1340939960f, 4.1345535064f, 4.1350130150f, 4.1354725218f, 4.1359320269f,
    4.1363915302f, 4.1368510317f, 4.1373105315f, 4.1377700296f, 4.1382295258f,
    4.1386890203f, 4.1391485131f, 4.1396080041f, 4.1400674934f, 4.1405269809f,
    4.1409864666f, 4.1414459506f, 4.1419054329f, 4.1423649134f, 4.1428243922f,
    4.1432838692f, 4.1437433445f, 4.1442028180f, 4.1446622899f, 4.1451217599f,
    4.1455812283f, 4.1460406948f, 4.1465001597f, 4.1469596228f, 4.1474190842f,
    4.1478785439f, 4.1483380018f, 4.1487974580f, 4.1492569125f, 4.1497163653f,
    4.1501758163f, 4.1506352656f, 4.1510947132f, 4.1515541591f, 4.1520136032f,
    4.1524730456f, 4.1529324863f, 4.1533919253f, 4.1538513626f, 4.1543107982f,
    4.1547702320f, 4.1552296642f, 4.1556890946f, 4.1561485234f, 4.1566079504f,
    4.1570673757f, 4.1575267993f, 4.1579862212f, 4.1584456414f, 4.1589050599f,
    4.1593644767f, 4.1598238918f, 4.1602833053f, 4.1607427170f, 4.1612021270f,
    4.1616615353f, 4.1621209420f, 4.1625803469f, 4.1630397502f, 4.1634991517f,
    4.1639585516f, 4.1644179498f, 4.1648773463f, 4.1653367412f, 4.1657961343f,
    4.1662555258f, 4.1667149156f, 4.1671743037f, 4.1676336901f, 4.1680930749f,
    4.1685524579f, 4.1690118393f, 4.1694712191f, 4.1699305971f, 4.1703899735f,
    4.1708493483f, 4.1713087213f, 4.1717680927f, 4.1722274625f, 4.1726868305f,
    4.1731461969f, 4.1736055617f, 4.1740649248f, 4.1745242862f, 4.1749836459f,
    4.1754430041f, 4.1759023605f, 4.1763617153f, 4.1768210685f, 4.1772804200f,
    4.1777397698f, 4.1781991180f, 4.1786584646f, 4.1791178095f, 4.1795771528f,
    4.1800364944f, 4.1804958344f, 4.1809551727f, 4.1814145094f, 4.1818738444f,
    4.1823331779f, 4.1827925096f, 4.1832518398f, 4.1837111683f, 4.1841704952f,
    4.1846298204f, 4.1850891441f, 4.1855484660f, 4.1860077864f, 4.1864671051f,
    4.1869264223f, 4.1873857377f, 4.1878450516f, 4.1883043639f, 4.1887636745f,
    4.1892229835f, 4.1896822909f, 4.1901415966f, 4.1906009008f, 4.1910602033f,
    4.1915195042f, 4.1919788036f, 4.1924381013f, 4.1928973973f, 4.1933566918f,
    4.1938159847f, 4.1942752760f, 4.1947345656f, 4.1951938537f, 4.1956531402f,
    4.1961124250f, 4.1965717083f, 4.1970309899f, 4.1974902700f, 4.1979495485f,
    4.1984088253f, 4.1988681006f, 4.1993273743f, 4.1997866464f, 4.2002459169f,
    4.2007051858f, 4.2011644531f, 4.2016237189f, 4.2020829830f, 4.2025422456f,
    4.2030015066f, 4.2034607660f, 4.2039200238f, 4.2043792800f, 4.2048385347f,
    4.2052977878f, 4.2057570393f, 4.2062162892f, 4.2066755376f, 4.2071347844f,
    4.2075940296f, 4.2080532733f, 4.2085125153f, 4.2089717559f, 4.2094309948f,
    4.2098902322f, 4.2103494680f, 4.2108087023f, 4.2112679350f, 4.2117271661f,
    4.2121863957f, 4.2126456237f, 4.2131048502f, 4.2135640751f, 4.2140232984f,
    4.2144825202f, 4.2149417405f, 4.2154009592f, 4.2158601763f, 4.2163193919f,
    4.2167786059f, 4.2172378185f, 4.2176970294f, 4.2181562388f, 4.2186154467f,
    4.2190746530f, 4.2195338578f, 4.2199930611f, 4.2204522628f, 4.2209114630f,
    4.2213706616f, 4.2218298587f, 4.2222890543f, 4.2227482483f, 4.2232074409f,
    4.2236666318f, 4.2241258213f, 4.2245850092f, 4.2250441956f, 4.2255033805f,
    4.2259625639f, 4.2264217457f, 4.2268809260f, 4.2273401048f, 4.2277992821f,
    4.2282584578f, 4.2287176321f, 4.2291768048f, 4.2296359760f, 4.2300951457f,
    4.2305543139f, 4.2310134806f, 4.2314726457f, 4.2319318094f, 4.2323909715f,
    4.2328501322f, 4.2333092913f, 4.2337684489f, 4.2342276051f, 4.2346867597f,
    4.2351459128f, 4.2356050645f, 4.2360642146f, 4.2365233632f, 4.2369825104f,
    4.2374416560f, 4.2379008002f, 4.2383599429f, 4.2388190840f, 4.2392782237f,
    4.2397373619f, 4.2401964986f, 4.2406556338f, 4.2411147676f, 4.2415738998f,
    4.2420330306f, 4.2424921599f, 4.2429512877f, 4.2434104140f, 4.2438695389f,
    4.2443286623f, 4.2447877842f, 4.2452469046f, 4.2457060235f, 4.2461651410f,
    4.2466242570f, 4.2470833716f, 4.2475424846f, 4.2480015962f, 4.2484607064f,
    4.2489198150f, 4.2493789223f, 4.2498380280f, 4.2502971323f, 4.2507562351f,
    4.2512153365f, 4.2516744364f, 4.2521335348f, 4.2525926318f, 4.2530517274f,
    4.2535108214f, 4.2539699141f, 4.2544290053f, 4.2548880950f, 4.2553471833f,
    4.2558062701f, 4.2562653555f, 4.2567244394f, 4.2571835219f, 4.2576426030f,
    4.2581016826f, 4.2585607608f, 4.2590198375f, 4.2594789128f, 4.2599379867f,
    4.2603970591f, 4.2608561301f, 4.2613151996f, 4.2617742677f, 4.2622333344f,
    4.2626923997f, 4.2631514635f, 4.2636105259f, 4.2640695869f, 4.2645286464f,
    4.2649877045f, 4.2654467612f, 4.2659058165f, 4.2663648703f, 4.2668239228f,
    4.2672829738f, 4.2677420234f, 4.2682010716f, 4.2686601183f, 4.2691191637f,
    4.2695782076f, 4.2700372501f, 4.2704962912f, 4.2709553309f, 4.2714143692f,
    4.2718734061f, 4.2723324416f, 4.2727914756f, 4.2732505083f, 4.2737095396f,
    4.2741685694f, 4.2746275979f, 4.2750866250f, 4.2755456506f, 4.2760046749f,
    4.2764636978f, 4.2769227192f, 4.2773817393f, 4.2778407580f, 4.2782997753f,
    4.2787587912f, 4.2792178057f, 4.2796768188f, 4.2801358306f, 4.2805948409f,
    4.2810538499f, 4.2815128575f, 4.2819718637f, 4.2824308685f, 4.2828898719f,
    4.2833488740f, 4.2838078746f, 4.2842668739f, 4.2847258719f, 4.2851848684f,
    4.2856438636f, 4.2861028574f, 4.2865618498f, 4.2870208409f, 4.2874798306f,
    4.2879388189f, 4.2883978059f, 4.2888567914f, 4.2893157757f, 4.2897747585f,
    4.2902337400f, 4.2906927202f, 4.2911516989f, 4.2916106764f, 4.2920696524f,
    4.2925286271f, 4.2929876005f, 4.2934465725f, 4.2939055431f, 4.2943645124f,
    4.2948234803f, 4.2952824469f, 4.2957414121f, 4.2962003760f, 4.2966593386f,
    4.2971182998f, 4.2975772596f, 4.2980362181f, 4.2984951753f, 4.2989541311f,
    4.2994130856f, 4.2998720387f, 4.3003309905f, 4.3007899410f, 4.3012488901f,
    4.3017078379f, 4.3021667844f, 4.3026257295f, 4.3030846733f, 4.3035436158f,
    4.3040025569f, 4.3044614967f, 4.3049204352f, 4.3053793723f, 4.3058383082f,
    4.3062972427f, 4.3067561759f, 4.3072151077f, 4.3076740383f, 4.3081329675f,
    4.3085918954f, 4.3090508220f, 4.3095097473f, 4.3099686712f, 4.3104275939f,
    4.3108865152f, 4.3113454352f, 4.3118043539f, 4.3122632713f, 4.3127221874f,
    4.3131811022f, 4.3136400157f, 4.3140989278f, 4.3145578387f, 4.3150167483f,
    4.3154756565f, 4.3159345635f, 4.3163934692f, 4.3168523735f, 4.3173112766f,
    4.3177701784f, 4.3182290788f, 4.3186879780f, 4.3191468759f, 4.3196057725f,
    4.3200646678f, 4.3205235618f, 4.3209824546f, 4.3214413460f, 4.3219002362f,
    4.3223591250f, 4.3228180126f, 4.3232768989f, 4.3237357839f, 4.3241946677f,
    4.3246535501f, 4.3251124313f, 4.3255713112f, 4.3260301898f, 4.3264890672f,
    4.3269479433f, 4.3274068181f, 4.3278656916f, 4.3283245639f, 4.3287834348f,
    4.3292423046f, 4.3297011730f, 4.3301600402f, 4.3306189061f, 4.3310777708f,
    4.3315366342f, 4.3319954963f, 4.3324543572f, 4.3329132168f, 4.3333720751f,
    4.3338309322f, 4.3342897880f, 4.3347486426f, 4.3352074959f, 4.3356663480f,
    4.3361251988f, 4.3365840484f, 4.3370428967f, 4.3375017438f, 4.3379605896f,
    4.3384194342f, 4.3388782775f, 4.3393371195f, 4.3397959604f, 4.3402548000f,
    4.3407136383f, 4.3411724754f, 4.3416313113f, 4.3420901459f, 4.3425489793f,
    4.3430078115f, 4.3434666424f, 4.3439254721f, 4.3443843005f, 4.3448431277f,
    4.3453019537f, 4.3457607785f, 4.3462196020f, 4.3466784243f, 4.3471372454f,
    4.3475960652f, 4.3480548838f, 4.3485137012f, 4.3489725174f, 4.3494313324f,
    4.3498901461f, 4.3503489586f, 4.3508077699f, 4.3512665800f, 4.3517253888f,
    4.3521841965f, 4.3526430029f, 4.3531018081f, 4.3535606121f, 4.3540194149f,
    4.3544782165f, 4.3549370169f, 4.3553958160f, 4.3558546140f, 4.3563134108f,
    4.3567722063f, 4.3572310007f, 4.3576897938f, 4.3581485858f, 4.3586073765f,
    4.3590661660f, 4.3595249544f, 4.3599837415f, 4.3604425275f, 4.3609013122f,
    4.3613600958f, 4.3618188782f, 4.3622776594f, 4.3627364393f, 4.3631952181f,
    4.3636539957f, 4.3641127722f, 4.3645715474f, 4.3650303215f, 4.3654890943f,
    4.3659478660f, 4.3664066365f, 4.3668654058f, 4.3673241739f, 4.3677829409f,
    4.3682417067f, 4.3687004713f, 4.3691592347f, 4.3696179970f, 4.3700767580f,
    4.3705355179f, 4.3709942767f, 4.3714530342f, 4.3719117906f, 4.3723705459f,
    4.3728292999f, 4.3732880528f, 4.3737468045f, 4.3742055551f, 4.3746643045f,
    4.3751230527f, 4.3755817998f, 4.3760405457f, 4.3764992904f, 4.3769580340f,
    4.3774167765f, 4.3778755177f, 4.3783342579f, 4.3787929968f, 4.3792517347f,
    4.3797104713f, 4.3801692068f, 4.3806279412f, 4.3810866744f, 4.3815454065f,
    4.3820041374f, 4.3824628672f, 4.3829215958f, 4.3833803233f, 4.3838390496f,
    4.3842977748f, 4.3847564989f, 4.3852152218f, 4.3856739436f, 4.3861326643f,
    4.3865913838f, 4.3870501021f, 4.3875088194f, 4.3879675355f, 4.3884262505f,
    4.3888849643f, 4.3893436770f, 4.3898023886f, 4.3902610991f, 4.3907198084f,
    4.3911785166f, 4.3916372237f, 4.3920959296f, 4.3925546345f, 4.3930133382f,
    4.3934720407f, 4.3939307422f, 4.3943894426f, 4.3948481418f, 4.3953068399f,
    4.3957655369f, 4.3962242328f, 4.3966829276f, 4.3971416212f, 4.3976003138f,
    4.3980590052f, 4.3985176955f, 4.3989763847f, 4.3994350728f, 4.3998937599f,
    4.4003524457f, 4.4008111305f, 4.4012698142f, 4.4017284968f, 4.4021871783f,
    4.4026458587f, 4.4031045380f, 4.4035632162f, 4.4040218932f, 4.4044805692f,
    4.4049392441f, 4.4053979179f, 4.4058565907f, 4.4063152623f, 4.4067739328f,
    4.4072326022f, 4.4076912706f, 4.4081499378f, 4.4086086040f, 4.4090672691f,
    4.4095259331f, 4.4099845960f, 4.4104432579f, 4.4109019186f, 4.4113605783f,
    4.4118192369f, 4.4122778944f, 4.4127365508f, 4.4131952062f, 4.4136538605f,
    4.4141125137f, 4.4145711658f, 4.4150298169f, 4.4154884669f, 4.4159471158f,
    4.4164057636f, 4.4168644104f, 4.4173230561f, 4.4177817008f, 4.4182403443f,
    4.4186989868f, 4.4191576283f, 4.4196162687f, 4.4200749080f, 4.4205335463f,
    4.4209921835f, 4.4214508196f, 4.4219094547f, 4.4223680887f, 4.4228267217f,
    4.4232853536f, 4.4237439845f, 4.4242026143f, 4.4246612431f, 4.4251198708f,
    4.4255784975f, 4.4260371231f, 4.4264957476f, 4.4269543712f, 4.4274129936f,
    4.4278716151f, 4.4283302355f, 4.4287888548f, 4.4292474731f, 4.4297060904f,
    4.4301647066f, 4.4306233218f, 4.4310819359f, 4.4315405490f, 4.4319991611f,
    4.4324577721f, 4.4329163821f, 4.4333749911f, 4.4338335991f, 4.4342922060f,
    4.4347508119f, 4.4352094167f, 4.4356680205f, 4.4361266233f, 4.4365852251f,
    4.4370438258f, 4.4375024256f, 4.4379610243f, 4.4384196220f, 4.4388782186f,
    4.4393368143f, 4.4397954089f, 4.4402540025f, 4.4407125951f, 4.4411711866f,
    4.4416297772f, 4.4420883667f, 4.4425469553f, 4.4430055428f, 4.4434641293f,
    4.4439227148f, 4.4443812993f, 4.4448398828f, 4.4452984652f, 4.4457570467f,
    4.4462156272f, 4.4466742066f, 4.4471327851f, 4.4475913625f, 4.4161034198f,
    4.4166593240f, 4.4172152283f, 4.4177711325f, 4.4183270368f, 4.4188829410f,
    4.4194388453f, 4.4199947496f, 4.4205506538f, 4.4211065581f, 4.4216624623f,
    4.4222183666f, 4.4227742708f, 4.4233301751f, 4.4238860794f, 4.4244419836f,
    4.4249978879f, 4.4255537921f, 4.4261096964f, 4.4266656006f, 4.4272215049f,
    4.4277774092f, 4.4283333134f, 4.4288892177f, 4.4294451219f, 4.4300010262f,
    4.4305569304f, 4.4311128347f, 4.4316687390f, 4.4322246432f, 4.4327805475f,
    4.4333364517f, 4.4338923560f, 4.4344482602f, 4.4350041645f, 4.4355600688f,
    4.4361159730f, 4.4366718773f, 4.4372277815f, 4.4377836858f, 4.4383395900f,
    4.4388954943f, 4.4394513986f, 4.4400073028f, 4.4405632071f, 4.4411191113f,
    4.4416750156f, 4.4422309198f, 4.4427868241f, 4.4433427284f, 4.4438986326f,
    4.4444545369f, 4.4450104411f, 4.4455663454f, 4.4461222496f, 4.4466781539f,
    4.4472340582f, 4.4477899624f, 4.4483458667f, 4.4489017709f, 4.4494576752f,
    4.4500135794f, 4.4505694837f, 4.4511253880f, 4.4516812922f, 4.4522371965f,
    4.4527931007f, 4.4533490050f, 4.4539049093f, 4.4544608135f, 4.4550167178f,
    4.4555726220f, 4.4561285263f, 4.4566844305f, 4.4572403348f, 4.4577962391f,
    4.4583521433f, 4.4589080476f, 4.4594639518f, 4.4600198561f, 4.4605757603f,
    4.4611316646f, 4.4616875689f, 4.4622434731f, 4.4627993774f, 4.4633552816f,
    4.4639111859f, 4.4644670901f, 4.4650229944f, 4.4655788987f, 4.4661348029f,
    4.4666907072f, 4.4672466114f, 4.4678025157f, 4.4683584199f, 4.4689143242f,
    4.4694702285f, 4.4700261327f, 4.4705820370f, 4.4711379412f, 4.4716938455f,
    4.4722497497f, 4.4728056540f, 4.4733615583f, 4.4739174625f, 4.4744733668f,
    4.4750292710f, 4.4755851753f, 4.4761410795f, 4.4766969838f, 4.4772528881f,
    4.4778087923f, 4.4783646966f, 4.4789206008f, 4.4794765051f, 4.4800324093f,
    4.4805883136f, 4.4811442179f, 4.4817001221f, 4.4822560264f, 4.4828119306f,
    4.4833678349f, 4.4839237391f, 4.4844796434f, 4.4850355477f, 4.4855914519f,
    4.4861473562f, 4.4867032604f, 4.4872591647f, 4.4878150689f, 4.4883709732f,
    4.4889268775f, 4.4894827817f, 4.4900386860f, 4.4905945902f, 4.4911504945f,
    4.4917063987f, 4.4922623030f, 4.4928182073f, 4.4933741115f, 4.4939300158f,
    4.4944859200f, 4.4950418243f, 4.4955977285f, 4.4961536328f, 4.4967095371f,
    4.4972654413f, 4.4978213456f, 4.4983772498f, 4.4989331541f, 4.4994890583f,
    4.5000449626f, 4.5006008669f, 4.5011567711f, 4.5017126754f, 4.5022685796f,
    4.5028244839f, 4.5033803881f, 4.5039362924f, 4.5044921967f, 4.5050481009f,
    4.5056040052f, 4.5061599094f, 4.5067158137f, 4.5072717179f, 4.5078276222f,
    4.5083835265f, 4.5089394307f, 4.5094953350f, 4.5100512392f, 4.5106071435f,
    4.5111630477f, 4.5117189520f, 4.5122748563f, 4.5128307605f, 4.5133866648f,
    4.5139425690f, 4.5144984733f, 4.5150543776f, 4.5156102818f, 4.5161661861f,
    4.5167220903f, 4.5172779946f, 4.5178338988f, 4.5183898031f, 4.5189457074f,
    4.5195016116f, 4.5200575159f, 4.5206134201f, 4.5211693244f, 4.5217252286f,
    4.5222811329f, 4.5228370372f, 4.5233929414f, 4.5239488457f, 4.5245047499f,
    4.5250606542f, 4.5256165584f, 4.5261724627f, 4.5267283670f, 4.5272842712f,
    4.5278401755f, 4.5283960797f, 4.5289519840f, 4.5295078882f, 4.5300637925f,
    4.5306196968f, 4.5311756010f, 4.5317315053f, 4.5322874095f, 4.5328433138f,
    4.5333992180f, 4.5339551223f, 4.5345110266f, 4.5350669308f, 4.5356228351f,
    4.5361787393f, 4.5367346436f, 4.5372905478f, 4.5378464521f, 4.5384023564f,
    4.5389582606f, 4.5395141649f, 4.5400700691f, 4.5406259734f, 4.5411818776f,
    4.5417377819f, 4.5422936862f, 4.5428495904f, 4.5434054947f, 4.5439613989f,
    4.5445173032f, 4.5450732074f, 4.5456291117f, 4.5461850160f, 4.5467409202f,
    4.5472968245f, 4.5478527287f, 4.5484086330f, 4.5489645372f, 4.5495204415f,
    4.5500763458f, 4.5506322500f, 4.5511881543f, 4.5517440585f, 4.5522999628f,
    4.5528558670f, 4.5534117713f, 4.5539676756f, 4.5545235798f, 4.5550794841f,
    4.5556353883f, 4.5561912926f, 4.5567471968f, 4.5573031011f, 4.5578590054f,
    4.5584149096f, 4.5589708139f, 4.5595267181f, 4.5600826224f, 4.5606385266f,
    4.5611944309f, 4.5617503352f, 4.5623062394f, 4.5628621437f, 4.5634180479f,
    4.5639739522f, 4.5645298564f, 4.5650857607f, 4.5656416650f, 4.5661975692f,
    4.5667534735f, 4.5673093777f, 4.5678652820f, 4.5684211862f, 4.5689770905f,
    4.5695329948f, 4.5700888990f, 4.5706448033f, 4.5712007075f, 4.5717566118f,
    4.5723125160f, 4.5728684203f, 4.5734243246f, 4.5739802288f, 4.5745361331f,
    4.5750920373f, 4.5756479416f, 4.5762038458f, 4.5767597501f, 4.5773156544f,
    4.5778715586f, 4.5784274629f, 4.5789833671f, 4.5795392714f, 4.5800951757f,
    4.5806510799f, 4.5812069842f, 4.5817628884f, 4.5823187927f, 4.5828746969f,
    4.5834306012f, 4.5839865055f, 4.5845424097f, 4.5850983140f, 4.5856542182f,
    4.5862101225f, 4.5867660267f, 4.5873219310f, 4.5878778353f, 4.5884337395f,
    4.5889896438f, 4.5895455480f, 4.5901014523f, 4.5906573565f, 4.5912132608f,
    4.5917691651f, 4.5923250693f, 4.5928809736f, 4.5934368778f, 4.5939927821f,
    4.5945486863f, 4.5951045906f, 4.5956604949f, 4.5962163991f, 4.5967723034f,
    4.5973282076f, 4.5978841119f, 4.5984400161f, 4.5989959204f, 4.5995518247f,
    4.6001077289f, 4.6006636332f, 4.6012195374f, 4.6017754417f, 4.6023313459f,
    4.6028872502f, 4.6034431545f, 4.6039990587f, 4.6045549630f, 4.6051108672f,
    4.6056667715f, 4.6062226757f, 4.6067785800f, 4.6073344843f, 4.6078903885f,
    4.6084462928f, 4.6090021970f, 4.6095581013f, 4.6101140055f, 4.6106699098f,
    4.6112258141f, 4.6117817183f, 4.6123376226f, 4.6128935268f, 4.6134494311f,
    4.6140053353f, 4.6145612396f, 4.6151171439f, 4.6156730481f, 4.6162289524f,
    4.6167848566f, 4.6173407609f, 4.6178966651f, 4.6184525694f, 4.6190084737f,
    4.6195643779f, 4.6201202822f, 4.6206761864f, 4.6212320907f, 4.6217879949f,
    4.6223438992f, 4.6228998035f, 4.6234557077f, 4.6240116120f, 4.6245675162f,
    4.6251234205f, 4.6256793247f, 4.6262352290f, 4.6267911333f, 4.6273470375f,
    4.6279029418f, 4.6284588460f, 4.6290147503f, 4.6295706545f, 4.6301265588f,
    4.6306824631f, 4.6312383673f, 4.6317942716f, 4.6323501758f, 4.6329060801f,
    4.6334619843f, 4.6340178886f, 4.6345737929f, 4.6351296971f, 4.6356856014f,
    4.6362415056f, 4.6367974099f, 4.6373533141f, 4.6379092184f, 4.6384651227f,
    4.6390210269f, 4.6395769312f, 4.6401328354f, 4.6406887397f, 4.6412446440f,
    4.6418005482f, 4.6423564525f, 4.6429123567f, 4.6434682610f, 4.6440241652f,
    4.6445800695f, 4.6451359738f, 4.6456918780f, 4.6462477823f, 4.6468036865f,
    4.6473595908f, 4.6479154950f, 4.6484713993f, 4.6490273036f, 4.6495832078f,
    4.6501391121f, 4.6506950163f, 4.6512509206f, 4.6518068248f, 4.6523627291f,
    4.6529186334f, 4.6534745376f, 4.6540304419f, 4.6545863461f, 4.6551422504f,
    4.6556981546f, 4.6562540589f, 4.6568099632f, 4.6573658674f, 4.6579217717f,
    4.6584776759f, 4.6590335802f, 4.6595894844f, 4.6601453887f, 4.6607012930f,
    4.6612571972f, 4.6618131015f, 4.6623690057f, 4.6629249100f, 4.6634808142f,
    4.6640367185f, 4.6645926228f, 4.6651485270f, 4.6657044313f, 4.6662603355f,
    4.6668162398f, 4.6673721440f, 4.6679280483f, 4.6684839526f, 4.6690398568f,
    4.6695957611f, 4.6701516653f, 4.6707075696f, 4.6712634738f, 4.6718193781f,
    4.6723752824f, 4.6729311866f, 4.6734870909f, 4.6740429951f, 4.6745988994f,
    4.6751548036f, 4.6757107079f, 4.6762666122f, 4.6768225164f, 4.6773784207f,
    4.6779343249f, 4.6784902292f, 4.6790461334f, 4.6796020377f, 4.6801579420f,
    4.6807138462f, 4.6812697505f, 4.6818256547f, 4.6823815590f, 4.6829374632f,
    4.6834933675f, 4.6840492718f, 4.6846051760f, 4.6851610803f, 4.6857169845f,
    4.6862728888f, 4.6868287930f, 4.6873846973f, 4.6879406016f, 4.6884965058f,
    4.6890524101f, 4.6896083143f, 4.6901642186f, 4.6907201228f, 4.6912760271f,
    4.6918319314f, 4.6923878356f, 4.6929437399f, 4.6934996441f, 4.6940555484f,
    4.6946114526f, 4.6951673569f, 4.6957232612f, 4.6962791654f, 4.6968350697f,
    4.6973909739f, 4.6979468782f, 4.6985027824f, 4.6990586867f, 4.6996145910f,
    4.7001704952f, 4.7007263995f, 4.7012823037f, 4.7018382080f, 4.7023941123f,
    4.7029500165f, 4.7035059208f, 4.7040618250f, 4.7046177293f, 4.7051736335f,
    4.7057295378f, 4.7062854421f, 4.7068413463f, 4.7073972506f, 4.7079531548f,
    4.7085090591f, 4.7090649633f, 4.7096208676f, 4.7101767719f, 4.7107326761f,
    4.7112885804f, 4.7118444846f, 4.7124003889f, 4.7129562931f, 4.7135121974f,
    4.7140681017f, 4.7146240059f, 4.7151799102f, 4.7157358144f, 4.7162917187f,
    4.7168476229f, 4.7174035272f, 4.7179594315f, 4.7185153357f, 4.7190712400f,
    4.7196271442f, 4.7201830485f, 4.7207389527f, 4.7212948570f, 4.7218507613f,
    4.7224066655f, 4.7229625698f, 4.7235184740f, 4.7240743783f, 4.7246302825f,
    4.7251861868f, 4.7257420911f, 4.7262979953f, 4.7268538996f, 4.7274098038f,
    4.7279657081f, 4.7285216123f, 4.7290775166f, 4.7296334209f, 4.7301893251f,
    4.7307452294f, 4.7313011336f, 4.7318570379f, 4.7324129421f, 4.7329688464f,
    4.7335247507f, 4.7340806549f, 4.7346365592f, 4.7351924634f, 4.7357483677f,
    4.7363042719f, 4.7368601762f, 4.7374160805f, 4.7379719847f, 4.7385278890f,
    4.7390837932f, 4.7396396975f, 4.7401956017f, 4.7407515060f, 4.7413074103f,
    4.7418633145f, 4.7424192188f, 4.7429751230f, 4.7435310273f, 4.7440869315f,
    4.7446428358f, 4.7451987401f, 4.7457546443f, 4.7463105486f, 4.7468664528f,
    4.7474223571f, 4.7479782613f, 4.7485341656f, 4.7490900699f, 4.7496459741f,
    4.7502018784f, 4.7507577826f, 4.7513136869f, 4.7518695911f, 4.7524254954f,
    4.7529813997f, 4.7535373039f, 4.7540932082f, 4.7546491124f, 4.7552050167f,
    4.7557609209f, 4.7563168252f, 4.7568727295f, 4.7574286337f, 4.7579845380f,
    4.7585404422f, 4.7590963465f, 4.7596522507f, 4.7602081550f, 4.7607640593f,
    4.7613199635f, 4.7618758678f, 4.7624317720f, 4.7629876763f, 4.7635435806f,
    4.7640994848f, 4.7646553891f, 4.7652112933f, 4.7657671976f, 4.7663231018f,
    4.7668790061f, 4.7674349104f, 4.7679908146f, 4.7685467189f, 4.7691026231f,
    4.7696585274f, 4.7702144316f, 4.7707703359f, 4.7713262402f, 4.7718821444f,
    4.7724380487f, 4.7729939529f, 4.7735498572f, 4.7741057614f, 4.7746616657f,
    4.7752175700f, 4.7757734742f, 4.7763293785f, 4.7768852827f, 4.7774411870f,
    4.7779970912f, 4.7785529955f, 4.7791088998f, 4.7796648040f, 4.7802207083f,
    4.7807766125f, 4.7813325168f, 4.7818884210f, 4.7824443253f, 4.7830002296f,
    4.7835561338f, 4.7841120381f, 4.7846679423f, 4.7852238466f, 4.7857797508f,
    4.7863356551f, 4.7868915594f, 4.7874474636f, 4.7880033679f, 4.7885592721f,
    4.7891151764f, 4.7896710806f, 4.7902269849f, 4.7907828892f, 4.7913387934f,
    4.7918946977f, 4.7924506019f, 4.7930065062f, 4.7935624104f, 4.7941183147f,
    4.7946742190f, 4.7952301232f, 4.7957860275f, 4.7963419317f, 4.7968978360f,
    4.7974537402f, 4.7980096445f, 4.7985655488f, 4.7991214530f, 4.7996773573f,
    4.8002332615f, 4.8007891658f, 4.8013450700f, 4.8019009743f, 4.8024568786f,
    4.8030127828f, 4.8035686871f, 4.8041245913f, 4.8046804956f, 4.8052363998f,
    4.8057923041f, 4.8063482084f, 4.8069041126f, 4.8074600169f, 4.8080159211f,
    4.8085718254f, 4.8091277296f, 4.8096836339f, 4.8102395382f, 4.8107954424f,
    4.8113513467f, 4.8119072509f, 4.8124631552f, 4.8130190594f, 4.8135749637f,
    4.8141308680f, 4.8146867722f, 4.8152426765f, 4.8157985807f, 4.8163544850f,
    4.8169103892f, 4.8174662935f, 4.8180221978f, 4.8185781020f, 4.8191340063f,
    4.8196899105f, 4.8202458148f, 4.8208017190f, 4.8213576233f, 4.8219135276f,
    4.8224694318f, 4.8230253361f, 4.8235812403f, 4.8241371446f, 4.8246930488f,
    4.8252489531f, 4.8258048574f, 4.8263607616f, 4.8269166659f, 4.8274725701f,
    4.8280284744f, 4.8285843787f, 4.8291402829f, 4.8296961872f, 4.8302520914f,
    4.8308079957f, 4.8313638999f, 4.8319198042f, 4.8324757085f, 4.8330316127f,
    4.8335875170f, 4.8341434212f, 4.8346993255f, 4.8352552297f, 4.8358111340f,
    4.8363670383f, 4.8369229425f, 4.8374788468f, 4.8380347510f, 4.8385906553f,
    4.8391465595f, 4.8397024638f, 4.8402583681f, 4.8408142723f, 4.8413701766f,
    4.8419260808f, 4.8424819851f, 4.8430378893f, 4.8435937936f, 4.8441496979f,
    4.8447056021f, 4.8452615064f, 4.8458174106f, 4.8463733149f, 4.8469292191f,
    4.8474851234f, 4.8480410277f, 4.8485969319f, 4.8491528362f, 4.8497087404f,
    4.8502646447f, 4.8508205489f, 4.8513764532f, 4.8519323575f, 4.8524882617f,
    4.8530441660f, 4.8536000702f, 4.8541559745f, 4.8547118787f, 4.8552677830f,
    4.8558236873f, 4.8563795915f, 4.8569354958f, 4.8574914000f, 4.8580473043f,
    4.8586032085f, 4.8591591128f, 4.8597150171f, 4.8602709213f, 4.8608268256f,
    4.8613827298f, 4.8619386341f, 4.8624945383f, 4.8630504426f, 4.8636063469f,
    4.8641622511f, 4.8647181554f, 4.8652740596f, 4.8658299639f, 4.8663858681f,
    4.8669417724f, 4.8674976767f, 4.8680535809f, 4.8686094852f, 4.8691653894f,
    4.8697212937f, 4.8702771979f, 4.8708331022f, 4.8713890065f, 4.8719449107f,
    4.8725008150f, 4.8730567192f, 4.8736126235f, 4.8741685277f, 4.8747244320f,
    4.8752803363f, 4.8758362405f, 4.8763921448f, 4.8769480490f, 4.8775039533f,
    4.8780598575f, 4.8786157618f, 4.8791716661f, 4.8797275703f, 4.8802834746f,
    4.8808393788f, 4.8813952831f, 4.8819511873f, 4.8825070916f, 4.8830629959f,
    4.8836189001f, 4.8841748044f, 4.8847307086f, 4.8852866129f, 4.8858425171f,
    4.8863984214f, 4.8869543257f, 4.8875102299f, 4.8880661342f, 4.8886220384f,
    4.8891779427f, 4.8897338470f, 4.8902897512f, 4.8908456555f, 4.8914015597f,
    4.8919574640f, 4.8925133682f, 4.8930692725f, 4.8936251768f, 4.8941810810f,
    4.8947369853f, 4.8952928895f, 4.8958487938f, 4.8964046980f, 4.8969606023f,
    4.8975165066f, 4.8980724108f, 4.8986283151f, 4.8991842193f, 4.8997401236f,
    4.9002960278f, 4.9008519321f, 4.9014078364f, 4.9019637406f, 4.9025196449f,
    4.9030755491f, 4.9036314534f, 4.9041873576f, 4.9047432619f, 4.9052991662f,
    4.9058550704f, 4.9064109747f, 4.9069668789f, 4.9075227832f, 4.9080786874f,
    4.9086345917f, 4.9091904960f, 4.9097464002f, 4.9103023045f, 4.9108582087f,
    4.9114141130f, 4.9119700172f, 4.9125259215f, 4.9130818258f, 4.9136377300f,
    4.9141936343f, 4.9147495385f, 4.9153054428f, 4.9158613470f, 4.9164172513f,
    4.9169731556f, 4.9175290598f, 4.9180849641f, 4.9186408683f, 4.9191967726f,
    4.9197526768f, 4.9203085811f, 4.9208644854f, 4.9214203896f, 4.9219762939f,
    4.9225321981f, 4.9230881024f, 4.9236440066f, 4.9241999109f, 4.9247558152f,
    4.9253117194f, 4.9258676237f, 4.9264235279f, 4.9269794322f, 4.9275353364f,
    4.9280912407f, 4.9286471450f, 4.9292030492f, 4.9297589535f, 4.9303148577f,
    4.9308707620f, 4.9314266662f, 4.9319825705f, 4.9325384748f, 4.9330943790f,
    4.9336502833f, 4.9342061875f, 4.9347620918f, 4.9353179960f, 4.9358739003f,
    4.9364298046f, 4.9369857088f, 4.9375416131f, 4.9380975173f, 4.9386534216f,
    4.9392093258f, 4.9397652301f, 4.9403211344f, 4.9408770386f, 4.9414329429f,
    4.9419888471f, 4.9425447514f, 4.9431006556f, 4.9436565599f, 4.9442124642f,
    4.9447683684f, 4.9453242727f, 4.9458801769f, 4.9464360812f, 4.9469919854f,
    4.9475478897f, 4.9481037940f, 4.9486596982f, 4.9492156025f, 4.9497715067f,
    4.9503274110f, 4.9508833153f, 4.9514392195f, 4.9519951238f, 4.9525510280f,
    4.9531069323f, 4.9536628365f, 4.9542187408f, 4.9547746451f, 4.9553305493f,
    4.9558864536f, 4.9564423578f, 4.9569982621f, 4.9575541663f, 4.9581100706f,
    4.9586659749f, 4.9592218791f, 4.9597777834f, 4.9603336876f, 4.9608895919f,
    4.9614454961f, 4.9620014004f, 4.9625573047f, 4.9631132089f, 4.9636691132f,
    4.9642250174f, 4.9647809217f, 4.9653368259f, 4.9658927302f, 4.9664486345f,
    4.9670045387f, 4.9675604430f, 4.9681163472f, 4.9686722515f, 4.9692281557f,
    4.9697840600f, 4.9703399643f, 4.9708958685f, 4.9714517728f, 4.9720076770f,
    4.9725635813f, 4.9731194855f, 4.9736753898f, 4.9742312941f, 4.9747871983f,
    4.9753431026f, 4.9758990068f, 4.9764549111f, 4.9770108153f, 4.9775667196f,
    4.9781226239f, 4.9786785281f, 4.9792344324f, 4.9797903366f, 4.9803462409f,
    4.9809021451f, 4.9814580494f, 4.9820139537f, 4.9825698579f, 4.9831257622f,
    4.9836816664f, 4.9842375707f, 4.9847934749f, 4.9853493792f, 4.9859052835f,
    4.9864611877f, 4.9870170920f, 4.9875729962f, 4.9881289005f, 4.9886848047f,
    4.9892407090f, 4.9897966133f, 4.9903525175f, 4.9909084218f, 4.9914643260f,
    4.9920202303f, 4.9925761345f, 4.9931320388f, 4.9936879431f, 4.9942438473f,
    4.9947997516f, 4.9953556558f, 4.9959115601f, 4.9964674643f, 4.9970233686f,
    4.9975792729f, 4.9981351771f, 4.9986910814f, 4.9992469856f, 4.9998028899f,
    5.0003587941f, 5.0009146984f, 5.0014706027f, 5.0020265069f, 5.0025824112f,
    5.0031383154f, 5.0036942197f, 5.0042501239f, 5.0048060282f, 5.0053619325f,
    5.0059178367f, 5.0064737410f, 5.0070296452f, 5.0075855495f, 5.0081414537f,
    5.0086973580f, 5.0092532623f, 5.0098091665f, 5.0103650708f, 5.0109209750f,
    5.0114768793f, 5.0120327835f, 5.0125886878f, 5.0131445921f, 5.0137004963f,
    5.0142564006f, 5.0148123048f, 5.0153682091f, 5.0159241134f, 5.0164800176f,
    5.0170359219f, 5.0175918261f, 5.0181477304f, 5.0187036346f, 5.0192595389f,
    5.0198154432f, 5.0203713474f, 5.0209272517f, 5.0214831559f, 5.0220390602f,
    5.0225949644f, 5.0231508687f, 5.0237067730f, 5.0242626772f, 5.0248185815f,
    5.0253744857f, 5.0259303900f, 5.0264862942f, 5.0270421985f, 5.0275981028f,
    5.0281540070f, 5.0287099113f, 5.0292658155f, 5.0298217198f, 5.0303776240f,
    5.0309335283f, 5.0314894326f, 5.0320453368f, 5.0326012411f, 5.0331571453f,
    5.0337130496f, 5.0342689538f, 5.0348248581f, 5.0353807624f, 5.0359366666f,
    5.0364925709f, 5.0370484751f, 5.0376043794f, 5.0381602836f, 5.0387161879f,
    5.0392720922f, 5.0398279964f, 5.0403839007f, 5.0409398049f, 5.0414957092f,
    5.0420516134f, 5.0426075177f, 5.0431634220f, 5.0437193262f, 5.0442752305f,
    5.0448311347f, 5.0453870390f, 5.0459429432f, 5.0464988475f, 5.0470547518f,
    5.0476106560f, 5.0481665603f, 5.0487224645f, 5.0492783688f, 5.0498342730f,
    5.0503901773f, 5.0509460816f, 5.0515019858f, 5.0520578901f, 5.0526137943f,
    5.0531696986f, 5.0537256028f, 5.0542815071f, 5.0548374114f, 5.0553933156f,
    5.0559492199f, 5.0565051241f, 5.0570610284f, 5.0576169326f, 5.0581728369f,
    5.0587287412f, 5.0592846454f, 5.0598405497f, 5.0603964539f, 5.0609523582f,
    5.0615082624f, 5.0620641667f, 5.0626200710f, 5.0631759752f, 5.0637318795f,
    5.0642877837f, 5.0648436880f, 5.0653995922f, 5.0659554965f, 5.0665114008f,
    5.0670673050f, 5.0676232093f, 5.0681791135f, 5.0687350178f, 5.0692909220f,
    5.0698468263f, 5.0704027306f, 5.0709586348f, 5.0715145391f, 5.0720704433f,
    5.0726263476f, 5.0731822518f, 5.0737381561f, 5.0742940604f, 5.0748499646f,
    5.0754058689f, 5.0759617731f, 5.0765176774f, 5.0770735817f, 5.0776294859f,
    5.0781853902f, 5.0787412944f, 5.0792971987f, 5.0798531029f, 5.0804090072f,
    5.0809649115f, 5.0815208157f, 5.0820767200f, 5.0826326242f, 5.0831885285f,
    5.0837444327f, 5.0843003370f, 5.0848562413f, 5.0854121455f, 5.0859680498f,
    5.0865239540f, 5.0870798583f, 5.0876357625f, 5.0881916668f, 5.0887475711f,
    5.0893034753f, 5.0898593796f, 5.0904152838f, 5.0909711881f, 5.0915270923f,
    5.0920829966f, 5.0926389009f, 5.0931948051f, 5.0937507094f, 5.0943066136f,
    5.0948625179f, 5.0954184221f, 5.0959743264f, 5.0965302307f, 5.0970861349f,
    5.0976420392f, 5.0981979434f, 5.0987538477f, 5.0993097519f, 5.0998656562f,
    5.1004215605f, 5.1009774647f, 5.1015333690f, 5.1020892732f, 5.1026451775f,
    5.1032010817f, 5.1037569860f, 5.1043128903f, 5.1048687945f, 5.1054246988f,
    5.1059806030f, 5.1065365073f, 5.1070924115f, 5.1076483158f, 5.1082042201f,
    5.1087601243f, 5.1093160286f, 5.1098719328f, 5.1104278371f, 5.1109837413f,
    5.1115396456f, 5.1120955499f, 5.1126514541f, 5.1132073584f, 5.1137632626f,
    5.1143191669f, 5.1148750711f, 5.1154309754f, 5.1159868797f, 5.1165427839f,
    5.1170986882f, 5.1176545924f, 5.1182104967f, 5.1187664009f, 5.1193223052f,
    5.1198782095f, 5.1204341137f, 5.1209900180f, 5.1215459222f, 5.1221018265f,
    5.1226577307f, 5.1232136350f, 5.1237695393f, 5.1243254435f, 5.1248813478f,
    5.1254372520f, 5.1259931563f, 5.1265490605f, 5.1271049648f, 5.1276608691f,
    5.1282167733f, 5.1287726776f, 5.1293285818f, 5.1298844861f, 5.1304403903f,
    5.1309962946f, 5.1315521989f, 5.1321081031f, 5.1326640074f, 5.1332199116f,
    5.1337758159f, 5.1343317201f, 5.1348876244f, 5.1354435287f, 5.1359994329f,
    5.1365553372f, 5.1371112414f, 5.1376671457f, 5.1382230500f, 5.1387789542f,
    5.1393348585f, 5.1398907627f, 5.1404466670f, 5.1410025712f, 5.1415584755f,
    5.1421143798f, 5.1426702840f, 5.1432261883f, 5.1437820925f, 5.1443379968f,
    5.1448939010f, 5.1454498053f, 5.1460057096f, 5.1465616138f, 5.1471175181f,
    5.1476734223f, 5.1482293266f, 5.1487852308f, 5.1493411351f, 5.1498970394f,
    5.1504529436f, 5.1510088479f, 5.1515647521f, 5.1521206564f, 5.1526765606f,
    5.1532324649f, 5.1537883692f, 5.1543442734f, 5.1549001777f, 5.1554560819f,
    5.1560119862f, 5.1565678904f, 5.1571237947f, 5.1576796990f, 5.1582356032f,
    5.1587915075f, 5.1593474117f, 5.1599033160f, 5.1604592202f, 5.1610151245f,
    5.1615710288f, 5.1621269330f, 5.1626828373f, 5.1632387415f, 5.1637946458f,
    5.1643505500f, 5.1649064543f, 5.1654623586f, 5.1660182628f, 5.1665741671f,
    5.1671300713f, 5.1676859756f, 5.1682418798f, 5.1687977841f, 5.1693536884f,
    5.1699095926f, 5.1704654969f, 5.1710214011f, 5.1715773054f, 5.1721332096f,
    5.1726891139f, 5.1732450182f, 5.1738009224f, 5.1743568267f, 5.1749127309f,
    5.1754686352f, 5.1760245394f, 5.1765804437f, 5.1771363480f, 5.1776922522f,
    5.1782481565f, 5.1788040607f, 5.1793599650f, 5.1799158692f, 5.1804717735f,
    5.1810276778f, 5.1815835820f, 5.1821394863f, 5.1826953905f, 5.1832512948f,
    5.1838071990f, 5.1843631033f, 5.1849190076f, 5.1854749118f, 5.1860308161f,
    5.1865867203f, 5.1871426246f, 5.1876985288f, 5.1882544331f, 5.1888103374f,
    5.1893662416f, 5.1899221459f, 5.1904780501f, 5.1910339544f, 5.1915898586f,
    5.1921457629f, 5.1927016672f, 5.1932575714f, 5.1938134757f, 5.1943693799f,
    5.1949252842f, 5.1954811884f, 5.1960370927f, 5.1965929970f, 5.1971489012f,
    5.1977048055f, 5.1982607097f, 5.1988166140f, 5.1993725183f, 5.1999284225f,
    5.2004843268f, 5.2010402310f, 5.2015961353f, 5.2021520395f, 5.2027079438f,
    5.2032638481f, 5.2038197523f, 5.2043756566f, 5.2049315608f, 5.2054874651f,
    5.2060433693f, 5.2065992736f, 5.2071551779f, 5.2077110821f, 5.2082669864f,
    5.2088228906f, 5.2093787949f, 5.2099346991f, 5.2104906034f, 5.2110465077f,
    5.2116024119f, 5.2121583162f, 5.2127142204f, 5.2132701247f, 5.2138260289f,
    5.2143819332f, 5.2149378375f, 5.2154937417f, 5.2160496460f, 5.2166055502f,
    5.2171614545f, 5.2177173587f, 5.2182732630f, 5.2188291673f, 5.2193850715f,
    5.2199409758f, 5.2204968800f, 5.2210527843f, 5.2216086885f, 5.2221645928f,
    5.2227204971f, 5.2232764013f, 5.2238323056f, 5.2243882098f, 5.2249441141f,
    5.2255000183f, 5.2260559226f, 5.2266118269f, 5.2271677311f, 5.2277236354f,
    5.2282795396f, 5.2288354439f, 5.2293913481f, 5.2299472524f, 5.2305031567f,
    5.2310590609f, 5.2316149652f, 5.2321708694f, 5.2327267737f, 5.2332826779f,
    5.2338385822f, 5.2343944865f, 5.2349503907f, 5.2355062950f, 5.2360621992f,
    5.2366181035f, 5.2371740077f, 5.2377299120f, 5.2382858163f, 5.2388417205f,
    5.2393976248f, 5.2399535290f, 5.2405094333f, 5.2410653375f, 5.2416212418f,
    5.2421771461f, 5.2427330503f, 5.2432889546f, 5.2438448588f, 5.2444007631f,
    5.2449566673f, 5.2455125716f, 5.2460684759f, 5.2466243801f, 5.2471802844f,
    5.2477361886f, 5.2482920929f, 5.2488479971f, 5.2494039014f, 5.2499598057f,
    5.2505157099f, 5.2510716142f, 5.2516275184f, 5.2521834227f, 5.2527393269f,
    5.2532952312f, 5.2538511355f, 5.2544070397f, 5.2549629440f, 5.2555188482f,
    5.2560747525f, 5.2566306567f, 5.2571865610f, 5.2577424653f, 5.2582983695f,
    5.2588542738f, 5.2594101780f, 5.2599660823f, 5.2605219865f, 5.2610778908f,
    5.2616337951f, 5.2621896993f, 5.2627456036f, 5.2633015078f, 5.2638574121f,
    5.2644133164f, 5.2649692206f, 5.2655251249f, 5.2660810291f, 5.2666369334f,
    5.2671928376f, 5.2677487419f, 5.2683046462f, 5.2688605504f, 5.2694164547f,
    5.2699723589f, 5.2705282632f, 5.2710841674f, 5.2716400717f, 5.2721959760f,
    5.2727518802f, 5.2733077845f, 5.2738636887f, 5.2744195930f, 5.2749754972f,
    5.2755314015f, 5.2760873058f, 5.2766432100f, 5.2771991143f, 5.2777550185f,
    5.2783109228f, 5.2788668270f, 5.2794227313f, 5.2799786356f, 5.2805345398f,
    5.2810904441f, 5.2816463483f, 5.2822022526f, 5.2827581568f, 5.2833140611f,
    5.2838699654f, 5.2844258696f, 5.2849817739f, 5.2855376781f, 5.2860935824f,
    5.2866494866f, 5.2872053909f, 5.2877612952f, 5.2883171994f, 5.2888731037f,
    5.2894290079f, 5.2899849122f, 5.2905408164f, 5.2910967207f, 5.2916526250f,
    5.2922085292f, 5.2927644335f, 5.2933203377f, 5.2938762420f, 5.2944321462f,
    5.2949880505f, 5.2955439548f, 5.2960998590f, 5.2966557633f, 5.2972116675f,
    5.2977675718f, 5.2983234760f, 5.2988793803f, 5.2994352846f, 5.2999911888f,
    5.3005470931f, 5.3011029973f, 5.3016589016f, 5.3022148058f, 5.3027707101f,
    5.3033266144f, 5.3038825186f, 5.3044384229f, 5.3049943271f, 5.3055502314f,
    5.3061061356f, 5.3066620399f, 5.3072179442f, 5.3077738484f, 5.3083297527f,
    5.3088856569f, 5.3094415612f, 5.3099974654f, 5.3105533697f, 5.3111092740f,
    5.3116651782f, 5.3122210825f, 5.3127769867f, 5.3133328910f, 5.3138887952f,
    5.3144446995f, 5.3150006038f, 5.3155565080f, 5.3161124123f, 5.3166683165f,
    5.3172242208f, 5.3177801250f, 5.3183360293f, 5.3188919336f, 5.3194478378f,
    5.3200037421f, 5.3205596463f, 5.3211155506f, 5.3216714548f, 5.3222273591f,
    5.3227832634f, 5.3233391676f, 5.3238950719f, 5.3244509761f, 5.3250068804f,
    5.3255627847f, 5.3261186889f, 5.3266745932f, 5.3272304974f, 5.3277864017f,
    5.3283423059f, 5.3288982102f, 5.3294541145f, 5.3300100187f, 5.3305659230f,
    5.3311218272f, 5.3316777315f, 5.3322336357f, 5.3327895400f, 5.3333454443f,
    5.3339013485f, 5.3344572528f, 5.3350131570f, 5.3355690613f, 5.3361249655f,
    5.3366808698f, 5.3372367741f, 5.3377926783f, 5.3383485826f, 5.3389044868f,
    5.3394603911f, 5.3400162953f, 5.3405721996f, 5.3411281039f, 5.3416840081f,
    5.3422399124f, 5.3427958166f, 5.3433517209f, 5.3439076251f, 5.3444635294f,
    5.3450194337f, 5.3455753379f, 5.3461312422f, 5.3466871464f, 5.3472430507f,
    5.3477989549f, 5.3483548592f, 5.3489107635f, 5.3494666677f, 5.3500225720f,
    5.3505784762f, 5.3511343805f, 5.3516902847f, 5.3522461890f, 5.3528020933f,
    5.3533579975f, 5.3539139018f, 5.3544698060f, 5.3550257103f, 5.3555816145f,
    5.3561375188f, 5.3566934231f, 5.3572493273f, 5.3578052316f, 5.3583611358f,
    5.3589170401f, 5.3594729443f, 5.3600288486f, 5.3605847529f, 5.3611406571f,
    5.3616965614f, 5.3622524656f, 5.3628083699f, 5.3633642741f, 5.3639201784f,
    5.3644760827f, 5.3650319869f, 5.3655878912f, 5.3661437954f, 5.3666996997f,
    5.3672556039f, 5.3678115082f, 5.3683674125f, 5.3689233167f, 5.3694792210f,
    5.3700351252f, 5.3705910295f, 5.3711469337f, 5.3717028380f, 5.3722587423f,
    5.3728146465f, 5.3733705508f, 5.3739264550f, 5.3744823593f, 5.3750382635f,
    5.3755941678f, 5.3761500721f, 5.3767059763f, 5.3772618806f, 5.3778177848f,
    5.3783736891f, 5.3789295933f, 5.3794854976f, 5.3800414019f, 5.3805973061f,
    5.3811532104f, 5.3817091146f, 5.3822650189f, 5.3828209231f, 5.3833768274f,
    5.3839327317f, 5.3844886359f, 5.3850445402f, 5.3856004444f, 5.3861563487f,
    5.3867122530f, 5.3872681572f, 5.3878240615f, 5.3883799657f, 5.3889358700f,
    5.3894917742f, 5.3900476785f, 5.3906035828f, 5.3911594870f, 5.3917153913f,
    5.3922712955f, 5.3928271998f, 5.3933831040f, 5.3939390083f, 5.3944949126f,
    5.3950508168f, 5.3956067211f, 5.3961626253f, 5.3967185296f, 5.3972744338f,
    5.3978303381f, 5.3983862424f, 5.3989421466f, 5.3994980509f, 5.4000539551f,
    5.4006098594f, 5.4011657636f, 5.4017216679f, 5.4022775722f, 5.4028334764f,
    5.4033893807f, 5.4039452849f, 5.4045011892f, 5.4050570934f, 5.4056129977f,
    5.4061689020f, 5.4067248062f, 5.4072807105f, 5.4078366147f, 5.4083925190f,
    5.4089484232f, 5.4095043275f, 5.4100602318f, 5.4106161360f, 5.4111720403f,
    5.4117279445f, 5.4122838488f, 5.4128397530f, 5.4133956573f, 5.4139515616f,
    5.4145074658f, 5.4150633701f, 5.4156192743f, 5.4161751786f, 5.4167310828f,
    5.4172869871f, 5.4178428914f, 5.4183987956f, 5.4189546999f, 5.4195106041f,
    5.4200665084f, 5.4206224126f, 5.4211783169f, 5.4217342212f, 5.4222901254f,
    5.4228460297f, 5.4234019339f, 5.4239578382f, 5.4245137424f, 5.4250696467f,
    5.4256255510f, 5.4261814552f, 5.4267373595f, 5.4272932637f, 5.4278491680f,
    5.4284050722f, 5.4289609765f, 5.4295168808f, 5.4300727850f, 5.4306286893f,
    5.4311845935f, 5.4317404978f, 5.4322964020f, 5.4328523063f, 5.4334082106f,
    5.4339641148f, 5.4345200191f, 5.4350759233f, 5.4356318276f, 5.4361877318f,
    5.4367436361f, 5.4372995404f, 5.4378554446f, 5.4384113489f, 5.4389672531f,
    5.4395231574f, 5.4400790616f, 5.4406349659f, 5.4411908702f, 5.4417467744f,
    5.4423026787f, 5.4428585829f, 5.4434144872f, 5.4439703914f, 5.4445262957f,
    5.4450822000f, 5.4456381042f, 5.4461940085f, 5.4467499127f, 5.4473058170f,
    5.4478617212f, 5.4484176255f, 5.4489735298f, 5.4495294340f, 5.4500853383f,
    5.4506412425f, 5.4511971468f, 5.4517530511f, 5.4523089553f, 5.4528648596f,
    5.4534207638f, 5.4539766681f, 5.4545325723f, 5.4550884766f, 5.4556443809f,
    5.4562002851f, 5.4567561894f, 5.4573120936f, 5.4578679979f, 5.4584239021f,
    5.4589798064f, 5.4595357107f, 5.4600916149f, 5.4606475192f, 5.4612034234f,
    5.4617593277f, 5.4623152319f, 5.4628711362f, 5.4634270405f, 5.4639829447f,
    5.4645388490f, 5.4650947532f, 5.4656506575f, 5.4662065617f, 5.4667624660f,
    5.4673183703f, 5.4678742745f, 5.4684301788f, 5.4689860830f, 5.4695419873f,
    5.4700978915f, 5.4706537958f, 5.4712097001f, 5.4717656043f, 5.4723215086f,
    5.4728774128f, 5.4734333171f, 5.4739892213f, 5.4745451256f, 5.4751010299f,
    5.4756569341f, 5.4762128384f, 5.4767687426f, 5.4773246469f, 5.4778805511f,
    5.4784364554f, 5.4789923597f, 5.4795482639f, 5.4801041682f, 5.4806600724f,
    5.4812159767f, 5.4817718809f, 5.4823277852f, 5.4828836895f, 5.4834395937f,
    5.4839954980f, 5.4845514022f, 5.4851073065f, 5.4856632107f, 5.4862191150f,
    5.4867750193f, 5.4873309235f, 5.4878868278f, 5.4884427320f, 5.4889986363f,
    5.4895545405f, 5.4901104448f, 5.4906663491f, 5.4912222533f, 5.4917781576f,
    5.4923340618f, 5.4928899661f, 5.4934458703f, 5.4940017746f, 5.4945576789f,
    5.4951135831f, 5.4956694874f, 5.4962253916f, 5.4967812959f, 5.4973372001f,
    5.4978931044f, 5.4984490087f, 5.4990049129f, 5.4995608172f, 5.5001167214f,
    5.5006726257f, 5.5012285299f, 5.5017844342f, 5.5023403385f, 5.5028962427f,
    5.5034521470f, 5.5040080512f, 5.5045639555f, 5.5051198597f, 5.5056757640f,
    5.5062316683f, 5.5067875725f, 5.5073434768f, 5.5078993810f, 5.5084552853f,
    5.5090111895f, 5.5095670938f, 5.5101229981f, 5.5106789023f, 5.5112348066f,
    5.5117907108f, 5.5123466151f, 5.5129025194f, 5.5134584236f, 5.5140143279f,
    5.5145702321f, 5.5151261364f, 5.5156820406f, 5.5162379449f, 5.5167938492f,
    5.5173497534f, 5.5179056577f, 5.5184615619f, 5.5190174662f, 5.5195733704f,
    5.5201292747f, 5.5206851790f, 5.5212410832f, 5.5217969875f, 5.5223528917f,
    5.5229087960f, 5.5234647002f, 5.5240206045f, 5.5245765088f, 5.5251324130f,
    5.5256883173f, 5.5262442215f, 5.5268001258f, 5.5273560300f, 5.5279119343f,
    5.5284678386f, 5.5290237428f, 5.5295796471f, 5.5301355513f, 5.5306914556f,
    5.5312473598f, 5.5318032641f, 5.5323591684f, 5.5329150726f, 5.5334709769f,
    5.5340268811f, 5.5345827854f, 5.5351386896f, 5.5356945939f, 5.5362504982f,
    5.5368064024f, 5.5373623067f, 5.5379182109f, 5.5384741152f, 5.5390300194f,
    5.5395859237f, 5.5401418280f, 5.5406977322f, 5.5412536365f, 5.5418095407f,
    5.5423654450f, 5.5429213492f, 5.5434772535f, 5.5440331578f, 5.5445890620f,
    5.5451449663f, 5.5457008705f, 5.5462567748f, 5.5468126790f, 5.5473685833f,
    5.5479244876f, 5.5484803918f, 5.5490362961f, 5.5495922003f, 5.5501481046f,
    5.5507040088f, 5.5512599131f, 5.5518158174f, 5.5523717216f, 5.5529276259f,
    5.5534835301f, 5.5540394344f, 5.5545953386f, 5.5551512429f, 5.5557071472f,
    5.5562630514f, 5.5568189557f, 5.5573748599f, 5.5579307642f, 5.5584866684f,
};
static float get_threshold_vs_intensity(float value) {
  DCHECK(value >= 0.0f);
  DCHECK(value < 100.0f);
  return gTVITable[(int)(value * 100.0f)];
}

static float gVisualMaskTable[] = {
    1.0000000000f,   1.1897247198f,   1.6811970813f,   2.1839523495f,
    2.6547752201f,   3.0963096336f,   3.5139692055f,   3.9121076634f,
    4.2939844505f,   4.6620559235f,   5.0182118232f,   5.3639381283f,
    5.7004270140f,   6.0286520228f,   6.3494205286f,   6.6634111728f,
    6.9712011485f,   7.2732864768f,   7.5700973467f,   7.8620099053f,
    8.1493554541f,   8.4324277147f,   8.7114886393f,   8.9867731060f,
    9.2584927519f,   9.5268391297f,   9.7919863293f,   10.0540931710f,
    10.3133050540f,  10.5697555236f,  10.8235676089f,  11.0748549704f,
    11.3237228897f,  11.5702691275f,  11.8145846707f,  12.0567543856f,
    12.2968575912f,  12.5349685653f,  12.7711569910f,  13.0054883541f,
    13.2380242961f,  13.4688229298f,  13.6979391221f,  13.9254247479f,
    14.1513289185f,  14.3756981881f,  14.5985767405f,  14.8200065586f,
    15.0400275782f,  15.2586778282f,  15.4759935584f,  15.6920093571f,
    15.9067582574f,  16.1202718361f,  16.3325803041f,  16.5437125892f,
    16.7536964134f,  16.9625583630f,  17.1703239549f,  17.3770176970f,
    17.5826631441f,  17.7872829508f,  17.9908989195f,  18.1935320461f,
    18.3952025619f,  18.5959299728f,  18.7957330963f,  18.9946300956f,
    19.1926385122f,  19.3897752951f,  19.5860568301f,  19.7814989656f,
    19.9761170379f,  20.1699258942f,  20.3629399152f,  20.5551730353f,
    20.7466387627f,  20.9373501975f,  21.1273200494f,  21.3165606539f,
    21.5050839883f,  21.6929016861f,  21.8800250510f,  22.0664650704f,
    22.2522324278f,  22.4373375146f,  22.6217904416f,  22.8056010496f,
    22.9887789198f,  23.1713333835f,  23.3532735311f,  23.5346082210f,
    23.7153460884f,  23.8954955528f,  24.0750648258f,  24.2540619184f,
    24.4324946480f,  24.6103706451f,  24.7876973593f,  24.9644820659f,
    25.1407318713f,  25.3164537188f,  25.4916543937f,  25.6663405286f,
    25.8405186082f,  26.0141949740f,  26.1873758287f,  26.3600672409f,
    26.5322751485f,  26.7040053635f,  26.8752635753f,  27.0460553544f,
    27.2163861562f,  27.3862613242f,  27.5556860931f,  27.7246655923f,
    27.8932048488f,  28.0613087898f,  28.2289822461f,  28.3962299542f,
    28.5630565593f,  28.7294666176f,  28.8954645988f,  29.0610548887f,
    29.2262417907f,  29.3910295289f,  29.5554222497f,  29.7194240236f,
    29.8830388479f,  30.0462706478f,  30.2091232789f,  30.3716005284f,
    30.5337061172f,  30.6954437015f,  30.8568168742f,  31.0178291668f,
    31.1784840505f,  31.3387849380f,  31.4987351846f,  31.6583380900f,
    31.8175968991f,  31.9765148037f,  32.1350949435f,  32.2933404076f,
    32.4512542352f,  32.6088394171f,  32.7660988969f,  32.9230355715f,
    33.0796522929f,  33.2359518686f,  33.3919370628f,  33.5476105975f,
    33.7029751531f,  33.8580333698f,  34.0127878477f,  34.1672411485f,
    34.3213957956f,  34.4752542755f,  34.6288190382f,  34.7820924981f,
    34.9350770346f,  35.0877749931f,  35.2401886853f,  35.3923203904f,
    35.5441723552f,  35.6957467952f,  35.8470458949f,  35.9980718087f,
    36.1488266612f,  36.2993125482f,  36.4495315367f,  36.5994856659f,
    36.7491769476f,  36.8986073668f,  37.0477788820f,  37.1966934258f,
    37.3453529055f,  37.4937592036f,  37.6419141780f,  37.7898196627f,
    37.9374774680f,  38.0848893814f,  38.2320571673f,  38.3789825683f,
    38.5256673046f,  38.6721130753f,  38.8183215582f,  38.9642944105f,
    39.1100332690f,  39.2555397503f,  39.4008154516f,  39.5458619506f,
    39.6906808062f,  39.8352735585f,  39.9796417293f,  40.1237868223f,
    40.2677103236f,  40.4114137019f,  40.5548984086f,  40.6981658783f,
    40.8412175291f,  40.9840547628f,  41.1266789651f,  41.2690915061f,
    41.4112937401f,  41.5532870064f,  41.6950726292f,  41.8366519180f,
    41.9780261675f,  42.1191966584f,  42.2601646571f,  42.4009314163f,
    42.5414981750f,  42.6818661588f,  42.8220365799f,  42.9620106376f,
    43.1017895185f,  43.2413743965f,  43.3807664328f,  43.5199667769f,
    43.6589765656f,  43.7977969244f,  43.9364289667f,  44.0748737945f,
    44.2131324986f,  44.3512061583f,  44.4890958421f,  44.6268026076f,
    44.7643275016f,  44.9016715605f,  45.0388358101f,  45.1758212661f,
    45.3126289340f,  45.4492598095f,  45.5857148782f,  45.7219951164f,
    45.8581014904f,  45.9940349575f,  46.1297964654f,  46.2653869528f,
    46.4008073495f,  46.5360585761f,  46.6711415446f,  46.8060571584f,
    46.9408063121f,  47.0753898922f,  47.2098087766f,  47.3440638352f,
    47.4781559296f,  47.6120859137f,  47.7458546332f,  47.8794629262f,
    48.0129116232f,  48.1462015470f,  48.2793335128f,  48.4123083288f,
    48.5451267955f,  48.6777897064f,  48.8102978481f,  48.9426519997f,
    49.0748529340f,  49.2069014164f,  49.3387982059f,  49.4705440547f,
    49.6021397085f,  49.7335859065f,  49.8648833815f,  49.9960328598f,
    50.1270350617f,  50.2578907012f,  50.3886004861f,  50.5191651183f,
    50.6495852939f,  50.7798617027f,  50.9099950290f,  51.0399859514f,
    51.1698351425f,  51.2995432697f,  51.4291109947f,  51.5585389736f,
    51.6878278571f,  51.8169782909f,  51.9459909150f,  52.0748663644f,
    52.2036052690f,  52.3322082533f,  52.4606759371f,  52.5890089350f,
    52.7172078569f,  52.8452733075f,  52.9732058871f,  53.1010061908f,
    53.2286748093f,  53.3562123287f,  53.4836193301f,  53.6108963906f,
    53.7380440824f,  53.8650629734f,  53.9919536271f,  54.1187166027f,
    54.2453524549f,  54.3718617344f,  54.4982449875f,  54.6245027566f,
    54.7506355796f,  54.8766439908f,  55.0025285200f,  55.1282896933f,
    55.2539280328f,  55.3794440568f,  55.5048382795f,  55.6301112115f,
    55.7552633595f,  55.8802952267f,  56.0052073123f,  56.1300001119f,
    56.2546741177f,  56.3792298181f,  56.5036676981f,  56.6279882391f,
    56.7521919190f,  56.8762792124f,  57.0002505904f,  57.1241065208f,
    57.2478474679f,  57.3714738931f,  57.4949862540f,  57.6183850054f,
    57.7416705987f,  57.8648434822f,  57.9879041011f,  58.1108528974f,
    58.2336903102f,  58.3564167752f,  58.4790327256f,  58.6015385911f,
    58.7239347990f,  58.8462217731f,  58.9683999348f,  59.0904697023f,
    59.2124314911f,  59.3342857139f,  59.4560327806f,  59.5776730984f,
    59.6992070716f,  59.8206351019f,  59.9419575885f,  60.0631749276f,
    60.1842875131f,  60.3052957360f,  60.4261999850f,  60.5470006461f,
    60.6676981027f,  60.7882927359f,  60.9087849242f,  61.0291750436f,
    61.1494634678f,  61.2696505679f,  61.3897367128f,  61.5097222688f,
    61.6296076002f,  61.7493930687f,  61.8690790336f,  61.9886658524f,
    62.1081538797f,  62.2275434684f,  62.3468349689f,  62.4660287294f,
    62.5851250961f,  62.7041244128f,  62.8230270213f,  62.9418332613f,
    63.0605434703f,  63.1791579837f,  63.2976771350f,  63.4161012555f,
    63.5344306745f,  63.6526657193f,  63.7708067152f,  63.8888539855f,
    64.0068078516f,  64.1246686328f,  64.2424366468f,  64.3601122090f,
    64.4776956331f,  64.5951872310f,  64.7125873125f,  64.8298961859f,
    64.9471141573f,  65.0642415312f,  65.1812786102f,  65.2982256953f,
    65.4150830854f,  65.5318510781f,  65.6485299688f,  65.7651200514f,
    65.8816216181f,  65.9980349595f,  66.1143603642f,  66.2305981194f,
    66.3467485106f,  66.4628118215f,  66.5787883345f,  66.6946783300f,
    66.8104820871f,  66.9261998832f,  67.0418319940f,  67.1573786939f,
    67.2728402556f,  67.3882169501f,  67.5035090473f,  67.6187168152f,
    67.7338405204f,  67.8488804281f,  67.9638368020f,  68.0787099043f,
    68.1934999957f,  68.3082073356f,  68.4228321819f,  68.5373747910f,
    68.6518354179f,  68.7662143164f,  68.8805117387f,  68.9947279357f,
    69.1088631570f,  69.2229176507f,  69.3368916637f,  69.4507854415f,
    69.5645992283f,  69.6783332670f,  69.7919877992f,  69.9055630651f,
    70.0190593037f,  70.1324767528f,  70.2458156488f,  70.3590762270f,
    70.4722587213f,  70.5853633645f,  70.6983903880f,  70.8113400223f,
    70.9242124963f,  71.0370080380f,  71.1497268740f,  71.2623692300f,
    71.3749353302f,  71.4874253979f,  71.5998396551f,  71.7121783227f,
    71.8244416205f,  71.9366297670f,  72.0487429799f,  72.1607814755f,
    72.2727454691f,  72.3846351749f,  72.4964508061f,  72.6081925746f,
    72.7198606915f,  72.8314553666f,  72.9429768088f,  73.0544252259f,
    73.1658008247f,  73.2771038108f,  73.3883343890f,  73.4994927630f,
    73.6105791353f,  73.7215937078f,  73.8325366810f,  73.9434082546f,
    74.0542086273f,  74.1649379969f,  74.2755965600f,  74.3861845126f,
    74.4967020493f,  74.6071493641f,  74.7175266499f,  74.8278340987f,
    74.9380719016f,  75.0482402488f,  75.1583393294f,  75.2683693318f,
    75.3783304435f,  75.4882228508f,  75.5980467396f,  75.7078022944f,
    75.8174896992f,  75.9271091370f,  76.0366607899f,  76.1461448391f,
    76.2555614651f,  76.3649108474f,  76.4741931647f,  76.5834085949f,
    76.6925573150f,  76.8016395013f,  76.9106553292f,  77.0196049731f,
    77.1284886069f,  77.2373064036f,  77.3460585353f,  77.4547451733f,
    77.5633664883f,  77.6719226499f,  77.7804138273f,  77.8888401887f,
    77.9972019015f,  78.1054991325f,  78.2137320475f,  78.3219008118f,
    78.4300055898f,  78.5380465452f,  78.6460238410f,  78.7539376394f,
    78.8617881018f,  78.9695753891f,  79.0772996613f,  79.1849610777f,
    79.2925597969f,  79.4000959769f,  79.5075697749f,  79.6149813473f,
    79.7223308501f,  79.8296184382f,  79.9368442662f,  80.0440084879f,
    80.1511112563f,  80.2581527238f,  80.3651330422f,  80.4720523625f,
    80.5789108353f,  80.6857086103f,  80.7924458365f,  80.8991226625f,
    81.0057392361f,  81.1122957045f,  81.2187922142f,  81.3252289112f,
    81.4316059408f,  81.5379234477f,  81.6441815758f,  81.7503804687f,
    81.8565202691f,  81.9626011194f,  82.0686231610f,  82.1745865351f,
    82.2804913820f,  82.3863378415f,  82.4921260530f,  82.5978561550f,
    82.7035282856f,  82.8091425824f,  82.9146991821f,  83.0201982212f,
    83.1256398354f,  83.2310241599f,  83.3363513293f,  83.4416214778f,
    83.5468347389f,  83.6519912455f,  83.7570911301f,  83.8621345245f,
    83.9671215601f,  84.0720523677f,  84.1769270775f,  84.2817458193f,
    84.3865087223f,  84.4912159151f,  84.5958675259f,  84.7004636823f,
    84.8050045115f,  84.9094901400f,  85.0139206939f,  85.1182962987f,
    85.2226170797f,  85.3268831613f,  85.4310946675f,  85.5352517220f,
    85.6393544479f,  85.7434029677f,  85.8473974035f,  85.9513378769f,
    86.0552245091f,  86.1590574207f,  86.2628367319f,  86.3665625623f,
    86.4702350312f,  86.5738542574f,  86.6774203591f,  86.7809334542f,
    86.8843936600f,  86.9878010934f,  87.0911558709f,  87.1944581085f,
    87.2977079216f,  87.4009054254f,  87.5040507346f,  87.6071439633f,
    87.7101852253f,  87.8131746340f,  87.9161123021f,  88.0189983422f,
    88.1218328663f,  88.2246159860f,  88.3273478124f,  88.4300284562f,
    88.5326580279f,  88.6352366372f,  88.7377643937f,  88.8402414064f,
    88.9426677840f,  89.0450436347f,  89.1473690663f,  89.2496441863f,
    89.3518691018f,  89.4540439192f,  89.5561687448f,  89.6582436845f,
    89.7602688437f,  89.8622443273f,  89.9641702401f,  90.0660466863f,
    90.1678737697f,  90.2696515939f,  90.3713802619f,  90.4730598764f,
    90.5746905398f,  90.6762723540f,  90.7778054207f,  90.8792898409f,
    90.9807257156f,  91.0821131453f,  91.1834522300f,  91.2847430694f,
    91.3859857630f,  91.4871804097f,  91.5883271082f,  91.6894259568f,
    91.7904770534f,  91.8914804956f,  91.9924363807f,  92.0933448055f,
    92.1942058666f,  92.2950196600f,  92.3957862818f,  92.4965058274f,
    92.5971783918f,  92.6978040701f,  92.7983829565f,  92.8989151453f,
    92.9994007303f,  93.0998398050f,  93.2002324624f,  93.3005787954f,
    93.4008788965f,  93.5011328579f,  93.6013407713f,  93.7015027284f,
    93.8016188202f,  93.9016891376f,  94.0017137713f,  94.1016928114f,
    94.2016263479f,  94.3015144703f,  94.4013572681f,  94.5011548300f,
    94.6009072449f,  94.7006146011f,  94.8002769867f,  94.8998944894f,
    94.9994671967f,  95.0989951957f,  95.1984785734f,  95.2979174161f,
    95.3973118103f,  95.4966618419f,  95.5959675966f,  95.6952291597f,
    95.7944466164f,  95.8936200514f,  95.9927495492f,  96.0918351941f,
    96.1908770701f,  96.2898752607f,  96.3888298493f,  96.4877409192f,
    96.5866085529f,  96.6854328332f,  96.7842138422f,  96.8829516620f,
    96.9816463742f,  97.0802980603f,  97.1789068014f,  97.2774726785f,
    97.3759957722f,  97.4744761627f,  97.5729139303f,  97.6713091547f,
    97.7696619155f,  97.8679722920f,  97.9662403632f,  98.0644662079f,
    98.1626499046f,  98.2607915316f,  98.3588911669f,  98.4569488882f,
    98.5549647731f,  98.6529388986f,  98.7508713419f,  98.8487621797f,
    98.9466114885f,  99.0444193444f,  99.1421858235f,  99.2399110016f,
    99.3375949541f,  99.4352377563f,  99.5328394832f,  99.6304002096f,
    99.7279200099f,  99.8253989586f,  99.9228371296f,  100.0202345968f,
    100.1175914337f, 100.2149077137f, 100.3121835099f, 100.4094188952f,
    100.5066139422f, 100.6037687234f, 100.7008833108f, 100.7979577766f,
    100.8949921924f, 100.9919866297f, 101.0889411597f, 101.1858558537f,
    101.2827307823f, 101.3795660162f, 101.4763616257f, 101.5731176811f,
    101.6698342523f, 101.7665114090f, 101.8631492207f, 101.9597477567f,
    102.0563070861f, 102.1528272777f, 102.2493084002f, 102.3457505221f,
    102.4421537115f, 102.5385180365f, 102.6348435649f, 102.7311303643f,
    102.8273785020f, 102.9235880452f, 103.0197590609f, 103.1158916160f,
    103.2119857768f, 103.3080416099f, 103.4040591813f, 103.5000385570f,
    103.5959798028f, 103.6918829842f, 103.7877481666f, 103.8835754151f,
    103.9793647947f, 104.0751163702f, 104.1708302060f, 104.2665063667f,
    104.3621449164f, 104.4577459190f, 104.5533094383f, 104.6488355380f,
    104.7443242815f, 104.8397757320f, 104.9351899524f, 105.0305670058f,
    105.1259069546f, 105.2212098614f, 105.3164757885f, 105.4117047980f,
    105.5068969518f, 105.6020523115f, 105.6971709388f, 105.7922528951f,
    105.8872982415f, 105.9823070389f, 106.0772793484f, 106.1722152304f,
    106.2671147454f, 106.3619779539f, 106.4568049157f, 106.5515956910f,
    106.6463503394f, 106.7410689206f, 106.8357514940f, 106.9303981188f,
    107.0250088540f, 107.1195837586f, 107.2141228914f, 107.3086263108f,
    107.4030940752f, 107.4975262429f, 107.5919228720f, 107.6862840202f,
    107.7806097454f, 107.8749001050f, 107.9691551565f, 108.0633749571f,
    108.1575595639f, 108.2517090336f, 108.3458234232f, 108.4399027890f,
    108.5339471877f, 108.6279566753f, 108.7219313080f, 108.8158711417f,
    108.9097762323f, 109.0036466352f, 109.0974824060f, 109.1912835999f,
    109.2850502721f, 109.3787824776f, 109.4724802713f, 109.5661437077f,
    109.6597728415f, 109.7533677269f, 109.8469284183f, 109.9404549697f,
    110.0339474349f, 110.1274058679f, 110.2208303221f, 110.3142208510f,
    110.4075775081f, 110.5009003464f, 110.5941894189f, 110.6874447786f,
    110.7806664782f, 110.8738545702f, 110.9670091071f, 111.0601301412f,
    111.1532177247f, 111.2462719095f, 111.3392927475f, 111.4322802905f,
    111.5252345899f, 111.6181556974f, 111.7110436640f, 111.8038985411f,
    111.8967203797f, 111.9895092305f, 112.0822651444f, 112.1749881720f,
    112.2676783636f, 112.3603357697f, 112.4529604405f, 112.5455524260f,
    112.6381117761f, 112.7306385406f, 112.8231327691f, 112.9155945113f,
    113.0080238164f, 113.1004207337f, 113.1927853124f, 113.2851176014f,
    113.3774176496f, 113.4696855057f, 113.5619212183f, 113.6541248359f,
    113.7462964068f, 113.8384359793f, 113.9305436014f, 114.0226193210f,
    114.1146631860f, 114.2066752442f, 114.2986555430f, 114.3906041299f,
    114.4825210522f, 114.5744063572f, 114.6662600919f, 114.7580823033f,
    114.8498730381f, 114.9416323432f, 115.0333602650f, 115.1250568500f,
    115.2167221447f, 115.3083561951f, 115.3999590474f, 115.4915307475f,
    115.5830713414f, 115.6745808747f, 115.7660593931f, 115.8575069420f,
    115.9489235669f, 116.0403093131f, 116.1316642256f, 116.2229883494f,
    116.3142817296f, 116.4055444109f, 116.4967764380f, 116.5879778554f,
    116.6791487077f, 116.7702890390f, 116.8613988938f, 116.9524783161f,
    117.0435273498f, 117.1345460389f, 117.2255344272f, 117.3164925583f,
    117.4074204757f, 117.4983182229f, 117.5891858433f, 117.6800233801f,
    117.7708308763f, 117.8616083750f, 117.9523559190f, 118.0430735512f,
    118.1337613143f, 118.2244192507f, 118.3150474030f, 118.4056458135f,
    118.4962145245f, 118.5867535781f, 118.6772630163f, 118.7677428811f,
    118.8581932143f, 118.9486140577f, 119.0390054528f, 119.1293674411f,
    119.2197000642f, 119.3100033632f, 119.4002773794f, 119.4905221539f,
    119.5807377277f, 119.6709241416f, 119.7610814366f, 119.8512096532f,
    119.9413088322f, 120.0313790139f, 120.1214202388f, 120.2114325471f,
    120.3014159792f, 120.3913705750f, 120.4812963746f, 120.5711934178f,
    120.6610617446f, 120.7509013945f, 120.8407124072f, 120.9304948223f,
    121.0202486791f, 121.1099740169f, 121.1996708750f, 121.2893392925f,
    121.3789793085f, 121.4685909619f, 121.5581742915f, 121.6477293361f,
    121.7372561343f, 121.8267547248f, 121.9162251459f, 122.0056674361f,
    122.0950816337f, 122.1844677768f, 122.2738259035f, 122.3631560520f,
    122.4524582600f, 122.5417325654f, 122.6309790060f, 122.7201976194f,
    122.8093884431f, 122.8985515147f, 122.9876868715f, 123.0767945508f,
    123.1658745898f, 123.2549270256f, 123.3439518953f, 123.4329492357f,
    123.5219190838f, 123.6108614763f, 123.6997764499f, 123.7886640412f,
    123.8775242866f, 123.9663572226f, 124.0551628856f, 124.1439413117f,
    124.2326925372f, 124.3214165980f, 124.4101135303f, 124.4987833699f,
    124.5874261526f, 124.6760419142f, 124.7646306903f, 124.8531925165f,
    124.9417274284f, 125.0302354612f, 125.1187166504f, 125.2071710311f,
    125.2955986386f, 125.3839995079f, 125.4723736740f, 125.5607211719f,
    125.6490420363f, 125.7373363021f, 125.8256040038f, 125.9138451762f,
    126.0020598537f, 126.0902480708f, 126.1784098618f, 126.2665452609f,
    126.3546543025f, 126.4427370206f, 126.5307934493f, 126.6188236225f,
    126.7068275742f, 126.7948053381f, 126.8827569480f, 126.9706824375f,
    127.0585818402f, 127.1464551896f, 127.2343025192f, 127.3221238623f,
    127.4099192522f, 127.4976887221f, 127.5854323050f, 127.6731500342f,
    127.7608419425f, 127.8485080628f, 127.9361484281f, 128.0237630709f,
    128.1113520241f, 128.1989153202f, 128.2864529918f, 128.3739650713f,
    128.4614515912f, 128.5489125836f, 128.6363480810f, 128.7237581154f,
    128.8111427189f, 128.8985019236f, 128.9858357615f, 129.0731442644f,
    129.1604274642f, 129.2476853926f, 129.3349180812f, 129.4221255617f,
    129.5093078657f, 129.5964650245f, 129.6835970696f, 129.7707040323f,
    129.8577859439f, 129.9448428355f, 130.0318747383f, 130.1188816833f,
    130.2058637015f, 130.2928208239f, 130.3797530812f, 130.4666605043f,
    130.5535431239f, 130.6404009705f, 130.7272340749f, 130.8140424675f,
    130.9008261787f, 130.9875852390f, 131.0743196786f, 131.1610295278f,
    131.2477148168f, 131.3343755757f, 131.4210118345f, 131.5076236233f,
    131.5942109719f, 131.6807739103f, 131.7673124681f, 131.8538266752f,
    131.9403165612f, 132.0267821556f, 132.1132234881f, 132.1996405881f,
    132.2860334850f, 132.3724022082f, 132.4587467869f, 132.5450672504f,
    132.6313636279f, 132.7176359483f, 132.8038842408f, 132.8901085343f,
    132.9763088578f, 133.0624852401f, 133.1486377099f, 133.2347662960f,
    133.3208710271f, 133.4069519318f, 133.4930090386f, 133.5790423760f,
    133.6650519724f, 133.7510378562f, 133.8370000556f, 133.9229385990f,
    134.0088535146f, 134.0947448303f, 134.1806125744f, 134.2664567748f,
    134.3522774594f, 134.4380746562f, 134.5238483930f, 134.6095986975f,
    134.6953255975f, 134.7810291206f, 134.8667092944f, 134.9523661465f,
    135.0379997043f, 135.1236099953f, 135.2091970468f, 135.2947608862f,
    135.3803015407f, 135.4658190375f, 135.5513134037f, 135.6367846665f,
    135.7222328529f, 135.8076579897f, 135.8930601041f, 135.9784392227f,
    136.0637953725f, 136.1491285802f, 136.2344388724f, 136.3197262759f,
    136.4049908171f, 136.4902325227f, 136.5754514192f, 136.6606475328f,
    136.7458208901f, 136.8309715173f, 136.9160994407f, 137.0012046865f,
    137.0862872808f, 137.1713472498f, 137.2563846195f, 137.3413994159f,
    137.4263916650f, 137.5113613926f, 137.5963086245f, 137.6812333866f,
    137.7661357046f, 137.8510156042f, 137.9358731110f, 138.0207082505f,
    138.1055210484f, 138.1903115300f, 138.2750797208f, 138.3598256462f,
    138.4445493315f, 138.5292508020f, 138.6139300828f, 138.6985871992f,
    138.7832221762f, 138.8678350390f, 138.9524258125f, 139.0369945218f,
    139.1215411916f, 139.2060658470f, 139.2905685127f, 139.3750492135f,
    139.4595079741f, 139.5439448191f, 139.6283597733f, 139.7127528612f,
    139.7971241072f, 139.8814735359f, 139.9658011717f, 140.0501070390f,
    140.1343911620f, 140.2186535652f, 140.3028942727f, 140.3871133086f,
    140.4713106973f, 140.5554864626f, 140.6396406287f, 140.7237732196f,
    140.8078842593f, 140.8919737715f, 140.9760417802f, 141.0600883092f,
    141.1441133823f, 141.2281170231f, 141.3120992554f, 141.3960601027f,
    141.4799995886f, 141.5639177367f, 141.6478145705f, 141.7316901133f,
    141.8155443886f, 141.8993774198f, 141.9831892301f, 142.0669798427f,
    142.1507492810f, 142.2344975681f, 142.3182247270f, 142.4019307809f,
    142.4856157528f, 142.5692796657f, 142.6529225426f, 142.7365444062f,
    142.8201452796f, 142.9037251855f, 142.9872841467f, 143.0708221858f,
    143.1543393257f, 143.2378355888f, 143.3213109979f, 143.4047655755f,
    143.4881993440f, 143.5716123260f, 143.6550045438f, 143.7383760199f,
    143.8217267766f, 143.9050568361f, 143.9883662208f, 144.0716549528f,
    144.1549230543f, 144.2381705475f, 144.3213974544f, 144.4046037970f,
    144.4877895974f, 144.5709548775f, 144.6540996592f, 144.7372239644f,
    144.8203278150f, 144.9034112327f, 144.9864742394f, 145.0695168566f,
    145.1525391061f, 145.2355410094f, 145.3185225883f, 145.4014838642f,
    145.4844248587f, 145.5673455931f, 145.6502460891f, 145.7331263678f,
    145.8159864507f, 145.8988263591f, 145.9816461143f, 146.0644457375f,
    146.1472252498f, 146.2299846724f, 146.3127240265f, 146.3954433331f,
    146.4781426132f, 146.5608218878f, 146.6434811779f, 146.7261205044f,
    146.8087398882f, 146.8913393501f, 146.9739189109f, 147.0564785914f,
    147.1390184123f, 147.2215383942f, 147.3040385579f, 147.3865189239f,
    147.4689795129f, 147.5514203452f, 147.6338414415f, 147.7162428222f,
    147.7986245077f, 147.8809865184f, 147.9633288746f, 148.0456515967f,
    148.1279547049f, 148.2102382194f, 148.2925021605f, 148.3747465483f,
    148.4569714029f, 148.5391767445f, 148.6213625930f, 148.7035289685f,
    148.7856758910f, 148.8678033804f, 148.9499114566f, 149.0320001395f,
    149.1140694489f, 149.1961194046f, 149.2781500263f, 149.3601613339f,
    149.4421533470f, 149.5241260852f, 149.6060795682f, 149.6880138155f,
    149.7699288467f, 149.8518246813f, 149.9337013388f, 150.0155588387f,
    150.0973972003f, 150.1792164430f, 150.2610165862f, 150.3427976491f,
    150.4245596511f, 150.5063026114f, 150.5880265491f, 150.6697314835f,
    150.7514174336f, 150.8330844186f, 150.9147324576f, 150.9963615695f,
    151.0779717734f, 151.1595630882f, 151.2411355329f, 151.3226891264f,
    151.4042238874f, 151.4857398350f, 151.5672369878f, 151.6487153646f,
    151.7301749841f, 151.8116158651f, 151.8930380262f, 151.9744414860f,
    152.0558262632f, 152.1371923763f, 152.2185398438f, 152.2998686843f,
    152.3811789161f, 152.4624705578f, 152.5437436278f, 152.6249981444f,
    152.7062341259f, 152.7874515908f, 152.8686505571f, 152.9498310433f,
    153.0309930674f, 153.1121366477f, 153.1932618024f, 153.2743685495f,
    153.3554569071f, 153.4365268933f, 153.5175785261f, 153.5986118235f,
    153.6796268035f, 153.7606234840f, 153.8416018828f, 153.9225620179f,
    154.0035039071f, 154.0844275682f, 154.1653330190f, 154.2462202772f,
    154.3270893605f, 154.4079402866f, 154.4887730732f, 154.5695877379f,
    154.6503842982f, 154.7311627718f, 154.8119231762f, 154.8926655288f,
    154.9733898472f, 155.0540961487f, 155.1347844509f, 155.2154547711f,
    155.2961071266f, 155.3767415347f, 155.4573580128f, 155.5379565781f,
    155.6185372479f, 155.6991000393f, 155.7796449696f, 155.8601720558f,
    155.9406813151f, 156.0211727646f, 156.1016464214f, 156.1821023024f,
    156.2625404247f, 156.3429608053f, 156.4233634611f, 156.5037484089f,
    156.5841156658f, 156.6644652485f, 156.7447971740f, 156.8251114589f,
    156.9054081201f, 156.9856871743f, 157.0659486382f, 157.1461925285f,
    157.2264188620f, 157.3066276551f, 157.3868189246f, 157.4669926869f,
    157.5471489587f, 157.6272877565f, 157.7074090968f, 157.7875129959f,
    157.8675994705f, 157.9476685368f, 158.0277202114f, 158.1077545104f,
    158.1877714503f, 158.2677710474f, 158.3477533179f, 158.4277182781f,
    158.5076659443f, 158.5875963325f, 158.6675094590f, 158.7474053400f,
    158.8272839914f, 158.9071454295f, 158.9869896703f, 159.0668167298f,
    159.1466266241f, 159.2264193691f, 159.3061949807f, 159.3859534750f,
    159.4656948677f, 159.5454191749f, 159.6251264123f, 159.7048165957f,
    159.7844897410f, 159.8641458640f, 159.9437849804f, 160.0234071058f,
    160.1030122561f, 160.1826004468f, 160.2621716937f, 160.3417260124f,
    160.4212634183f, 160.5007839272f, 160.5802875545f, 160.6597743159f,
    160.7392442266f, 160.8186973023f, 160.8981335584f, 160.9775530103f,
    161.0569556734f, 161.1363415631f, 161.2157106946f, 161.2950630834f,
    161.3743987447f, 161.4537176937f, 161.5330199458f, 161.6123055162f,
    161.6915744200f, 161.7708266724f, 161.8500622886f, 161.9292812837f,
    162.0084836727f, 162.0876694708f, 162.1668386930f, 162.2459913544f,
    162.3251274698f, 162.4042470544f, 162.4833501231f, 162.5624366907f,
    162.6415067723f, 162.7205603826f, 162.7995975366f, 162.8786182490f,
    162.9576225347f, 163.0366104085f, 163.1155818851f, 163.1945369793f,
    163.2734757058f, 163.3523980793f, 163.4313041144f, 163.5101938259f,
    163.5890672282f, 163.6679243361f, 163.7467651641f, 163.8255897267f,
    163.9043980385f, 163.9831901141f, 164.0619659678f, 164.1407256141f,
    164.2194690675f, 164.2981963425f, 164.3769074533f, 164.4556024144f,
    164.5342812400f, 164.6129439447f, 164.6915905426f, 164.7702210480f,
    164.8488354752f, 164.9274338384f, 165.0060161518f, 165.0845824297f,
    165.1631326862f, 165.2416669354f, 165.3201851915f, 165.3986874686f,
    165.4771737807f, 165.5556441419f, 165.6340985663f, 165.7125370679f,
    165.7909596606f, 165.8693663585f, 165.9477571755f, 166.0261321255f,
    166.1044912224f, 166.1828344801f, 166.2611619125f, 166.3394735334f,
    166.4177693567f, 166.4960493961f, 166.5743136654f, 166.6525621784f,
    166.7307949488f, 166.8090119903f, 166.8872133167f, 166.9653989416f,
    167.0435688786f, 167.1217231414f, 167.1998617436f, 167.2779846988f,
    167.3560920205f, 167.4341837223f, 167.5122598177f, 167.5903203203f,
    167.6683652435f, 167.7463946007f, 167.8244084055f, 167.9024066713f,
    167.9803894113f, 168.0583566392f, 168.1363083681f, 168.2142446114f,
    168.2921653825f, 168.3700706947f, 168.4479605612f, 168.5258349954f,
    168.6036940103f, 168.6815376194f, 168.7593658357f, 168.8371786724f,
    168.9149761428f, 168.9927582599f, 169.0705250369f, 169.1482764869f,
    169.2260126229f, 169.3037334580f, 169.3814390053f, 169.4591292777f,
    169.5368042884f, 169.6144640502f, 169.6921085762f, 169.7697378792f,
    169.8473519722f, 169.9249508681f, 170.0025345798f, 170.0801031202f,
    170.1576565021f, 170.2351947383f, 170.3127178416f, 170.3902258249f,
    170.4677187009f, 170.5451964824f, 170.6226591820f, 170.7001068125f,
    170.7775393866f, 170.8549569170f, 170.9323594164f, 171.0097468972f,
    171.0871193723f, 171.1644768542f, 171.2418193554f, 171.3191468886f,
    171.3964594662f, 171.4737571009f, 171.5510398050f, 171.6283075911f,
    171.7055604718f, 171.7827984593f, 171.8600215662f, 171.9372298048f,
    172.0144231877f, 172.0916017270f, 172.1687654353f, 172.2459143248f,
    172.3230484079f, 172.4001676969f, 172.4772722040f, 172.5543619416f,
    172.6314369219f, 172.7084971570f, 172.7855426594f, 172.8625734410f,
    172.9395895142f, 173.0165908910f, 173.0935775837f, 173.1705496043f,
    173.2475069650f, 173.3244496778f, 173.4013777548f, 173.4782912082f,
    173.5551900498f, 173.6320742918f, 173.7089439461f, 173.7857990248f,
    173.8626395397f, 173.9394655029f, 174.0162769263f, 174.0930738218f,
    174.1698562013f, 174.2466240766f, 174.3233774598f, 174.4001163625f,
    174.4768407966f, 174.5535507740f, 174.6302463064f, 174.7069274056f,
    174.7835940834f, 174.8602463515f, 174.9368842217f, 175.0135077056f,
    175.0901168150f, 175.1667115616f, 175.2432919569f, 175.3198580127f,
    175.3964097406f, 175.4729471521f, 175.5494702589f, 175.6259790726f,
    175.7024736047f, 175.7789538667f, 175.8554198703f, 175.9318716268f,
    176.0083091478f, 176.0847324449f, 176.1611415293f, 176.2375364127f,
    176.3139171063f, 176.3902836217f, 176.4666359702f, 176.5429741633f,
    176.6192982122f, 176.6956081283f, 176.7719039230f, 176.8481856076f,
    176.9244531933f, 177.0007066915f, 177.0769461134f, 177.1531714704f,
    177.2293827735f, 177.3055800341f, 177.3817632633f, 177.4579324723f,
    177.5340876724f, 177.6102288746f, 177.6863560902f, 177.7624693302f,
    177.8385686057f, 177.9146539279f, 177.9907253078f, 178.0667827565f,
    178.1428262850f, 178.2188559044f, 178.2948716257f, 178.3708734598f,
    178.4468614179f, 178.5228355108f, 178.5987957495f, 178.6747421449f,
    178.7506747080f, 178.8265934497f, 178.9024983809f, 178.9783895124f,
    179.0542668552f, 179.1301304200f, 179.2059802178f, 179.2818162592f,
    179.3576385552f, 179.4334471165f, 179.5092419539f, 179.5850230782f,
    179.6607905000f, 179.7365442302f, 179.8122842794f, 179.8880106584f,
    179.9637233778f, 180.0394224483f, 180.1151078806f, 180.1907796852f,
    180.2664378729f, 180.3420824542f, 180.4177134398f, 180.4933308401f,
    180.5689346659f, 180.6445249276f, 180.7201016357f, 180.7956648009f,
    180.8712144335f, 180.9467505442f, 181.0222731434f, 181.0977822415f,
    181.1732778490f, 181.2487599764f, 181.3242286340f, 181.3996838323f,
    181.4751255817f, 181.5505538925f, 181.6259687752f, 181.7013702400f,
    181.7767582973f, 181.8521329575f, 181.9274942309f, 182.0028421276f,
    182.0781766581f, 182.1534978326f, 182.2288056614f, 182.3041001546f,
    182.3793813226f, 182.4546491755f, 182.5299037235f, 182.6051449769f,
    182.6803729457f, 182.7555876402f, 182.8307890705f, 182.9059772467f,
    182.9811521789f, 183.0563138773f, 183.1314623519f, 183.2065976128f,
    183.2817196701f, 183.3568285338f, 183.4319242139f, 183.5070067206f,
    183.5820760637f, 183.6571322532f, 183.7321752993f, 183.8072052118f,
    183.8822220006f, 183.9572256758f, 184.0322162472f, 184.1071937248f,
    184.1821581184f, 184.2571094380f, 184.3320476935f, 184.4069728946f,
    184.4818850513f, 184.5567841733f, 184.6316702706f, 184.7065433528f,
    184.7814034299f, 184.8562505115f, 184.9310846075f, 185.0059057276f,
    185.0807138816f, 185.1555090791f, 185.2302913300f, 185.3050606438f,
    185.3798170304f, 185.4545604994f, 185.5292910604f, 185.6040087231f,
    185.6787134972f, 185.7534053922f, 185.8280844179f, 185.9027505837f,
    185.9774038993f, 186.0520443743f, 186.1266720182f, 186.2012868406f,
    186.2758888510f, 186.3504780590f, 186.4250544740f, 186.4996181056f,
    186.5741689633f, 186.6487070564f, 186.7232323946f, 186.7977449873f,
    186.8722448438f, 186.9467319736f, 187.0212063862f, 187.0956680910f,
    187.1701170972f, 187.2445534144f, 187.3189770518f, 187.3933880189f,
    187.4677863249f, 187.5421719793f, 187.6165449912f, 187.6909053701f,
    187.7652531252f, 187.8395882658f, 187.9139108012f, 187.9882207406f,
    188.0625180933f, 188.1368028685f, 188.2110750754f, 188.2853347233f,
    188.3595818212f, 188.4338163785f, 188.5080384043f, 188.5822479078f,
    188.6564448980f, 188.7306293842f, 188.8048013755f, 188.8789608809f,
    188.9531079096f, 189.0272424707f, 189.1013645733f, 189.1754742264f,
    189.2495714391f, 189.3236562204f, 189.3977285793f, 189.4717885249f,
    189.5458360662f, 189.6198712122f, 189.6938939719f, 189.7679043542f,
    189.8419023681f, 189.9158880226f, 189.9898613266f, 190.0638222890f,
    190.1377709188f, 190.2117072248f, 190.2856312160f, 190.3595429012f,
    190.4334422893f, 190.5073293892f, 190.5812042097f, 190.6550667596f,
    190.7289170479f, 190.8027550832f, 190.8765808744f, 190.9503944303f,
    191.0241957597f, 191.0979848714f, 191.1717617740f, 191.2455264764f,
    191.3192789873f, 191.3930193154f, 191.4667474695f, 191.5404634582f,
    191.6141672902f, 191.6878589743f, 191.7615385190f, 191.8352059331f,
    191.9088612252f, 191.9825044039f, 192.0561354779f, 192.1297544558f,
    192.2033613461f, 192.2769561576f, 192.3505388987f, 192.4241095781f,
    192.4976682043f, 192.5712147858f, 192.6447493312f, 192.7182718491f,
    192.7917823479f, 192.8652808362f, 192.9387673224f, 193.0122418151f,
    193.0857043227f, 193.1591548537f, 193.2325934166f, 193.3060200197f,
    193.3794346716f, 193.4528373806f, 193.5262281552f, 193.5996070038f,
    193.6729739347f, 193.7463289564f, 193.8196720772f, 193.8930033056f,
    193.9663226497f, 194.0396301180f, 194.1129257188f, 194.1862094605f,
    194.2594813513f, 194.3327413995f, 194.4059896135f, 194.4792260014f,
    194.5524505717f, 194.6256633325f, 194.6988642921f, 194.7720534586f,
    194.8452308405f, 194.9183964458f, 194.9915502828f, 195.0646923597f,
    195.1378226846f, 195.2109412658f, 195.2840481114f, 195.3571432296f,
    195.4302266285f, 195.5032983162f, 195.5763583010f, 195.6494065908f,
    195.7224431938f, 195.7954681182f, 195.8684813719f, 195.9414829631f,
    196.0144728998f, 196.0874511902f, 196.1604178422f, 196.2333728638f,
    196.3063162632f, 196.3792480483f, 196.4521682272f, 196.5250768078f,
    196.5979737982f, 196.6708592062f, 196.7437330399f, 196.8165953073f,
    196.8894460163f, 196.9622851748f, 197.0351127907f, 197.1079288721f,
    197.1807334267f, 197.2535264626f, 197.3263079876f, 197.3990780095f,
    197.4718365363f, 197.5445835758f, 197.6173191358f, 197.6900432243f,
    197.7627558491f, 197.8354570179f, 197.9081467386f, 197.9808250191f,
    198.0534918670f, 198.1261472902f, 198.1987912965f, 198.2714238937f,
    198.3440450894f, 198.4166548915f, 198.4892533077f, 198.5618403458f,
    198.6344160133f, 198.7069803182f, 198.7795332680f, 198.8520748705f,
    198.9246051333f, 198.9971240642f, 199.0696316708f, 199.1421279607f,
    199.2146129416f, 199.2870866212f, 199.3595490071f, 199.4320001068f,
    199.5044399281f, 199.5768684785f, 199.6492857656f, 199.7216917971f,
    199.7940865804f, 199.8664701231f, 199.9388424328f, 200.0112035171f,
    200.0835533835f, 200.1558920396f, 200.2282194928f, 200.3005357506f,
    200.3728408206f, 200.4451347103f, 200.5174174271f, 200.5896889786f,
    200.6619493722f, 200.7341986153f, 200.8064367155f, 200.8786636801f,
    200.9508795166f, 201.0230842325f, 201.0952778350f, 201.1674603317f,
    201.2396317300f, 201.3117920372f, 201.3839412607f, 201.4560794079f,
    201.5282064862f, 201.6003225029f, 201.6724274653f, 201.7445213808f,
    201.8166042568f, 201.8886761005f, 201.9607369193f, 202.0327867204f,
    202.1048255112f, 202.1768532990f, 202.2488700910f, 202.3208758945f,
    202.3928707167f, 202.4648545650f, 202.5368274465f, 202.6087893686f,
    202.6807403383f, 202.7526803630f, 202.8246094499f, 202.8965276061f,
    202.9684348388f, 203.0403311553f, 203.1122165627f, 203.1840910682f,
    203.2559546790f, 203.3278074021f, 203.3996492448f, 203.4714802142f,
    203.5433003174f, 203.6151095615f, 203.6869079536f, 203.7586955009f,
    203.8304722104f, 203.9022380892f, 203.9739931444f, 204.0457373831f,
    204.1174708124f, 204.1891934392f, 204.2609052706f, 204.3326063138f,
    204.4042965756f, 204.4759760631f, 204.5476447834f, 204.6193027434f,
    204.6909499501f, 204.7625864106f, 204.8342121318f, 204.9058271206f,
    204.9774313841f, 205.0490249292f, 205.1206077629f, 205.1921798920f,
    205.2637413236f, 205.3352920645f, 205.4068321217f, 205.4783615020f,
    205.5498802124f, 205.6213882598f, 205.6928856511f, 205.7643723931f,
    205.8358484927f, 205.9073139568f, 205.9787687921f, 206.0502130057f,
    206.1216466042f, 206.1930695946f, 206.2644819837f, 206.3358837782f,
    206.4072749850f, 206.4786556109f, 206.5500256627f, 206.6213851471f,
    206.6927340710f, 206.7640724411f, 206.8354002641f, 206.9067175469f,
    206.9780242961f, 207.0493205185f, 207.1206062209f, 207.1918814099f,
    207.2631460924f, 207.3344002748f, 207.4056439641f, 207.4768771669f,
    207.5480998898f, 207.6193121395f, 207.6905139228f, 207.7617052462f,
    207.8328861165f, 207.9040565402f, 207.9752165241f, 208.0463660747f,
    208.1175051986f, 208.1886339026f, 208.2597521932f, 208.3308600770f,
    208.4019575606f, 208.4730446505f, 208.5441213535f, 208.6151876760f,
    208.6862436246f, 208.7572892058f, 208.8283244263f, 208.8993492926f,
    208.9703638111f, 209.0413679885f, 209.1123618313f, 209.1833453459f,
    209.2543185389f, 209.3252814168f, 209.3962339860f, 209.4671762531f,
    209.5381082245f, 209.6090299068f, 209.6799413063f, 209.7508424296f,
    209.8217332830f, 209.8926138730f, 209.9634842062f, 210.0343442888f,
    210.1051941273f, 210.1760337281f, 210.2468630977f, 210.3176822423f,
    210.3884911686f, 210.4592898827f, 210.5300783911f, 210.6008567002f,
    210.6716248163f, 210.7423827458f, 210.8131304950f, 210.8838680703f,
    210.9545954780f, 211.0253127245f, 211.0960198160f, 211.1667167589f,
    211.2374035595f, 211.3080802241f, 211.3787467590f, 211.4494031705f,
    211.5200494648f, 211.5906856483f, 211.6613117272f, 211.7319277077f,
    211.8025335962f, 211.8731293988f, 211.9437151218f, 212.0142907715f,
    212.0848563540f, 212.1554118756f, 212.2259573425f, 212.2964927609f,
    212.3670181371f, 212.4375334771f, 212.5080387872f, 212.5785340735f,
    212.6490193423f, 212.7194945997f, 212.7899598518f, 212.8604151049f,
    212.9308603650f, 213.0012956383f, 213.0717209309f, 213.1421362490f,
    213.2125415986f, 213.2829369860f, 213.3533224171f, 213.4236978981f,
    213.4940634351f, 213.5644190342f, 213.6347647014f, 213.7051004428f,
    213.7754262645f, 213.8457421725f, 213.9160481730f, 213.9863442719f,
    214.0566304753f, 214.1269067892f, 214.1971732196f, 214.2674297726f,
    214.3376764542f, 214.4079132703f, 214.4781402271f, 214.5483573304f,
    214.6185645863f, 214.6887620007f, 214.7589495797f, 214.8291273292f,
    214.8992952551f, 214.9694533635f, 215.0396016602f, 215.1097401512f,
    215.1798688424f, 215.2499877399f, 215.3200968494f, 215.3901961769f,
    215.4602857284f, 215.5303655097f, 215.6004355267f, 215.6704957854f,
    215.7405462915f, 215.8105870511f, 215.8806180699f, 215.9506393539f,
    216.0206509088f, 216.0906527406f, 216.1606448551f, 216.2306272581f,
    216.3005999555f, 216.3705629531f, 216.4405162568f, 216.5104598722f,
    216.5803938054f, 216.6503180620f, 216.7202326479f, 216.7901375688f,
    216.8600328306f, 216.9299184390f, 216.9997943998f, 217.0696607187f,
    217.1395174016f, 217.2093644542f, 217.2792018822f, 217.3490296914f,
    217.4188478875f, 217.4886564763f, 217.5584554635f, 217.6282448547f,
    217.6980246558f, 217.7677948724f, 217.8375555102f, 217.9073065749f,
    217.9770480722f, 218.0467800078f, 218.1165023874f, 218.1862152167f,
    218.2559185012f, 218.3256122467f, 218.3952964589f, 218.4649711433f,
    218.5346363056f, 218.6042919515f, 218.6739380866f, 218.7435747164f,
    218.8132018467f, 218.8828194830f, 218.9524276310f, 219.0220262962f,
    219.0916154843f, 219.1611952008f, 219.2307654513f, 219.3003262414f,
    219.3698775767f, 219.4394194627f, 219.5089519050f, 219.5784749091f,
    219.6479884807f, 219.7174926251f, 219.7869873481f, 219.8564726551f,
    219.9259485516f, 219.9954150431f, 220.0648721352f, 220.1343198334f,
    220.2037581432f, 220.2731870701f, 220.3426066195f, 220.4120167970f,
    220.4814176080f, 220.5508090580f, 220.6201911525f, 220.6895638970f,
    220.7589272968f, 220.8282813576f, 220.8976260846f, 220.9669614833f,
    221.0362875592f, 221.1056043178f, 221.1749117643f, 221.2442099043f,
    221.3134987432f, 221.3827782863f, 221.4520485391f, 221.5213095070f,
    221.5905611953f, 221.6598036095f, 221.7290367548f, 221.7982606368f,
    221.8674752608f, 221.9366806320f, 222.0058767560f, 222.0750636380f,
    222.1442412833f, 222.2134096974f, 222.2825688856f, 222.3517188531f,
    222.4208596054f, 222.4899911477f, 222.5591134853f, 222.6282266236f,
    222.6973305678f, 222.7664253233f, 222.8355108954f, 222.9045872893f,
    222.9736545103f, 223.0427125637f, 223.1117614548f, 223.1808011888f,
    223.2498317709f, 223.3188532066f, 223.3878655009f, 223.4568686591f,
    223.5258626866f, 223.5948475884f, 223.6638233699f, 223.7327900362f,
    223.8017475926f, 223.8706960443f, 223.9396353966f, 224.0085656545f,
    224.0774868232f, 224.1463989081f, 224.2153019143f, 224.2841958469f,
    224.3530807111f, 224.4219565121f, 224.4908232551f, 224.5596809453f,
    224.6285295876f, 224.6973691875f, 224.7661997499f, 224.8350212800f,
    224.9038337829f, 224.9726372638f, 225.0414317278f, 225.1102171801f,
    225.1789936256f, 225.2477610696f, 225.3165195172f, 225.3852689733f,
    225.4540094432f, 225.5227409319f, 225.5914634446f, 225.6601769862f,
    225.7288815618f, 225.7975771766f, 225.8662638355f, 225.9349415437f,
    226.0036103062f, 226.0722701280f, 226.1409210142f, 226.2095629698f,
    226.2781959998f, 226.3468201094f, 226.4154353034f, 226.4840415869f,
    226.5526389650f, 226.6212274426f, 226.6898070247f, 226.7583777164f,
    226.8269395226f, 226.8954924483f, 226.9640364985f, 227.0325716781f,
    227.1010979922f, 227.1696154458f, 227.2381240437f, 227.3066237909f,
    227.3751146924f, 227.4435967531f, 227.5120699781f, 227.5805343721f,
    227.6489899402f, 227.7174366872f, 227.7858746182f, 227.8543037379f,
    227.9227240514f, 227.9911355636f, 228.0595382792f, 228.1279322034f,
    228.1963173408f, 228.2646936965f, 228.3330612753f, 228.4014200821f,
    228.4697701217f, 228.5381113991f, 228.6064439191f, 228.6747676865f,
    228.7430827063f, 228.8113889832f, 228.8796865222f, 228.9479753280f,
    229.0162554055f, 229.0845267595f, 229.1527893949f, 229.2210433164f,
    229.2892885290f, 229.3575250374f, 229.4257528463f, 229.4939719607f,
    229.5621823854f, 229.6303841250f, 229.6985771844f, 229.7667615685f,
    229.8349372819f, 229.9031043294f, 229.9712627159f, 230.0394124460f,
    230.1075535246f, 230.1756859564f, 230.2438097462f, 230.3119248986f,
    230.3800314185f, 230.4481293106f, 230.5162185796f, 230.5842992303f,
    230.6523712673f, 230.7204346955f, 230.7884895194f, 230.8565357439f,
    230.9245733736f, 230.9926024132f, 231.0606228675f, 231.1286347411f,
    231.1966380387f, 231.2646327650f, 231.3326189246f, 231.4005965223f,
    231.4685655628f, 231.5365260506f, 231.6044779905f, 231.6724213871f,
    231.7403562450f, 231.8082825689f, 231.8762003635f, 231.9441096334f,
    232.0120103832f, 232.0799026176f, 232.1477863411f, 232.2156615585f,
    232.2835282742f, 232.3513864930f, 232.4192362194f, 232.4870774581f,
    232.5549102136f, 232.6227344905f, 232.6905502935f, 232.7583576271f,
    232.8261564958f, 232.8939469044f, 232.9617288573f, 233.0295023590f,
    233.0972674143f, 233.1650240276f, 233.2327722035f, 233.3005119466f,
    233.3682432613f, 233.4359661522f, 233.5036806240f, 233.5713866810f,
    233.6390843278f, 233.7067735691f, 233.7744544092f, 233.8421268526f,
    233.9097909040f, 233.9774465678f, 234.0450938486f, 234.1127327507f,
    234.1803632788f, 234.2479854372f, 234.3155992306f, 234.3832046633f,
    234.4508017399f, 234.5183904648f, 234.5859708424f, 234.6535428774f,
    234.7211065740f, 234.7886619369f, 234.8562089704f, 234.9237476789f,
    234.9912780670f, 235.0588001390f, 235.1263138994f, 235.1938193527f,
    235.2613165032f, 235.3288053554f, 235.3962859137f, 235.4637581825f,
    235.5312221662f, 235.5986778693f, 235.6661252961f, 235.7335644510f,
    235.8009953384f, 235.8684179628f, 235.9358323285f, 236.0032384398f,
    236.0706363013f, 236.1380259171f, 236.2054072918f, 236.2727804296f,
    236.3401453350f, 236.4075020122f, 236.4748504657f, 236.5421906998f,
    236.6095227189f, 236.6768465272f, 236.7441621291f, 236.8114695290f,
    236.8787687311f, 236.9460597399f, 237.0133425596f, 237.0806171945f,
    237.1478836489f, 237.2151419273f, 237.2823920338f, 237.3496339727f,
    237.4168677485f, 237.4840933652f, 237.5513108274f, 237.6185201391f,
    237.6857213048f, 237.7529143286f, 237.8200992150f, 237.8872759680f,
    237.9544445920f, 238.0216050913f, 238.0887574701f, 238.1559017327f,
    238.2230378833f, 238.2901659261f, 238.3572858654f, 238.4243977055f,
    238.4915014506f, 238.5585971048f, 238.6256846725f, 238.6927641578f,
    238.7598355650f, 238.8268988982f, 238.8939541618f, 238.9610013598f,
    239.0280404966f, 239.0950715762f, 239.1620946029f, 239.2291095809f,
    239.2961165144f, 239.3631154076f, 239.4301062645f, 239.4970890895f,
    239.5640638866f, 239.6310306601f, 239.6979894141f, 239.7649401527f,
    239.8318828802f, 239.8988176006f, 239.9657443182f, 240.0326630371f,
    240.0995737613f, 240.1664764951f, 240.2333712426f, 240.3002580079f,
    240.3671367951f, 240.4340076084f, 240.5008704518f, 240.5677253296f,
    240.6345722457f, 240.7014112044f, 240.7682422096f, 240.8350652656f,
    240.9018803764f, 240.9686875461f, 241.0354867787f, 241.1022780785f,
    241.1690614494f, 241.2358368955f, 241.3026044209f, 241.3693640297f,
    241.4361157259f, 241.5028595136f, 241.5695953969f, 241.6363233798f,
    241.7030434663f, 241.7697556606f, 241.8364599666f, 241.9031563884f,
    241.9698449301f, 242.0365255956f, 242.1031983890f, 242.1698633144f,
    242.2365203756f, 242.3031695769f, 242.3698109221f, 242.4364444153f,
    242.5030700605f, 242.5696878617f, 242.6362978229f, 242.7028999480f,
    242.7694942412f, 242.8360807064f, 242.9026593475f, 242.9692301685f,
    243.0357931735f, 243.1023483664f, 243.1688957511f, 243.2354353317f,
    243.3019671121f, 243.3684910963f, 243.4350072882f, 243.5015156917f,
    243.5680163109f, 243.6345091496f, 243.7009942119f, 243.7674715016f,
    243.8339410227f, 243.9004027791f, 243.9668567748f, 244.0333030137f,
    244.0997414996f, 244.1661722366f, 244.2325952285f, 244.2990104792f,
    244.3654179927f, 244.4318177729f, 244.4982098236f, 244.5645941488f,
    244.6309707523f, 244.6973396380f, 244.7637008099f, 244.8300542718f,
    244.8964000276f, 244.9627380811f, 245.0290684363f, 245.0953910970f,
    245.1617060671f, 245.2280133504f, 245.2943129508f, 245.3606048721f,
    245.4268891183f, 245.4931656931f, 245.5594346004f, 245.6256958441f,
    245.6919494279f, 245.7581953558f, 245.8244336315f, 245.8906642589f,
    245.9568872418f, 246.0231025841f, 246.0893102895f, 246.1555103618f,
    246.2217028049f, 246.2878876226f, 246.3540648187f, 246.4202343969f,
    246.4863963612f, 246.5525507152f, 246.6186974628f, 246.6848366078f,
    246.7509681539f, 246.8170921050f, 246.8832084648f, 246.9493172370f,
    247.0154184255f, 247.0815120340f, 247.1475980663f, 247.2136765262f,
    247.2797474173f, 247.3458107436f, 247.4118665086f, 247.4779147162f,
    247.5439553701f, 247.6099884741f, 247.6760140319f, 247.7420320472f,
    247.8080425237f, 247.8740454652f, 247.9400408755f, 248.0060287582f,
    248.0720091170f, 248.1379819557f, 248.2039472780f, 248.2699050876f,
    248.3358553882f, 248.4017981834f, 248.4677334771f, 248.5336612729f,
    248.5995815745f, 248.6654943855f, 248.7313997098f, 248.7972975509f,
    248.8631879125f, 248.9290707983f, 248.9949462120f, 249.0608141573f,
    249.1266746377f, 249.1925276571f, 249.2583732190f, 249.3242113272f,
    249.3900419852f, 249.4558651967f, 249.5216809654f, 249.5874892948f,
    249.6532901888f, 249.7190836508f, 249.7848696845f, 249.8506482936f,
    249.9164194817f, 249.9821832524f, 250.0479396094f, 250.1136885562f,
    250.1794300964f, 250.2451642338f, 250.3108909719f, 250.3766103143f,
    250.4423222646f, 250.5080268264f, 250.5737240033f, 250.6394137989f,
    250.7050962168f, 250.7707712607f, 250.8364389340f, 250.9020992403f,
    250.9677521833f, 251.0333977665f, 251.0990359936f, 251.1646668679f,
    251.2302903932f, 251.2959065730f, 251.3615154109f, 251.4271169103f,
    251.4927110750f, 251.5582979083f, 251.6238774139f, 251.6894495954f,
    251.7550144562f, 251.8205719999f, 251.8861222300f, 251.9516651502f,
    252.0172007638f, 252.0827290744f, 252.1482500856f, 252.2137638009f,
    252.2792702238f, 252.3447693578f, 252.4102612065f, 252.4757457732f,
    252.5412230616f, 252.6066930752f, 252.6721558174f, 252.7376112918f,
    252.8030595018f, 252.8685004509f, 252.9339341427f, 252.9993605806f,
    253.0647797681f, 253.1301917086f, 253.1955964058f, 253.2609938629f,
    253.3263840835f, 253.3917670711f, 253.4571428292f, 253.5225113611f,
    253.5878726704f, 253.6532267605f, 253.7185736349f, 253.7839132970f,
    253.8492457503f, 253.9145709981f, 253.9798890441f, 254.0451998915f,
    254.1105035438f, 254.1758000045f, 254.2410892771f, 254.3063713648f,
    254.3716462712f, 254.4369139996f, 254.5021745535f, 254.5674279364f,
    254.6326741515f, 254.6979132024f, 254.7631450925f, 254.8283698250f,
    254.8935874035f, 254.9587978314f, 255.0240011120f, 255.0891972487f,
    255.1543862449f, 255.2195681041f, 255.2847428295f, 255.3499104246f,
    255.4150708928f, 255.4802242374f, 255.5453704618f, 255.6105095694f,
    255.6756415635f, 255.7407664475f, 255.8058842248f, 255.8709948988f,
    255.9360984727f, 256.0011949500f, 256.0662843339f, 256.1313666279f,
    256.1964418353f, 256.2615099594f, 256.3265710035f, 256.3916249711f,
    256.4566718654f, 256.5217116898f, 256.5867444476f, 256.6517701421f,
    256.7167887766f, 256.7818003546f, 256.8468048792f, 256.9118023538f,
    256.9767927817f, 257.0417761662f, 257.1067525107f, 257.1717218184f,
    257.2366840926f, 257.3016393367f, 257.3665875539f, 257.4315287475f,
    257.4964629208f, 257.5613900771f, 257.6263102197f, 257.6912233518f,
    257.7561294768f, 257.8210285980f, 257.8859207185f, 257.9508058417f,
    258.0156839708f, 258.0805551091f, 258.1454192599f, 258.2102764264f,
    258.2751266118f, 258.3399698195f, 258.4048060527f, 258.4696353147f,
    258.5344576086f, 258.5992729377f, 258.6640813053f, 258.7288827147f,
    258.7936771689f, 258.8584646714f, 258.9232452252f, 258.9880188337f,
    259.0527855001f, 259.1175452275f, 259.1822980193f, 259.2470438785f,
    259.3117828085f, 259.3765148125f, 259.4412398936f, 259.5059580551f,
    259.5706693002f, 259.6353736320f, 259.7000710538f, 259.7647615688f,
    259.8294451802f, 259.8941218911f, 259.9587917047f, 260.0234546243f,
    260.0881106530f, 260.1527597940f, 260.2174020504f, 260.2820374255f,
    260.3466659225f, 260.4112875444f, 260.4759022945f, 260.5405101759f,
    260.6051111918f, 260.6697053454f, 260.7342926397f, 260.7988730781f,
    260.8634466635f, 260.9280133992f, 260.9925732883f, 261.0571263340f,
    261.1216725394f, 261.1862119076f, 261.2507444418f, 261.3152701451f,
    261.3797890207f, 261.4443010716f, 261.5088063010f, 261.5733047121f,
    261.6377963079f, 261.7022810916f, 261.7667590662f, 261.8312302350f,
    261.8956946009f, 261.9601521672f, 262.0246029369f, 262.0890469132f,
    262.1534840990f, 262.2179144977f, 262.2823381121f, 262.3467549455f,
    262.4111650008f, 262.4755682813f, 262.5399647900f, 262.6043545299f,
    262.6687375042f, 262.7331137160f, 262.7974831682f, 262.8618458641f,
    262.9262018066f, 262.9905509988f, 263.0548934439f, 263.1192291448f,
    263.1835581046f, 263.2478803264f, 263.3121958132f, 263.3765045682f,
    263.4408065943f, 263.5051018946f, 263.5693904721f, 263.6336723299f,
    263.6979474711f, 263.7622158986f, 263.8264776156f, 263.8907326250f,
    263.9549809298f, 264.0192225332f, 264.0834574381f, 264.1476856476f,
    264.2119071647f, 264.2761219924f, 264.3403301337f, 264.4045315916f,
    264.4687263692f, 264.5329144695f, 264.5970958954f, 264.6612706500f,
    264.7254387363f, 264.7896001573f, 264.8537549160f, 264.9179030153f,
    264.9820444583f, 265.0461792480f, 265.1103073874f, 265.1744288794f,
    265.2385437270f, 265.3026519333f, 265.3667535011f, 265.4308484335f,
    265.4949367335f, 265.5590184039f, 265.6230934479f, 265.6871618683f,
    265.7512236682f, 265.8152788504f, 265.8793274180f, 265.9433693738f,
    266.0074047210f, 266.0714334624f, 266.1354556009f, 266.1994711396f,
    266.2634800813f, 266.3274824290f, 266.3914781857f, 266.4554673543f,
    266.5194499377f, 266.5834259389f, 266.6473953608f, 266.7113582063f,
    266.7753144784f, 266.8392641799f, 266.9032073139f, 266.9671438832f,
    267.0310738908f, 267.0949973395f, 267.1589142323f, 267.2228245722f,
    267.2867283619f, 267.3506256044f, 267.4145163027f, 267.4784004596f,
    267.5422780780f, 267.6061491608f, 267.6700137110f, 267.7338717314f,
    267.7977232248f, 267.8615681943f, 267.9254066427f, 267.9892385728f,
    268.0530639876f, 268.1168828899f, 268.1806952827f, 268.2445011687f,
    268.3083005509f, 268.3720934321f, 268.4358798153f, 268.4996597032f,
    268.5634330987f, 268.6272000048f, 268.6909604242f, 268.7547143598f,
    268.8184618145f, 268.8822027911f, 268.9459372925f, 269.0096653216f,
    269.0733868811f, 269.1371019739f, 269.2008106029f, 269.2645127709f,
    269.3282084808f, 269.3918977353f, 269.4555805374f, 269.5192568898f,
    269.5829267953f, 269.6465902569f, 269.7102472773f, 269.7738978594f,
    269.8375420059f, 269.9011797197f, 269.9648110037f, 270.0284358605f,
    270.0920542931f, 270.1556663042f, 270.2192718967f, 270.2828710734f,
    270.3464638370f, 270.4100501903f, 270.4736301362f, 270.5372036775f,
    270.6007708170f, 270.6643315573f, 270.7278859015f, 270.7914338521f,
    270.8549754120f, 270.9185105841f, 270.9820393710f, 271.0455617756f,
    271.1090778006f, 271.1725874488f, 271.2360907230f, 271.2995876260f,
    271.3630781605f, 271.4265623292f, 271.4900401350f, 271.5535115807f,
    271.6169766689f, 271.6804354025f, 271.7438877841f, 271.8073338166f,
    271.8707735027f, 271.9342068451f, 271.9976338467f, 272.0610545100f,
    272.1244688380f, 272.1878768333f, 272.2512784986f, 272.3146738368f,
    272.3780628505f, 272.4414455425f, 272.5048219154f, 272.5681919722f,
    272.6315557153f, 272.6949131477f, 272.7582642719f, 272.8216090908f,
    272.8849476071f, 272.9482798233f, 273.0116057424f, 273.0749253670f,
    273.1382386998f, 273.2015457434f, 273.2648465007f, 273.3281409743f,
    273.3914291669f, 273.4547110813f, 273.5179867201f, 273.5812560859f,
    273.6445191816f, 273.7077760098f, 273.7710265732f, 273.8342708744f,
    273.8975089163f, 273.9607407013f, 274.0239662323f, 274.0871855119f,
    274.1503985428f, 274.2136053277f, 274.2768058692f, 274.3400001700f,
    274.4031882327f, 274.4663700601f, 274.5295456549f, 274.5927150196f,
    274.6558781569f, 274.7190350695f, 274.7821857601f, 274.8453302313f,
    274.9084684857f, 274.9716005261f, 275.0347263550f, 275.0978459751f,
    275.1609593890f, 275.2240665995f, 275.2871676091f, 275.3502624205f,
    275.4133510363f, 275.4764334591f, 275.5395096916f, 275.6025797365f,
    275.6656435963f, 275.7287012736f, 275.7917527712f, 275.8547980916f,
    275.9178372374f, 275.9808702112f, 276.0438970158f, 276.1069176537f,
    276.1699321274f, 276.2329404397f, 276.2959425931f, 276.3589385903f,
    276.4219284338f, 276.4849121262f, 276.5478896702f, 276.6108610683f,
    276.6738263232f, 276.7367854375f, 276.7997384136f, 276.8626852544f,
    276.9256259622f, 276.9885605397f, 277.0514889896f, 277.1144113143f,
    277.1773275165f, 277.2402375987f, 277.3031415635f, 277.3660394136f,
    277.4289311514f, 277.4918167796f, 277.5546963007f, 277.6175697172f,
    277.6804370319f, 277.7432982471f, 277.8061533656f, 277.8690023898f,
    277.9318453223f, 277.9946821656f, 278.0575129224f, 278.1203375951f,
    278.1831561864f, 278.2459686988f, 278.3087751347f, 278.3715754969f,
    278.4343697877f, 278.4971580098f, 278.5599401658f, 278.6227162580f,
    278.6854862891f, 278.7482502617f, 278.8110081781f, 278.8737600411f,
    278.9365058530f, 278.9992456165f, 279.0619793341f, 279.1247070082f,
    279.1874286414f, 279.2501442362f, 279.3128537952f, 279.3755573209f,
    279.4382548157f, 279.5009462822f, 279.5636317229f, 279.6263111403f,
    279.6889845369f, 279.7516519152f, 279.8143132778f, 279.8769686270f,
    279.9396179655f, 280.0022612957f, 280.0648986201f, 280.1275299413f,
    280.1901552616f, 280.2527745837f, 280.3153879099f, 280.3779952428f,
    280.4405965848f, 280.5031919385f, 280.5657813063f, 280.6283646906f,
    280.6909420941f, 280.7535135191f, 280.8160789682f, 280.8786384437f,
    280.9411919483f, 281.0037394842f, 281.0662810541f, 281.1288166603f,
    281.1913463054f, 281.2538699917f, 281.3163877219f, 281.3788994982f,
    281.4414053232f, 281.5039051993f, 281.5663991290f, 281.6288871148f,
    281.6913691590f, 281.7538452641f, 281.8163154326f, 281.8787796669f,
    281.9412379695f, 282.0036903428f, 282.0661367892f, 282.1285773111f,
    282.1910119111f, 282.2534405915f, 282.3158633548f, 282.3782802034f,
    282.4406911397f, 282.5030961662f, 282.5654952852f, 282.6278884993f,
    282.6902758108f, 282.7526572221f, 282.8150327356f, 282.8774023539f,
    282.9397660792f, 283.0021239140f, 283.0644758607f, 283.1268219218f,
    283.1891620995f, 283.2514963964f, 283.3138248149f, 283.3761473572f,
    283.4384640259f, 283.5007748233f, 283.5630797519f, 283.6253788140f,
    283.6876720120f, 283.7499593482f, 283.8122408252f, 283.8745164453f,
    283.9367862109f, 283.9990501242f, 284.0613081879f, 284.1235604041f,
    284.1858067754f, 284.2480473040f, 284.3102819924f, 284.3725108428f,
    284.4347338578f, 284.4969510397f, 284.5591623908f, 284.6213679134f,
    284.6835676101f, 284.7457614831f, 284.8079495348f, 284.8701317675f,
    284.9323081836f, 284.9944787855f, 285.0566435756f, 285.1188025561f,
    285.1809557294f, 285.2431030980f, 285.3052446640f, 285.3673804299f,
    285.4295103981f, 285.4916345708f, 285.5537529504f, 285.6158655393f,
    285.6779723397f, 285.7400733541f, 285.8021685847f, 285.8642580340f,
    285.9263417041f, 285.9884195975f, 286.0504917165f, 286.1125580633f,
    286.1746186405f, 286.2366734501f, 286.2987224947f, 286.3607657764f,
    286.4228032977f, 286.4848350608f, 286.5468610680f, 286.6088813217f,
    286.6708958242f, 286.7329045778f, 286.7949075847f, 286.8569048474f,
    286.9188963681f, 286.9808821491f, 287.0428621927f, 287.1048365012f,
    287.1668050769f, 287.2287679221f, 287.2907250391f, 287.3526764303f,
    287.4146220978f, 287.4765620440f, 287.5384962711f, 287.6004247816f,
    287.6623475775f, 287.7242646613f, 287.7861760353f, 287.8480817016f,
    287.9099816625f, 287.9718759205f, 288.0337644776f, 288.0956473363f,
    288.1575244987f, 288.2193959672f, 288.2812617439f, 288.3431218313f,
    288.4049762315f, 288.4668249468f, 288.5286679795f, 288.5905053319f,
    288.6523370061f, 288.7141630045f, 288.7759833294f, 288.8377979828f,
    288.8996069673f, 288.9614102848f, 289.0232079379f, 289.0849999286f,
    289.1467862592f, 289.2085669320f, 289.2703419492f, 289.3321113130f,
    289.3938750258f, 289.4556330897f, 289.5173855070f, 289.5791322798f,
    289.6408734106f, 289.7026089014f, 289.7643387545f, 289.8260629722f,
    289.8877815566f, 289.9494945101f, 290.0112018347f, 290.0729035328f,
    290.1345996066f, 290.1962900583f, 290.2579748901f, 290.3196541042f,
    290.3813277029f, 290.4429956883f, 290.5046580627f, 290.5663148283f,
    290.6279659873f, 290.6896115419f, 290.7512514942f, 290.8128858467f,
    290.8745146013f, 290.9361377603f, 290.9977553260f, 291.0593673005f,
    291.1209736860f, 291.1825744848f, 291.2441696989f, 291.3057593307f,
    291.3673433822f, 291.4289218558f, 291.4904947535f, 291.5520620776f,
    291.6136238302f, 291.6751800135f, 291.7367306298f, 291.7982756812f,
    291.8598151698f, 291.9213490979f, 291.9828774677f, 292.0444002812f,
    292.1059175407f, 292.1674292484f, 292.2289354064f, 292.2904360168f,
    292.3519310820f, 292.4134206039f, 292.4749045849f, 292.5363830270f,
    292.5978559324f, 292.6593233033f, 292.7207851418f, 292.7822414501f,
    292.8436922304f, 292.9051374847f, 292.9665772153f, 293.0280114244f,
    293.0894401139f, 293.1508632862f, 293.2122809433f, 293.2736930874f,
    293.3350997206f, 293.3965008451f, 293.4578964631f, 293.5192865766f,
    293.5806711878f, 293.6420502988f, 293.7034239118f, 293.7647920289f,
    293.8261546522f, 293.8875117839f, 293.9488634261f, 294.0102095809f,
    294.0715502505f, 294.1328854369f, 294.1942151423f, 294.2555393688f,
    294.3168581186f, 294.3781713938f, 294.4394791964f, 294.5007815286f,
    294.5620783925f, 294.6233697902f, 294.6846557238f, 294.7459361955f,
    294.8072112073f, 294.8684807614f, 294.9297448599f, 294.9910035048f,
    295.0522566982f, 295.1135044424f, 295.1747467393f, 295.2359835911f,
    295.2972149999f, 295.3584409677f, 295.4196614966f, 295.4808765889f,
    295.5420862464f, 295.6032904714f, 295.6644892659f, 295.7256826321f,
    295.7868705719f, 295.8480530875f, 295.9092301809f, 295.9704018543f,
    296.0315681097f, 296.0927289493f, 296.1538843749f, 296.2150343889f,
    296.2761789932f, 296.3373181899f, 296.3984519810f, 296.4595803687f,
    296.5207033550f, 296.5818209420f, 296.6429331318f, 296.7040399264f,
    296.7651413278f, 296.8262373382f, 296.8873279595f, 296.9484131940f,
    297.0094930435f, 297.0705675102f, 297.1316365962f, 297.1927003034f,
    297.2537586339f, 297.3148115899f, 297.3758591732f, 297.4369013861f,
    297.4979382305f, 297.5589697084f, 297.6199958220f, 297.6810165732f,
    297.7420319642f, 297.8030419968f, 297.8640466733f, 297.9250459955f,
    297.9860399657f, 298.0470285857f, 298.1080118576f, 298.1689897835f,
    298.2299623653f, 298.2909296052f, 298.3518915051f, 298.4128480670f,
    298.4737992931f, 298.5347451853f, 298.5956857456f, 298.6566209760f,
    298.7175508787f, 298.7784754555f, 298.8393947085f, 298.9003086398f,
    298.9612172513f, 299.0221205450f, 299.0830185230f, 299.1439111873f,
    299.2047985399f, 299.2656805827f, 299.3265573178f, 299.3874287473f,
    299.4482948730f, 299.5091556971f, 299.5700112214f, 299.6308614481f,
    299.6917063790f, 299.7525460163f, 299.8133803618f, 299.8742094177f,
    299.9350331858f, 299.9958516682f, 300.0566648668f, 300.1174727837f,
    300.1782754208f, 300.2390727802f, 300.2998648637f, 300.3606516735f,
    300.4214332114f, 300.4822094795f, 300.5429804797f, 300.6037462140f,
    300.6645066844f, 300.7252618928f, 300.7860118413f, 300.8467565318f,
    300.9074959663f, 300.9682301468f, 301.0289590751f, 301.0896827534f,
    301.1504011835f, 301.2111143674f, 301.2718223071f, 301.3325250046f,
    301.3932224617f, 301.4539146805f, 301.5146016630f, 301.5752834110f,
    301.6359599265f, 301.6966312116f, 301.7572972681f, 301.8179580980f,
    301.8786137032f, 301.9392640857f, 301.9999092475f, 302.0605491905f,
    302.1211839166f, 302.1818134278f, 302.2424377260f, 302.3030568132f,
    302.3636706913f, 302.4242793622f, 302.4848828279f, 302.5454810904f,
    302.6060741514f, 302.6666620131f, 302.7272446773f, 302.7878221460f,
    302.8483944210f, 302.9089615044f, 302.9695233980f, 303.0300801037f,
    303.0906316236f, 303.1511779595f, 303.2117191133f, 303.2722550870f,
    303.3327858824f, 303.3933115016f, 303.4538319463f, 303.5143472186f,
    303.5748573204f, 303.6353622535f, 303.6958620199f, 303.7563566215f,
    303.8168460601f, 303.8773303378f, 303.9378094564f, 303.9982834178f,
    304.0587522239f, 304.1192158767f, 304.1796743780f, 304.2401277297f,
    304.3005759338f, 304.3610189920f, 304.4214569065f, 304.4818896789f,
    304.5423173113f, 304.6027398054f, 304.6631571633f, 304.7235693868f,
    304.7839764778f, 304.8443784381f, 304.9047752697f, 304.9651669745f,
    305.0255535543f, 305.0859350110f, 305.1463113465f, 305.2066825627f,
    305.2670486615f, 305.3274096447f, 305.3877655143f, 305.4481162720f,
    305.5084619199f, 305.5688024596f, 305.6291378932f, 305.6894682225f,
    305.7497934494f, 305.8101135757f, 305.8704286033f, 305.9307385341f,
    305.9910433699f, 306.0513431126f, 306.1116377640f, 306.1719273261f,
    306.2322118007f, 306.2924911897f, 306.3527654948f, 306.4130347180f,
    306.4732988611f, 306.5335579260f, 306.5938119145f, 306.6540608286f,
    306.7143046699f, 306.7745434404f, 306.8347771420f, 306.8950057764f,
    306.9552293456f, 307.0154478513f, 307.0756612955f, 307.1358696799f,
    307.1960730064f, 307.2562712768f, 307.3164644931f, 307.3766526569f,
    307.4368357702f, 307.4970138348f, 307.5571868526f, 307.6173548253f,
    307.6775177547f, 307.7376756429f, 307.7978284914f, 307.8579763023f,
    307.9181190772f, 307.9782568181f, 308.0383895268f, 308.0985172050f,
    308.1586398547f, 308.2187574776f, 308.2788700755f, 308.3389776504f,
    308.3990802039f, 308.4591777379f, 308.5192702542f, 308.5793577547f,
    308.6394402412f, 308.6995177154f, 308.7595901791f, 308.8196576343f,
    308.8797200827f, 308.9397775260f, 308.9998299662f, 309.0598774050f,
    309.1199198442f, 309.1799572857f, 309.2399897311f, 309.3000171824f,
    309.3600396414f, 309.4200571097f, 309.4800695893f, 309.5400770819f,
    309.6000795893f, 309.6600771133f, 309.7200696557f, 309.7800572184f,
    309.8400398030f, 309.9000174114f, 309.9599900453f, 310.0199577066f,
    310.0799203970f, 310.1398781184f, 310.1998308724f, 310.2597786610f,
    310.3197214858f, 310.3796593487f, 310.4395922514f, 310.4995201957f,
    310.5594431834f, 310.6193612162f, 310.6792742960f, 310.7391824245f,
    310.7990856035f, 310.8589838348f, 310.9188771200f, 310.9787654611f,
    311.0386488597f, 311.0985273177f, 311.1584008367f, 311.2182694186f,
    311.2781330651f, 311.3379917781f, 311.3978455591f, 311.4576944101f,
    311.5175383327f, 311.5773773288f, 311.6372114000f, 311.6970405482f,
    311.7568647751f, 311.8166840824f, 311.8764984719f, 311.9363079454f,
    311.9961125046f, 312.0559121512f, 312.1157068870f, 312.1754967138f,
    312.2352816333f, 312.2950616472f, 312.3548367573f, 312.4146069653f,
    312.4743722729f, 312.5341326820f, 312.5938881942f, 312.6536388113f,
    312.7133845350f, 312.7731253671f, 312.8328613093f, 312.8925923633f,
    312.9523185308f, 313.0120398136f, 313.0717562135f, 313.1314677321f,
    313.1911743712f, 313.2508761325f, 313.3105730177f, 313.3702650286f,
    313.4299521669f, 313.4896344342f, 313.5493118324f, 313.6089843632f,
    313.6686520282f, 313.7283148292f, 313.7879727679f, 313.8476258460f,
    313.9072740652f, 313.9669174274f, 314.0265559340f, 314.0861895870f,
    314.1458183879f, 314.2054423385f, 314.2650614406f, 314.3246756957f,
    314.3842851057f, 314.4438896722f, 314.5034893970f, 314.5630842817f,
    314.6226743280f, 314.6822595376f, 314.7418399123f, 314.8014154538f,
    314.8609861637f, 314.9205520437f, 314.9801130956f, 315.0396693210f,
    315.0992207216f, 315.1587672991f, 315.2183090552f, 315.2778459917f,
    315.3373781101f, 315.3969054122f, 315.4564278997f, 315.5159455743f,
    315.5754584375f, 315.6349664912f, 315.6944697371f, 315.7539681767f,
    315.8134618118f, 315.8729506440f, 315.9324346751f, 315.9919139067f,
    316.0513883404f, 316.1108579781f, 316.1703228213f, 316.2297828717f,
    316.2892381310f, 316.3486886009f, 316.4081342830f, 316.4675751790f,
    316.5270112905f, 316.5864426194f, 316.6458691671f, 316.7052909354f,
    316.7647079260f, 316.8241201404f, 316.8835275805f, 316.9429302477f,
    317.0023281439f, 317.0617212706f, 317.1211096295f, 317.1804932223f,
    317.2398720506f, 317.2992461161f, 317.3586154205f, 317.4179799653f,
    317.4773397523f, 317.5366947831f, 317.5960450593f, 317.6553905826f,
    317.7147313547f, 317.7740673771f, 317.8333986516f, 317.8927251798f,
    317.9520469634f, 318.0113640039f, 318.0706763030f, 318.1299838624f,
    318.1892866837f, 318.2485847685f, 318.3078781185f, 318.3671667353f,
    318.4264506206f, 318.4857297760f, 318.5450042031f, 318.6042739035f,
    318.6635388790f, 318.7227991311f, 318.7820546614f, 318.8413054716f,
    318.9005515634f, 318.9597929382f, 319.0190295979f, 319.0782615439f,
    319.1374887780f, 319.1967113017f, 319.2559291167f, 319.3151422245f,
    319.3743506269f, 319.4335543254f, 319.4927533216f, 319.5519476172f,
    319.6111372138f, 319.6703221130f, 319.7295023164f, 319.7886778257f,
    319.8478486424f, 319.9070147681f, 319.9661762045f, 320.0253329532f,
    320.0844850157f, 320.1436323938f, 320.2027750889f, 320.2619131028f,
    320.3210464369f, 320.3801750930f, 320.4392990726f, 320.4984183773f,
    320.5575330088f, 320.6166429685f, 320.6757482582f, 320.7348488794f,
    320.7939448337f, 320.8530361228f, 320.9121227481f, 320.9712047114f,
    321.0302820141f, 321.0893546579f, 321.1484226445f, 321.2074859752f,
    321.2665446519f, 321.3255986760f, 321.3846480491f, 321.4436927729f,
    321.5027328489f, 321.5617682787f, 321.6207990638f, 321.6798252060f,
    321.7388467066f, 321.7978635674f, 321.8568757899f, 321.9158833757f,
    321.9748863264f, 322.0338846435f, 322.0928783286f, 322.1518673833f,
    322.2108518092f, 322.2698316078f, 322.3288067807f, 322.3877773296f,
    322.4467432559f, 322.5057045612f, 322.5646612471f, 322.6236133151f,
    322.6825607669f, 322.7415036040f, 322.8004418280f, 322.8593754404f,
    322.9183044427f, 322.9772288367f, 323.0361486237f, 323.0950638054f,
    323.1539743833f, 323.2128803591f, 323.2717817341f, 323.3306785101f,
    323.3895706886f, 323.4484582710f, 323.5073412591f, 323.5662196542f,
    323.6250934580f, 323.6839626721f, 323.7428272979f, 323.8016873371f,
    323.8605427911f, 323.9193936615f, 323.9782399499f, 324.0370816579f,
    324.0959187868f, 324.1547513384f, 324.2135793141f, 324.2724027156f,
    324.3312215442f, 324.3900358016f, 324.4488454893f, 324.5076506089f,
    324.5664511618f, 324.6252471496f, 324.6840385739f, 324.7428254362f,
    324.8016077380f, 324.8603854809f, 324.9191586663f, 324.9779272959f,
    325.0366913711f, 325.0954508935f, 325.1542058646f, 325.2129562859f,
    325.2717021589f, 325.3304434853f, 325.3891802664f, 325.4479125039f,
    325.5066401993f, 325.5653633540f, 325.6240819696f, 325.6827960476f,
    325.7415055896f, 325.8002105970f, 325.8589110714f, 325.9176070142f,
    325.9762984271f, 326.0349853115f, 326.0936676689f, 326.1523455009f,
    326.2110188089f, 326.2696875944f, 326.3283518591f, 326.3870116043f,
    326.4456668317f, 326.5043175426f, 326.5629637386f, 326.6216054213f,
    326.6802425921f, 326.7388752525f, 326.7975034040f, 326.8561270481f,
    326.9147461864f, 326.9733608203f, 327.0319709513f, 327.0905765810f,
    327.1491777108f, 327.2077743422f, 327.2663664767f, 327.3249541158f,
    327.3835372611f, 327.4421159139f, 327.5006900758f, 327.5592597483f,
    327.6178249329f, 327.6763856311f, 327.7349418443f, 327.7934935740f,
    327.8520408218f, 327.9105835891f, 327.9691218774f, 328.0276556882f,
    328.0861850229f, 328.1447098831f, 328.2032302702f, 328.2617461858f,
    328.3202576312f, 328.3787646080f, 328.4372671177f, 328.4957651617f,
    328.5542587415f, 328.6127478585f, 328.6712325144f, 328.7297127105f,
    328.7881884482f, 328.8466597292f, 328.9051265548f, 328.9635889265f,
    329.0220468458f, 329.0805003142f, 329.1389493331f, 329.1973939040f,
    329.2558340283f, 329.3142697076f, 329.3727009433f, 329.4311277368f,
    329.4895500897f, 329.5479680033f, 329.6063814791f, 329.6647905187f,
    329.7231951234f, 329.7815952948f, 329.8399910342f, 329.8983823432f,
    329.9567692231f, 330.0151516755f, 330.0735297018f, 330.1319033035f,
    330.1902724820f, 330.2486372387f, 330.3069975751f, 330.3653534927f,
    330.4237049929f, 330.4820520772f, 330.5403947470f, 330.5987330037f,
    330.6570668488f, 330.7153962838f, 330.7737213101f, 330.8320419291f,
    330.8903581422f, 330.9486699510f, 331.0069773569f, 331.0652803612f,
    331.1235789655f, 331.1818731712f, 331.2401629797f, 331.2984483924f,
    331.3567294109f, 331.4150060364f, 331.4732782705f, 331.5315461146f,
    331.5898095702f, 331.6480686385f, 331.7063233212f, 331.7645736196f,
    331.8228195351f, 331.8810610693f, 331.9392982234f, 331.9975309989f,
    332.0557593973f, 332.1139834200f, 332.1722030684f, 332.2304183439f,
    332.2886292480f, 332.3468357821f, 332.4050379475f, 332.4632357458f,
};
static float get_visual_mask(float value) {
  DCHECK(value >= 0.0f);
  DCHECK(value < 4000.0f);
  return gVisualMaskTable[(int)value];
}
}  // namespace SkPMetricUtil

#endif  // CHROME_BROWSER_CHROMEOS_LOGIN_SCREENSHOT_TESTING_SKPMETRICUTIL_GEN_H_
