/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-cfg-common.c,v 1.5 2003/12/15 16:08:53 hoa Exp $
 */

#include "etpan-cfg-common.h"

#include <stdlib.h>
#include <string.h>

#include <libetpan/libetpan.h>

#include "etpan-errors.h"

int etpan_cfg_strdup(char ** pnew_str, char * str)
{
  char * new_str;

  if (str != NULL) {
    new_str = strdup(str);
    if (new_str == NULL)
      return ERROR_MEMORY;
  }
  else
    new_str = NULL;

  * pnew_str = new_str;

  return NO_ERROR;
}


int etpan_cfg_get_type_from_name(struct etpan_type_name * table, int count,
    const char * name)
{
  int i;

  for(i = 0 ; i < count ; i++) {
    if (strcasecmp(name, table[i].name) == 0)
      return table[i].id;
  }

  return -1;
}

const char * etpan_cfg_get_name_from_type(struct etpan_type_name * table,
    int count, const int type)
{
  int i;

  for(i = 0 ; i < count ; i++) {
    if (type == table[i].id)
      return table[i].name;
  }

  return NULL;
}

struct etpan_command *
etpan_command_new(int type, char * cmd)
{
  struct etpan_command * cmd_data;

  cmd_data = malloc(sizeof(struct etpan_command));
  if (cmd_data == NULL)
    return NULL;

  cmd_data->type = type;
  cmd_data->name = cmd;

  return cmd_data;
}

void etpan_command_free(struct etpan_command * cmd_data)
{
  free(cmd_data->name);
  free(cmd_data);
}

static struct etpan_type_name flag_types_name[] = {
  {MAIL_FLAG_NEW, "new"},
  {MAIL_FLAG_SEEN, "seen"},
  {MAIL_FLAG_FLAGGED, "flagged"},
  {MAIL_FLAG_DELETED, "deleted"},
  {MAIL_FLAG_ANSWERED, "answered"},
  {MAIL_FLAG_FORWARDED, "forwarded"},
};

uint32_t etpan_cfg_get_flag_value(char * flag)
{
  return etpan_cfg_get_type_from_name(flag_types_name,
      sizeof(flag_types_name) / sizeof(struct etpan_type_name),
      flag);
}
