/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-cfg-vfolder.h,v 1.9 2004/11/12 13:57:02 hoa Exp $
 */

#ifndef ETPAN_CFG_VFOLDER_H

#define ETPAN_CFG_VFOLDER_H

#include <libetpan/libetpan.h>
#include <libetpan/clist.h>
#include <libetpan/chash.h>
#include "etpan-cfg-storage-types.h"
#include "etpan-cfg-account-types.h"
#include "etpan-cfg-vfolder-types.h"

int etpan_vfolder_config_read(char * filename,
    struct etpan_storage_config * storage_config,
    struct etpan_account_config * account_config,
    struct etpan_vfolder_config ** result);

struct etpan_account_info *
etpan_vfolder_get_account(struct etpan_vfolder_config * vfolder_config,
    struct etpan_account_config * account_config,
    struct mailfolder * folder);

void etpan_vfolder_set_account(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder, struct etpan_account_info * account);

struct mailfolder *
etpan_vfolder_get_sent_folder(struct etpan_vfolder_config * config,
    struct mailfolder * folder);

void etpan_vfolder_set_sent_folder(struct etpan_vfolder_config *
    vfolder_config,
    struct mailfolder * folder, struct mailfolder * sent_folder);

struct mailfolder *
etpan_vfolder_get_draft_folder(struct etpan_vfolder_config * config,
    struct mailfolder * folder);

void etpan_vfolder_set_draft_folder(struct etpan_vfolder_config *
    vfolder_config,
    struct mailfolder * folder, struct mailfolder * draft_folder);

struct mailimf_address_list *
etpan_vfolder_get_to(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder);

void etpan_vfolder_set_mail_to(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder, struct mailimf_address_list * mail_to);

int etpan_vfolder_do_poll(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder);

void etpan_vfolder_set_poll(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder, int poll);

uint32_t etpan_vfolder_get_max(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder);

void etpan_vfolder_set_max(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder, uint32_t max);

struct etpan_vfolder_config *
etpan_vfolder_config_new(struct mailfolder * root,
    chash * folder_prop,
    struct mailfolder * default_folder,
    struct mailfolder * sent_folder,
    struct mailfolder * draft_folder);

void etpan_vfolder_config_free(struct etpan_vfolder_config * config);

int etpan_offline_config_read(char * filename,
    struct etpan_storage_config * storage_config, 
    struct etpan_offline_config ** result);

struct etpan_offline_config * etpan_offline_config_new(chash * folder_hash,
    clist * folder_list);

void etpan_offline_config_free(struct etpan_offline_config * config);

char * etpan_folder_get_virtual_path(struct mailfolder * folder);

int etpan_cfg_vfolder_write(char * filename,
    struct etpan_vfolder_config * vfolder_config,
    struct etpan_account_config * account_config);


int etpan_cfg_vfolder_add_prop(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder);

int etpan_cfg_vfolder_remove_prop(struct etpan_vfolder_config * vfolder_config,
    struct mailfolder * folder);

struct etpan_vfolder_property *
etpan_vfolder_get_prop(struct etpan_vfolder_config * config,
    struct mailfolder * folder);

struct mailfolder *
etpan_vfolder_get_folder(struct etpan_vfolder_config * config,
    char * name);

#endif

