/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-msg-list-app.h,v 1.11 2004/11/14 18:22:13 hoa Exp $
 */

#ifndef ETPAN_MSG_LIST_APP_H

#define ETPAN_MSG_LIST_APP_H

#include <libetpan/libetpan.h>
#include "etpan-subapp-types.h"

struct etpan_subapp * etpan_msg_list_app_new(struct etpan_app * app);

int etpan_msg_list_app_set_folder(struct etpan_subapp * app,
    struct mailfolder * folder);

void etpan_msg_list_app_set_msglist(struct etpan_subapp * app,
    struct mailmessage_tree * env_tree,
    struct etpan_node_msg_params * node_params);

struct mailfolder * etpan_msg_list_app_get_folder(struct etpan_subapp * app);

mailmessage * etpan_msg_list_app_get_selected_msg(struct etpan_subapp * app);

int etpan_msg_list_app_open_next(struct etpan_subapp * app,
    int forward);

int etpan_view_mime(struct etpan_subapp * app, mailmessage * msg);

int etpan_msg_list_first_unread(struct etpan_subapp * app,
    int verbose);

#endif
