/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-storage-common.c,v 1.7 2004/11/12 12:13:27 nyoxi Exp $
 */

#include "etpan-storage-common.h"
#include "etpan-subapp.h"
#include "etpan-app.h"
#include "etpan-app-subapp.h"
#include "etpan-errors.h"
#include "etpan-tools.h"
#include "etpan-cfg-storage.h"
#include "etpan-cfg-common.h"
#include <stdlib.h>
#include "etpan-thread-manager.h"
#include "etpan-storage-edit.h"
#include "etpan-subapp-thread.h"

struct storage_info {
  int ref;
};

static struct storage_info * get_storage_info(chash * storage_info,
    struct mailstorage * storage)
{
  chashdatum key;
  chashdatum value;
  int r;
  
  key.data = &storage;
  key.len = sizeof(storage);
  
  r = chash_get(storage_info, &key, &value);
  if (r < 0)
    return NULL;
  else
    return value.data;
}


void etpan_storage_common_display(struct etpan_subapp * app,
    struct etpan_storage_common_state * state,
    WINDOW * w, char * help_text)
{
  int percent;
  int list_lines;
  char * output;
  char * fill;
  int y;
  unsigned int i;

  list_lines = app->display_height - 1;
  
  output = app->app->output;
  fill = app->app->fill;
  
  /* update window */
  
  if (state->index > carray_count(state->storage_tab) - 1)
    state->index = carray_count(state->storage_tab) - 1;
  
  if (state->index < state->first)
    state->first = state->index;
  if (state->index - state->first + 1 > (unsigned int) list_lines)
    state->first = state->index - list_lines + 1;
  
#if 0
  i = state->first;
  for(i = 0 ;
      i < carray_count(state->config->storage_config->storage_tab) ; i ++) {
    struct mailstorage * storage;
    
    storage = carray_get(state->config->storage_config->storage_tab, i);
    
    index ++;
  }
  cur = clist_nth(state->config->storage_config->list, state->first);
#endif
  
  /* start to display */
  
  i = state->first;
  wattron(w, state->main_attr);
  
  y = 0;
  while (y < list_lines) {
    struct mailstorage * storage;
    struct storage_info * info;
    int ref;
    
    if (i >= carray_count(state->storage_tab))
      break;
    
    storage = carray_get(state->storage_tab, i);
    
    ref = 0;
    info = get_storage_info(state->storage_info, storage);
    if (info != NULL)
      ref = info->ref;
    
    if (storage->sto_id != NULL)
      snprintf(output, app->display_width, "%s (%s) (%i)%s",
          storage->sto_id, storage->sto_driver->sto_name, ref, fill);
    else
      snprintf(output, app->display_width, "[no name] (%s) (%i)%s",
          storage->sto_driver->sto_name, ref, fill);
    if (i == state->index) {
      wattroff(w, state->main_attr);
      wattron(w, state->selection_attr);
    }
    mvwprintw(w, y, 0, "%s", output);
    if (i == state->index) {
      wattroff(w, state->selection_attr);
      wattron(w, state->main_attr);
    }
    
    y ++;
    i ++;

#if 0    
    cur = clist_next(cur);
#endif
  }
  
  while (y < list_lines) {
    mvwprintw(w, y, 0, "%s", fill);
    y ++;
  }

  wattroff(w, state->main_attr);
  
  /* status bar */

  wattron(w, state->status_attr);
  
  if (carray_count(state->storage_tab) == 0)
    percent = 0;
  else if (carray_count(state->storage_tab) == 1)
	percent = 100;
  else
    percent = state->index * 100 / (carray_count(state->storage_tab)-1);
  
  if (help_text != NULL)
    snprintf(output, app->display_width + 1,
        " %3i %% | %i storages | %s%s",
        percent, carray_count(state->storage_tab), help_text, fill);
  else
    snprintf(output, app->display_width + 1,
        " %3i %% | %i storages%s",
        percent, carray_count(state->storage_tab), fill);
  
  mvwprintw(w, app->display_height - 1, 0, "%s", output);
  
  wattroff(w, state->status_attr);
}

int etpan_storage_common_init(struct etpan_storage_common_state * state)
{
  state->storage_info = chash_new(CHASH_DEFAULTSIZE, CHASH_COPYKEY);
  if (state->storage_info == NULL)
    goto err;
  
  state->storage_tab = carray_new(16);
  if (state->storage_tab == NULL)
    goto free_storage_info;
  
  state->config = NULL;
  state->index = 0;
  state->first = 0;
  
  /* colors */
  state->main_attr = A_NORMAL;
  state->selection_attr = A_REVERSE;
  state->status_attr = A_REVERSE;
  
  return NO_ERROR;
  
 free_storage_info:
  chash_free(state->storage_info);
 err:
  return ERROR_MEMORY;
}


void etpan_storage_common_flush(struct etpan_storage_common_state * state)
{
  chashiter * cur;
  
  state->config = NULL;
  
  for(cur = chash_begin(state->storage_info) ; cur != NULL ;
      cur = chash_next(state->storage_info, cur)) {
    chashdatum value;
    struct storage_info * info;
    
    chash_value(cur, &value);
    info = value.data;
    free(info);
  }
  chash_clear(state->storage_info);
}

static void
recursive_folder_count_ref(chash * storage_info,
    struct mailfolder * folder)
{
  unsigned int i;
  int r;
  chashdatum key;
  chashdatum value;
  
  if (folder->fld_storage != NULL) {
    struct storage_info * info;
    
    info = get_storage_info(storage_info, folder->fld_storage);
    if (info == NULL) {
      info = malloc(sizeof(* info));
      if (info == NULL) {
        /* error */
        return;
      }
      
      info->ref = 0;
      
      key.data = &folder->fld_storage;
      key.len = sizeof(folder->fld_storage);
      value.data = info;
      value.len = 0;
      r = chash_set(storage_info, &key, &value, NULL);
      if (r < 0) {
        free(info);
        info = NULL;
      }
    }
    if (info != NULL) {
      info->ref ++;
    }
  }
  
  for(i = 0 ; i < carray_count(folder->fld_children) ; i ++) {
    struct mailfolder * child;
    
    child = carray_get(folder->fld_children, i);
    recursive_folder_count_ref(storage_info, child);
  }
}

int etpan_storage_common_set(struct etpan_storage_common_state * state,
    struct etpan_app_config * config, struct mailstorage * storage)
{
  unsigned int i;
  
  etpan_storage_common_flush(state);
  
  state->config = config;
  
  carray_set_size(state->storage_tab, 0);
  
  for(i = 0 ;
      i < carray_count(state->config->storage_config->storage_tab) ; i ++) {
    struct mailstorage * cur_storage;
    
    cur_storage = carray_get(state->config->storage_config->storage_tab, i);
    if (!etpan_storage_config_is_generated(state->config->storage_config,
            cur_storage)) {
      carray_add(state->storage_tab, cur_storage, NULL);
      
      if (storage == cur_storage)
        state->index = carray_count(state->storage_tab) - 1;
    }
  }
  
#if 0
  state->count = clist_count(state->config->storage_config->list);
#endif
  
  recursive_folder_count_ref(state->storage_info,
      state->config->vfolder_config->root);

#if 0  
  i = 0;
  for(cur = clist_begin(state->config->storage_config->list) ; cur != NULL ;
      cur = clist_next(cur)) {
    if (storage == clist_content(cur)) {
      state->index = i;
      break;
    }
    
    i ++;
  }
#endif
  
  return NO_ERROR;
}

#if 0
static void update_state(struct etpan_subapp * app)
{
  struct app_state * state;
  chashiter * cur;
  
  state = app->data;
  
  state->count = clist_count(state->config->list);
  
  for(cur = chash_begin(state->storage_info) ; cur != NULL ;
      cur = chash_next(state->storage_info, cur)) {
    chashdatum value;
    struct storage_info * info;
    
    chash_value(cur, &value);
    info = (struct storage_info *) value.data;
    free(info);
  }
  chash_clear(state->storage_info);
  
  if (state->root != NULL)
    recursive_folder_count_ref(app, state->storage_info,
        state->root);
}
#endif


void etpan_storage_common_handle_key(struct etpan_subapp * app,
    struct etpan_storage_common_state * state, int key)
{
  unsigned int list_lines;
  unsigned int chosen;
  
  chosen = 0;
  list_lines = app->display_height - 1;
  
  switch (key) {
  case '0':
  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9':
  case 'G':
    break;
    
  default:
    chosen = 0;
    break;
  }
  
  switch (key) {
  case '0':
  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9':
    chosen *= 10;
    chosen += key - '0';
    break;
    
  case 'G':
    if (chosen == 0) {
      if (carray_count(state->storage_tab) > 0)
        state->index = carray_count(state->storage_tab) - 1;
    }
    else {
      if (chosen >= carray_count(state->storage_tab) - 1)
        chosen = carray_count(state->storage_tab);
      if (chosen > 0)
        state->index = chosen - 1;
    }
    break;
    
  case KEY_UP:
  case 'k':
    if (state->index > 0)
      state->index --;
    break;
    
  case KEY_DOWN:
  case 'j':
    if (state->index < carray_count(state->storage_tab) - 1)
      state->index ++;
    break;

  case KEY_NPAGE:
    if (state->index + list_lines - 1 < carray_count(state->storage_tab))
      state->index += list_lines - 1;
    else
      state->index = carray_count(state->storage_tab) - 1;
    break;
    
  case KEY_PPAGE:
    if (state->index >= list_lines - 1)
      state->index -= list_lines - 1;
    else
      state->index = 0;
    break;
    
  case KEY_HOME:
    state->index = 0;
    break;
    
  case KEY_END:
    state->index = carray_count(state->storage_tab) - 1;
    break;
  }
}

void etpan_storage_common_set_color(struct etpan_subapp * app,
    struct etpan_storage_common_state * state)
{
  etpan_app_set_color(app->app, "main",
      &state->main_attr, A_NORMAL);
  etpan_app_set_color(app->app, "selection",
      &state->selection_attr, A_REVERSE);
  etpan_app_set_color(app->app, "status",
      &state->status_attr, A_REVERSE);
}

void etpan_storage_common_done(struct etpan_storage_common_state * state)
{
  chash_free(state->storage_info);
}


  
struct mailstorage *
etpan_storage_common_get_selected_storage(struct etpan_storage_common_state *
    state)
{
  struct mailstorage * storage;
  
  storage = carray_get(state->config->storage_config->storage_tab,
      state->index);
  
  return storage;
}


int etpan_storage_common_get_storage_ref_count(struct
    etpan_storage_common_state * state, struct mailstorage * storage)
{
  struct storage_info * info;
  
  info = get_storage_info(state->storage_info, storage);
  if (info == NULL)
    return 0;
  
  return info->ref;
}
