/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-thread-manager.h,v 1.12 2004/12/12 12:38:57 hoa Exp $
 */

#ifndef ETPAN_THREAD_MANAGER_H

#define ETPAN_THREAD_MANAGER_H

#include "etpan-thread-manager-types.h"
#include <libetpan/libetpan.h>
#include <semaphore.h>

/*
  these 3 headers MUST be included before <sys/select.h>
  to insure compatibility with Mac OS X (this is true for 10.2)
*/
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/select.h>

void etpan_thread_op_cancel(struct etpan_thread_op * op);

struct etpan_thread_manager * etpan_thread_manager_new(struct etpan_app * app);
void etpan_thread_manager_free(struct etpan_thread_manager * thread_manager);

int etpan_thread_manager_stop(struct etpan_thread_manager * thread_manager);

struct etpan_thread_op *
etpan_thread_op_add(struct etpan_thread_manager * thread_manager,
    int cmd,
    struct mailstorage * storage,
    struct mailfolder * folder,
    mailmessage * msg,
    struct mailmime * mime,
    void * arg, int detached);

int etpan_thread_op_is_finished(struct etpan_thread_op * op);

void etpan_thread_op_wait(struct etpan_thread_op * op);
void etpan_thread_op_ack(struct etpan_thread_op * op);

void etpan_thread_op_set_fds(struct etpan_thread_op * op, fd_set * fds,
    int * max_fd);

int etpan_storage_op_count(struct etpan_thread_manager * thread_manager,
    struct mailstorage * storage);

#if 0
void etpan_stop_storage_thread(struct etpan_thread_manager * thread_manager,
    struct mailstorage * storage);
#endif

struct etpan_thread_op *
etpan_thread_msg_op_add(struct etpan_thread_manager * thread_manager,
    int cmd,
    mailmessage * msg,
    struct mailmime * mime,
    void * arg, int detached);

struct etpan_thread_op *
etpan_thread_folder_op_add(struct etpan_thread_manager * thread_manager,
    int cmd,
    struct mailfolder * folder,
    mailmessage * msg,
    struct mailmime * mime,
    void * arg, int detached);

int etpan_thread_manager_start(struct etpan_thread_manager * manager);

struct etpan_thread_op *
etpan_thread_abook_op_add(struct etpan_thread_manager * thread_manager,
    int cmd,
    struct etpan_abook * abook,
    void * arg, int detached);

struct etpan_thread_op *
etpan_thread_sender_op_add(struct etpan_thread_manager * thread_manager,
    int cmd,
    struct etpan_sender_item * sender,
    void * arg, int detached);

#endif
