/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: p64.h,v 1.1.8.1 2004/07/09 01:50:08 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/*
 * Copyright (c) 1993-1994 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Network Research
 *	Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/*
 * This code is derived from the P64 software implementation by the
 * Stanford PVRG group:
 * 
 * Copyright (C) 1990, 1991, 1993 Andy C. Hung, all rights reserved.
 * PUBLIC DOMAIN LICENSE: Stanford University Portable Video Research
 * Group. If you use this software, you agree to the following: This
 * program package is purely experimental, and is licensed "as is".
 * Permission is granted to use, modify, and distribute this program
 * without charge for any purpose, provided this license/ disclaimer
 * notice appears in the copies.  No warranty or maintenance is given,
 * either expressed or implied.  In no event shall the author(s) be
 * liable to you or a third party for any special, incidental,
 * consequential, or other damages, arising out of the use or inability
 * to use the program for any purpose (or the loss of data), even if we
 * have been advised of such possibilities.  Any public reference or
 * advertisement of this source code should refer to it as the Portable
 * Video Research Group (PVRG) code, and not by any author(s) (or
 * Stanford University) name.
 */

#ifndef lib_p64_h
#define lib_p64_h

#ifndef _MACINTOSH
#   include <sys/types.h>
#else
#   include "config.h"
#endif // _MACINTOSH

struct huffcode;

#define MBPERGOB 33

class P64Decoder {
    public:
	virtual ~P64Decoder();
	const u_char* frame() const { return (back_); }
	inline int ndblk() const { return (ndblk_); }
	inline void resetndblk() { ndblk_ = 0; }
	inline int width() const { return (width_); }
	inline int height() const { return (height_); }
	virtual int frame_size() = 0;
	virtual int decode(const u_char* bp, int cc,
			   int sbit, int ebit, int mba, int gob,
			   int quant, int mvdh, int mvdv);
	virtual void sync();
	inline void bb(int& x, int& y, int& w, int& h) {
		x = bbx_; y = bby_; w = bbw_; h = bbh_;
	};
	inline u_int bad_psc() const { return (bad_psc_); }
	inline u_int bad_bits() const { return (bad_bits_); }
	inline u_int bad_GOBno() const { return (bad_GOBno_); }
	inline u_int bad_fmt() const { return (bad_fmt_); }
	inline int seenMaxGob() const { return (maxgob_ >= ngob_ - 1); }
	inline u_int gobquant() const { return (gobquant_); }

	inline void marks(u_char* p) { marks_ = p; }
	inline void mark(int v) { mark_ = v; }
    protected:
	P64Decoder();
	void init();
	virtual void allocate() = 0;
	void inithuff();
	void initquant();
	virtual void err(const char* msg ...) const;
	int quantize(int v, int q);
#ifdef INT_64
	int parse_block(short* blk, INT_64* mask);
#else
	int parse_block(short* blk, u_int* mask);
#endif
	void decode_block(u_int tc, u_int x, u_int y, u_int stride,
			  u_char* front, u_char* back, int sf);
	void filter(u_char* in, u_char* out, u_int stride);
	void mvblk(u_char* in, u_char* out, u_int stride);
	void mvblka(u_char*, u_char*, u_int stride);

	int parse_picture_hdr();
	int parse_sc();
	int parse_gob_hdr(int);
	int parse_mb_hdr(u_int& cbp);
	int decode_gob(u_int gob);
	int decode_mb();

	FILE*			m_pLog;

	u_int size_;
	u_char* fs_;
	u_char* front_;
	u_char* back_;

	struct hufftab {
		int maxlen;
		const short* prefix;
	};
	hufftab ht_mba_;
	hufftab ht_mvd_;
	hufftab ht_cbp_;
	hufftab ht_tcoeff_;
	hufftab ht_mtype_;

	u_int bb_;		/* 32-bit bit buffer */
	int nbb_;		/* number bits in bit buffer */
	const u_short* bs_;	/* input bit stream (less bits in bb_) */
	const u_short* es_;	/* pointer to end if input stream */
	const u_short* ps_;	/* packet start (for error reporting) */
	int pebit_;		/* packet end bit (for error reporting) */

#define MBST_FRESH	0
#define MBST_OLD	1
#define MBST_NEW	2
	u_char* mbst_;
	short* qt_;
	u_short* coord_;

	u_int width_;		/* width of Y component */
	u_int height_;		/* height of Y component */
	
#define IT_QCIF	0
#define IT_CIF	1
	u_int fmt_;		/* image format (CIF/QCIF) */
	u_int ngob_;		/* number of gobs (12 for CIF, 3 for QCIF) */
	u_int maxgob_;		/* max gob seen this frame */
	int ndblk_;		/* # of decoded macroblocks */
	u_int gobquant_;	/* last gob quantizer (for info funtion) */

	u_int mt_;		/* macroblock type (flags in p64-huff.h) */
	u_int gob_;		/* current gob index */
	int mba_;		/* macroblock address (predictor) */
	int mvdh_;		/* motion vector (predictor) */
	int mvdv_;		/* motion vector (predictor) */

	/* bounding box */
	u_int minx_;
	u_int miny_;
	u_int maxx_;
	u_int maxy_;
	u_int bbx_;
	u_int bby_;
	u_int bbw_;
	u_int bbh_;

	/*
	 * Table to indicate which blocks have changed.
	 */
	u_char* marks_;
	int mark_;

	/* error counters */
	int bad_psc_;
	int bad_bits_;
	int bad_GOBno_;
	int bad_fmt_;		/* # times RTP fmt != H.261 fmt */

	u_char mb_state_[16 * 64];
	/* inverse quantization via table lookup */
	short quant_[32 * 256];
	/* gob/mba to coordinate mappings */
	u_short base_[16 * 64];
};

class FullP64Decoder : public P64Decoder {
    public:
	FullP64Decoder();
    protected:
	virtual void allocate();
	void mbcopy(u_int mba);
	void swap();
	virtual void sync();
	virtual int frame_size() { return (size_ + (size_ >> 1)); }

};

class IntraP64Decoder : public P64Decoder {
    public:
	IntraP64Decoder();
    protected:
	virtual void allocate();
	virtual int frame_size() { return (size_ + (size_ >> 1)); }
};

#endif
