/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: theora_codec_info.h,v 1.2.4.1 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef THEORA_CODEC_INFO_H
#define THEORA_CODEC_INFO_H

#include "codec_info.h"

class CTheoraCodecInfo : public COggCodecInfo
{
public:
    static COggCodecInfo* Build(ogg_packet* pPkt);
    
    virtual ~CTheoraCodecInfo();

    // COggCodecInfo methods
    virtual HX_RESULT OnPacket(ogg_packet* pPkt);

    virtual OggCodecType Type() const;
    virtual BOOL HaveHeaders() const;
    virtual BOOL HaveBaseGranulePos() const;
    virtual BOOL AllowPacketOutError() const;

    virtual ogg_int64_t CurrentGranulePos() const;
    virtual HX_RESULT SetCurrentGranulePos(ogg_int64_t pos);
    virtual ogg_int64_t GranulePosDropped() const;
    virtual ogg_int64_t GranulePosDifference(ogg_int64_t a, 
                                             ogg_int64_t b) const;

    virtual BOOL IsHeader(ogg_packet* pPkt) const;
    virtual BOOL IsCommentHeader(ogg_packet* pPkt) const;
    virtual ogg_packet* CreateBlankCommentPacket() const;

    virtual HX_RESULT GetTimestamp(ogg_int64_t granulePos, 
                                   COggTimestamp& timestamp) const;

    virtual HX_RESULT GetBaseTimestamp(COggTimestamp& timestamp) const;
    virtual HX_RESULT SetBaseTimestamp(const COggTimestamp& timestamp);
    virtual HX_RESULT SetStartTimestamp(const COggTimestamp& timestamp);

    virtual COggCodecInfo* Clone() const;

private:
    typedef enum {
        Start,
        NeedComment,
        NeedCodebook,
        NeedFirstDataPkt,
        NeedBaseTime,
        Ready
    } State;

    CTheoraCodecInfo();
    HX_RESULT copy(const CTheoraCodecInfo& rhs);

    void changeState(State newState);
    HX_RESULT handleIdentHdr(ogg_packet* pPkt);
    HX_RESULT updatePosition(ogg_packet* pPkt);
    
    UINT32 gcd(UINT32 a, UINT32 b);
    ogg_int64_t granuleToFrames(ogg_int64_t pos) const;
    ogg_int64_t framesToGranulePos(ogg_int64_t frames) const;

    static BOOL isTheoraHeader(ogg_packet* pPkt);

    State m_state;
    UINT32 m_uFPSNum;
    UINT32 m_uFPSDenom;
    UINT32 m_uBitrate;    
    UINT8  m_uKeyFrameShift;
    UINT8* m_pIdentBuf;
    UINT32 m_uIdentBufSize;
    BOOL m_bFirstPkt;
    ogg_int64_t m_currentPos;
    ogg_int64_t m_basePos;
    ogg_int64_t m_dropped;

    COggTimestamp m_startTimestamp;
    
    static const unsigned char zm_blankComment[];
};
#endif /* THEORA_CODEC_INFO_H */
