/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smltime.h,v 1.2.12.1 2004/07/09 01:58:02 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SMLTIME_H_
#define _SMLTIME_H_

// Forward declarations
class CSmilTimelineElement;
class CHXMapStringToOb;
class CSmilElement;
class CSmilParser;
class CHXSimpleList;

class CSmilTimelineElementManager
{
public:
    CSmilTimelineElementManager();
    ~CSmilTimelineElementManager();

    void                  addTimelineElement(CSmilTimelineElement* pElement);
    void                  addNotification(const char* pID,
                                          CSmilTimelineElement* pElement);
    void                  notify(const char* pID);
    void                  resetTimeline();
    CSmilTimelineElement* getTimelineElement(const char* pID);
private:

    CHXMapStringToOb*                   m_pElementMap;
    CHXMapStringToOb*                   m_pNotifierMap;
};

class CSmilTimelineElement
{
public:
    CSmilTimelineElement(CSmilElement* pSourceElement,
                         CSmilParser*  pParser);
    virtual ~CSmilTimelineElement();

    virtual void setDelay(UINT32 ulDelay, BOOL bSetByParent);
    virtual void setDuration(UINT32 ulDuration, BOOL bSetFromParent = FALSE,
                             BOOL bDurationExtendingDueToPause=FALSE);
    virtual void setMaxDuration(UINT32 ulMaxDuration);
    virtual void adjustDependentDuration(CSmilTimelineElement* pDependent);
    virtual void addDuration(UINT32 ulDuration, UINT32 ulDelay,
			     UINT32 ulChildDelayBeyondStartOfThis, const char* pID) {};
    virtual void resetDelay(UINT32 ulDelay);
            void resetDuration(UINT32 ulDuration);
    virtual void adjustDuration(void);
    void         prepForRestart();
    BOOL         initialDelaySet() { return m_bDelaySet; }
    BOOL         delayEvent() { return m_bDelayEvent; }
    BOOL         isDelayEventResolved() { return !m_bDelayEvent; }
    void         setDelayEventResolved(BOOL bResolved) { m_bDelayEvent = !bResolved; }
    BOOL         durationSet() { return m_bDurationSet; }
    BOOL         durationEvent() { return m_bDurationEvent; }
    HX_RESULT    handlePrefetchFinished(UINT32 ulTimeFinished);
    void         reset();
    virtual void elementResolved(CSmilTimelineElement* pElement);
    void         setParent(CSmilTimelineElement* pParent) { m_pParent = pParent; }
    void         setDependent(CSmilTimelineElement* pDependent) { m_pDependent = pDependent; }
    void         addChild(CSmilTimelineElement* pChild);
    UINT32       getDuration();
    UINT32       getDelay();
    virtual void dump();
    void         checkChildrenFillBehavior();
    void         checkElementFillBehavior();
    CSmilTimelineElement* getDependent() const { return m_pDependent; }
    CSmilTimelineElement* getParent() const { return m_pParent; }
    CSmilElement*         getSourceElement() const { return m_pSourceElement; }

    char*        m_pID;

    UINT32       numChildDursAdded() {return(m_pChildDurAddedMap? m_pChildDurAddedMap->GetCount():0);}

    BOOL         hasChildWithScheduledBegin() { return m_bHasChildWithScheduledBegin; }
    void         setHasChildWithScheduledBegin(BOOL bHC) { m_bHasChildWithScheduledBegin = bHC; }

    UINT32	 getNumChildren() { return (m_pChildren? (UINT32)m_pChildren->GetCount():0); }

    CHXSimpleList*  getChildren() { return m_pChildren; }
protected:
    CSmilElement*         m_pSourceElement;
    CSmilParser*          m_pParser;
    CHXSimpleList*        m_pChildren;
    CSmilTimelineElement* m_pParent;
    CSmilTimelineElement* m_pDependent;
    BOOL                  m_bDelaySet;
    BOOL                  m_bDelayEvent;
    BOOL                  m_bDurationEvent;
    BOOL                  m_bDurationSet;
    BOOL                  m_bMaxDurationSet;
    BOOL                  m_bDontResetDuration;
    //The following is for cases where a non-event delay and
    // an event delay exist and m_bDelaySet is not sufficient
    // to keep track of all 3 possible delaySet states.  The
    // non-event delay is always set before the event is resolved
    // so that's why there are 3 and not 4 states:
    BOOL                  m_bNonEventDelaySet;
    ULONG32		  m_ulNonEventDelay;

    // /This map keeps track of whether or not child elements have been
    // added to the duration of this; if a child adds its duration twice,
    // we don't want to increment m_nDurationAdded vars (see subclasses):
    CHXMapStringToOb*	  m_pChildDurAddedMap;

    BOOL                  m_bHasChildWithScheduledBegin;

    BOOL		  m_bInElementResolved;

    // Methods that are shared by <par> and <excl>
    void setParExclDuration(UINT32 ulDuration, BOOL bSetFromParent = FALSE);
    void setParExclMaxDuration(UINT32 ulMaxDuration);
    void parExclElementResolved(CSmilTimelineElement* pElement);
    void parExclDurationResolved(UINT32 ulDuration, BOOL bUpdateChildren);
    
    friend class CSmilTimelinePar;
    friend class CSmilTimelineSeq;
    friend class CSmilTimelineExcl;
    friend class CSmilTimelineAnchor;
};

        
class CSmilTimelinePar : public CSmilTimelineElement
{
public:
    CSmilTimelinePar(CSmilElement* pSourceElement,
                     CSmilParser*  pRenderer);
    virtual ~CSmilTimelinePar();

    virtual void setDelay(UINT32 ulDelay, BOOL bSetByParent);
    virtual void setDuration(UINT32 ulDuration, BOOL bSetFromParent = FALSE,
                             BOOL bDurationExtendingDueToPause=FALSE);
    virtual void setMaxDuration(UINT32 ulMaxDuration);
    virtual void addDuration(UINT32 ulDuration, UINT32 ulDelay,
			     UINT32 ulChildDelayBeyondStartOfThis, const char* pID);
    virtual void resetDelay(UINT32 ulDelay);
    virtual void adjustDuration(void);
    virtual void elementResolved(CSmilTimelineElement* pElement);
    void         durationResolved(UINT32 ulDuration, BOOL bUpdateChildren);
private:
    int    m_nDurationAdded;
    UINT32 m_ulFirstDuration;
    // /Use of this *helps* fix PR 56795 and PR 50684:
    BOOL   m_bFirstDurationHasBeenSet;
    UINT32 m_ulLastDuration;
};

class CSmilTimelineSeq : public CSmilTimelineElement
{
public:
    CSmilTimelineSeq(CSmilElement* pSourceElement, 
                     CSmilParser*  pRenderer);

    virtual void setDelay(UINT32 ulDelay, BOOL bSetByParent);
    virtual void setDuration(UINT32 ulDuration, BOOL bSetFromParent = FALSE,
                             BOOL bDurationExtendingDueToPause=FALSE);
    virtual void setMaxDuration(UINT32 ulMaxDuration);
    virtual void adjustDependentDuration(CSmilTimelineElement* pDependent);
    BOOL         setElementDuration(UINT32& ulDurationLeft, CSmilTimelineElement* pElement);
    virtual void addDuration(UINT32 ulDuration, UINT32 ulDelay,
			     UINT32 ulChildDelayBeyondStartOfThis, const char* pID);
    virtual void resetDelay(UINT32 ulDelay);
    virtual void adjustDuration(void);
private:
    int m_nDurationAdded;
};

class CSmilTimelineExcl : public CSmilTimelineElement
{
public:
    CSmilTimelineExcl(CSmilElement* pSourceElement, 
                      CSmilParser*  pRenderer);
    virtual ~CSmilTimelineExcl();

    virtual void setDelay(UINT32 ulDelay, BOOL bSetByParent);
    virtual void setDuration(UINT32 ulDuration, BOOL bSetFromParent = FALSE,
                             BOOL bDurationExtendingDueToPause=FALSE);
    virtual void setMaxDuration(UINT32 ulMaxDuration);
    virtual void addDuration(UINT32 ulDuration, UINT32 ulDelay,
			     UINT32 ulChildDelayBeyondStartOfThis, const char* pID);
    virtual void resetDelay(UINT32 ulDelay);
    virtual void adjustDuration(void);
    virtual void elementResolved(CSmilTimelineElement* pElement);
    void         durationResolved(UINT32 ulDuration, BOOL bUpdateChildren);
private:
    int    m_nDurationAdded;
    UINT32 m_ulFirstDuration;
    BOOL   m_bFirstDurationHasBeenSet;
    UINT32 m_ulLastDuration;
};

class CSmilTimelineAnchor: public CSmilTimelineElement
{
public:
    CSmilTimelineAnchor(CSmilElement* pSourceElement,
                        CSmilParser*  pRenderer);
    virtual ~CSmilTimelineAnchor();

    virtual void elementResolved(CSmilTimelineElement* pElement);
    void         durationResolved(UINT32 ulDuration);
private:
    int m_nDurationAdded;
};

class CSmilTimelineAnimate : public CSmilTimelineElement
{
public:
    CSmilTimelineAnimate(CSmilElement* pSourceElement,
                         CSmilParser*  pRenderer);
    virtual ~CSmilTimelineAnimate();

    virtual void setDuration(UINT32 ulDuration, BOOL bSetFromParent = FALSE,
                             BOOL bDurationExtendingDueToPause=FALSE);
private:
};

#endif  /* _SMLTIME_H_ */
