/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: c_rtrndr.h,v 1.1.2.1 2004/07/09 01:50:49 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  C_RTRNDR.H
//
//  This file contains the definition of the class RealTextRenderer.
//
//  The constuctor takes a pointer to a TextWindow object (see "txtwindw.h"),
//  and does not verify whether or not it is a valid pointer.  The destructor
//  of RealTextRenderer does not delete m_pTextWindow, so it is the
//  duty of the code that created that TextWindow to delete it.
//
//

#if !defined(_C_RTRNDR_H_)
#define _C_RTRNDR_H_


class TextWindow;
class TextParser;

/*  Minimum pixels in x and/or y that any text must move
*  (by scrolling and/or crawling) before being redrawn:  */
#define MOTION_GRANULARITY		    2

//Delete everything in the TextContainerList every time the
// following number of milliseconds goes by:
#define TIME_BETWEEN_LIVE_LIST_PURGES_msec 8000


//This is used to keep track of what data is new to the
// renderer and what has already been seen in a previous packet.  Data
// may get resent and we should ignore it if we've seen it already:
class ListOfPacketDataIDsReceived : public CHXSimpleList
{
  public:
    ListOfPacketDataIDsReceived() {;}
    ~ListOfPacketDataIDsReceived() { flush(); }

    void flush() { RemoveAll(); }

    BOOL HaveAlreadySeenThisData(ULONG32 ulPacketDataID);
};


class RealTextRenderer :  public TextParser
			, public ListOfPacketDataIDsReceived
{
  public:

    RealTextRenderer(TextWindow* pTxtWin) : TextParser(pTxtWin)
	    , m_bIsFirstTimeSynch(TRUE)
	    , m_ulTimeOfLastListPurge(0L)
	    , m_bSomeonesBeginOrEndTimeWasCrossedOver(FALSE)
	    , m_bWeAreInsidePacketOpaqueHeader(FALSE)
	    , m_bHorizontalLoopJustOccurred(FALSE)
	    , m_ulRTMarkupParsingMajorVersion(
		    DEFAULT_MARKUP_PARSING_MAJOR_VERSION)
	    , m_ulRTMarkupParsingMinorVersion(
		    DEFAULT_MARKUP_PARSING_MINOR_VERSION)
	    , m_bIsPlainTextSMILFileDataURL(FALSE)
	    , m_ulTotalSourceFileSizeInBytes(0)
	    , m_bIsTextPlainStreamMimeType(FALSE)
	    , m_pPlainTextData(NULL)
	    , m_ulPlainTextDataLen(0)
	    , m_ulPlainTextDataBufferSize(0)
	    , m_ulMaxAllowedPlainTextCharsOnThisSystem((UINT32)-1)
	    , m_ulNoWrdWrpNoVertAlignPlainTxtCharsSinceLastCRorLF(0)
	    , m_ulNoWrdWrpNoVertAlignPlainTxtCRsAndLFsSoFar(0)
	    , m_ulMaxPlainTextBytesToBeSentByFF((UINT32)-1)
    { };

    ~RealTextRenderer() { if(m_pPlainTextData) 
			    delete [] m_pPlainTextData; };

    ULONG32 OnHeader(void* pData, ULONG32 dataLength);

    void OnData(void* pData, ULONG32 dataLength, BOOL bFromOnPacket);

    BOOL OnTimeSynch(ULONG32 time);

    void GetSystemScreenInfo(UINT32& rulScreenHeight,
			     UINT32& rulScreenWidth,
			     UINT32& rulScreenBitDepth);

    //Added the following to force a delete of all
    // text that is no longer visible in time or space (if the text
    // feed is live) so that it won't needlesly buffer text to which it
    // can never seek back:
    ULONG32 TimeOfLastListPurge() { return m_ulTimeOfLastListPurge; }
    void TimeOfLastListPurge(ULONG32 time) { m_ulTimeOfLastListPurge=time; }

    BOOL SomeonesBeginOrEndTimeWasCrossedOverSinceLastDraw()
	    { return m_bSomeonesBeginOrEndTimeWasCrossedOver; }
    void SetSomeonesBeginOrEndTimeWasCrossedOverSinceLastDraw(BOOL b)
	    { m_bSomeonesBeginOrEndTimeWasCrossedOver = b; }

    BOOL WeAreInsidePacketOpaqueHeader()
	    { return m_bWeAreInsidePacketOpaqueHeader; }
    void SetWeAreInsidePacketOpaqueHeader(BOOL b)
	    { m_bWeAreInsidePacketOpaqueHeader = b; }

    //For making sure this renderer doesn't try to handle a font that
    // the file format sending the stream can not handle:
    BOOL IsFaceRecognizedByThisVersionOfFileFormat(ULONG32 ulFaceIndx);

    HX_RESULT setPlainTextData(const char* pTextData);
    HX_RESULT appendPlainTextData(const char* pTextData);

    BOOL isPlainTextSMILFileDataURL() { return m_bIsPlainTextSMILFileDataURL; }
    void setSMILFileDataURLFlag(BOOL bIsDataURL)
	    { m_bIsPlainTextSMILFileDataURL = bIsDataURL;}

    BOOL isTextPlainStreamMimeType() { return m_bIsTextPlainStreamMimeType; }
    void setIsTextPlainStreamMimeType(BOOL bIsTextPlain)
	    { m_bIsTextPlainStreamMimeType = bIsTextPlain;}

    void setSourceFileSize(ULONG32 ulTotalSourceFileSizeInBytes)
	{ m_ulTotalSourceFileSizeInBytes = ulTotalSourceFileSizeInBytes;}
    ULONG32 getSourceFileSize()	{ return m_ulTotalSourceFileSizeInBytes;}

    // /File-Format plug-in may limit the number of bytes it sends of a
    // very large text file:
    void setMaxPlainTextBytesToBeSentByFF(ULONG32 ulMaxPlainTextBytesToBeSentByFF)
	{ m_ulMaxPlainTextBytesToBeSentByFF = ulMaxPlainTextBytesToBeSentByFF;}
    ULONG32 getMaxPlainTextBytesToBeSentByFF()	{ return m_ulMaxPlainTextBytesToBeSentByFF;}

    BOOL isPlainText() { return (isTextPlainStreamMimeType()  ||
			 isPlainTextSMILFileDataURL()); }

    // /Gets user pref for text size and adjusts the default, or "base" size
    // of the text:
    HX_RESULT adjustForUserTextSizeSetting();


  protected:
#ifdef _WINDOWS
    HDC		    m_hDC;
    PAINTSTRUCT	    m_paintStruct;
#endif
    BOOL m_bHorizontalLoopJustOccurred;

    ULONG32 m_ulRTMarkupParsingMajorVersion;
    ULONG32 m_ulRTMarkupParsingMinorVersion;

    BOOL m_bIsFirstTimeSynch;

    ULONG32 m_ulTotalSourceFileSizeInBytes;

    BOOL m_bIsPlainTextSMILFileDataURL;
    char* m_pPlainTextData;
    ULONG32 m_ulPlainTextDataLen;
    ULONG32 m_ulPlainTextDataBufferSize;

    // /These are all needed for preventing too-large a text file from being
    // fully processed when most of it wouldn't show (PR 78150):
    ULONG32 m_ulMaxAllowedPlainTextCharsOnThisSystem;
    ULONG32 m_ulNoWrdWrpNoVertAlignPlainTxtCharsSinceLastCRorLF;
    ULONG32 m_ulNoWrdWrpNoVertAlignPlainTxtCRsAndLFsSoFar;
    ULONG32 m_ulMaxPlainTextBytesToBeSentByFF;

    BOOL m_bIsTextPlainStreamMimeType;

  private:
	
      //private so this can't be instantiated:
    RealTextRenderer():TextParser(NULL) { ; }; 

    BOOL m_bSomeonesBeginOrEndTimeWasCrossedOver;

    BOOL m_bWeAreInsidePacketOpaqueHeader;

    //Added the following to force a delete of all
    // text that is no longer visible in time or space (if the text
    // feed is live) so that it won't needlesly buffer text to which it
    // can never seek back:
    ULONG32 m_ulTimeOfLastListPurge;
}; //end class RealTextRenderer.


#endif
