/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: HXClientPlayer.h,v 1.8.2.3 2004/07/09 01:49:26 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/* Objective C wrapper around the Helix Client Player. */

#import <Foundation/Foundation.h>

#include "HXClientTypes.h"
#import "HXClientCallbacks.h"

typedef struct IHXClientPlayer* IHXClientPlayerPtr;
@class HXClientEngine;

#ifdef HELIX_FEATURE_VIDEO
@class HXClientView;
#endif

@interface HXClientPlayer : NSObject
{
	HXClientEngine* clientEngine;
	IHXClientPlayerPtr m_pIClientPlayer;
	void* m_pStatisticObserver;
}
- (IHXClientPlayerPtr)createClientForCorePlayer:(void *)pIHXPlayer
									 withEngine:(void *)pIHXClientEngine
									   inWindow:(SHXClientWindow *)pWindow
								   withObserver:(id)observer
								 usingCallbacks:(HXClientCallbacks*)pClientCallbacks;

// Designated initializer
- (id)initInWindow:(SHXClientWindow *)pWindow withObserver:(id)observer usingCallbacks:(HXClientCallbacks*)pClientCallbacks;

- (id)initInWindow:(SHXClientWindow *)pWindow withObserver:(id)observer;

#ifdef HELIX_FEATURE_VIDEO
- (id)initInView:(HXClientView *)view withObserver:(id)observer;
#endif

- (void)openWithURL:(NSURL *)url mimeType:(NSString *)mimeType;

- (BOOL)canViewSource;
- (void)viewSource;
- (BOOL)canViewRights;
- (void)viewRights;

- (BOOL)authenticateForUser:(NSString *)username withPassword:(NSString *)password;

- (int)contentState;
- (BOOL)setStatus:(NSString *)status;
- (void)play;
- (void)pause;
- (void)stop;

- (BOOL)startSeeking;
- (void)stopSeeking;

- (BOOL)setPosition:(UInt32)position;
- (UInt32)position;
- (UInt32)length;
- (BOOL)isLive;

- (NSString *)title;
- (NSURL *)contextURL;

- (BOOL)hasVisualContent;
- (NSSize)idealSize;
- (SInt32)clipBandwidth;
- (void)setSize:(NSSize)siteSize;
- (void)drawSite:(SHXClientRect)siteRect;

- (UInt16)groupCount;
- (UInt16)currentGroup;
- (BOOL)setCurrentGroup:(UInt16)groupIndex;
- (NSURL*)groupURLByIndex:(UInt16)groupIndex;
- (NSString*)groupTitleByIndex:(UInt16)groupIndex;
- (NSArray*)groupsArray;

- (UInt16)volume;
- (void)setVolume:(UInt16)volume;
- (BOOL)isMuted;
- (void)mute:(BOOL)shouldMute;

- (void)enableEQ:(BOOL)enable;
- (BOOL)isEQEnabled;
- (void)setEQGain:(SInt32)gain forBand:(int)band;
- (SInt32)eqGainForBand:(int)band;
- (void)setEQPreGain:(SInt32)preGain;
- (SInt32)eqPreGain;
- (void)enableEQAutoPreGain:(BOOL)enable;
- (BOOL)isEQAutoPreGainEnabled;
- (void)setEQReverb:(SInt32)reverb;
- (SInt32)eqReverb;
- (void)setEQRoomSize:(SInt32)roomSize;
- (SInt32)eqRoomSize;

- (BOOL)hasVideoAttribute:(float *)curValue forKey:(int)attributeKey;
- (BOOL)setVideoAttribute:(float)value forKey:(int)attributeKey;

- (CFTypeRef)copyStatisticsFor:(NSString *)key;
- (BOOL)addObserver:(id)observer forStatistic:(NSString *)key userInfo:(UInt32)aUserInfo;
- (void)removeObserver:(id)observer forStatistic:(NSString *)key userInfo:(UInt32)aUserInfo;

@end
