#
# ***** BEGIN LICENSE BLOCK *****
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s): See changelog
# 
# ***** END LICENSE BLOCK *****
# 

Summary:        RealPlayer 10 for Linux
Name:           RealPlayer
Version:        10.0.8
Release:        1
Group:          Applications/Multimedia
License:        RPSL, EULA
URL:            http://www.real.com/linux
Source:         install.bz2
Obsoletes:      G2player, RealOne
ExcludeArch:    x86_64 ppc64 ppc s390 s390x ia64
BuildRoot:      %{_tmppath}/%{name}-%{version}-buildroot
Patch1:         RealPlayer-helixlibs.patch
Patch2:         RealPlayer-kde31-integration.patch

%description
RealPlayer is a media player providing solid media playback locally 
and via streaming. It plays RealAudio, RealVideo, MP3, 3GPP Video, 
Flash, SMIL 2.0, JPEG, GIF, PNG, RealPix and RealText and 
more. The RealPlayer 10 for Linux builds on top of the popular 
GPL/RPSL Helix Player 1.0.

%prep
%setup -q -c -n realplay-10.0.8
%patch1 -p1 -b .helixlibs
%patch2 -p1 -b .kde31

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applnk/Vendor_menus/Applications/Multimedia
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mimelnk/audio
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applnk/Vendor_menus/Applications/Multimedia
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/{16x16,32x32,48x48,192x192}/{apps,mimetypes}
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applications
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/pixmaps
mkdir -p $RPM_BUILD_ROOT/%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/helix
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/helix/share
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applications
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mimelnk/application
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mimelnk/audio
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mimelnk/video
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mimelnk/text

cp -a ./codecs $RPM_BUILD_ROOT/%{_libdir}/helix
cp -a ./common $RPM_BUILD_ROOT/%{_libdir}/helix
cp -a ./plugins $RPM_BUILD_ROOT/%{_libdir}/helix
cp -a ./share/default $RPM_BUILD_ROOT/%{_libdir}/helix/share
cp -a ./share/realplay $RPM_BUILD_ROOT/%{_libdir}/helix/share
cp ./README $RPM_BUILD_ROOT/%{_libdir}/helix
cp ./LICENSE $RPM_BUILD_ROOT/%{_libdir}/helix

for LANGUAGE in de es fr hi it ja ko pl pt_BR zh_CN zh_TW; do
    mkdir -p $RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES
    mkdir -p $RPM_BUILD_ROOT/%{_libdir}/helix/share/locale/$LANGUAGE
    cp "./share/locale/$LANGUAGE/player.mo" "$RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES/realplay.mo"
    cp "./share/locale/$LANGUAGE/widget.mo" "$RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    cp "./share/locale/$LANGUAGE/README" "$RPM_BUILD_ROOT/%{_libdir}/helix/share/locale/$LANGUAGE"
    cp "./share/locale/$LANGUAGE/LICENSE" "$RPM_BUILD_ROOT/%{_libdir}/helix/share/locale/$LANGUAGE"
done

for SIZE in "48x48" "192x192" ; do
    for MIME in \
        "application-generic" \
        "audio-generic"       \
        "text-realtext"       \
        "video-generic"       \
        "video-ogg"           \
        "application-ogg"     \
        "application-ram"     \
        "application-rpm"     \
        "application-smil"    \
        "application-rm"      \
        "audio-aiff"          \
        "audio-au"            \
        "audio-mp3"           \
        "audio-mp4"           \
        "audio-ogg"           \
        "audio-ra"            \
        "audio-wav"           \
        "video-avi"           \
        "video-mov"           \
        "video-rv"            \
        "video-swf" ; do
        ICON="./share/icons/mime-${MIME}_$SIZE.png"
        cp "$ICON" "$RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/$SIZE/mimetypes/realplay-${MIME}.png"
    done
done

for SIZE in "16x16" "32x32" "48x48" "192x192" ; do
    cp ./share/icons/realplay_${SIZE}.png $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/${SIZE}/apps/realplay.png
done

cp ./share/realplay.png $RPM_BUILD_ROOT/%{_datadir}/pixmaps
cp ./share/realplay.desktop $RPM_BUILD_ROOT/%{_datadir}/applications

cp ./share/realplay.desktop $RPM_BUILD_ROOT/%{_datadir}/applnk/Vendor_menus/Applications/Multimedia/

for MIME_TYPE in \
    "application/sdp" \
    "application/x-streamingmedia" \
    "application/vnd.rn-realmedia-secure" \
    "application/vnd.rn-realmedia" \
    "application/x-smil" \
    "application/vnd.rn-realmedia-vbr" \
    "application/ogg" \
    "audio/mpeg" \
    "audio/vnd.rn-realaudio" \
    "audio/x-aac" \
    "audio/x-aiff" \
    "audio/x-m4a" \
    "audio/x-mpegurl" \
    "audio/x-pn-realaudio" \
    "audio/x-scpls" \
    "audio/x-wav" \
    "video/vnd.rn-realvideo" \
    "video/x-3gpp2" \
    "text/vnd.rn-realtext" ; do
    cp ./share/mimelnk/${MIME_TYPE}.desktop $RPM_BUILD_ROOT/%{_datadir}/mimelnk/${MIME_TYPE}.desktop
done

cp ./mozilla/nphelix.so $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins
cp ./mozilla/nphelix.xpt $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins

cp ./realplay.bin $RPM_BUILD_ROOT/%{_libdir}/helix
cp ./realplay $RPM_BUILD_ROOT/%{_libdir}/helix
ln -s %{_libdir}/helix/realplay $RPM_BUILD_ROOT/usr/bin

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/realplay
%{_libdir}/helix/*
%{_libdir}/mozilla/*
%{_datadir}/icons/hicolor/*
%{_datadir}/pixmaps/*
%{_datadir}/applications/realplay.desktop
%{_datadir}/applnk/Vendor_menus/Applications/Multimedia/*
%{_datadir}/mimelnk/audio/*
%{_datadir}/locale/*/LC_MESSAGES/*

%changelog
* Mon Jun 26 2006 Bob Clark <bobclark@real.com> 10.0.8
- Updating for 10.0.8

* Tue Feb 28 2006 Bob Clark <bobclark@real.com> 10.0.7
- Updating for 10.0.7

* Fri Aug 19 2005 Ryan Gammon <rgammon@real.com> 10.0.6
- Updating for 10.0.6

* Fri May 13 2005 Ryan Gammon <rgammon@real.com> 10.0.5
- Updating for 10.0.5

* Wed Mar 23 2005 Ryan Gammon <rgammon@real.com> 10.0.4
- Updating for 10.0.4

* Thu Feb 10 2005 Ryan Gammon <rgammon@real.com> 10.0.3
- Updating for 10.0.3

* Wed Nov 29 2004 Ryan Gammon <rgammon@real.com> 10.0.2-1pre1
- Updating for 10.0.2
- Adding mimelnk configuration

* Wed Oct 20 2004 Ryan Gammon <rgammon@real.com> 10.0.1-1pre1
- First RPM build for TurboLinux 10 (F, Desktop, TurboHome)
