<?php
// File           jsrs/detail_request.php / ibWebAdmin
// Purpose        answer to the requests send by a 'toggle detail' link for views, tables, ...
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <14/01/03 23:01:18 lb>
//
// $Id: detail_request.php,v 1.12 2004/03/31 20:02:53 lbrueckner Exp $

require('../inc/configuration.inc.php');
require('../inc/session.inc.php');

session_start();
localize_session_vars();

require('../lang/' . (isset($s_cust) ? $s_cust['language'] : LANGUAGE) . '.inc.php');
require('../inc/functions.inc.php');
require('../inc/panel_elements.inc.php');
require('./jsrsServer.php.inc');

if (DEBUG === TRUE) {
    include('../inc/debug_funcs.inc.php');
}

$dbhandle = db_connect();

// guess the server
list($family, $version) = server_info($s_login['server']);
define('SERVER_FAMILY', $family);
define('SERVER_VERSION', $version);


$icon_path = DATAPATH . (BG_TRANSPARENT == TRUE ? 'transparent/' : 'opaque/') . strtolower(ICON_SIZE) . '/';
$red_triangle_icon   = $icon_path.'red_triangle.png';


// answer to the request with the result of get_fk_values()
jsrsDispatch('get_detail');


// build the answer for the jsrs request
function get_detail($type, $name, $title) {

    switch ($type) {
        case 'table':
            $url  = fold_detail_url('table', 'open', $name, $title);
            $html = get_opened_table($name, $title, $url);
            $id = 't_'.$name;

            $GLOBALS['s_tables'][$name]['status'] = 'open';
            break;

        case 'view':
            include('../inc/views.inc.php');

            $url  = fold_detail_url('view', 'open', $name, $title);
            $html = get_opened_view($name, $title, $url);
            $id = 'v_'.$name;

            $GLOBALS['s_tables'][$name]['status'] = 'open';
            break;

        case 'trigger':
            include('../inc/triggers.inc.php');

            if (empty($GLOBALS['s_triggers'][$name]['source'])) {
                $GLOBALS['s_triggers'][$name]['source'] = get_trigger_source($name);
            }

            $url  = fold_detail_url('trigger', 'open', $name, $title);
            $html = get_opened_trigger($name, $GLOBALS['s_triggers'][$name], $url);
            $id = 'r_'.$name;

            $GLOBALS['s_triggers'][$name]['display'] = 'open';
            break;

        case 'procedure':
            include('../inc/procedures.inc.php');
            include('../inc/interbase.inc.php');

            if (empty($GLOBALS['s_procedures'][$name]['source'])) {
                $GLOBALS['s_procedures'][$name]['source'] = get_procedure_source($name);

                list($in, $out) = get_procedure_parameters($name);
                $GLOBALS['s_procedures'][$name]['in']  = $in;
                $GLOBALS['s_procedures'][$name]['out'] = $out;
            }

            $url  = fold_detail_url('procedure', 'open', $name, $title);
            $html = get_opened_procedure($name, $GLOBALS['s_procedures'][$name], $url);
            $id = 'p_'.$name;

            $GLOBALS['s_procedures'][$name]['status'] = 'open';
            break;
    }

    globalize_session_vars();

    return jsrsArrayToString(array($id, $html), $delim='~');
}

?>
