/***************************************************************************
                          group.h  -  description
                             -------------------
    begin                : tor mar 14 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUP_H
#define GROUP_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
#include <qdatastream.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

/**
  *@author Bjrn Sahlstrm
  */

class Group {
public: 
	/** */
	Group(){}
	/** */
	~Group(){}
	/** */
	QString label() const { return m_label; }
	/** */
	QString parent() const { return m_parent; }
	/** */
	void setLabel( const QString& label ) { m_label = label; }
	/** */
	void setParent( const QString& parent ) { m_parent = parent; }
	/** */
	void insert( QDataStream& out ) const {
		out << m_parent << m_label;
	}
	/** */
	void extract( QDataStream& in ) {
		in >> m_parent >> m_label;
	}
private:
	QString m_parent;
	QString m_label;
};
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s, const Group& group ) {
	group.insert( s );
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, Group& group ) {
	group.extract( s );
	return s;
}

#endif
