/***************************************************************************
                          transfer.h  -  description
                             -------------------
    begin                : lr feb 9 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSFER_H
#define TRANSFER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
#include <qmap.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/jobclasses.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearcopyjob.h"
#include "kbeartransferviewitem.h"
#include "connection.h"

/**
	* This class contains all information needed for a transfer like source URL:s, destination,
	* information about PASV / EPSV, Binary / ASCII transfer etc. etc.
	* The sources are saved in a @ref KURL::List and destination in a @ ref KURL.
	*@author Bjrn Sahlstrm
  */

class Transfer {
	friend class KBearTransferViewItem;
public:
	/** */
	Transfer() : m_job(0L),m_viewItem(0L), m_isPaused(false){}
	/** */
	~Transfer(){}
	/** */
	void setMove( bool m ) { m_move = m; }
	/** */
	bool move() { return m_move; }
	/** */
	Connection& sourceConnection() { return m_sourceConnection; }
	/** */
	void setSourceConnection( const Connection& c ) { m_sourceConnection=c; }
	/** */
	Connection& destConnection() { return m_destConnection; }
	/** */
	void setDestConnection( const Connection& c ) { m_destConnection=c; }
	/** */
	KURL::List& sourceList() { return m_sourceList; }
	/** */
	void setDestURL( const KURL& u ) { m_destURL = u; }
	/** */
	KURL destURL() const { return m_destURL; }
	/** */
	void setViewItem( KBearTransferViewItem* v ) { m_viewItem = v; }
	/** */
	void setJob( KBearCopyJob* j ) { m_job = j; }
	/** */
	KIO::Job* job() { return m_job; }
	/** */
	KBearCopyJob* start() { return m_viewItem->start(); }
	/** */
	void stop() { return m_viewItem->stop(); }
	/** */
	bool isPaused() { return m_isPaused; }
protected:
	void pause( bool p ) { m_isPaused = p; }
private: //Private attributes
	Connection m_sourceConnection;
	Connection m_destConnection;
	KURL::List m_sourceList;
	KURL m_destURL;
	KBearCopyJob* m_job;
	KBearTransferViewItem* m_viewItem;
	bool m_move;
	bool m_isPaused;
};

#endif
