/***************************************************************************
                          kbearsitemanager.h  -  description
                             -------------------
    begin                : fre mar 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGER_H
#define KBEARSITEMANAGER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qvaluelist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kcombobox.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsitemanagerbase.h"
#include "kbearsitemanageriface.h"
#include "kbearsitemanageradvanceddialog.h"
#include "siteimportdialog.h"

/**
  *@author Bjrn Sahlstrm
  */

class KBearSiteManager : public KBearSiteManagerBase {
   Q_OBJECT
	friend class KBearSiteManagerPlugin;
public: 
	/** */
	KBearSiteManager(QWidget *parent, const char *name );
	/** */
	virtual ~KBearSiteManager();
	/** */
	void setSite( const Site& );
	/** */
	QString decodePassword( const QString& );
	/** */
	QString encodePassword( const QString& );
	/** */
	bool hasKBearFTP() const { return m_hasKBearFTP; }
	/** */
	QString promptForGroupName();
	/** */
//	void firstTimeImport( const QString& file );
	/** */
	Site getCurrentSite();
	/** */
	void clear();
	/** */
	bool checkModified();
public slots:
	/** */
	virtual void slotSelectedSite(QListViewItem* item = 0L);

signals:
	/** */
	void update();
	/** */
	void showSystemTray(bool);
	/** */
	void plugInKonq( bool );
	/** */
	void importSites( const QString& );
	/** */
	void siteSelected( const Site& );
	/** */
	void selectionCleared();
	/** */
	void openConnection( const Site& );
	/** */
	void saveSite( const Site& );
	/** */
	void changeSite( const Site&, const QString& oldName );
	/** */
	void changeGroup( const Group&, const QString& oldName );
	/** */
	void newGroup( const Group& name );
	/** */
	void moveSite( const Site& site, const QString& newParent );
	/** */
	void moveGroup( const Group& group, const QString& newParent );
	/** */
	void newEncoding( const QString& encoding );
	/** */
	void removeSite( const Site& );
	/** */
	void removeGroup( const Group& );
protected slots:
	/** */
	virtual void accept();
	/** */
	virtual void reject();
	/** */
	virtual void slotItemRenamed(QListViewItem*, const QString&, int);
	/** */
    virtual void slotSetEdited();
	/** */
    virtual void slotSetHostEdited();
	/** */
	virtual void slotAdvancedSettings();
	/** */
	virtual void slotConnect();
	/** */
	virtual void slotDoubleClicked(QListViewItem *);
	/** */
	virtual void slotMoved(const QString& parentPath, const QString& name, QListViewItem* newParent,bool isGroup);
	/** */
	virtual void slotNewGroup();
	/** */
	virtual void slotRemove();
	/** */
	virtual void slotSave();
	/** */
	virtual void slotSetEncoding(const QString&);
	/** */
	virtual void slotSelectedProtocol( const QString& );
	/** */
	virtual void slotOpenImportDialog();
	/** */
	virtual void slotPressed(QListViewItem*);
	/** */
	virtual void slotContextMenu( KListView*, QListViewItem* item, const QPoint& );
protected:
	/** */
	virtual void closeEvent( QCloseEvent* e );
private: //Private methods
	void setupProtocolCombo();
protected:
	SiteImportDialog* m_importDialog;
private: //Private attributes
	KBearSiteManagerAdvancedDialog* m_advancedDialog;
	bool m_hasKBearFTP;
	bool m_pendingConnect;
	bool m_isModified;
	Site m_selectedItem;
	Group m_movedItem;
};

#endif
