/***************************************************************************
                          kdlgdefault.h  -  description
                             -------------------
    begin                : Wed Jan 17 2001
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.3 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGDEFAULT_H
#define KDLGDEFAULT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ktabctl.h>

class KMagoDoc;
class KDlgManager1;
class KDlgTransfer1;
#ifdef ENABLE_WGET
class KDlgTransferWget1;
#endif
#ifdef ENABLE_KIO
class KDlgTransferKio1;
#endif

/**
 * @short Dialog for Document defaults configuration
 *
 * @author Sergio Moretti
 *
 * @version $Id: kdlgdefault.h,v 1.3 2001/03/05 20:59:22 sergio Exp $
 */

class KDlgDefault : public KTabCtl 
{
   Q_OBJECT
  
public: 
   KDlgDefault(KMagoDoc *doc, QWidget *parent=0, const char *name=0);
   ~KDlgDefault();
   bool isAcceptable() const;
   void accept();
   void reject();

protected:
   void initDialog();

private:
   KMagoDoc *_doc;
   KDlgManager1 *_p1;
   KDlgTransfer1 *_p2;
#ifdef ENABLE_WGET
   KDlgTransferWget1 *_p3;
#endif
#ifdef ENABLE_KIO
   KDlgTransfer1 *_p4;
   KDlgTransferKio1 *_p5;
#endif
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
