/***************************************************************************
                          kdlgtransferstatus.h  -  description
                             -------------------
    begin                : Thu Sep 7 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.12 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGTRANSFERSTATUS_H
#define KDLGTRANSFERSTATUS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kcombobox.h>
#include "ktransfer.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif

class KMagoDoc;

/**
 * @short Window to show @ref KTransfer status
 *
 * @author Sergio Moretti
 *
 * @version $Id: kdlgtransferstatus.h,v 1.12 2001/03/23 17:14:59 sergio Exp $
 */

class KDlgTransferStatus : public QWidget 
{
   Q_OBJECT
public:
   KDlgTransferStatus(KTransfer t, KMagoDoc *doc, QWidget *parent, 
		      const char *name = 0);
   ~KDlgTransferStatus();
  
protected:
   void initDialog();
   void init();
   bool isAcceptable() const;
  
public slots: // Public slots
   void slotUpdate(KTransfer tr);

protected slots:
   void slotOk();

signals:
   void sigClose(int id);

protected:
   QLineEdit *lneRemote,
      *lneLocal,
      *lneType,
      *lneTmp,
      *lneTStart,
      *lneTEst,
      *lneBand,
      *lneMBand,
      *lneRetry,
      *lneID,
      *lneConn,
      *lnePartial,
      *lneLen,
      *lneResumable,
      *lneResumed,
      *lneState,
      *lnePriority;
   QPushButton *btnOK;

private:
   KTransfer t;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
